/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.PlatformIcons;
import com.intellij.ws.rest.JaxRsLineMarkerProvider;
import com.intellij.ws.rest.RSBundle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JList;

public class JaxRsLineMarkerInfo
extends LineMarkerInfo<PsiIdentifier> {
    public static final Function<PsiIdentifier, String> TOOLTIP = new ConstantFunction((Object)"Go to template");

    public JaxRsLineMarkerInfo(PsiIdentifier element, VirtualFile file) {
        super((PsiElement)element, element.getTextRange(), PlatformIcons.JSP_ICON, TOOLTIP, (GutterIconNavigationHandler)new JaxRsTemplateNavHandler(element.getProject(), file), GutterIconRenderer.Alignment.LEFT);
    }

    static class JaxRsTemplateNavHandler
    implements GutterIconNavigationHandler<PsiIdentifier> {
        private final Project project;
        private final VirtualFile file;

        JaxRsTemplateNavHandler(Project project, VirtualFile file) {
            this.project = project;
            this.file = file;
        }

        public void navigate(MouseEvent e, PsiIdentifier elt) {
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
            for (VirtualFile f : this.file.getChildren()) {
                if (!JaxRsLineMarkerProvider.isAllowedExt(f)) continue;
                files.add(f);
            }
            if (files.size() > 1) {
                JBList list = new JBList(files);
                list.installCellRenderer(o -> new JLabel(o.getName(), VirtualFilePresentation.getIcon((VirtualFile)o), 2));
                JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(RSBundle.message("gutter.choose.template.action", new Object[0])).setItemChoosenCallback(() -> {
                    int selectedIndex = list.getSelectedIndex();
                    if (selectedIndex == -1) {
                        return;
                    }
                    FileEditorManager.getInstance((Project)this.project).openFile((VirtualFile)files.get(selectedIndex), true);
                }).setAutoselectOnMouseMove(true).createPopup().show(new RelativePoint(e));
            } else if (files.size() == 1) {
                FileEditorManager.getInstance((Project)this.project).openFile((VirtualFile)files.get(0), true);
            }
        }
    }
}

