/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/MarkdownNotifier;", "", "()V", "NOTIFICATION_GROUP", "Lcom/intellij/notification/NotificationGroup;", "kotlin.jvm.PlatformType", "getNOTIFICATION_GROUP", "()Lcom/intellij/notification/NotificationGroup;", "notifyAboutConversionWarning", "", "project", "Lcom/intellij/openapi/project/Project;", "msg", "", "notifyIfConvertFailed", "notifyNetworkProblems", "notifyOfSuccessfulExport", "notifyPandocDetected", "notifyPandocDetectionFailed", "notifyPandocNotDetected", "intellij.markdown"})
public final class MarkdownNotifier {
    private static final NotificationGroup NOTIFICATION_GROUP;
    @NotNull
    public static final MarkdownNotifier INSTANCE;

    public final NotificationGroup getNOTIFICATION_GROUP() {
        return NOTIFICATION_GROUP;
    }

    public final void notifyNetworkProblems(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = MarkdownBundle.message("markdown.google.import.network.problems.msg", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026rt.network.problems.msg\")");
        NOTIFICATION_GROUP.createNotification(string, NotificationType.ERROR).notify(project);
    }

    public final void notifyPandocDetected(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = MarkdownBundle.message("markdown.settings.pandoc.notification.detected", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026c.notification.detected\")");
        NOTIFICATION_GROUP.createNotification(string, NotificationType.INFORMATION).notify(project);
    }

    public final void notifyPandocNotDetected(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = MarkdownBundle.message("markdown.settings.pandoc.notification.not.detected", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026tification.not.detected\")");
        NOTIFICATION_GROUP.createNotification(string, NotificationType.WARNING).notify(project);
    }

    public final void notifyPandocDetectionFailed(@NotNull Project project, @NlsSafe @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        NOTIFICATION_GROUP.createNotification(msg, NotificationType.ERROR).notify(project);
    }

    public final void notifyIfConvertFailed(@NotNull Project project, @NlsSafe @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        NOTIFICATION_GROUP.createNotification(msg, NotificationType.ERROR).notify(project);
    }

    public final void notifyOfSuccessfulExport(@NotNull Project project, @NlsSafe @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        NOTIFICATION_GROUP.createNotification(msg, NotificationType.INFORMATION).notify(project);
    }

    public final void notifyAboutConversionWarning(@NotNull Project project, @NlsSafe @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        NOTIFICATION_GROUP.createNotification(msg, NotificationType.WARNING).notify(project);
    }

    private MarkdownNotifier() {
    }

    static {
        MarkdownNotifier markdownNotifier;
        INSTANCE = markdownNotifier = new MarkdownNotifier();
        NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Markdown");
    }
}

