/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.wizards.MavenOpenProjectProvider;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/maven/wizards/MavenProjectOpenProcessor;", "Lcom/intellij/projectImport/ProjectOpenProcessor;", "()V", "importProvider", "Lorg/jetbrains/idea/maven/wizards/MavenOpenProjectProvider;", "canImportProjectAfterwards", "", "canOpenProject", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "doOpenProject", "Lcom/intellij/openapi/project/Project;", "projectFile", "projectToClose", "forceOpenInNewFrame", "getIcon", "Ljavax/swing/Icon;", "getName", "", "importProjectAfterwards", "", "project", "intellij.maven"})
public final class MavenProjectOpenProcessor
extends ProjectOpenProcessor {
    private final MavenOpenProjectProvider importProvider = new MavenOpenProjectProvider();

    @NotNull
    public String getName() {
        String string = this.importProvider.getBuilder().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"importProvider.builder.name");
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return this.importProvider.getBuilder().getIcon();
    }

    public boolean canOpenProject(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.importProvider.canOpenProject(file);
    }

    @Nullable
    public Project doOpenProject(@NotNull VirtualFile projectFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Intrinsics.checkNotNullParameter((Object)projectFile, (String)"projectFile");
        return this.importProvider.openProject(projectFile, projectToClose, forceOpenInNewFrame);
    }

    public boolean canImportProjectAfterwards() {
        return true;
    }

    public void importProjectAfterwards(@NotNull Project project2, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.importProvider.linkToExistingProject(file, project2);
    }
}

