/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks;

import com.google.common.collect.Sets;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.DefaultJavaProgramRunner;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.DisposableWrapperList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTask;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTasksProvider;
import org.jetbrains.idea.maven.tasks.MavenCompilerTask;
import org.jetbrains.idea.maven.tasks.MavenTasksManagerState;
import org.jetbrains.idea.maven.tasks.TasksBundle;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenSimpleProjectComponent;

@State(name="MavenCompilerTasksManager")
public final class MavenTasksManager
extends MavenSimpleProjectComponent
implements PersistentStateComponent<MavenTasksManagerState>,
Disposable {
    private volatile MavenTasksManagerState myState;
    private final Object myStateLock;
    private final DisposableWrapperList<Listener> myListeners;

    public static MavenTasksManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            MavenTasksManager.$$$reportNull$$$0(0);
        }
        return (MavenTasksManager)project2.getService(MavenTasksManager.class);
    }

    public MavenTasksManager(@NotNull Project project2) {
        if (project2 == null) {
            MavenTasksManager.$$$reportNull$$$0(1);
        }
        super(project2);
        this.myState = new MavenTasksManagerState();
        this.myStateLock = new Object();
        this.myListeners = new DisposableWrapperList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenTasksManagerState getState() {
        Object object = this.myStateLock;
        synchronized (object) {
            MavenTasksManagerState result = new MavenTasksManagerState();
            result.afterCompileTasks = new HashSet<MavenCompilerTask>(this.myState.afterCompileTasks);
            result.beforeCompileTasks = new HashSet<MavenCompilerTask>(this.myState.beforeCompileTasks);
            result.afterRebuildTask = new HashSet<MavenCompilerTask>(this.myState.afterRebuildTask);
            result.beforeRebuildTask = new HashSet<MavenCompilerTask>(this.myState.beforeRebuildTask);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull MavenTasksManagerState state2) {
        if (state2 == null) {
            MavenTasksManager.$$$reportNull$$$0(2);
        }
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState = state2;
        }
        this.fireTasksChanged();
    }

    public void dispose() {
        this.myListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doExecute(boolean before, CompileContext context) {
        ArrayList<MavenRunnerParameters> parametersList;
        Object object = this.myStateLock;
        synchronized (object) {
            Sets.SetView tasks;
            parametersList = new ArrayList<MavenRunnerParameters>();
            Object object2 = tasks = before ? this.myState.beforeCompileTasks : this.myState.afterCompileTasks;
            if (context.isRebuild()) {
                tasks = Sets.union(before ? this.myState.beforeRebuildTask : this.myState.afterRebuildTask, tasks);
            }
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(this.myProject);
            for (MavenCompilerTask each : tasks) {
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(each.getProjectPath());
                if (file == null) continue;
                MavenExplicitProfiles explicitProfiles = mavenProjectsManager.getExplicitProfiles();
                parametersList.add(new MavenRunnerParameters(true, file.getParent().getPath(), file.getName(), Collections.singletonList(each.getGoal()), explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles()));
            }
        }
        return MavenTasksManager.doRunTask(context, parametersList);
    }

    private static boolean doRunTask(CompileContext context, List<MavenRunnerParameters> parametersList) {
        try {
            ProgramRunner runner = DefaultJavaProgramRunner.getInstance();
            Executor executor = DefaultRunExecutor.getRunExecutorInstance();
            long executionId = ExecutionEnvironment.getNextUnusedExecutionId();
            int count = 0;
            for (MavenRunnerParameters params : parametersList) {
                RunnerAndConfigurationSettings configuration = MavenRunConfigurationType.createRunnerAndConfigurationSettings(null, null, params, context.getProject());
                if (parametersList.size() > 1) {
                    configuration.setName(MavenProjectBundle.message("maven.before.build.of.count", ++count, parametersList.size(), configuration.getName()));
                }
                ExecutionEnvironment environment = new ExecutionEnvironment(executor, runner, configuration, context.getProject());
                environment.setExecutionId(executionId);
                boolean result = RunConfigurationBeforeRunProvider.doRunTask((String)executor.getId(), (ExecutionEnvironment)environment, (ProgramRunner)runner);
                if (result) continue;
                return false;
            }
            return true;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            MavenLog.LOG.error("Cannot execute:", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompileTaskOfPhase(@NotNull MavenCompilerTask task, @NotNull Phase phase) {
        if (task == null) {
            MavenTasksManager.$$$reportNull$$$0(3);
        }
        if (phase == null) {
            MavenTasksManager.$$$reportNull$$$0(4);
        }
        Object object = this.myStateLock;
        synchronized (object) {
            return this.myState.getTasks(phase).contains(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompileTasks(List<MavenCompilerTask> tasks, @NotNull Phase phase) {
        if (phase == null) {
            MavenTasksManager.$$$reportNull$$$0(5);
        }
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState.getTasks(phase).addAll(tasks);
        }
        this.fireTasksChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompileTasks(List<MavenCompilerTask> tasks, @NotNull Phase phase) {
        if (phase == null) {
            MavenTasksManager.$$$reportNull$$$0(6);
        }
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState.getTasks(phase).removeAll(tasks);
        }
        this.fireTasksChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription(MavenProject project2, String goal) {
        ArrayList<String> result = new ArrayList<String>();
        MavenCompilerTask compilerTask = new MavenCompilerTask(project2.getPath(), goal);
        Iterator iterator = this.myStateLock;
        synchronized (iterator) {
            for (Phase phase : Phase.values()) {
                if (!this.myState.getTasks(phase).contains(compilerTask)) continue;
                result.add(TasksBundle.message(phase.myMessageKey, new Object[0]));
            }
        }
        for (MavenBeforeRunTask each : RunManagerEx.getInstanceEx((Project)this.myProject).getBeforeRunTasks(MavenBeforeRunTasksProvider.ID)) {
            if (!each.isFor(project2, goal)) continue;
            result.add(TasksBundle.message("maven.tasks.goal.before.run", new Object[0]));
            break;
        }
        return StringUtil.join(result, (String)", ");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public void addListener(Listener l) {
        this.myListeners.add((Object)l);
    }

    public void addListener(@NotNull Listener l, @NotNull Disposable disposable) {
        if (l == null) {
            MavenTasksManager.$$$reportNull$$$0(7);
        }
        if (disposable == null) {
            MavenTasksManager.$$$reportNull$$$0(8);
        }
        this.myListeners.add((Object)l, disposable);
    }

    public void fireTasksChanged() {
        for (Listener each : this.myListeners) {
            each.compileTasksChanged();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/tasks/MavenTasksManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompileTaskOfPhase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompileTasks";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeCompileTasks";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Listener {
        public void compileTasksChanged();
    }

    @ApiStatus.Internal
    static class MavenAfterCompileTask
    extends MyCompileTask {
        MavenAfterCompileTask() {
            super(false);
        }
    }

    @ApiStatus.Internal
    static class MavenBeforeCompileTask
    extends MyCompileTask {
        MavenBeforeCompileTask() {
            super(true);
        }
    }

    private static class MyCompileTask
    implements CompileTask {
        private final boolean myBefore;

        MyCompileTask(boolean before) {
            this.myBefore = before;
        }

        public boolean execute(@NotNull CompileContext context) {
            if (context == null) {
                MyCompileTask.$$$reportNull$$$0(0);
            }
            MavenTasksManager mavenTasksManager = (MavenTasksManager)context.getProject().getService(MavenTasksManager.class);
            return mavenTasksManager.doExecute(this.myBefore, context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/maven/tasks/MavenTasksManager$MyCompileTask", "execute"));
        }
    }

    public static enum Phase {
        BEFORE_COMPILE("maven.tasks.goal.before.compile"),
        AFTER_COMPILE("maven.tasks.goal.after.compile"),
        BEFORE_REBUILD("maven.tasks.goal.before.rebuild"),
        AFTER_REBUILD("maven.tasks.goal.after.rebuild");

        @PropertyKey(resourceBundle="messages.MavenTasksBundle")
        public final @PropertyKey(resourceBundle="messages.MavenTasksBundle") String myMessageKey;

        private Phase(String messageKey) {
            this.myMessageKey = messageKey;
        }
    }
}

