/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.RemotePathTransformerFactory;
import org.jetbrains.idea.maven.utils.MavenWslUtil;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/maven/server/wsl/WslRemotePathTransformFactory;", "Lorg/jetbrains/idea/maven/server/RemotePathTransformerFactory;", "()V", "createTransformer", "Lorg/jetbrains/idea/maven/server/RemotePathTransformerFactory$Transformer;", "project", "Lcom/intellij/openapi/project/Project;", "isApplicable", "", "intellij.maven"})
public final class WslRemotePathTransformFactory
implements RemotePathTransformerFactory {
    @Override
    public boolean isApplicable(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return MavenWslUtil.useWslMaven(project2);
    }

    @Override
    @NotNull
    public RemotePathTransformerFactory.Transformer createTransformer(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        WSLDistribution wSLDistribution = MavenWslUtil.tryGetWslDistribution(project2);
        if (wSLDistribution == null) {
            throw (Throwable)new IllegalArgumentException("Project " + project2 + " is not WSL based!");
        }
        WSLDistribution wslDistribution2 = wSLDistribution;
        return new RemotePathTransformerFactory.Transformer(wslDistribution2){
            final /* synthetic */ WSLDistribution $wslDistribution;

            @Nullable
            public String toRemotePath(@NotNull String localPath) {
                Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
                return this.$wslDistribution.getWslPath(localPath);
            }

            @Nullable
            public String toIdePath(@NotNull String remotePath) {
                Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
                return this.$wslDistribution.getWindowsPath(remotePath);
            }
            {
                this.$wslDistribution = $captured_local_variable$0;
            }
        };
    }
}

