/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.ui;

import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.Collection;
import javax.swing.ListSelectionModel;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.ui.ConnectorTable;
import org.jetbrains.idea.maven.statistics.MavenActionsUsagesCollector;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0014\u0010\r\u001a\u0004\u0018\u00010\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0014J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0014J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0014\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0014J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0014J\u0012\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0002H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/idea/maven/server/ui/ConnectorTable;", "Lcom/intellij/execution/util/ListTableWithButtons;", "Lorg/jetbrains/idea/maven/server/MavenServerConnector;", "()V", "refresh", "Lcom/intellij/ui/AnActionButton;", "getRefresh", "()Lcom/intellij/ui/AnActionButton;", "stop", "getStop", "canDeleteElement", "", "selection", "cloneElement", "variable", "createAddAction", "Lcom/intellij/ui/AnActionButtonRunnable;", "createElement", "createExtraActions", "", "()[Lcom/intellij/ui/AnActionButton;", "createListModel", "Lcom/intellij/util/ui/ListTableModel;", "createRemoveAction", "isEmpty", "element", "TableColumn", "intellij.maven"})
public final class ConnectorTable
extends ListTableWithButtons<MavenServerConnector> {
    @NotNull
    private final AnActionButton stop = new AnActionButton(this, MavenConfigurableBundle.message("connector.ui.stop", new Object[0]), AllIcons.Debugger.KillProcess){
        final /* synthetic */ ConnectorTable this$0;

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            MavenActionsUsagesCollector.Companion.trigger(e.getProject(), MavenActionsUsagesCollector.ActionID.KillMavenConnector);
            TableView tableView = this.this$0.getTableView();
            Intrinsics.checkNotNullExpressionValue((Object)tableView, (String)"tableView");
            MavenServerConnector mavenServerConnector = (MavenServerConnector)tableView.getSelectedObject();
            if (mavenServerConnector == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)mavenServerConnector, (String)"tableView.selectedObject ?: return");
            MavenServerConnector connector = mavenServerConnector;
            connector.shutdown(true);
            this.this$0.refreshValues();
        }

        public void updateButton(@NotNull AnActionEvent e) {
            MavenServerConnector connector;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TableView tableView = this.this$0.getTableView();
            Intrinsics.checkNotNullExpressionValue((Object)tableView, (String)"tableView");
            MavenServerConnector mavenServerConnector = connector = (MavenServerConnector)tableView.getSelectedObject();
            this.setEnabled((mavenServerConnector != null ? mavenServerConnector.getState() : null) == MavenServerConnector.State.RUNNING);
        }
        {
            this.this$0 = this$0;
            super($super_call_param$1, $super_call_param$2);
        }
    };
    @NotNull
    private final AnActionButton refresh = new AnActionButton(this, MavenConfigurableBundle.message("connector.ui.refresh", new Object[0]), AllIcons.Actions.Refresh){
        final /* synthetic */ ConnectorTable this$0;

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.this$0.getTableView().setModelAndUpdateColumns(this.this$0.createListModel());
            ConnectorTable.access$setModified(this.this$0);
        }
        {
            this.this$0 = this$0;
            super($super_call_param$1, $super_call_param$2);
        }
    };

    @NotNull
    public final AnActionButton getStop() {
        return this.stop;
    }

    @NotNull
    public final AnActionButton getRefresh() {
        return this.refresh;
    }

    @NotNull
    protected ListTableModel<MavenServerConnector> createListModel() {
        String string = MavenConfigurableBundle.message("connector.ui.project", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MavenConfigurableBundle.\u2026e(\"connector.ui.project\")");
        TableColumn project2 = new TableColumn(string, (Function1<? super MavenServerConnector, String>)((Function1)createListModel.project.1.INSTANCE));
        String string2 = MavenConfigurableBundle.message("connector.ui.jdk", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MavenConfigurableBundle.\u2026ssage(\"connector.ui.jdk\")");
        TableColumn jdk2 = new TableColumn(string2, (Function1<? super MavenServerConnector, String>)((Function1)createListModel.jdk.1.INSTANCE));
        String string3 = MavenConfigurableBundle.message("connector.ui.vmOptions", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"MavenConfigurableBundle.\u2026\"connector.ui.vmOptions\")");
        TableColumn vmopts2 = new TableColumn(string3, (Function1<? super MavenServerConnector, String>)((Function1)createListModel.vmopts.1.INSTANCE));
        String string4 = MavenConfigurableBundle.message("connector.ui.dir", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"MavenConfigurableBundle.\u2026ssage(\"connector.ui.dir\")");
        TableColumn dir2 = new TableColumn(string4, (Function1<? super MavenServerConnector, String>)((Function1)createListModel.dir.1.INSTANCE));
        String string5 = MavenConfigurableBundle.message("connector.ui.maven", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"MavenConfigurableBundle.\u2026age(\"connector.ui.maven\")");
        TableColumn maven2 = new TableColumn(string5, (Function1<? super MavenServerConnector, String>)((Function1)createListModel.maven.1.INSTANCE));
        String string6 = MavenConfigurableBundle.message("connector.ui.state", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"MavenConfigurableBundle.\u2026age(\"connector.ui.state\")");
        TableColumn state2 = new TableColumn(string6, (Function1<? super MavenServerConnector, String>)((Function1)createListModel.state.1.INSTANCE));
        String string7 = MavenConfigurableBundle.message("connector.ui.type", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"MavenConfigurableBundle.\u2026sage(\"connector.ui.type\")");
        TableColumn type2 = new TableColumn(string7, (Function1<? super MavenServerConnector, String>)((Function1)createListModel.type.1.INSTANCE));
        TableColumn[] columnInfos = new TableColumn[]{project2, dir2, type2, maven2, state2};
        ColumnInfo[] columnInfoArray = (ColumnInfo[])columnInfos;
        MavenServerManager mavenServerManager = MavenServerManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)mavenServerManager, (String)"MavenServerManager.getInstance()");
        Collection<MavenServerConnector> collection = mavenServerManager.getAllConnectors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"MavenServerManager.getInstance().allConnectors");
        return new ListTableModel(columnInfoArray, CollectionsKt.toList((Iterable)collection), 3, SortOrder.DESCENDING);
    }

    @NotNull
    protected AnActionButton[] createExtraActions() {
        return new AnActionButton[]{this.refresh, this.stop};
    }

    @Nullable
    protected MavenServerConnector createElement() {
        return null;
    }

    protected boolean isEmpty(@Nullable MavenServerConnector element) {
        return element == null;
    }

    protected boolean canDeleteElement(@NotNull MavenServerConnector selection) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        return false;
    }

    @Nullable
    protected AnActionButtonRunnable createRemoveAction() {
        return null;
    }

    @Nullable
    protected AnActionButtonRunnable createAddAction() {
        return null;
    }

    @Nullable
    protected MavenServerConnector cloneElement(@Nullable MavenServerConnector variable) {
        return null;
    }

    public ConnectorTable() {
        TableView tableView = this.getTableView();
        Intrinsics.checkNotNullExpressionValue((Object)tableView, (String)"tableView");
        ListSelectionModel listSelectionModel = tableView.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)listSelectionModel, (String)"tableView.selectionModel");
        listSelectionModel.setSelectionMode(0);
        TableView tableView2 = this.getTableView();
        Intrinsics.checkNotNullExpressionValue((Object)tableView2, (String)"tableView");
        tableView2.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent it) {
                ListSelectionEvent listSelectionEvent = it;
                Intrinsics.checkNotNullExpressionValue((Object)listSelectionEvent, (String)"it");
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                TableView tableView = this.getTableView();
                Intrinsics.checkNotNullExpressionValue((Object)tableView, (String)"tableView");
                MavenServerConnector connector = (MavenServerConnector)tableView.getSelectedObject();
                MavenServerConnector mavenServerConnector = connector;
                this.getStop().setEnabled((mavenServerConnector != null ? mavenServerConnector.getState() : null) == MavenServerConnector.State.RUNNING);
            }
        });
    }

    public static final /* synthetic */ void access$setModified(ConnectorTable $this) {
        $this.setModified();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/server/ui/ConnectorTable$TableColumn;", "Lcom/intellij/execution/util/ListTableWithButtons$ElementsColumnInfoBase;", "Lorg/jetbrains/idea/maven/server/MavenServerConnector;", "name", "", "supplier", "Lkotlin/Function1;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getSupplier", "()Lkotlin/jvm/functions/Function1;", "getDescription", "element", "valueOf", "item", "intellij.maven"})
    private static final class TableColumn
    extends ListTableWithButtons.ElementsColumnInfoBase<MavenServerConnector> {
        @NotNull
        private final Function1<MavenServerConnector, String> supplier;

        @Nullable
        protected String getDescription(@Nullable MavenServerConnector element) {
            return null;
        }

        @NotNull
        public String valueOf(@NotNull MavenServerConnector item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return (String)this.supplier.invoke((Object)item);
        }

        @NotNull
        public final Function1<MavenServerConnector, String> getSupplier() {
            return this.supplier;
        }

        public TableColumn(@NotNull String name, @NotNull Function1<? super MavenServerConnector, String> supplier) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            super(name);
            this.supplier = supplier;
        }
    }
}

