/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.impl.TrustChangeNotifier;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang.SystemUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.MavenDisposable;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.server.DummyIndexer;
import org.jetbrains.idea.maven.server.DummyMavenServerConnector;
import org.jetbrains.idea.maven.server.LocalMavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.MavenIndexerWrapper;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerConnectorImpl;
import org.jetbrains.idea.maven.server.MavenServerDownloadListener;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.RemotePathTransformerFactory;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.MavenWslUtil;

public final class MavenServerManager
implements Disposable {
    public static final String BUNDLED_MAVEN_2 = "Bundled (Maven 2)";
    public static final String BUNDLED_MAVEN_3 = "Bundled (Maven 3)";
    public static final String WRAPPED_MAVEN = "Use Maven wrapper";
    private final Map<String, MavenServerConnector> myMultimoduleDirToConnectorMap = new HashMap<String, MavenServerConnector>();
    private File eventListenerJar;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<MavenServerConnector> getAllConnectors() {
        Set<MavenServerConnector> set = Collections.newSetFromMap(new IdentityHashMap());
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            set.addAll(this.myMultimoduleDirToConnectorMap.values());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp(MavenServerConnector connector) {
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            this.myMultimoduleDirToConnectorMap.entrySet().removeIf(e -> e.getValue() == connector);
        }
    }

    public static MavenServerManager getInstance() {
        return (MavenServerManager)ApplicationManager.getApplication().getService(MavenServerManager.class);
    }

    @Nullable
    public static MavenServerManager getInstanceIfCreated() {
        return (MavenServerManager)ApplicationManager.getApplication().getServiceIfCreated(MavenServerManager.class);
    }

    public MavenServerManager() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            public void appWillBeClosed(boolean isRestart) {
                ProgressManager.getInstance().run((Task)new Task.Modal(null, RunnerBundle.message("maven.server.shutdown", new Object[0]), false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        MavenServerManager.this.shutdown(true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/server/MavenServerManager$1$1", "run"));
                    }
                });
            }
        });
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ("org.jetbrains.idea.maven".equals(pluginDescriptor.getPluginId().getIdString())) {
                    ProgressManager.getInstance().run((Task)new Task.Modal(null, RunnerBundle.message("maven.server.shutdown", new Object[0]), false){

                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            MavenServerManager.this.shutdown(true);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/server/MavenServerManager$2$1", "run"));
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "org/jetbrains/idea/maven/server/MavenServerManager$2", "beforePluginUnload"));
            }
        });
        connection.subscribe(TrustChangeNotifier.TOPIC, (Object)new TrustChangeNotifier(){

            public void projectTrusted(@NotNull Project project2) {
                MavenProjectsManager manager;
                if (project2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((manager = MavenProjectsManager.getInstance(project2)).isMavenizedProject()) {
                    MavenUtil.restartMavenConnectors(project2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/server/MavenServerManager$3", "projectTrusted"));
            }
        });
    }

    public MavenServerConnector getConnector(@NotNull Project project2, @NotNull String workingDirectory) {
        MavenWorkspaceSettings settings;
        Sdk jdk2;
        String multimoduleDirectory;
        MavenServerConnector connector;
        if (project2 == null) {
            MavenServerManager.$$$reportNull$$$0(0);
        }
        if (workingDirectory == null) {
            MavenServerManager.$$$reportNull$$$0(1);
        }
        if ((connector = this.doGetOrCreateConnector(project2, multimoduleDirectory = MavenDistributionsCache.getInstance(project2).getMultimoduleDirectory(workingDirectory), jdk2 = MavenServerManager.getJdk(project2, settings = MavenWorkspaceSettingsComponent.getInstance(project2).getSettings()))).isNew()) {
            connector.connect();
        } else if (!MavenServerManager.compatibleParameters(project2, connector, jdk2, multimoduleDirectory)) {
            MavenLog.LOG.info("Maven connector in " + multimoduleDirectory + " is incompatible, restarting");
            connector.shutdown(false);
            connector = this.doGetOrCreateConnector(project2, multimoduleDirectory, jdk2);
            connector.connect();
        }
        return connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenServerConnector doGetOrCreateConnector(@NotNull Project project2, @NotNull String multimoduleDirectory, @NotNull Sdk jdk2) {
        MavenServerConnector connector;
        if (project2 == null) {
            MavenServerManager.$$$reportNull$$$0(2);
        }
        if (multimoduleDirectory == null) {
            MavenServerManager.$$$reportNull$$$0(3);
        }
        if (jdk2 == null) {
            MavenServerManager.$$$reportNull$$$0(4);
        }
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            connector = this.myMultimoduleDirToConnectorMap.get(multimoduleDirectory);
            if (connector != null) {
                return connector;
            }
            connector = this.findCompatibleConnector(project2, jdk2, multimoduleDirectory);
            if (connector != null) {
                MavenLog.LOG.info("use existing connector for " + multimoduleDirectory + ":::" + connector.getMultimoduleDirectories());
                connector.addMultimoduleDir(multimoduleDirectory);
            } else {
                connector = this.registerNewConnector(project2, jdk2, multimoduleDirectory);
            }
            this.myMultimoduleDirToConnectorMap.put(multimoduleDirectory, connector);
        }
        return connector;
    }

    @Nullable
    private MavenServerConnector findCompatibleConnector(@NotNull Project project2, @NotNull Sdk jdk2, @NotNull String multimoduleDirectory) {
        if (project2 == null) {
            MavenServerManager.$$$reportNull$$$0(5);
        }
        if (jdk2 == null) {
            MavenServerManager.$$$reportNull$$$0(6);
        }
        if (multimoduleDirectory == null) {
            MavenServerManager.$$$reportNull$$$0(7);
        }
        MavenDistribution distribution = MavenDistributionsCache.getInstance(project2).getMavenDistribution(multimoduleDirectory);
        String vmOptions = MavenDistributionsCache.getInstance(project2).getVmOptions(multimoduleDirectory);
        for (Map.Entry<String, MavenServerConnector> entry : this.myMultimoduleDirToConnectorMap.entrySet()) {
            if (!entry.getValue().getProject().equals(project2)) continue;
            if (Registry.is((String)"maven.server.per.idea.project")) {
                return entry.getValue();
            }
            if (!entry.getValue().isCompatibleWith(jdk2, vmOptions, distribution)) continue;
            return entry.getValue();
        }
        return null;
    }

    @NotNull
    private MavenServerConnector registerNewConnector(Project project2, Sdk jdk2, String multimoduleDirectory) {
        MavenServerConnector connector;
        MavenDistribution distribution = MavenDistributionsCache.getInstance(project2).getMavenDistribution(multimoduleDirectory);
        String vmOptions = MavenDistributionsCache.getInstance(project2).getVmOptions(multimoduleDirectory);
        Integer debugPort = MavenServerManager.getDebugPort(project2);
        if (MavenUtil.isProjectTrustedEnoughToImport(project2, false)) {
            MavenLog.LOG.info("Creating new maven connector for " + project2 + " in " + multimoduleDirectory);
            connector = new MavenServerConnectorImpl(project2, this, jdk2, vmOptions, debugPort, distribution, multimoduleDirectory);
        } else {
            MavenLog.LOG.warn("Project " + project2 + " not trusted enough. Will not start maven for it");
            connector = new DummyMavenServerConnector(project2, this, jdk2, vmOptions, distribution, multimoduleDirectory);
        }
        this.registerDisposable(project2, connector);
        MavenServerConnector mavenServerConnector = connector;
        if (mavenServerConnector == null) {
            MavenServerManager.$$$reportNull$$$0(8);
        }
        return mavenServerConnector;
    }

    private void registerDisposable(Project project2, MavenServerConnector connector) {
        Disposer.register((Disposable)MavenDisposable.getInstance(project2), () -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
            synchronized (map) {
                connector.shutdown(false);
            }
        }));
    }

    private static Integer getDebugPort(Project project2) {
        if (project2.isDefault() && Registry.is((String)"maven.server.debug.default") || Registry.is((String)"maven.server.debug")) {
            try {
                return NetUtils.findAvailableSocketPort();
            }
            catch (IOException e) {
                MavenLog.LOG.warn((Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    private static Sdk getJdk(Project project2, MavenWorkspaceSettings settings) {
        Sdk sdk;
        String jdkForImporterName = settings.getImportingSettings().getJdkForImporter();
        try {
            sdk = MavenUtil.getJdk(project2, jdkForImporterName);
        }
        catch (ExternalSystemJdkException e) {
            Sdk jdk2 = MavenUtil.getJdk(project2, "#USE_PROJECT_JDK");
            MavenProjectsManager.getInstance(project2).getSyncConsole().addWarning(SyncBundle.message("importing.jdk.changed", new Object[0]), SyncBundle.message("importing.jdk.changed.description", jdkForImporterName, jdk2.getName()));
            Sdk sdk2 = jdk2;
            if (sdk2 == null) {
                MavenServerManager.$$$reportNull$$$0(10);
            }
            return sdk2;
        }
        if (sdk == null) {
            MavenServerManager.$$$reportNull$$$0(9);
        }
        return sdk;
    }

    private static boolean compatibleParameters(Project project2, MavenServerConnector connector, Sdk jdk2, String multimoduleDirectory) {
        if (Registry.is((String)"maven.server.per.idea.project")) {
            return true;
        }
        MavenDistributionsCache cache = MavenDistributionsCache.getInstance(project2);
        MavenDistribution distribution = cache.getMavenDistribution(multimoduleDirectory);
        String vmOptions = cache.getVmOptions(multimoduleDirectory);
        return connector.isCompatibleWith(jdk2, vmOptions, distribution);
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown(boolean wait) {
        ArrayList<MavenServerConnector> values;
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            values = new ArrayList<MavenServerConnector>(this.myMultimoduleDirToConnectorMap.values());
        }
        values.forEach(c -> c.shutdown(wait));
    }

    public static boolean verifyMavenSdkRequirements(@NotNull Sdk jdk2, String mavenVersion) {
        if (jdk2 == null) {
            MavenServerManager.$$$reportNull$$$0(11);
        }
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.3.1") < 0) {
            return true;
        }
        JavaSdkVersion version2 = ((JavaSdk)jdk2.getSdkType()).getVersion(jdk2);
        return version2 == null || version2.isAtLeast(JavaSdkVersion.JDK_1_7);
    }

    public static File getMavenEventListener() {
        return MavenServerManager.getInstance().getEventListenerJar();
    }

    private File getEventListenerJar() {
        if (this.eventListenerJar != null) {
            return this.eventListenerJar;
        }
        File pluginFileOrDir = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
        String root = pluginFileOrDir.getParent();
        this.eventListenerJar = pluginFileOrDir.isDirectory() ? MavenServerManager.getEventSpyPathForLocalBuild() : new File(root, "maven-event-listener.jar");
        if (!this.eventListenerJar.exists()) {
            if (ApplicationManager.getApplication().isInternal()) {
                MavenLog.LOG.warn("Event listener does not exist: Please run rebuild for maven modules:\ncommunity/plugins/maven/maven-event-listener\nand all maven*-server* modules");
            } else {
                MavenLog.LOG.warn("Event listener does not exist " + this.eventListenerJar);
            }
        }
        return this.eventListenerJar;
    }

    private static File getEventSpyPathForLocalBuild() {
        File root = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
        return new File(root.getParent(), "intellij.maven.server.eventListener");
    }

    @Nullable
    public String getMavenVersion(@Nullable String mavenHome) {
        return MavenUtil.getMavenVersion(MavenServerManager.getMavenHomeFile(mavenHome));
    }

    @Nullable
    public String getMavenVersion(@Nullable File mavenHome) {
        return MavenUtil.getMavenVersion(mavenHome);
    }

    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public String getCurrentMavenVersion() {
        return null;
    }

    public static List<File> collectClassPathAndLibsFolder(@NotNull MavenDistribution distribution) {
        if (distribution == null) {
            MavenServerManager.$$$reportNull$$$0(12);
        }
        if (!distribution.isValid()) {
            MavenLog.LOG.warn("Maven Distribution " + distribution + " is not valid");
            throw new IllegalArgumentException("Maven distribution at" + distribution.getMavenHome().getAbsolutePath() + " is not valid");
        }
        File pluginFileOrDir = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
        String root = pluginFileOrDir.getParent();
        ArrayList<File> classpath = new ArrayList<File>();
        if (pluginFileOrDir.isDirectory()) {
            MavenLog.LOG.debug("collecting classpath for local run");
            MavenServerManager.prepareClassPathForLocalRunAndUnitTests(distribution.getVersion(), classpath, root);
        } else {
            MavenLog.LOG.debug("collecting classpath for production");
            MavenServerManager.prepareClassPathForProduction(distribution.getVersion(), classpath, root);
        }
        MavenServerManager.addMavenLibs(classpath, distribution.getMavenHome());
        MavenLog.LOG.debug("Collected classpath = ", new Object[]{classpath});
        return classpath;
    }

    private static void prepareClassPathForProduction(@NotNull String mavenVersion, List<File> classpath, String root) {
        if (mavenVersion == null) {
            MavenServerManager.$$$reportNull$$$0(13);
        }
        classpath.add(new File(PathUtil.getJarPathForClass(MavenId.class)));
        classpath.add(new File(root, "maven-server-api.jar"));
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3") < 0) {
            classpath.add(new File(root, "maven2-server.jar"));
            MavenServerManager.addDir(classpath, new File(root, "maven2-server-lib"), f -> true);
        } else {
            classpath.add(new File(root, "maven3-server-common.jar"));
            MavenServerManager.addDir(classpath, new File(root, "maven3-server-lib"), f -> true);
            if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.1") < 0) {
                classpath.add(new File(root, "maven30-server.jar"));
            } else {
                classpath.add(new File(root, "maven3-server.jar"));
                if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.6") >= 0) {
                    classpath.add(new File(root, "maven36-server.jar"));
                }
            }
        }
    }

    private static void prepareClassPathForLocalRunAndUnitTests(@NotNull String mavenVersion, List<File> classpath, String root) {
        if (mavenVersion == null) {
            MavenServerManager.$$$reportNull$$$0(14);
        }
        classpath.add(new File(PathUtil.getJarPathForClass(MavenId.class)));
        classpath.add(new File(root, "intellij.maven.server"));
        File parentFile = MavenUtil.getMavenPluginParentFile();
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3") < 0) {
            classpath.add(new File(root, "intellij.maven.server.m2.impl"));
            MavenServerManager.addDir(classpath, new File(parentFile, "maven2-server-impl/lib"), f -> true);
        } else {
            classpath.add(new File(root, "intellij.maven.server.m3.common"));
            MavenServerManager.addDir(classpath, new File(parentFile, "maven3-server-common/lib"), f -> true);
            if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.1") < 0) {
                classpath.add(new File(root, "intellij.maven.server.m30.impl"));
            } else {
                classpath.add(new File(root, "intellij.maven.server.m3.impl"));
                if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.6") >= 0) {
                    classpath.add(new File(root, "intellij.maven.server.m36.impl"));
                }
            }
        }
    }

    private static void addMavenLibs(List<File> classpath, File mavenHome) {
        MavenServerManager.addDir(classpath, new File(mavenHome, "lib"), f -> !f.getName().contains("maven-slf4j-provider"));
        File bootFolder = new File(mavenHome, "boot");
        File[] classworldsJars = bootFolder.listFiles((dir2, name) -> StringUtil.contains((CharSequence)name, (CharSequence)"classworlds"));
        if (classworldsJars != null) {
            Collections.addAll(classpath, classworldsJars);
        }
    }

    private static void addDir(List<File> classpath, File dir2, Predicate<File> filter) {
        File[] files = dir2.listFiles();
        if (files == null) {
            return;
        }
        for (File jar : files) {
            if (!jar.isFile() || !jar.getName().endsWith(".jar") || !filter.test(jar)) continue;
            classpath.add(jar);
        }
    }

    public MavenEmbedderWrapper createEmbedder(final Project project2, final boolean alwaysOnline, final @Nullable String workingDirectory, final @NotNull String multiModuleProjectDirectory) {
        if (multiModuleProjectDirectory == null) {
            MavenServerManager.$$$reportNull$$$0(15);
        }
        return new MavenEmbedderWrapper(project2, null){

            @Override
            @NotNull
            protected MavenServerEmbedder create() throws RemoteException {
                MavenServerSettings settings = MavenServerManager.convertSettings(project2, MavenProjectsManager.getInstance(project2).getGeneralSettings());
                if (alwaysOnline && settings.isOffline()) {
                    settings = settings.clone();
                    settings.setOffline(false);
                }
                settings.setProjectJdk(MavenUtil.getSdkPath(ProjectRootManager.getInstance((Project)project2).getProjectSdk()));
                MavenServerEmbedder mavenServerEmbedder = MavenServerManager.this.getConnector(project2, multiModuleProjectDirectory).createEmbedder(new MavenEmbedderSettings(settings, workingDirectory, multiModuleProjectDirectory));
                if (mavenServerEmbedder == null) {
                    4.$$$reportNull$$$0(0);
                }
                return mavenServerEmbedder;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManager$4", "create"));
            }
        };
    }

    public MavenIndexerWrapper createIndexer(final @NotNull Project project2) {
        String path;
        if (project2 == null) {
            MavenServerManager.$$$reportNull$$$0(16);
        }
        if ((path = project2.getBasePath()) == null) {
            path = new File(".").getPath();
        }
        final String finalPath = path;
        if (MavenWslUtil.tryGetWslDistributionForPath(path) != null) {
            return new MavenIndexerWrapper(null, project2){

                @Override
                @NotNull
                protected MavenServerIndexer create() throws RemoteException {
                    return new DummyIndexer();
                }
            };
        }
        return new MavenIndexerWrapper(null, project2){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NotNull
            protected MavenServerIndexer create() throws RemoteException {
                MavenServerConnector connector;
                Map<String, MavenServerConnector> map = MavenServerManager.this.myMultimoduleDirToConnectorMap;
                synchronized (map) {
                    connector = (MavenServerConnector)ContainerUtil.find(MavenServerManager.this.myMultimoduleDirToConnectorMap.values(), c -> ContainerUtil.find(c.myMultimoduleDirectories, mDir -> FileUtil.isAncestor((String)finalPath, (String)mDir, (boolean)false)) != null);
                }
                if (connector != null) {
                    MavenServerIndexer mavenServerIndexer = connector.createIndexer();
                    if (mavenServerIndexer == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    return mavenServerIndexer;
                }
                MavenServerIndexer mavenServerIndexer = MavenServerManager.this.getConnector(project2, (String)ObjectUtils.chooseNotNull((Object)project2.getBasePath(), (Object)SystemUtils.getUserHome().getAbsolutePath())).createIndexer();
                if (mavenServerIndexer == null) {
                    6.$$$reportNull$$$0(1);
                }
                return mavenServerIndexer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManager$6", "create"));
            }
        };
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public MavenIndexerWrapper createIndexer() {
        return this.createIndexer(ProjectManager.getInstance().getDefaultProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownloadListener(MavenServerDownloadListener listener2) {
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            this.myMultimoduleDirToConnectorMap.values().forEach(connector -> connector.addDownloadListener(listener2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadListener(MavenServerDownloadListener listener2) {
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            this.myMultimoduleDirToConnectorMap.values().forEach(connector -> connector.removeDownloadListener(listener2));
        }
    }

    public static MavenServerSettings convertSettings(Project project2, MavenGeneralSettings settings) {
        RemotePathTransformerFactory.Transformer transformer = RemotePathTransformerFactory.createForProject(project2);
        MavenServerSettings result = new MavenServerSettings();
        result.setLoggingLevel(settings.getOutputLevel().getLevel());
        result.setOffline(settings.isWorkOffline());
        result.setMavenHome(settings.getEffectiveMavenHome());
        result.setUserSettingsFile(transformer == RemotePathTransformerFactory.Transformer.ID ? settings.getEffectiveUserSettingsIoFile() : null);
        result.setGlobalSettingsFile(transformer == RemotePathTransformerFactory.Transformer.ID ? settings.getEffectiveGlobalSettingsIoFile() : null);
        result.setLocalRepository(transformer == RemotePathTransformerFactory.Transformer.ID ? settings.getEffectiveLocalRepository() : null);
        result.setPluginUpdatePolicy(settings.getPluginUpdatePolicy().getServerPolicy());
        result.setSnapshotUpdatePolicy(settings.isAlwaysUpdateSnapshots() ? MavenServerSettings.UpdatePolicy.ALWAYS_UPDATE : MavenServerSettings.UpdatePolicy.DO_NOT_UPDATE);
        return result;
    }

    public boolean isUseMaven2() {
        return false;
    }

    @Nullable
    @ApiStatus.Internal
    public static File getMavenHomeFile(@Nullable String mavenHome) {
        if (mavenHome == null) {
            return null;
        }
        if (StringUtil.equals((CharSequence)BUNDLED_MAVEN_2, (CharSequence)mavenHome) && ApplicationManager.getApplication().isUnitTestMode()) {
            return MavenServerManager.resolveEmbeddedMaven2HomeForTests().getMavenHome();
        }
        if (StringUtil.equals((CharSequence)BUNDLED_MAVEN_3, (CharSequence)mavenHome) || StringUtil.equals((CharSequence)MavenProjectBundle.message("maven.bundled.version.title", new Object[0]), (CharSequence)mavenHome)) {
            return MavenDistributionsCache.resolveEmbeddedMavenHome().getMavenHome();
        }
        File home = new File(mavenHome);
        return MavenUtil.isValidMavenHome(home) ? home : null;
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public String getMavenEmbedderVMOptions() {
        return "";
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public void setMavenEmbedderVMOptions(@NotNull String mavenEmbedderVMOptions) {
        if (mavenEmbedderVMOptions == null) {
            MavenServerManager.$$$reportNull$$$0(17);
        }
    }

    @NotNull
    private static LocalMavenDistribution resolveEmbeddedMaven2HomeForTests() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException("Maven2 is for test purpose only");
        }
        File pluginFileOrDir = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
        if (pluginFileOrDir.isDirectory()) {
            File parentFile = MavenUtil.getMavenPluginParentFile();
            return new LocalMavenDistribution(new File(parentFile, "maven2-server-impl/lib/maven2"), BUNDLED_MAVEN_2);
        }
        throw new IllegalStateException("Maven2 is not bundled anymore, please do not try to use it in tests");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multimoduleDirectory";
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenServerManager";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenVersion";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiModuleProjectDirectory";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenEmbedderVMOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenServerManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "registerNewConnector";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConnector";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doGetOrCreateConnector";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findCompatibleConnector";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "verifyMavenSdkRequirements";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectClassPathAndLibsFolder";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassPathForProduction";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassPathForLocalRunAndUnitTests";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createEmbedder";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createIndexer";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setMavenEmbedderVMOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

