/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.server.LocalMavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionConverter;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenWrapperSupport;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenDistributionsCache {
    private final ConcurrentMap<String, String> myWorkingDirToMultimoduleMap = ContainerUtil.createConcurrentWeakMap();
    private final ConcurrentMap<String, String> myVmSettingsMap = ContainerUtil.createConcurrentWeakMap();
    private final ConcurrentMap<String, MavenDistribution> myMultimoduleDirToWrapperedMavenDistributionsMap = new ConcurrentHashMap<String, MavenDistribution>();
    private final Project myProject;
    private final ClearableLazyValue<MavenDistribution> mySettingsDistribution = ClearableLazyValue.create(() -> this.getSettingsDistribution());

    public MavenDistributionsCache(Project project2) {
        this.myProject = project2;
    }

    public static MavenDistributionsCache getInstance(Project project2) {
        return (MavenDistributionsCache)project2.getService(MavenDistributionsCache.class);
    }

    public void cleanCaches() {
        this.mySettingsDistribution.drop();
        this.myWorkingDirToMultimoduleMap.clear();
        this.myMultimoduleDirToWrapperedMavenDistributionsMap.clear();
        this.myVmSettingsMap.clear();
    }

    @NotNull
    public MavenDistribution getSettingsDistribution() {
        MavenWorkspaceSettings settings = MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings();
        MavenDistribution distribution = new MavenDistributionConverter().fromString(settings.getGeneralSettings().getMavenHome());
        if (distribution == null) {
            MavenProjectsManager.getInstance(this.myProject).getSyncConsole().addWarning(SyncBundle.message("cannot.resolve.maven.home", new Object[0]), SyncBundle.message("is.not.correct.maven.home.reverting.to.embedded", settings.generalSettings.getMavenHome()));
            return MavenDistributionsCache.resolveEmbeddedMavenHome();
        }
        MavenDistribution mavenDistribution = distribution;
        if (mavenDistribution == null) {
            MavenDistributionsCache.$$$reportNull$$$0(0);
        }
        return mavenDistribution;
    }

    @NotNull
    public String getVmOptions(@Nullable String workingDirectory) {
        String vmOptions = MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings().getImportingSettings().getVmOptionsForImporter();
        if (workingDirectory == null || !StringUtil.isEmptyOrSpaces((String)vmOptions)) {
            String string = vmOptions;
            if (string == null) {
                MavenDistributionsCache.$$$reportNull$$$0(1);
            }
            return string;
        }
        String multiModuleDir = this.myWorkingDirToMultimoduleMap.computeIfAbsent(workingDirectory, this::resolveMultimoduleDirectory);
        String string = this.myVmSettingsMap.computeIfAbsent(multiModuleDir, MavenExternalParameters::readJvmConfigOptions);
        if (string == null) {
            MavenDistributionsCache.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public MavenDistribution getMavenDistribution(@Nullable String workingDirectory) {
        if (!this.useWrapper() || workingDirectory == null) {
            MavenDistribution mavenDistribution = (MavenDistribution)this.mySettingsDistribution.getValue();
            if (mavenDistribution == null) {
                MavenDistributionsCache.$$$reportNull$$$0(3);
            }
            return mavenDistribution;
        }
        String multiModuleDir = this.myWorkingDirToMultimoduleMap.computeIfAbsent(workingDirectory, this::resolveMultimoduleDirectory);
        MavenDistribution mavenDistribution = this.myMultimoduleDirToWrapperedMavenDistributionsMap.computeIfAbsent(multiModuleDir, this::getWrapperDistribution);
        if (mavenDistribution == null) {
            MavenDistributionsCache.$$$reportNull$$$0(4);
        }
        return mavenDistribution;
    }

    @NotNull
    private MavenDistribution getWrapperDistribution(@NotNull String multiModuleDir) {
        if (multiModuleDir == null) {
            MavenDistributionsCache.$$$reportNull$$$0(5);
        }
        MavenWorkspaceSettings settings = MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings();
        String distributionUrl = MavenDistributionsCache.getWrapperDistributionUrl(multiModuleDir);
        if (distributionUrl == null) {
            MavenProjectsManager.getInstance(this.myProject).getSyncConsole().addWarning(SyncBundle.message("cannot.resolve.maven.home", new Object[0]), SyncBundle.message("is.not.correct.maven.home.reverting.to.embedded", settings.generalSettings.getMavenHome()));
            return MavenDistributionsCache.resolveEmbeddedMavenHome();
        }
        MavenDistribution mavenDistribution = this.doResolveMavenWrapper(distributionUrl, multiModuleDir);
        if (mavenDistribution == null) {
            MavenDistributionsCache.$$$reportNull$$$0(6);
        }
        return mavenDistribution;
    }

    private MavenDistribution doResolveMavenWrapper(String distributionUrl, String multiModuleDir) {
        MavenSyncConsole console = MavenProjectsManager.getInstance(this.myProject).getSyncConsole();
        try {
            console.startWrapperResolving();
            MavenDistribution distribution = new MavenWrapperSupport().downloadAndInstallMaven(distributionUrl, console.progressIndicatorForWrapper());
            if (distributionUrl.toLowerCase(Locale.ENGLISH).startsWith("http:")) {
                MavenWrapperSupport.showUnsecureWarning(console, LocalFileSystem.getInstance().findFileByPath(multiModuleDir));
            }
            console.finishWrapperResolving(null);
            return distribution;
        }
        catch (Exception e) {
            console.finishWrapperResolving(e);
            LocalMavenDistribution distribution = MavenDistributionsCache.resolveEmbeddedMavenHome();
            return new LocalMavenDistribution(distribution.getMavenHome(), distributionUrl);
        }
    }

    @NotNull
    public static LocalMavenDistribution resolveEmbeddedMavenHome() {
        File pluginFileOrDir = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
        String root = pluginFileOrDir.getParent();
        if (pluginFileOrDir.isDirectory()) {
            File parentFile = MavenUtil.getMavenPluginParentFile();
            File mavenFile = new File(parentFile, "maven36-server-impl/lib/maven3");
            if (mavenFile.isDirectory()) {
                return new LocalMavenDistribution(mavenFile, "Bundled (Maven 3)");
            }
        } else {
            return new LocalMavenDistribution(new File(root, "maven3"), "Bundled (Maven 3)");
        }
        throw new RuntimeException("run setupBundledMaven.gradle task. Cannot resolve embedded maven home without it");
    }

    @Nullable
    private static String getWrapperDistributionUrl(String multimoduleDirectory) {
        VirtualFile baseDir = LocalFileSystem.getInstance().findFileByPath(multimoduleDirectory);
        if (baseDir == null) {
            return null;
        }
        return MavenWrapperSupport.getWrapperDistributionUrl(baseDir);
    }

    @NotNull
    private String resolveMultimoduleDirectory(@NotNull String workingDirectory) {
        MavenProjectsManager manager;
        if (workingDirectory == null) {
            MavenDistributionsCache.$$$reportNull$$$0(7);
        }
        if (!(manager = MavenProjectsManager.getInstance(this.myProject)).isMavenizedProject()) {
            String string = FileUtil.toSystemIndependentName((String)this.calculateMultimoduleDirUpToFileTree(workingDirectory));
            if (string == null) {
                MavenDistributionsCache.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = FileUtil.toSystemIndependentName((String)manager.getRootProjects().stream().map(p -> p.getDirectory()).filter(rpDirectory -> FileUtil.isAncestor((String)rpDirectory, (String)workingDirectory, (boolean)false)).findFirst().orElseGet(() -> this.calculateMultimoduleDirUpToFileTree(workingDirectory)));
        if (string == null) {
            MavenDistributionsCache.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private String calculateMultimoduleDirUpToFileTree(String directory) {
        VirtualFile path = LocalFileSystem.getInstance().findFileByPath(directory);
        if (path == null) {
            String string = directory;
            if (string == null) {
                MavenDistributionsCache.$$$reportNull$$$0(10);
            }
            return string;
        }
        Collection knownWorkingDirs = this.myWorkingDirToMultimoduleMap.values();
        for (String known : knownWorkingDirs) {
            if (!FileUtil.isAncestor((String)known, (String)directory, (boolean)false)) continue;
            String string = known;
            if (string == null) {
                MavenDistributionsCache.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = MavenUtil.getVFileBaseDir(path).getPath();
        if (string == null) {
            MavenDistributionsCache.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getMultimoduleDirectory(@NotNull String workingDirectory) {
        if (workingDirectory == null) {
            MavenDistributionsCache.$$$reportNull$$$0(13);
        }
        String string = this.myWorkingDirToMultimoduleMap.computeIfAbsent(workingDirectory, this::resolveMultimoduleDirectory);
        if (string == null) {
            MavenDistributionsCache.$$$reportNull$$$0(14);
        }
        return string;
    }

    private boolean useWrapper() {
        MavenWorkspaceSettings settings = MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings();
        return "Use Maven wrapper".equals(settings.getGeneralSettings().getMavenHome()) || StringUtil.equals((CharSequence)settings.getGeneralSettings().getMavenHome(), (CharSequence)MavenProjectBundle.message("maven.wrapper.version.title", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 7: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 7: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenDistributionsCache";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiModuleDir";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsDistribution";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmOptions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenDistribution";
                break;
            }
            case 5: 
            case 7: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenDistributionsCache";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapperDistribution";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMultimoduleDirectory";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateMultimoduleDirUpToFileTree";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultimoduleDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getWrapperDistribution";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveMultimoduleDirectory";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getMultimoduleDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

