/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenRemoteProcessSupportFactory;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenLog;

public abstract class AbstractMavenServerRemoteProcessSupport
extends MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport {
    protected final Sdk myJdk;
    protected final String myOptions;
    protected final MavenDistribution myDistribution;
    protected final Project myProject;
    protected final Integer myDebugPort;
    @Nullable
    protected Consumer<ProcessEvent> onTerminate;

    public AbstractMavenServerRemoteProcessSupport(@NotNull Sdk jdk2, @Nullable String vmOptions, @NotNull MavenDistribution mavenDistribution, @NotNull Project project2, @Nullable Integer debugPort) {
        if (jdk2 == null) {
            AbstractMavenServerRemoteProcessSupport.$$$reportNull$$$0(0);
        }
        if (mavenDistribution == null) {
            AbstractMavenServerRemoteProcessSupport.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            AbstractMavenServerRemoteProcessSupport.$$$reportNull$$$0(2);
        }
        super(MavenServer.class);
        this.myJdk = jdk2;
        this.myOptions = vmOptions;
        this.myDistribution = mavenDistribution;
        this.myProject = project2;
        this.myDebugPort = debugPort;
    }

    protected void fireModificationCountChanged() {
    }

    protected String getName(@NotNull Object file) {
        if (file == null) {
            AbstractMavenServerRemoteProcessSupport.$$$reportNull$$$0(3);
        }
        return MavenServerManager.class.getSimpleName();
    }

    protected void sendDataAfterStart(ProcessHandler handler) {
        if (handler.getProcessInput() == null) {
            return;
        }
        OutputStreamWriter writer = new OutputStreamWriter(handler.getProcessInput(), StandardCharsets.UTF_8);
        try {
            writer.write("token=" + MavenRemoteObjectWrapper.ourToken);
            writer.write(System.lineSeparator());
            writer.flush();
            MavenLog.LOG.info("Sent token to maven server");
        }
        catch (IOException e) {
            MavenLog.LOG.warn("Cannot send token to maven server", (Throwable)e);
        }
    }

    @Override
    public void onTerminate(Consumer<ProcessEvent> onTerminate) {
        this.onTerminate = onTerminate;
    }

    protected void onProcessTerminated(ProcessEvent event) {
        Project[] openProjects;
        if (event.getExitCode() == 0) {
            return;
        }
        Consumer<ProcessEvent> eventConsumer = this.onTerminate;
        if (eventConsumer != null) {
            eventConsumer.accept(event);
        }
        for (Project p : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            ReadAction.run(() -> {
                if (p.isDisposed()) {
                    return;
                }
                MavenProjectsManager manager = MavenProjectsManager.getInstance(p);
                if (!manager.isMavenizedProject()) {
                    return;
                }
                manager.terminateImport(event.getExitCode());
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenDistribution";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/server/AbstractMavenServerRemoteProcessSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

