/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.UntrustedProjectModeProvider;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/project/MavenUntrustedModeProvider;", "Lcom/intellij/openapi/externalSystem/service/project/UntrustedProjectModeProvider;", "()V", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "Lorg/jetbrains/annotations/NotNull;", "getSystemId", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "loadAllLinkedProjects", "", "project", "Lcom/intellij/openapi/project/Project;", "shouldShowEditorNotification", "", "intellij.maven"})
public final class MavenUntrustedModeProvider
implements UntrustedProjectModeProvider {
    @NotNull
    private final ProjectSystemId systemId;

    @NotNull
    public ProjectSystemId getSystemId() {
        return this.systemId;
    }

    public boolean shouldShowEditorNotification(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"MavenProjectsManager.getInstance(project)");
        return mavenProjectsManager.isMavenizedProject();
    }

    public void loadAllLinkedProjects(@NotNull Project project2) {
        MavenProjectsManager manager;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        MavenProjectsManager mavenProjectsManager = manager = MavenProjectsManager.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"manager");
        if (mavenProjectsManager.isMavenizedProject()) {
            manager.forceUpdateAllProjectsOrFindAllAvailablePomFiles();
        }
    }

    public MavenUntrustedModeProvider() {
        ProjectSystemId projectSystemId = MavenUtil.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"MavenUtil.SYSTEM_ID");
        this.systemId = projectSystemId;
    }
}

