/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.Collection;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenArtifactDownloader;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectResolver;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public class MavenProjectsProcessorArtifactsDownloadingTask
implements MavenProjectsProcessorTask {
    private final Collection<MavenProject> myProjects;
    private final Collection<MavenArtifact> myArtifacts;
    private final boolean myDownloadSources;
    private final boolean myDownloadDocs;
    private final AsyncPromise<? super MavenArtifactDownloader.DownloadResult> myCallbackResult;
    private final MavenProjectResolver myResolver;

    public MavenProjectsProcessorArtifactsDownloadingTask(Collection<MavenProject> projects, Collection<MavenArtifact> artifacts, MavenProjectResolver resolver, boolean downloadSources, boolean downloadDocs, AsyncPromise<? super MavenArtifactDownloader.DownloadResult> callbackResult) {
        this.myProjects = projects;
        this.myArtifacts = artifacts;
        this.myResolver = resolver;
        this.myDownloadSources = downloadSources;
        this.myDownloadDocs = downloadDocs;
        this.myCallbackResult = callbackResult;
    }

    @Override
    public void perform(Project project2, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        MavenArtifactDownloader.DownloadResult result = this.myResolver.downloadSourcesAndJavadocs(project2, this.myProjects, this.myArtifacts, this.myDownloadSources, this.myDownloadDocs, embeddersManager, console, indicator);
        if (this.myCallbackResult != null) {
            this.myCallbackResult.setResult((Object)result);
        }
        ApplicationManager.getApplication().invokeLater(() -> VirtualFileManager.getInstance().asyncRefresh(null));
    }
}

