/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTracker;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenGeneralSettingsWatcher;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsAware;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessor;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorReadingTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenLog;

public class MavenProjectsManagerWatcher {
    private static final Logger LOG = Logger.getInstance(MavenProjectsManagerWatcher.class);
    private final Project myProject;
    private final MavenProjectsTree myProjectsTree;
    private final MavenGeneralSettings myGeneralSettings;
    private final MavenProjectsProcessor myReadingProcessor;
    private final MavenProjectsAware myProjectsAware;
    private final ExecutorService myBackgroundExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"MavenProjectsManagerWatcher.backgroundExecutor", (int)1);
    private final Disposable myDisposable;

    public MavenProjectsManagerWatcher(Project project2, MavenProjectsTree projectsTree, MavenGeneralSettings generalSettings, MavenProjectsProcessor readingProcessor) {
        this.myProject = project2;
        this.myProjectsTree = projectsTree;
        this.myGeneralSettings = generalSettings;
        this.myReadingProcessor = readingProcessor;
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
        this.myProjectsAware = new MavenProjectsAware(project2, projectsTree, projectsManager, this, this.myBackgroundExecutor);
        this.myDisposable = Disposer.newDisposable((Disposable)projectsManager, (String)MavenProjectsManagerWatcher.class.toString());
    }

    public synchronized void start() {
        MessageBusConnection busConnection = this.myProject.getMessageBus().connect(this.myDisposable);
        busConnection.subscribe(ProjectTopics.MODULES, (Object)new MavenIgnoredModulesWatcher());
        busConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyRootChangesListener());
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
        MavenGeneralSettingsWatcher.registerGeneralSettingsWatcher(projectsManager, this, this.myBackgroundExecutor, this.myDisposable);
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance((Project)this.myProject);
        projectTracker.register((ExternalSystemProjectAware)this.myProjectsAware, (Disposable)projectsManager);
        projectTracker.activate(this.myProjectsAware.getProjectId());
    }

    @TestOnly
    public synchronized void enableAutoImportInTests() {
        AutoImportProjectTracker.getInstance((Project)this.myProject).enableAutoImportInTests();
    }

    public synchronized void stop() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    public synchronized void addManagedFilesWithProfiles(List<VirtualFile> files, MavenExplicitProfiles explicitProfiles) {
        this.myProjectsTree.addManagedFilesWithProfiles(files, explicitProfiles);
        this.scheduleUpdateAll(false, true);
    }

    @TestOnly
    public synchronized void resetManagedFilesAndProfilesInTests(List<VirtualFile> files, MavenExplicitProfiles explicitProfiles) {
        this.myProjectsTree.resetManagedFilesAndProfiles(files, explicitProfiles);
        this.scheduleUpdateAll(false, true);
    }

    public synchronized void removeManagedFiles(List<VirtualFile> files) {
        this.myProjectsTree.removeManagedFiles(files);
        this.scheduleUpdateAll(false, true);
    }

    public synchronized void setExplicitProfiles(MavenExplicitProfiles profiles) {
        this.myProjectsTree.setExplicitProfiles(profiles);
        this.scheduleUpdateAll(false, false);
    }

    public Promise<Void> scheduleUpdateAll(boolean force, boolean forceImportAndResolve) {
        AsyncPromise promise = new AsyncPromise();
        Runnable onCompletion = this.createScheduleImportAction(forceImportAndResolve, (AsyncPromise<Void>)promise);
        this.scheduleReadingTask(new MavenProjectsProcessorReadingTask(force, this.myProjectsTree, this.myGeneralSettings, onCompletion));
        return promise;
    }

    public Promise<Void> scheduleUpdate(List<VirtualFile> filesToUpdate, List<VirtualFile> filesToDelete, boolean force, boolean forceImportAndResolve) {
        AsyncPromise promise = new AsyncPromise();
        Runnable onCompletion = this.createScheduleImportAction(forceImportAndResolve, (AsyncPromise<Void>)promise);
        if (LOG.isDebugEnabled()) {
            String withForceOptionMessage = force ? " with force option" : "";
            LOG.debug("Scheduling update for " + this.myProjectsTree + withForceOptionMessage + ". Files to update: " + filesToUpdate + ". Files to delete: " + filesToDelete);
        }
        this.scheduleReadingTask(new MavenProjectsProcessorReadingTask(filesToUpdate, filesToDelete, force, this.myProjectsTree, this.myGeneralSettings, onCompletion));
        return promise;
    }

    private void scheduleReadingTask(@NotNull MavenProjectsProcessorReadingTask readingTask) {
        if (readingTask == null) {
            MavenProjectsManagerWatcher.$$$reportNull$$$0(0);
        }
        this.myReadingProcessor.scheduleTask(readingTask);
    }

    @NotNull
    private Runnable createScheduleImportAction(boolean forceImportAndResolve, AsyncPromise<Void> promise) {
        Runnable runnable = () -> {
            if (this.myProject.isDisposed()) {
                promise.setError("Project disposed");
                return;
            }
            if (forceImportAndResolve) {
                MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
                projectsManager.scheduleImportAndResolve().onSuccess(modules -> promise.setResult(null));
            } else {
                promise.setResult(null);
            }
        };
        if (runnable == null) {
            MavenProjectsManagerWatcher.$$$reportNull$$$0(1);
        }
        return runnable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readingTask";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createScheduleImportAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "scheduleReadingTask";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MavenIgnoredModulesWatcher
    implements ModuleListener {
        private MavenIgnoredModulesWatcher() {
        }

        public void moduleRemoved(@NotNull Project project2, @NotNull Module module) {
            if (project2 == null) {
                MavenIgnoredModulesWatcher.$$$reportNull$$$0(0);
            }
            if (module == null) {
                MavenIgnoredModulesWatcher.$$$reportNull$$$0(1);
            }
            if (Registry.is((String)"maven.modules.do.not.ignore.on.delete")) {
                return;
            }
            MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(MavenProjectsManagerWatcher.this.myProject);
            MavenProject mavenProject = projectsManager.findProject(module);
            if (mavenProject != null && !projectsManager.isIgnored(mavenProject)) {
                VirtualFile file = mavenProject.getFile();
                if (projectsManager.isManagedFile(file) && projectsManager.getModules(mavenProject).isEmpty()) {
                    MavenLog.LOG.info("remove managed maven project  + " + mavenProject + "because there is no module for it");
                    projectsManager.removeManagedFiles(Collections.singletonList(file));
                } else {
                    if (projectsManager.getRootProjects().contains(mavenProject)) {
                        MavenLog.LOG.info("Requested to ignore " + mavenProject + ", will not do it because it is a root project");
                        return;
                    }
                    MavenLog.LOG.info("Ignoring " + mavenProject);
                    projectsManager.setIgnoredState(Collections.singletonList(mavenProject), true);
                }
            }
        }

        public void moduleAdded(@NotNull Project project2, @NotNull Module module) {
            if (project2 == null) {
                MavenIgnoredModulesWatcher.$$$reportNull$$$0(2);
            }
            if (module == null) {
                MavenIgnoredModulesWatcher.$$$reportNull$$$0(3);
            }
            if (Registry.is((String)"maven.modules.do.not.ignore.on.delete")) {
                return;
            }
            MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(MavenProjectsManagerWatcher.this.myProject);
            MavenProject mavenProject = projectsManager.findProject(module);
            if (mavenProject != null) {
                projectsManager.setIgnoredState(Collections.singletonList(mavenProject), false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher$MavenIgnoredModulesWatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moduleRemoved";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moduleAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyRootChangesListener
    implements ModuleRootListener {
        private MyRootChangesListener() {
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            if (event == null) {
                MyRootChangesListener.$$$reportNull$$$0(0);
            }
            List<VirtualFile> existingFiles = MavenProjectsManagerWatcher.this.myProjectsTree.getProjectsFiles();
            ArrayList<VirtualFile> newFiles = new ArrayList<VirtualFile>();
            ArrayList<VirtualFile> deletedFiles = new ArrayList<VirtualFile>();
            for (VirtualFile f : MavenProjectsManagerWatcher.this.myProjectsTree.getExistingManagedFiles()) {
                if (existingFiles.contains(f)) continue;
                newFiles.add(f);
            }
            for (VirtualFile f : existingFiles) {
                if (f.isValid()) continue;
                deletedFiles.add(f);
            }
            if (!deletedFiles.isEmpty() || !newFiles.isEmpty()) {
                MavenProjectsManagerWatcher.this.scheduleUpdate(newFiles, deletedFiles, false, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher$MyRootChangesListener", "rootsChanged"));
        }
    }
}

