/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Property;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;

public class MavenImportingSettings
implements Cloneable {
    private static final Logger LOG = Logger.getInstance(MavenImportingSettings.class);
    private static final String PROCESS_RESOURCES_PHASE = "process-resources";
    public static final String[] UPDATE_FOLDERS_PHASES = new String[]{"generate-sources", "process-sources", "generate-resources", "process-resources", "generate-test-sources", "process-test-sources", "generate-test-resources", "process-test-resources"};
    public static final String UPDATE_FOLDERS_DEFAULT_PHASE = "process-resources";
    public static final String DEFAULT_DEPENDENCY_TYPES = "jar, test-jar, maven-plugin, ejb, ejb-client, jboss-har, jboss-sar, war, ear, bundle";
    @NotNull
    @NlsSafe
    private String dedicatedModuleDir = "";
    private boolean lookForNested = false;
    private boolean importAutomatically = false;
    private boolean createModulesForAggregators = true;
    private boolean createModuleGroups = false;
    private boolean excludeTargetFolder = true;
    private boolean keepSourceFolders = true;
    private boolean useMavenOutput = true;
    @NlsSafe
    private String updateFoldersOnImportPhase = "process-resources";
    private boolean downloadSourcesAutomatically = false;
    private boolean downloadDocsAutomatically = false;
    private boolean downloadAnnotationsAutomatically = false;
    private boolean autoDetectCompiler = true;
    private GeneratedSourcesFolder generatedSourcesFolder = GeneratedSourcesFolder.AUTODETECT;
    private String dependencyTypes = "jar, test-jar, maven-plugin, ejb, ejb-client, jboss-har, jboss-sar, war, ear, bundle";
    private Set<String> myDependencyTypesAsSet;
    @NotNull
    @NlsSafe
    private String vmOptionsForImporter = "";
    @NotNull
    @NlsSafe
    private String jdkForImporter = "#JAVA_INTERNAL";
    private List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    @NotNull
    @NlsSafe
    public String getDedicatedModuleDir() {
        String string = this.dedicatedModuleDir;
        if (string == null) {
            MavenImportingSettings.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setDedicatedModuleDir(@NotNull String dedicatedModuleDir) {
        if (dedicatedModuleDir == null) {
            MavenImportingSettings.$$$reportNull$$$0(1);
        }
        this.dedicatedModuleDir = dedicatedModuleDir;
    }

    public boolean isLookForNested() {
        return this.lookForNested;
    }

    public void setLookForNested(boolean lookForNested) {
        this.lookForNested = lookForNested;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public boolean isImportAutomatically() {
        return this.importAutomatically;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void setImportAutomatically(boolean importAutomatically) {
        this.importAutomatically = importAutomatically;
    }

    @NotNull
    public String getDependencyTypes() {
        String string = this.dependencyTypes;
        if (string == null) {
            MavenImportingSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setDependencyTypes(@NotNull String dependencyTypes) {
        if (dependencyTypes == null) {
            MavenImportingSettings.$$$reportNull$$$0(3);
        }
        this.dependencyTypes = dependencyTypes;
        this.myDependencyTypesAsSet = null;
    }

    @NotNull
    public Set<String> getDependencyTypesAsSet() {
        if (this.myDependencyTypesAsSet == null) {
            LinkedHashSet<String> res = new LinkedHashSet<String>();
            for (String type2 : StringUtil.tokenize((String)this.dependencyTypes, (String)" \n\r\t,;")) {
                res.add(type2);
            }
            this.myDependencyTypesAsSet = res;
        }
        Set<String> set = this.myDependencyTypesAsSet;
        if (set == null) {
            MavenImportingSettings.$$$reportNull$$$0(4);
        }
        return set;
    }

    public boolean isCreateModuleGroups() {
        return this.createModuleGroups;
    }

    public void setCreateModuleGroups(boolean createModuleGroups) {
        this.createModuleGroups = createModuleGroups;
        this.fireCreateModuleGroupsChanged();
    }

    public boolean isCreateModulesForAggregators() {
        return this.createModulesForAggregators;
    }

    public void setCreateModulesForAggregators(boolean createModulesForAggregators) {
        this.createModulesForAggregators = createModulesForAggregators;
        this.fireCreateModuleForAggregatorsChanged();
    }

    public boolean isKeepSourceFolders() {
        return this.keepSourceFolders;
    }

    public void setKeepSourceFolders(boolean keepSourceFolders) {
        this.keepSourceFolders = keepSourceFolders;
    }

    public boolean isExcludeTargetFolder() {
        return this.excludeTargetFolder;
    }

    public void setExcludeTargetFolder(boolean excludeTargetFolder) {
        this.excludeTargetFolder = excludeTargetFolder;
    }

    public boolean isUseMavenOutput() {
        return this.useMavenOutput;
    }

    public void setUseMavenOutput(boolean useMavenOutput) {
        this.useMavenOutput = useMavenOutput;
    }

    @NlsSafe
    public String getUpdateFoldersOnImportPhase() {
        return this.updateFoldersOnImportPhase;
    }

    public void setUpdateFoldersOnImportPhase(String updateFoldersOnImportPhase) {
        this.updateFoldersOnImportPhase = updateFoldersOnImportPhase;
    }

    public boolean isDownloadSourcesAutomatically() {
        return this.downloadSourcesAutomatically;
    }

    public void setDownloadSourcesAutomatically(boolean Value) {
        this.downloadSourcesAutomatically = Value;
    }

    public boolean isDownloadDocsAutomatically() {
        return this.downloadDocsAutomatically;
    }

    public void setDownloadDocsAutomatically(boolean value) {
        this.downloadDocsAutomatically = value;
    }

    public boolean isDownloadAnnotationsAutomatically() {
        return this.downloadAnnotationsAutomatically;
    }

    public void setDownloadAnnotationsAutomatically(boolean value) {
        this.downloadAnnotationsAutomatically = value;
    }

    public boolean isAutoDetectCompiler() {
        return this.autoDetectCompiler;
    }

    public void setAutoDetectCompiler(boolean autoDetectCompiler) {
        this.autoDetectCompiler = autoDetectCompiler;
    }

    @Property
    @NotNull
    public GeneratedSourcesFolder getGeneratedSourcesFolder() {
        GeneratedSourcesFolder generatedSourcesFolder = this.generatedSourcesFolder;
        if (generatedSourcesFolder == null) {
            MavenImportingSettings.$$$reportNull$$$0(5);
        }
        return generatedSourcesFolder;
    }

    public void setGeneratedSourcesFolder(GeneratedSourcesFolder generatedSourcesFolder) {
        if (generatedSourcesFolder == null) {
            return;
        }
        this.generatedSourcesFolder = generatedSourcesFolder;
    }

    @NotNull
    public String getVmOptionsForImporter() {
        String string = this.vmOptionsForImporter;
        if (string == null) {
            MavenImportingSettings.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void setVmOptionsForImporter(String vmOptionsForImporter) {
        this.vmOptionsForImporter = StringUtil.notNullize((String)vmOptionsForImporter);
    }

    @NotNull
    public String getJdkForImporter() {
        String string = this.jdkForImporter;
        if (string == null) {
            MavenImportingSettings.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void setJdkForImporter(@NotNull String jdkForImporter) {
        if (jdkForImporter == null) {
            MavenImportingSettings.$$$reportNull$$$0(8);
        }
        this.jdkForImporter = jdkForImporter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenImportingSettings that = (MavenImportingSettings)o;
        if (this.createModuleGroups != that.createModuleGroups) {
            return false;
        }
        if (this.createModulesForAggregators != that.createModulesForAggregators) {
            return false;
        }
        if (!this.dependencyTypes.equals(that.dependencyTypes)) {
            return false;
        }
        if (this.downloadDocsAutomatically != that.downloadDocsAutomatically) {
            return false;
        }
        if (this.downloadSourcesAutomatically != that.downloadSourcesAutomatically) {
            return false;
        }
        if (this.downloadAnnotationsAutomatically != that.downloadAnnotationsAutomatically) {
            return false;
        }
        if (this.autoDetectCompiler != that.autoDetectCompiler) {
            return false;
        }
        if (this.keepSourceFolders != that.keepSourceFolders) {
            return false;
        }
        if (this.excludeTargetFolder != that.excludeTargetFolder) {
            return false;
        }
        if (this.useMavenOutput != that.useMavenOutput) {
            return false;
        }
        if (this.generatedSourcesFolder != that.generatedSourcesFolder) {
            return false;
        }
        if (!this.dedicatedModuleDir.equals(that.dedicatedModuleDir)) {
            return false;
        }
        if (!this.jdkForImporter.equals(that.jdkForImporter)) {
            return false;
        }
        if (!this.vmOptionsForImporter.equals(that.vmOptionsForImporter)) {
            return false;
        }
        return !(this.updateFoldersOnImportPhase != null ? !this.updateFoldersOnImportPhase.equals(that.updateFoldersOnImportPhase) : that.updateFoldersOnImportPhase != null);
    }

    public int hashCode() {
        int result = 0;
        if (this.createModulesForAggregators) {
            ++result;
        }
        result <<= 1;
        if (this.createModuleGroups) {
            ++result;
        }
        result <<= 1;
        if (this.keepSourceFolders) {
            ++result;
        }
        result <<= 1;
        if (this.useMavenOutput) {
            ++result;
        }
        result <<= 1;
        if (this.downloadSourcesAutomatically) {
            ++result;
        }
        result <<= 1;
        if (this.downloadDocsAutomatically) {
            ++result;
        }
        result <<= 1;
        if (this.downloadAnnotationsAutomatically) {
            ++result;
        }
        result <<= 1;
        if (this.autoDetectCompiler) {
            ++result;
        }
        result <<= 1;
        result = 31 * result + (this.updateFoldersOnImportPhase != null ? this.updateFoldersOnImportPhase.hashCode() : 0);
        result = 31 * result + this.dedicatedModuleDir.hashCode();
        result = 31 * result + this.generatedSourcesFolder.hashCode();
        result = 31 * result + this.dependencyTypes.hashCode();
        return result;
    }

    public MavenImportingSettings clone() {
        try {
            MavenImportingSettings result = (MavenImportingSettings)super.clone();
            result.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public void addListener(Listener l) {
        this.myListeners.add(l);
    }

    public void removeListener(Listener l) {
        this.myListeners.remove(l);
    }

    private void fireCreateModuleGroupsChanged() {
        for (Listener each : this.myListeners) {
            each.createModuleGroupsChanged();
        }
    }

    private void fireCreateModuleForAggregatorsChanged() {
        for (Listener each : this.myListeners) {
            each.createModuleForAggregatorsChanged();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenImportingSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dedicatedModuleDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyTypes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkForImporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDedicatedModuleDir";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenImportingSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyTypes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyTypesAsSet";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedSourcesFolder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmOptionsForImporter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdkForImporter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setDedicatedModuleDir";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDependencyTypes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setJdkForImporter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Listener {
        public void createModuleGroupsChanged();

        public void createModuleForAggregatorsChanged();
    }

    public static enum GeneratedSourcesFolder {
        IGNORE("maven.settings.generated.folder.ignore"),
        AUTODETECT("maven.settings.generated.folder.autodetect"),
        GENERATED_SOURCE_FOLDER("maven.settings.generated.folder.targerdir"),
        SUBFOLDER("maven.settings.generated.folder.targersubdir");

        public final String myMessageKey;

        private GeneratedSourcesFolder(String messageKey) {
            this.myMessageKey = messageKey;
        }

        @NlsContexts.ListItem
        public String getTitle() {
            return MavenConfigurableBundle.message(this.myMessageKey, new Object[0]);
        }
    }
}

