/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.ide.plugins.DependencyCollector;
import com.intellij.openapi.project.Project;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/maven/project/MavenDependencyCollector;", "Lcom/intellij/ide/plugins/DependencyCollector;", "()V", "collectDependencies", "", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.maven"})
public final class MavenDependencyCollector
implements DependencyCollector {
    @NotNull
    public List<String> collectDependencies(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        boolean bl = false;
        Set result = new LinkedHashSet();
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"MavenProjectsManager.getInstance(project)");
        Iterator<MavenProject> iterator = mavenProjectsManager.getProjects().iterator();
        while (iterator.hasNext()) {
            MavenProject mavenProject;
            MavenProject mavenProject2 = mavenProject = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)mavenProject2, (String)"mavenProject");
            for (MavenArtifact dependency : mavenProject2.getDependencies()) {
                StringBuilder stringBuilder = new StringBuilder();
                MavenArtifact mavenArtifact = dependency;
                Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"dependency");
                result.add(stringBuilder.append(mavenArtifact.getGroupId()).append(":").append(dependency.getArtifactId()).toString());
            }
        }
        return CollectionsKt.toList((Iterable)result);
    }
}

