/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.plugins.api;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.model.MavenDomConfiguration;
import org.jetbrains.idea.maven.dom.model.MavenDomGoal;
import org.jetbrains.idea.maven.dom.model.MavenDomGoals;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.idea.maven.plugins.api.MavenFixedValueReferenceProvider;
import org.jetbrains.idea.maven.plugins.api.MavenParamLanguageProvider;
import org.jetbrains.idea.maven.plugins.api.MavenParamReferenceProvider;
import org.jetbrains.idea.maven.plugins.api.MavenPluginDescriptor;
import org.jetbrains.idea.maven.plugins.api.MavenSoftAwareReferenceProvider;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class MavenPluginParamInfo {
    private static final Logger LOG = Logger.getInstance(MavenPluginParamInfo.class);
    private static volatile Map<String, Map> myMap;

    public static Map<String, Map> getMap() {
        Map<String, Map> res = myMap;
        if (res == null) {
            res = new HashMap<String, Map>();
            for (MavenPluginDescriptor pluginDescriptor : (MavenPluginDescriptor[])MavenPluginDescriptor.EP_NAME.getExtensions()) {
                if (pluginDescriptor.params == null) continue;
                Pair<String, String> pluginId = MavenPluginDescriptor.parsePluginId(pluginDescriptor.mavenId);
                for (MavenPluginDescriptor.Param param : pluginDescriptor.params) {
                    String[] paramPath = param.name.split("/");
                    Map pluginsMap = res;
                    for (int i = paramPath.length - 1; i >= 0; --i) {
                        pluginsMap = MavenUtil.getOrCreate(pluginsMap, paramPath[i]);
                    }
                    ParamInfo paramInfo = new ParamInfo(pluginDescriptor.getPluginDescriptor().getPluginClassLoader(), param);
                    ParamInfo goalsMap = MavenUtil.getOrCreate(pluginsMap, pluginId);
                    String goal = pluginDescriptor.goal;
                    assert (goal == null || !goal.isEmpty());
                    ParamInfo oldValue = goalsMap.put((String)goal, (ParamInfo)paramInfo);
                    if (oldValue == null) continue;
                    LOG.error("Duplicated maven plugin parameter descriptor: " + (String)pluginId.first + ":" + (String)pluginId.second + " -> " + (String)(goal != null ? "[" + goal + "]" : "") + param.name);
                }
            }
            myMap = res;
        }
        return res;
    }

    public static boolean isSimpleText(@NotNull XmlText paramValue) {
        PsiElement prevSibling;
        if (paramValue == null) {
            MavenPluginParamInfo.$$$reportNull$$$0(0);
        }
        if (!((prevSibling = paramValue.getPrevSibling()) instanceof LeafPsiElement) || ((LeafPsiElement)prevSibling).getElementType() != XmlTokenType.XML_TAG_END) {
            return false;
        }
        PsiElement nextSibling = paramValue.getNextSibling();
        return nextSibling instanceof LeafPsiElement && ((LeafPsiElement)nextSibling).getElementType() == XmlTokenType.XML_END_TAG_START;
    }

    public static ParamInfoList getParamInfoList(@NotNull XmlText paramValue) {
        XmlTag tag;
        if (paramValue == null) {
            MavenPluginParamInfo.$$$reportNull$$$0(1);
        }
        if ((tag = paramValue.getParentTag()) == null) {
            return ParamInfoList.EMPTY;
        }
        return MavenPluginParamInfo.getParamInfoList(tag);
    }

    public static ParamInfoList getParamInfoList(@NotNull XmlTag paramTag) {
        ParamInfo defaultInfo;
        Map goalsMap;
        DomElement domElement;
        if (paramTag == null) {
            MavenPluginParamInfo.$$$reportNull$$$0(2);
        }
        XmlTag configurationTag = paramTag;
        Map m = MavenPluginParamInfo.getMap().get(paramTag.getName());
        while (true) {
            if (m == null) {
                return ParamInfoList.EMPTY;
            }
            if ((configurationTag = configurationTag.getParentTag()) == null) {
                return ParamInfoList.EMPTY;
            }
            String tagName = configurationTag.getName();
            if ("configuration".equals(tagName)) {
                domElement = DomManager.getDomManager((Project)configurationTag.getProject()).getDomElement(configurationTag);
                if (domElement instanceof MavenDomConfiguration) break;
                if (domElement != null) {
                    return ParamInfoList.EMPTY;
                }
            }
            m = (Map)m.get(tagName);
        }
        Map pluginsMap = m;
        MavenDomConfiguration domCfg = (MavenDomConfiguration)domElement;
        MavenDomPlugin domPlugin = (MavenDomPlugin)domCfg.getParentOfType(MavenDomPlugin.class, true);
        if (domPlugin == null) {
            return ParamInfoList.EMPTY;
        }
        String pluginGroupId = domPlugin.getGroupId().getStringValue();
        String pluginArtifactId = domPlugin.getArtifactId().getStringValue();
        if (pluginGroupId == null) {
            goalsMap = (Map)pluginsMap.get(Pair.create((Object)"org.apache.maven.plugins", (Object)pluginArtifactId));
            if (goalsMap == null) {
                goalsMap = (Map)pluginsMap.get(Pair.create((Object)"org.codehaus.mojo", (Object)pluginArtifactId));
            }
        } else {
            goalsMap = (Map)pluginsMap.get(Pair.create((Object)pluginGroupId, (Object)pluginArtifactId));
        }
        if (goalsMap == null) {
            return ParamInfoList.EMPTY;
        }
        DomElement parent = domCfg.getParent();
        if (parent instanceof MavenDomPluginExecution) {
            SmartList infos = null;
            MavenDomGoals goals = ((MavenDomPluginExecution)parent).getGoals();
            for (MavenDomGoal goal : goals.getGoals()) {
                ParamInfo info = (ParamInfo)goalsMap.get(goal.getStringValue());
                if (info == null) continue;
                if (infos == null) {
                    infos = new SmartList();
                }
                infos.add((Object)info);
            }
            if (infos != null) {
                ParamInfo defaultInfo2 = (ParamInfo)goalsMap.get(null);
                if (defaultInfo2 != null) {
                    infos.add((Object)defaultInfo2);
                }
                return new ParamInfoList(domCfg, (List<ParamInfo>)infos);
            }
        }
        if ((defaultInfo = (ParamInfo)goalsMap.get(null)) != null) {
            return new ParamInfoList(domCfg, Collections.singletonList(defaultInfo));
        }
        return ParamInfoList.EMPTY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramTag";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/plugins/api/MavenPluginParamInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSimpleText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getParamInfoList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class PsiReferenceProviderWrapper
    implements MavenParamReferenceProvider,
    MavenSoftAwareReferenceProvider {
        private final PsiReferenceProvider myProvider;

        private PsiReferenceProviderWrapper(PsiReferenceProvider provider) {
            this.myProvider = provider;
        }

        @Override
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull MavenDomConfiguration domCfg, @NotNull ProcessingContext context) {
            if (element == null) {
                PsiReferenceProviderWrapper.$$$reportNull$$$0(0);
            }
            if (domCfg == null) {
                PsiReferenceProviderWrapper.$$$reportNull$$$0(1);
            }
            if (context == null) {
                PsiReferenceProviderWrapper.$$$reportNull$$$0(2);
            }
            return this.myProvider.getReferencesByElement(element, context);
        }

        @Override
        public void setSoft(boolean soft) {
            ((MavenSoftAwareReferenceProvider)this.myProvider).setSoft(soft);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "domCfg";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/plugins/api/MavenPluginParamInfo$PsiReferenceProviderWrapper";
            objectArray[2] = "getReferencesByElement";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ParamInfo {
        private final ClassLoader myClassLoader;
        private final MavenPluginDescriptor.Param myParam;
        private volatile boolean myLanguageInitialized;
        private Language myLanguageInstance;
        private MavenParamLanguageProvider myLanguageProvider;
        private volatile boolean myProviderInitialized;
        private volatile MavenParamReferenceProvider myProviderInstance;

        private ParamInfo(ClassLoader classLoader, MavenPluginDescriptor.Param param) {
            this.myClassLoader = classLoader;
            this.myParam = param;
        }

        private void ensureLanguageInit() {
            if (!this.myLanguageInitialized) {
                if (this.myParam.language != null) {
                    assert (this.myParam.languageProvider == null);
                    this.myLanguageInstance = Language.findLanguageByID((String)this.myParam.language);
                } else if (this.myParam.languageProvider != null) {
                    try {
                        this.myLanguageProvider = (MavenParamLanguageProvider)this.myClassLoader.loadClass(this.myParam.languageProvider).newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to create language provider instance", e);
                    }
                }
                this.myLanguageInitialized = true;
            }
        }

        @Nullable
        public Language getLanguage() {
            this.ensureLanguageInit();
            return this.myLanguageInstance;
        }

        @Nullable
        public MavenParamLanguageProvider getLanguageProvider() {
            this.ensureLanguageInit();
            return this.myLanguageProvider;
        }

        public MavenPluginDescriptor.Param getParam() {
            return this.myParam;
        }

        public String getLanguageInjectionPrefix() {
            return this.myParam.languageInjectionPrefix;
        }

        public String getLanguageInjectionSuffix() {
            return this.myParam.languageInjectionSuffix;
        }

        public MavenParamReferenceProvider getProviderInstance() {
            if (!this.myProviderInitialized) {
                MavenParamReferenceProvider res = null;
                if (this.myParam.refProvider != null) {
                    Object instance;
                    assert (this.myParam.values == null) : this.myParam.name;
                    try {
                        instance = this.myClassLoader.loadClass(this.myParam.refProvider).newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to create reference provider instance", e);
                    }
                    res = instance instanceof MavenParamReferenceProvider ? (MavenParamReferenceProvider)instance : new PsiReferenceProviderWrapper((PsiReferenceProvider)instance);
                } else if (this.myParam.values != null) {
                    StringTokenizer st = new StringTokenizer(this.myParam.values, " ,;");
                    int n = st.countTokens();
                    if (n == 0) {
                        throw new RuntimeException("Incorrect value of 'values' attribute for param " + this.myParam.name);
                    }
                    String[] values = new String[n];
                    for (int i = 0; i < n; ++i) {
                        values[i] = st.nextToken();
                    }
                    res = new MavenFixedValueReferenceProvider(values);
                }
                if (res != null && this.myParam.soft != null) {
                    ((MavenSoftAwareReferenceProvider)((Object)res)).setSoft(this.myParam.soft);
                }
                this.myProviderInstance = res;
                this.myProviderInitialized = true;
            }
            return this.myProviderInstance;
        }
    }

    public static class ParamInfoList
    implements Iterable<ParamInfo> {
        private static final ParamInfoList EMPTY = new ParamInfoList(null, Collections.emptyList());
        private final MavenDomConfiguration domCfg;
        private final List<ParamInfo> paramInfos;

        ParamInfoList(MavenDomConfiguration domCfg, @NotNull List<ParamInfo> paramInfos) {
            if (paramInfos == null) {
                ParamInfoList.$$$reportNull$$$0(0);
            }
            this.domCfg = domCfg;
            this.paramInfos = paramInfos;
        }

        public MavenDomConfiguration getDomCfg() {
            return this.domCfg;
        }

        @Override
        public Iterator<ParamInfo> iterator() {
            return this.paramInfos.iterator();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramInfos", "org/jetbrains/idea/maven/plugins/api/MavenPluginParamInfo$ParamInfoList", "<init>"));
        }
    }
}

