/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator;

import com.intellij.execution.Location;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenGoalLocation;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenConstants;
import org.jetbrains.idea.maven.model.MavenProfileKind;
import org.jetbrains.idea.maven.navigator.MavenProjectsStructure;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenDataKeys;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public final class MavenProjectsNavigatorPanel
extends SimpleToolWindowPanel
implements DataProvider {
    private final Project myProject;
    private final SimpleTree myTree;
    private final Comparator<String> myGoalOrderComparator = new Comparator<String>(){
        private Map<String, Integer> standardGoalOrder;

        @Override
        public int compare(String o1, String o2) {
            return this.getStandardGoalOrder(o1) - this.getStandardGoalOrder(o2);
        }

        private int getStandardGoalOrder(String goal) {
            Integer order;
            if (this.standardGoalOrder == null) {
                this.standardGoalOrder = new HashMap<String, Integer>();
                int i = 0;
                for (String aGoal : MavenConstants.PHASES) {
                    this.standardGoalOrder.put(aGoal, i++);
                }
            }
            return (order = this.standardGoalOrder.get(goal)) != null ? order.intValue() : this.standardGoalOrder.size();
        }
    };

    SimpleTree getTree() {
        return this.myTree;
    }

    public MavenProjectsNavigatorPanel(Project project2, SimpleTree tree) {
        super(true, true);
        this.myProject = project2;
        this.myTree = tree;
        final ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar actionToolbar = actionManager.createActionToolbar("Maven Navigator Toolbar", (ActionGroup)((DefaultActionGroup)actionManager.getAction("Maven.NavigatorActionsToolbar")), true);
        actionToolbar.setTargetComponent((JComponent)tree);
        this.setToolbar(actionToolbar.getComponent());
        this.setContent(ScrollPaneFactory.createScrollPane((Component)this.myTree));
        this.setTransferHandler(new MyTransferHandler(project2));
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionGroup actionGroup;
                String id = this.getMenuId(MavenProjectsNavigatorPanel.this.getSelectedNodes(MavenProjectsStructure.MavenSimpleNode.class));
                if (id != null && (actionGroup = (ActionGroup)actionManager.getAction(id)) != null) {
                    actionManager.createActionPopupMenu("Maven tool window", actionGroup).getComponent().show(comp, x, y);
                }
            }

            @Nullable
            private String getMenuId(Collection<? extends MavenProjectsStructure.MavenSimpleNode> nodes) {
                String id = null;
                for (MavenProjectsStructure.MavenSimpleNode mavenSimpleNode : nodes) {
                    String menuId = mavenSimpleNode.getMenuId();
                    if (menuId == null) {
                        return null;
                    }
                    if (id == null) {
                        id = menuId;
                        continue;
                    }
                    if (id.equals(menuId)) continue;
                    return null;
                }
                return id;
            }
        });
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            MavenProjectsNavigatorPanel.$$$reportNull$$$0(0);
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.toolWindows.mavenProjects";
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.extractVirtualFile();
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            return this.extractVirtualFiles();
        }
        if (Location.DATA_KEY.is(dataId)) {
            return this.extractLocation();
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.extractNavigatables();
        }
        if (MavenDataKeys.MAVEN_GOALS.is(dataId)) {
            return this.extractGoals(true);
        }
        if (MavenDataKeys.RUN_CONFIGURATION.is(dataId)) {
            return this.extractRunSettings();
        }
        if (MavenDataKeys.MAVEN_PROFILES.is(dataId)) {
            return this.extractProfiles();
        }
        if (MavenDataKeys.MAVEN_DEPENDENCIES.is(dataId)) {
            return this.extractDependencies();
        }
        if (MavenDataKeys.MAVEN_PROJECTS_TREE.is(dataId)) {
            return this.myTree;
        }
        if (TouchbarDataKeys.ACTIONS_KEY.is(dataId)) {
            return new DefaultActionGroup(new AnAction[]{ActionManager.getInstance().getAction("Maven.Reimport")});
        }
        return super.getData(dataId);
    }

    private VirtualFile extractVirtualFile() {
        for (MavenProjectsStructure.MavenSimpleNode each : this.getSelectedNodes(MavenProjectsStructure.MavenSimpleNode.class)) {
            VirtualFile file = each.getVirtualFile();
            if (file == null || !file.isValid()) continue;
            return file;
        }
        MavenProjectsStructure.ProjectNode projectNode = this.getContextProjectNode();
        if (projectNode == null) {
            return null;
        }
        VirtualFile file = projectNode.getVirtualFile();
        if (file == null || !file.isValid()) {
            return null;
        }
        return file;
    }

    private Object extractVirtualFiles() {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (MavenProjectsStructure.MavenSimpleNode each : this.getSelectedNodes(MavenProjectsStructure.MavenSimpleNode.class)) {
            VirtualFile file = each.getVirtualFile();
            if (file == null || !file.isValid()) continue;
            files.add(file);
        }
        return files.isEmpty() ? null : VfsUtil.toVirtualFileArray(files);
    }

    private Object extractNavigatables() {
        ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
        for (MavenProjectsStructure.MavenSimpleNode each : this.getSelectedNodes(MavenProjectsStructure.MavenSimpleNode.class)) {
            Navigatable navigatable = each.getNavigatable();
            if (navigatable == null) continue;
            navigatables.add(navigatable);
        }
        return navigatables.isEmpty() ? null : navigatables.toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY);
    }

    private Object extractLocation() {
        VirtualFile file = this.extractVirtualFile();
        if (file == null) {
            return null;
        }
        List<String> goals = this.extractGoals(false);
        if (goals == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        return psiFile == null ? null : new MavenGoalLocation(this.myProject, psiFile, goals);
    }

    @Nullable
    private RunnerAndConfigurationSettings extractRunSettings() {
        SimpleNode node2 = this.myTree.getSelectedNode();
        if (!(node2 instanceof MavenProjectsStructure.RunConfigurationNode)) {
            return null;
        }
        return ((MavenProjectsStructure.RunConfigurationNode)node2).getSettings();
    }

    private List<String> extractGoals(boolean qualifiedGoals) {
        MavenProjectsStructure.ProjectNode projectNode = this.getSelectedProjectNode();
        if (projectNode != null) {
            MavenProject project2 = projectNode.getMavenProject();
            String goal = project2.getDefaultGoal();
            if (!StringUtil.isEmptyOrSpaces((String)goal)) {
                return ContainerUtil.newArrayList((Iterable)StringUtil.tokenize((StringTokenizer)new StringTokenizer(goal)));
            }
        } else {
            List<MavenProjectsStructure.GoalNode> nodes = this.getSelectedNodes(MavenProjectsStructure.GoalNode.class);
            if (MavenProjectsStructure.getCommonProjectNode(nodes) == null) {
                return null;
            }
            ArrayList<String> goals = new ArrayList<String>();
            for (MavenProjectsStructure.GoalNode node2 : nodes) {
                goals.add(qualifiedGoals ? node2.getGoal() : node2.getName());
            }
            goals.sort(this.myGoalOrderComparator);
            return goals;
        }
        return null;
    }

    private Object extractProfiles() {
        List<MavenProjectsStructure.ProfileNode> nodes = this.getSelectedNodes(MavenProjectsStructure.ProfileNode.class);
        HashMap<String, MavenProfileKind> profiles = new HashMap<String, MavenProfileKind>();
        for (MavenProjectsStructure.ProfileNode node2 : nodes) {
            profiles.put(node2.getProfileName(), node2.getState());
        }
        return profiles;
    }

    private Set<MavenArtifact> extractDependencies() {
        HashSet<MavenArtifact> result = new HashSet<MavenArtifact>();
        List<MavenProjectsStructure.ProjectNode> projectNodes = this.getSelectedProjectNodes();
        if (!projectNodes.isEmpty()) {
            for (MavenProjectsStructure.ProjectNode each : projectNodes) {
                result.addAll(each.getMavenProject().getDependencies());
            }
            return result;
        }
        List<MavenProjectsStructure.BaseDependenciesNode> nodes = this.getSelectedNodes(MavenProjectsStructure.BaseDependenciesNode.class);
        for (MavenProjectsStructure.BaseDependenciesNode each : nodes) {
            if (each instanceof MavenProjectsStructure.DependenciesNode) {
                result.addAll(each.getMavenProject().getDependencies());
                continue;
            }
            result.add(((MavenProjectsStructure.DependencyNode)each).getArtifact());
        }
        return result;
    }

    private <T extends MavenProjectsStructure.MavenSimpleNode> List<T> getSelectedNodes(Class<T> aClass) {
        return MavenProjectsStructure.getSelectedNodes(this.myTree, aClass);
    }

    private List<MavenProjectsStructure.ProjectNode> getSelectedProjectNodes() {
        return this.getSelectedNodes(MavenProjectsStructure.ProjectNode.class);
    }

    @Nullable
    private MavenProjectsStructure.ProjectNode getSelectedProjectNode() {
        List<MavenProjectsStructure.ProjectNode> projectNodes = this.getSelectedProjectNodes();
        return projectNodes.size() == 1 ? projectNodes.get(0) : null;
    }

    @Nullable
    private MavenProjectsStructure.ProjectNode getContextProjectNode() {
        MavenProjectsStructure.ProjectNode projectNode = this.getSelectedProjectNode();
        if (projectNode != null) {
            return projectNode;
        }
        return MavenProjectsStructure.getCommonProjectNode(this.getSelectedNodes(MavenProjectsStructure.MavenSimpleNode.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "org/jetbrains/idea/maven/navigator/MavenProjectsNavigatorPanel", "getData"));
    }

    private static final class MyTransferHandler
    extends TransferHandler {
        private final Project myProject;

        private MyTransferHandler(Project project2) {
            this.myProject = project2;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (this.canImport(support)) {
                ArrayList<VirtualFile> pomFiles = new ArrayList<VirtualFile>();
                List fileList = FileCopyPasteUtil.getFileList((Transferable)support.getTransferable());
                if (fileList == null) {
                    return false;
                }
                MavenProjectsManager manager = MavenProjectsManager.getInstance(this.myProject);
                for (File file : fileList) {
                    VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
                    if (!file.isFile() || virtualFile == null || !MavenActionUtil.isMavenProjectFile(virtualFile) || manager.isManagedFile(virtualFile)) continue;
                    pomFiles.add(virtualFile);
                }
                if (pomFiles.isEmpty()) {
                    return false;
                }
                manager.addManagedFilesOrUnignore(pomFiles);
                return true;
            }
            return false;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return FileCopyPasteUtil.isFileListFlavorAvailable((DataFlavor[])support.getDataFlavors());
        }
    }
}

