/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator;

import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.containers.ContainerUtil;
import icons.MavenIcons;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.navigator.MavenProjectsNavigatorPanel;
import org.jetbrains.idea.maven.navigator.MavenProjectsNavigatorState;
import org.jetbrains.idea.maven.navigator.MavenProjectsStructure;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.tasks.MavenShortcutsManager;
import org.jetbrains.idea.maven.tasks.MavenTasksManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenSimpleProjectComponent;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.MavenWslUtil;

@State(name="MavenProjectNavigator", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
public final class MavenProjectsNavigator
extends MavenSimpleProjectComponent
implements PersistentStateComponent<MavenProjectsNavigatorState>,
Disposable {
    public static final String TOOL_WINDOW_ID = "Maven";
    public static final String TOOL_WINDOW_PLACE_ID = "Maven tool window";
    private MavenProjectsNavigatorState myState;
    private SimpleTree myTree;
    private MavenProjectsStructure myStructure;

    public static MavenProjectsNavigator getInstance(Project project2) {
        return (MavenProjectsNavigator)project2.getService(MavenProjectsNavigator.class);
    }

    public MavenProjectsNavigator(@NotNull Project project2) {
        if (project2 == null) {
            MavenProjectsNavigator.$$$reportNull$$$0(0);
        }
        super(project2);
        this.myState = new MavenProjectsNavigatorState();
    }

    public MavenProjectsNavigatorState getState() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myStructure != null) {
            try {
                this.myState.treeState = new Element("root");
                TreeState.createOn((JTree)this.myTree).writeExternal(this.myState.treeState);
            }
            catch (WriteExternalException e) {
                MavenLog.LOG.warn((Throwable)e);
            }
        }
        return this.myState;
    }

    public void loadState(@NotNull MavenProjectsNavigatorState state2) {
        if (state2 == null) {
            MavenProjectsNavigator.$$$reportNull$$$0(1);
        }
        this.myState = state2;
        this.scheduleStructureUpdate();
    }

    public boolean getGroupModules() {
        return this.myState.groupStructurally;
    }

    public void setGroupModules(boolean value) {
        if (this.myState.groupStructurally != value) {
            this.myState.groupStructurally = value;
            this.scheduleStructureUpdate();
        }
    }

    public boolean getShowIgnored() {
        return this.myState.showIgnored;
    }

    public void setShowIgnored(boolean value) {
        if (this.myState.showIgnored != value) {
            this.myState.showIgnored = value;
            this.scheduleStructureUpdate();
        }
    }

    public boolean getShowBasicPhasesOnly() {
        return this.myState.showBasicPhasesOnly;
    }

    public void setShowBasicPhasesOnly(boolean value) {
        if (this.myState.showBasicPhasesOnly != value) {
            this.myState.showBasicPhasesOnly = value;
            this.scheduleStructureUpdate();
        }
    }

    public boolean getAlwaysShowArtifactId() {
        return this.myState.alwaysShowArtifactId;
    }

    public void setAlwaysShowArtifactId(boolean value) {
        if (this.myState.alwaysShowArtifactId != value) {
            this.myState.alwaysShowArtifactId = value;
            this.scheduleStructureUpdate();
        }
    }

    public boolean getShowVersions() {
        return this.myState.showVersions;
    }

    public void setShowVersions(boolean value) {
        if (this.myState.showVersions != value) {
            this.myState.showVersions = value;
            this.scheduleStructureUpdate();
        }
    }

    public void initializeComponent() {
        if (!this.isNormalProject()) {
            return;
        }
        this.doInit();
    }

    @TestOnly
    public void initForTests() {
        this.doInit();
        this.initTree();
        this.initStructure();
    }

    public void headlessInit() {
        boolean shouldCreate;
        this.listenForProjectsChanges();
        boolean hasMavenProjects = !MavenProjectsManager.getInstance(this.myProject).getProjects().isEmpty();
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(TOOL_WINDOW_ID);
        if (toolWindow == null) {
            return;
        }
        if (toolWindow.isAvailable() != hasMavenProjects) {
            toolWindow.setAvailable(hasMavenProjects);
            if (hasMavenProjects) {
                toolWindow.activate(null);
            }
        }
        boolean bl = shouldCreate = this.myStructure == null;
        if (shouldCreate) {
            this.initStructure();
        }
        this.myStructure.update();
        TreeState.createFrom((Element)this.myState.treeState).applyTo((JTree)this.myTree);
    }

    private void doInit() {
        MavenProjectsManager.getInstance(this.myProject).addManagerListener(new MavenProjectsManager.Listener(){

            @Override
            public void activated() {
                AppUIUtil.invokeLaterIfProjectAlive((Project)MavenProjectsNavigator.this.myProject, () -> MavenProjectsNavigator.this.initToolWindow());
                MavenProjectsNavigator.this.listenForProjectsChanges();
                MavenProjectsNavigator.this.scheduleStructureUpdate();
            }
        });
    }

    public void dispose() {
    }

    private void listenForProjectsChanges() {
        MavenProjectsManager.getInstance(this.myProject).addProjectsTreeListener(new MyProjectsListener(), this);
        MavenShortcutsManager.getInstance(this.myProject).addListener(() -> this.scheduleStructureRequest(() -> this.myStructure.updateGoals()), this);
        MavenTasksManager.getInstance(this.myProject).addListener(new MavenTasksManager.Listener(){

            @Override
            public void compileTasksChanged() {
                MavenProjectsNavigator.this.scheduleStructureRequest(() -> MavenProjectsNavigator.this.myStructure.updateGoals());
            }
        }, this);
        MavenRunner.getInstance(this.myProject).getSettings().addListener(new MavenRunnerSettings.Listener(){

            @Override
            public void skipTestsChanged() {
                MavenProjectsNavigator.this.scheduleStructureRequest(() -> MavenProjectsNavigator.this.myStructure.updateGoals());
            }
        }, this);
        this.myProject.getMessageBus().connect().subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            private void changed() {
                MavenProjectsNavigator.this.scheduleStructureRequest(() -> MavenProjectsNavigator.this.myStructure.updateRunConfigurations());
            }

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    4.$$$reportNull$$$0(0);
                }
                this.changed();
            }

            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    4.$$$reportNull$$$0(1);
                }
                this.changed();
            }

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    4.$$$reportNull$$$0(2);
                }
                this.changed();
            }

            public void beforeRunTasksChanged() {
                MavenProjectsNavigator.this.scheduleStructureRequest(() -> MavenProjectsNavigator.this.myStructure.updateGoals());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "settings";
                objectArray2[1] = "org/jetbrains/idea/maven/navigator/MavenProjectsNavigator$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).addProjectJdkListener(() -> {
            MavenWslUtil.checkWslJdkAndShowNotification(this.myProject);
            MavenWslUtil.restartMavenConnectorsIfJdkIncorrect(this.myProject);
        });
        StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> MavenWslUtil.checkWslJdkAndShowNotification(this.myProject)));
    }

    void initToolWindow() {
        this.initTree();
        MavenProjectsNavigatorPanel panel2 = new MavenProjectsNavigatorPanel(this.myProject, this.myTree);
        AnAction removeAction = EmptyAction.wrap((AnAction)ActionManager.getInstance().getAction("Maven.RemoveRunConfiguration"));
        removeAction.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)this.myTree, (Disposable)this);
        AnAction editSource = EmptyAction.wrap((AnAction)ActionManager.getInstance().getAction("Maven.EditRunConfiguration"));
        editSource.registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)this.myTree, (Disposable)this);
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        final ToolWindow toolWindow = toolWindowManager.registerToolWindow(RegisterToolWindowTask.lazyAndNotClosable((String)TOOL_WINDOW_ID, (ToolWindowFactory)new ToolWindowFactory(){

            public void createToolWindowContent(@NotNull Project project2, @NotNull ToolWindow toolWindow) {
                if (project2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (toolWindow == null) {
                    5.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "toolWindow";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/maven/navigator/MavenProjectsNavigator$5";
                objectArray[2] = "createToolWindowContent";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Icon)MavenIcons.ToolWindowMaven, (ToolWindowAnchor)ToolWindowAnchor.RIGHT));
        ContentManager contentManager = toolWindow.getContentManager();
        Disposer.register((Disposable)this, () -> {
            contentManager.removeAllContents(true);
            Disposer.dispose((Disposable)contentManager);
            if (!this.myProject.isDisposed()) {
                toolWindow.remove();
            }
        });
        ContentFactory contentFactory = (ContentFactory)ApplicationManager.getApplication().getService(ContentFactory.class);
        Content content = contentFactory.createContent((JComponent)((Object)panel2), "", false);
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, false);
        this.myProject.getMessageBus().connect((Disposable)content).subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){
            boolean wasVisible = false;

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                if (toolWindowManager == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (toolWindow.isDisposed()) {
                    return;
                }
                boolean visible = ((ToolWindowManagerEx)toolWindowManager).shouldUpdateToolWindowContent(toolWindow);
                if (!visible || this.wasVisible) {
                    return;
                }
                MavenProjectsNavigator.this.scheduleStructureUpdate();
                this.wasVisible = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "org/jetbrains/idea/maven/navigator/MavenProjectsNavigator$6", "stateChanged"));
            }
        });
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(actionManager.getAction("Maven.GroupProjects"));
        group.add(actionManager.getAction("Maven.ShowIgnored"));
        group.add(actionManager.getAction("Maven.ShowBasicPhasesOnly"));
        group.add(actionManager.getAction("Maven.AlwaysShowArtifactId"));
        group.add(actionManager.getAction("Maven.ShowVersions"));
        ((ToolWindowEx)toolWindow).setAdditionalGearActions((ActionGroup)group);
    }

    private void initTree() {
        final MavenProjectsManager mavenProjectManager = MavenProjectsManager.getInstance(this.myProject);
        this.myTree = new SimpleTree(){
            private final JTextPane myPane = new JTextPane();
            {
                this.myPane.setOpaque(false);
                String addIconText = "'+'";
                String refreshIconText = "'Reimport'";
                String message = MavenProjectBundle.message("maven.navigator.nothing.to.display", addIconText, refreshIconText);
                int firstEol = message.indexOf("\n");
                int addIconMarkerIndex = message.indexOf(addIconText);
                this.myPane.replaceSelection(message.substring(0, addIconMarkerIndex));
                this.myPane.insertIcon(AllIcons.General.Add);
                int refreshIconMarkerIndex = message.indexOf(refreshIconText);
                this.myPane.replaceSelection(message.substring(addIconMarkerIndex + addIconText.length(), refreshIconMarkerIndex));
                this.myPane.insertIcon(AllIcons.Actions.Refresh);
                this.myPane.replaceSelection(message.substring(refreshIconMarkerIndex + refreshIconText.length()));
                StyledDocument document = this.myPane.getStyledDocument();
                SimpleAttributeSet centerAlignment = new SimpleAttributeSet();
                StyleConstants.setAlignment(centerAlignment, 1);
                SimpleAttributeSet justifiedAlignment = new SimpleAttributeSet();
                StyleConstants.setAlignment(justifiedAlignment, 3);
                document.setParagraphAttributes(0, firstEol, centerAlignment, false);
                document.setParagraphAttributes(firstEol + 2, document.getLength(), justifiedAlignment, false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (mavenProjectManager.hasProjects()) {
                    return;
                }
                this.myPane.setFont(this.getFont());
                this.myPane.setBackground(this.getBackground());
                this.myPane.setForeground(this.getForeground());
                Rectangle bounds = this.getBounds();
                this.myPane.setBounds(0, 0, bounds.width - 10, bounds.height);
                Graphics g2 = g.create(bounds.x + 10, bounds.y + 20, bounds.width, bounds.height);
                try {
                    this.myPane.paint(g2);
                }
                finally {
                    g2.dispose();
                }
            }
        };
        this.myTree.getEmptyText().clear();
        this.myTree.getSelectionModel().setSelectionMode(4);
    }

    @TestOnly
    public MavenProjectsStructure getStructureForTests() {
        return this.myStructure;
    }

    public void selectInTree(MavenProject project2) {
        this.scheduleStructureRequest(() -> this.myStructure.select(project2));
    }

    private void scheduleStructureRequest(Runnable r) {
        if (this.isUnitTestMode()) {
            if (this.myStructure != null) {
                r.run();
            }
            return;
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(TOOL_WINDOW_ID);
        if (toolWindow == null) {
            return;
        }
        MavenUtil.invokeLater(this.myProject, () -> {
            boolean shouldCreate;
            boolean hasMavenProjects;
            boolean bl = hasMavenProjects = !MavenProjectsManager.getInstance(this.myProject).getProjects().isEmpty();
            if (toolWindow.isAvailable() != hasMavenProjects) {
                toolWindow.setAvailable(hasMavenProjects);
                if (hasMavenProjects && this.myProject.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) == null) {
                    toolWindow.activate(null);
                }
            }
            boolean bl2 = shouldCreate = this.myStructure == null;
            if (shouldCreate) {
                this.initStructure();
            }
            r.run();
            if (shouldCreate) {
                TreeState.createFrom((Element)this.myState.treeState).applyTo((JTree)this.myTree);
            }
        });
    }

    private void initStructure() {
        this.myStructure = new MavenProjectsStructure(this.myProject, MavenProjectsManager.getInstance(this.myProject), MavenTasksManager.getInstance(this.myProject), MavenShortcutsManager.getInstance(this.myProject), this, this.myTree);
    }

    private void scheduleStructureUpdate() {
        this.scheduleStructureRequest(() -> this.myStructure.update());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/navigator/MavenProjectsNavigator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyProjectsListener
    implements MavenProjectsTree.Listener {
        private MyProjectsListener() {
        }

        @Override
        public void projectsIgnoredStateChanged(@NotNull List<MavenProject> ignored, @NotNull List<MavenProject> unignored, boolean fromImport) {
            if (ignored == null) {
                MyProjectsListener.$$$reportNull$$$0(0);
            }
            if (unignored == null) {
                MyProjectsListener.$$$reportNull$$$0(1);
            }
            MavenProjectsNavigator.this.scheduleStructureRequest(() -> MavenProjectsNavigator.this.myStructure.updateIgnored(ContainerUtil.concat((List)ignored, (List)unignored)));
        }

        @Override
        public void profilesChanged() {
            MavenProjectsNavigator.this.scheduleStructureRequest(() -> MavenProjectsNavigator.this.myStructure.updateProfiles());
        }

        @Override
        public void projectsUpdated(@NotNull List<Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
            if (updated == null) {
                MyProjectsListener.$$$reportNull$$$0(2);
            }
            if (deleted == null) {
                MyProjectsListener.$$$reportNull$$$0(3);
            }
            this.scheduleUpdateProjects(MavenUtil.collectFirsts(updated), deleted);
        }

        @Override
        public void projectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges, NativeMavenProjectHolder nativeMavenProject) {
            if (projectWithChanges == null) {
                MyProjectsListener.$$$reportNull$$$0(4);
            }
            this.scheduleUpdateProjects(Collections.singletonList((MavenProject)projectWithChanges.first), Collections.emptyList());
        }

        @Override
        public void pluginsResolved(@NotNull MavenProject project2) {
            if (project2 == null) {
                MyProjectsListener.$$$reportNull$$$0(5);
            }
            this.scheduleUpdateProjects(Collections.singletonList(project2), Collections.emptyList());
        }

        private void scheduleUpdateProjects(List<MavenProject> projects, List<MavenProject> deleted) {
            MavenProjectsNavigator.this.scheduleStructureRequest(() -> MavenProjectsNavigator.this.myStructure.updateProjects(projects, deleted));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignored";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unignored";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updated";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deleted";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectWithChanges";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/navigator/MavenProjectsNavigator$MyProjectsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectsIgnoredStateChanged";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectsUpdated";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectResolved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pluginsResolved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

