/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.worktree;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageDiffBuilder;
import com.intellij.workspaceModel.storage.bridgeEntities.BridgeModelModifiableEntitiesKt;
import com.intellij.workspaceModel.storage.bridgeEntities.ContentRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryId;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryRoot;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryRootTypeId;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleDependencyItem;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleId;
import com.intellij.workspaceModel.storage.bridgeEntities.SourceRootEntity;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenFoldersImporter;
import org.jetbrains.idea.maven.importing.MavenModelUtil;
import org.jetbrains.idea.maven.importing.worktree.MavenExternalSource;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.module.JpsModuleSourceRootPropertiesSerializer;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u001eH\u0002J\u0006\u0010\"\u001a\u00020\u001eJ\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/idea/maven/importing/worktree/WorkspaceModuleImporter;", "", "project", "Lcom/intellij/openapi/project/Project;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "projectsTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "diff", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/idea/maven/project/MavenProject;Lorg/jetbrains/idea/maven/project/MavenProjectsTree;Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;)V", "moduleEntity", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleEntity;", "virtualFileManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "addBundleDependency", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleDependencyItem;", "artifact", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "addLibraryToProjectTable", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryEntity;", "collectDependencies", "", "createDependency", "createLibraryDependency", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleDependencyItem$Exportable$LibraryDependency;", "createModuleDependency", "depProject", "createSystemDependency", "importFolders", "", "contentRootEntity", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ContentRootEntity;", "importLanguageLevel", "importModule", "libraryExists", "", "toEntityScope", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleDependencyItem$DependencyScope;", "mavenScope", "", "Companion", "intellij.maven"})
public final class WorkspaceModuleImporter {
    private final VirtualFileUrlManager virtualFileManager;
    private ModuleEntity moduleEntity;
    private final Project project;
    private final MavenProject mavenProject;
    private final MavenProjectsTree projectsTree;
    private final WorkspaceEntityStorageBuilder diff;
    @NotNull
    private static final LibraryRootTypeId JAVADOC_TYPE;
    @NotNull
    public static final Companion Companion;

    public final void importModule() {
        List<ModuleDependencyItem> dependencies = this.collectDependencies();
        WorkspaceEntityStorageDiffBuilder workspaceEntityStorageDiffBuilder = (WorkspaceEntityStorageDiffBuilder)this.diff;
        String string = this.mavenProject.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mavenProject.displayName");
        this.moduleEntity = BridgeModelModifiableEntitiesKt.addModuleEntity$default((WorkspaceEntityStorageDiffBuilder)workspaceEntityStorageDiffBuilder, (String)string, dependencies, (EntitySource)((EntitySource)MavenExternalSource.getINSTANCE()), null, (int)8, null);
        WorkspaceEntityStorageDiffBuilder workspaceEntityStorageDiffBuilder2 = (WorkspaceEntityStorageDiffBuilder)this.diff;
        String string2 = this.mavenProject.getDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mavenProject.directory");
        VirtualFileUrl virtualFileUrl = this.virtualFileManager.fromPath(string2);
        List list = CollectionsKt.emptyList();
        List list2 = CollectionsKt.emptyList();
        ModuleEntity moduleEntity = this.moduleEntity;
        if (moduleEntity == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"moduleEntity");
        }
        ContentRootEntity contentRootEntity = BridgeModelModifiableEntitiesKt.addContentRootEntity((WorkspaceEntityStorageDiffBuilder)workspaceEntityStorageDiffBuilder2, (VirtualFileUrl)virtualFileUrl, (List)list, (List)list2, (ModuleEntity)moduleEntity);
        this.importFolders(contentRootEntity);
        this.importLanguageLevel();
    }

    private final void importLanguageLevel() {
    }

    /*
     * WARNING - void declaration
     */
    private final List<ModuleDependencyItem> collectDependencies() {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"MavenProjectsManager.getInstance(project)");
        MavenImportingSettings mavenImportingSettings = mavenProjectsManager.getImportingSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenImportingSettings, (String)"MavenProjectsManager.get\u2026roject).importingSettings");
        Set<String> set = mavenImportingSettings.getDependencyTypesAsSet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"MavenProjectsManager.get\u2026ings.dependencyTypesAsSet");
        Set<String> dependencyTypes = set;
        Set<String> set2 = this.mavenProject.getDependencyTypesFromImporters(SupportedRequestType.FOR_IMPORT);
        Intrinsics.checkNotNullExpressionValue(set2, (String)"mavenProject.getDependen\u2026edRequestType.FOR_IMPORT)");
        dependencyTypes.addAll((Collection<String>)set2);
        Collection collection = CollectionsKt.listOf((Object[])new ModuleDependencyItem[]{(ModuleDependencyItem)ModuleDependencyItem.ModuleSourceDependency.INSTANCE, (ModuleDependencyItem)ModuleDependencyItem.InheritedSdkDependency.INSTANCE});
        List<MavenArtifact> list = this.mavenProject.getDependencies();
        Intrinsics.checkNotNullExpressionValue(list, (String)"mavenProject.dependencies");
        Iterable iterable = list;
        Collection collection2 = collection;
        boolean $i$f$filter = false;
        void var4_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MavenArtifact it = (MavenArtifact)element$iv$iv;
            boolean bl = false;
            MavenArtifact mavenArtifact = it;
            Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"it");
            if (!dependencyTypes.contains(mavenArtifact.getType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        $this$filter$iv = list2;
        WorkspaceModuleImporter workspaceModuleImporter = this;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ModuleDependencyItem moduleDependencyItem;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MavenArtifact p1 = (MavenArtifact)element$iv$iv;
            boolean bl2 = false;
            if (workspaceModuleImporter.createDependency(p1) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            ModuleDependencyItem it$iv$iv = moduleDependencyItem;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        list2 = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)collection2, (Iterable)list2);
    }

    private final ModuleDependencyItem createDependency(MavenArtifact artifact) {
        MavenProject depProject = this.projectsTree.findProject(artifact.getMavenId());
        if (depProject == null) {
            if (Intrinsics.areEqual((Object)artifact.getScope(), (Object)"system")) {
                return (ModuleDependencyItem)this.createSystemDependency(artifact);
            }
            if (Intrinsics.areEqual((Object)artifact.getType(), (Object)"bundle")) {
                return this.addBundleDependency(artifact);
            }
            return (ModuleDependencyItem)this.createLibraryDependency(artifact);
        }
        if (depProject == this.mavenProject) {
            return null;
        }
        if (this.projectsTree.isIgnored(depProject)) {
            boolean bl = false;
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
        return this.createModuleDependency(artifact, depProject);
    }

    private final ModuleDependencyItem addBundleDependency(MavenArtifact artifact) {
        MavenArtifact newArtifact = new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), "jar", artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), "jar", null, this.mavenProject.getLocalRepository(), false, false);
        return (ModuleDependencyItem)this.createLibraryDependency(newArtifact);
    }

    private final ModuleDependencyItem.Exportable.LibraryDependency createSystemDependency(MavenArtifact artifact) {
        boolean bl = Intrinsics.areEqual((Object)"system", (Object)artifact.getScope());
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ArrayList<LibraryRoot> roots = new ArrayList<LibraryRoot>();
        String string = MavenModelUtil.getArtifactUrlForClassifierAndExtension(artifact, null, null);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MavenModelUtil.getArtifa\u2026ion(artifact, null, null)");
        roots.add(new LibraryRoot(this.virtualFileManager.fromUrl(string), LibraryRootTypeId.Companion.getCOMPILED(), null, 4, null));
        String string2 = this.mavenProject.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mavenProject.displayName");
        LibraryTableId.ModuleLibraryTableId libraryTableId = new LibraryTableId.ModuleLibraryTableId(new ModuleId(string2));
        WorkspaceEntityStorageDiffBuilder workspaceEntityStorageDiffBuilder = (WorkspaceEntityStorageDiffBuilder)this.diff;
        String string3 = artifact.getLibraryName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"artifact.libraryName");
        BridgeModelModifiableEntitiesKt.addLibraryEntity((WorkspaceEntityStorageDiffBuilder)workspaceEntityStorageDiffBuilder, (String)string3, (LibraryTableId)((LibraryTableId)libraryTableId), (List)roots, (List)CollectionsKt.emptyList(), (EntitySource)((EntitySource)MavenExternalSource.getINSTANCE()));
        String string4 = artifact.getLibraryName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"artifact.libraryName");
        LibraryId libraryId = new LibraryId(string4, (LibraryTableId)libraryTableId);
        String string5 = artifact.getScope();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"artifact.scope");
        return new ModuleDependencyItem.Exportable.LibraryDependency(libraryId, false, this.toEntityScope(string5));
    }

    private final ModuleDependencyItem createModuleDependency(MavenArtifact artifact, MavenProject depProject) {
        boolean isTestJar = Intrinsics.areEqual((Object)"test-jar", (Object)artifact.getType()) || Intrinsics.areEqual((Object)"tests", (Object)artifact.getClassifier());
        String string = depProject.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"depProject.displayName");
        ModuleId moduleId = new ModuleId(string);
        String string2 = artifact.getScope();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"artifact.scope");
        return (ModuleDependencyItem)new ModuleDependencyItem.Exportable.ModuleDependency(moduleId, false, this.toEntityScope(string2), isTestJar);
    }

    private final ModuleDependencyItem.Exportable.LibraryDependency createLibraryDependency(MavenArtifact artifact) {
        boolean bl = Intrinsics.areEqual((Object)"system", (Object)artifact.getScope()) ^ true;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (!this.libraryExists(artifact)) {
            this.addLibraryToProjectTable(artifact);
        }
        LibraryTableId.ProjectLibraryTableId libraryTableId = LibraryTableId.ProjectLibraryTableId.INSTANCE;
        String string = artifact.getLibraryName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"artifact.libraryName");
        LibraryId libraryId = new LibraryId(string, (LibraryTableId)libraryTableId);
        String string2 = artifact.getScope();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"artifact.scope");
        return new ModuleDependencyItem.Exportable.LibraryDependency(libraryId, false, this.toEntityScope(string2));
    }

    private final boolean libraryExists(MavenArtifact artifact) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = this.diff.entities(LibraryEntity.class);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                LibraryEntity it = (LibraryEntity)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)artifact.getLibraryName())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final LibraryEntity addLibraryToProjectTable(MavenArtifact artifact) {
        ArrayList<LibraryRoot> roots = new ArrayList<LibraryRoot>();
        String string = MavenModelUtil.getArtifactUrlForClassifierAndExtension(artifact, null, null);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MavenModelUtil.getArtifa\u2026ion(artifact, null, null)");
        roots.add(new LibraryRoot(this.virtualFileManager.fromUrl(string), LibraryRootTypeId.Companion.getCOMPILED(), null, 4, null));
        String string2 = MavenModelUtil.getArtifactUrlForClassifierAndExtension(artifact, "javadoc", "jar");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MavenModelUtil.getArtifa\u2026tifact, \"javadoc\", \"jar\")");
        roots.add(new LibraryRoot(this.virtualFileManager.fromUrl(string2), JAVADOC_TYPE, null, 4, null));
        String string3 = MavenModelUtil.getArtifactUrlForClassifierAndExtension(artifact, "sources", "jar");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"MavenModelUtil.getArtifa\u2026tifact, \"sources\", \"jar\")");
        roots.add(new LibraryRoot(this.virtualFileManager.fromUrl(string3), LibraryRootTypeId.Companion.getSOURCES(), null, 4, null));
        LibraryTableId.ProjectLibraryTableId libraryTableId = LibraryTableId.ProjectLibraryTableId.INSTANCE;
        WorkspaceEntityStorageDiffBuilder workspaceEntityStorageDiffBuilder = (WorkspaceEntityStorageDiffBuilder)this.diff;
        String string4 = artifact.getLibraryName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"artifact.libraryName");
        return BridgeModelModifiableEntitiesKt.addLibraryEntity((WorkspaceEntityStorageDiffBuilder)workspaceEntityStorageDiffBuilder, (String)string4, (LibraryTableId)((LibraryTableId)libraryTableId), (List)roots, (List)CollectionsKt.emptyList(), (EntitySource)((EntitySource)MavenExternalSource.getINSTANCE()));
    }

    /*
     * WARNING - void declaration
     */
    private final void importFolders(ContentRootEntity contentRootEntity) {
        Map<String, JpsModuleSourceRootType<?>> map = MavenFoldersImporter.getSourceFolders(this.mavenProject);
        Intrinsics.checkNotNullExpressionValue(map, (String)"MavenFoldersImporter.get\u2026urceFolders(mavenProject)");
        Map<String, JpsModuleSourceRootType<?>> $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Map<String, JpsModuleSourceRootType<?>> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, JpsModuleSourceRootType<?>>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            JpsModuleSourceRootPropertiesSerializer serializer;
            Object v4;
            Object v3;
            String $this$firstOrNull$iv;
            Map.Entry<String, JpsModuleSourceRootType<?>> entry;
            block7: {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                Map.Entry<String, JpsModuleSourceRootType<?>> element$iv;
                entry = element$iv = iterator.next();
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)JpsModelSerializerExtension.getExtensions(), (String)"JpsModelSerializerExtension.getExtensions()");
                boolean $i$f$flatMap = false;
                Iterator iterator2 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    JpsModelSerializerExtension it = (JpsModelSerializerExtension)element$iv$iv;
                    boolean bl3 = false;
                    JpsModelSerializerExtension jpsModelSerializerExtension = it;
                    Intrinsics.checkNotNullExpressionValue((Object)jpsModelSerializerExtension, (String)"it");
                    Iterable list$iv$iv = jpsModelSerializerExtension.getModuleSourceRootPropertiesSerializers();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                iterator2 = $this$firstOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv2 = iterator2.next();
                    JpsModuleSourceRootPropertiesSerializer it = (JpsModuleSourceRootPropertiesSerializer)element$iv2;
                    boolean bl4 = false;
                    JpsModuleSourceRootPropertiesSerializer jpsModuleSourceRootPropertiesSerializer = it;
                    Intrinsics.checkNotNullExpressionValue((Object)jpsModuleSourceRootPropertiesSerializer, (String)"it");
                    if (!Intrinsics.areEqual((Object)((JpsModuleSourceRootType)jpsModuleSourceRootPropertiesSerializer.getType()), entry.getValue())) continue;
                    v3 = element$iv2;
                    break block7;
                }
                v3 = v4 = null;
            }
            if (!(v3 instanceof JpsModuleSourceRootPropertiesSerializer)) {
                v4 = null;
            }
            if ((JpsModuleSourceRootPropertiesSerializer)v4 == null) {
                $this$firstOrNull$iv = "Module source root type " + entry + ".value is not registered as JpsModelSerializerExtension";
                boolean bl5 = false;
                throw (Throwable)new IllegalStateException($this$firstOrNull$iv.toString());
            }
            WorkspaceEntityStorageDiffBuilder workspaceEntityStorageDiffBuilder = (WorkspaceEntityStorageDiffBuilder)this.diff;
            String string = VfsUtilCore.pathToUrl((String)entry.getKey());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtilCore.pathToUrl(entry.key)");
            VirtualFileUrl virtualFileUrl = this.virtualFileManager.fromUrl(string);
            String string2 = serializer.getTypeId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"serializer.typeId");
            SourceRootEntity sourceRootEntity = BridgeModelModifiableEntitiesKt.addSourceRootEntity((WorkspaceEntityStorageDiffBuilder)workspaceEntityStorageDiffBuilder, (ContentRootEntity)contentRootEntity, (VirtualFileUrl)virtualFileUrl, (String)string2, (EntitySource)((EntitySource)MavenExternalSource.getINSTANCE()));
            JpsModuleSourceRootType<?> jpsModuleSourceRootType = entry.getValue();
            if (jpsModuleSourceRootType instanceof JavaSourceRootType) {
                BridgeModelModifiableEntitiesKt.addJavaSourceRootEntity((WorkspaceEntityStorageDiffBuilder)((WorkspaceEntityStorageDiffBuilder)this.diff), (SourceRootEntity)sourceRootEntity, (boolean)false, (String)"");
                continue;
            }
            if (jpsModuleSourceRootType instanceof JavaResourceRootType) {
                BridgeModelModifiableEntitiesKt.addJavaResourceRootEntity((WorkspaceEntityStorageDiffBuilder)((WorkspaceEntityStorageDiffBuilder)this.diff), (SourceRootEntity)sourceRootEntity, (boolean)false, (String)"");
                continue;
            }
            boolean bl6 = false;
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
    }

    @NotNull
    public final ModuleDependencyItem.DependencyScope toEntityScope(@NotNull String mavenScope) {
        Intrinsics.checkNotNullParameter((Object)mavenScope, (String)"mavenScope");
        if (Intrinsics.areEqual((Object)"runtime", (Object)mavenScope)) {
            return ModuleDependencyItem.DependencyScope.RUNTIME;
        }
        if (Intrinsics.areEqual((Object)"test", (Object)mavenScope)) {
            return ModuleDependencyItem.DependencyScope.TEST;
        }
        return Intrinsics.areEqual((Object)"provided", (Object)mavenScope) ? ModuleDependencyItem.DependencyScope.PROVIDED : ModuleDependencyItem.DependencyScope.COMPILE;
    }

    public WorkspaceModuleImporter(@NotNull Project project2, @NotNull MavenProject mavenProject, @NotNull MavenProjectsTree projectsTree, @NotNull WorkspaceEntityStorageBuilder diff) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)projectsTree, (String)"projectsTree");
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        this.project = project2;
        this.mavenProject = mavenProject;
        this.projectsTree = projectsTree;
        this.diff = diff;
        this.virtualFileManager = VirtualFileUrlManagerUtil.getInstance((VirtualFileUrlManager.Companion)VirtualFileUrlManager.Companion, (Project)this.project);
    }

    static {
        Companion = new Companion(null);
        JAVADOC_TYPE = new LibraryRootTypeId("JAVADOC");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/maven/importing/worktree/WorkspaceModuleImporter$Companion;", "", "()V", "JAVADOC_TYPE", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryRootTypeId;", "getJAVADOC_TYPE$intellij_maven", "()Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryRootTypeId;", "intellij.maven"})
    public static final class Companion {
        @NotNull
        public final LibraryRootTypeId getJAVADOC_TYPE$intellij_maven() {
            return JAVADOC_TYPE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

