/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.configurers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.configurers.MavenModuleConfigurer;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenLog;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016Jh\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\"\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u00102\"\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J`\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\"\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u00102\"\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/idea/maven/importing/configurers/MavenEncodingConfigurer;", "Lorg/jetbrains/idea/maven/importing/configurers/MavenModuleConfigurer;", "()V", "configure", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "fillResourceEncoding", "newMap", "Ljava/util/LinkedHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/nio/charset/Charset;", "Lkotlin/collections/LinkedHashMap;", "leaveAsIsMap", "projectManagerImpl", "Lcom/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl;", "fillSourceEncoding", "getCharset", "name", "", "intellij.maven"})
public final class MavenEncodingConfigurer
extends MavenModuleConfigurer {
    @Override
    public void configure(@NotNull MavenProject mavenProject, @NotNull Project project2, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        LinkedHashMap newMap = new LinkedHashMap();
        LinkedHashMap leaveAsIsMap = new LinkedHashMap();
        EncodingProjectManager encodingProjectManager = EncodingProjectManager.getInstance((Project)project2);
        if (encodingProjectManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl");
        }
        EncodingProjectManagerImpl projectManagerImpl = (EncodingProjectManagerImpl)encodingProjectManager;
        ReadAction.compute((ThrowableComputable)new ThrowableComputable(this, mavenProject, newMap, leaveAsIsMap, projectManagerImpl){
            final /* synthetic */ MavenEncodingConfigurer this$0;
            final /* synthetic */ MavenProject $mavenProject;
            final /* synthetic */ LinkedHashMap $newMap;
            final /* synthetic */ LinkedHashMap $leaveAsIsMap;
            final /* synthetic */ EncodingProjectManagerImpl $projectManagerImpl;

            public final void compute() {
                MavenEncodingConfigurer.access$fillSourceEncoding(this.this$0, this.$mavenProject, this.$newMap, this.$leaveAsIsMap, this.$projectManagerImpl);
            }
            {
                this.this$0 = mavenEncodingConfigurer;
                this.$mavenProject = mavenProject;
                this.$newMap = linkedHashMap;
                this.$leaveAsIsMap = linkedHashMap2;
                this.$projectManagerImpl = encodingProjectManagerImpl;
            }
        });
        ReadAction.compute((ThrowableComputable)new ThrowableComputable(this, project2, mavenProject, newMap, leaveAsIsMap, projectManagerImpl){
            final /* synthetic */ MavenEncodingConfigurer this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ MavenProject $mavenProject;
            final /* synthetic */ LinkedHashMap $newMap;
            final /* synthetic */ LinkedHashMap $leaveAsIsMap;
            final /* synthetic */ EncodingProjectManagerImpl $projectManagerImpl;

            public final void compute() {
                MavenEncodingConfigurer.access$fillResourceEncoding(this.this$0, this.$project, this.$mavenProject, this.$newMap, this.$leaveAsIsMap, this.$projectManagerImpl);
            }
            {
                this.this$0 = mavenEncodingConfigurer;
                this.$project = project2;
                this.$mavenProject = mavenProject;
                this.$newMap = linkedHashMap;
                this.$leaveAsIsMap = linkedHashMap2;
                this.$projectManagerImpl = encodingProjectManagerImpl;
            }
        });
        if (newMap.isEmpty()) {
            return;
        }
        newMap.putAll(leaveAsIsMap);
        ApplicationManager.getApplication().invokeAndWait(new Runnable(projectManagerImpl, newMap){
            final /* synthetic */ EncodingProjectManagerImpl $projectManagerImpl;
            final /* synthetic */ LinkedHashMap $newMap;

            public final void run() {
                this.$projectManagerImpl.setMapping((Map)this.$newMap);
            }
            {
                this.$projectManagerImpl = encodingProjectManagerImpl;
                this.$newMap = linkedHashMap;
            }
        });
    }

    private final void fillResourceEncoding(Project project2, MavenProject mavenProject, LinkedHashMap<VirtualFile, Charset> newMap, LinkedHashMap<VirtualFile, Charset> leaveAsIsMap, EncodingProjectManagerImpl projectManagerImpl) {
        Object object = mavenProject.getResourceEncoding(project2);
        if (object != null) {
            Object object2 = object;
            MavenEncodingConfigurer mavenEncodingConfigurer = this;
            boolean bl = false;
            boolean bl2 = false;
            String p1 = object2;
            boolean bl3 = false;
            object = mavenEncodingConfigurer.getCharset(p1);
            if (object != null) {
                object2 = object;
                boolean bl4 = false;
                bl = false;
                Object charset = object2;
                boolean bl5 = false;
                List<MavenResource> list = mavenProject.getResources();
                Intrinsics.checkNotNullExpressionValue(list, (String)"mavenProject.resources");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map $this$forEach$iv2;
                    VirtualFile dirVfile;
                    MavenResource resource = (MavenResource)element$iv;
                    boolean bl6 = false;
                    LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                    MavenResource mavenResource = resource;
                    Intrinsics.checkNotNullExpressionValue((Object)mavenResource, (String)"resource");
                    if (localFileSystem.findFileByIoFile(new File(mavenResource.getDirectory())) == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)dirVfile, (String)"LocalFileSystem.getInsta\u2026rce.directory)) ?: return");
                    ((Map)newMap).put(dirVfile, charset);
                    Intrinsics.checkNotNullExpressionValue((Object)projectManagerImpl.getAllMappings(), (String)"projectManagerImpl.allMappings");
                    boolean $i$f$forEach2 = false;
                    Map map = $this$forEach$iv2;
                    boolean bl7 = false;
                    Iterator iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv2;
                        Map.Entry it = element$iv2 = iterator.next();
                        boolean bl8 = false;
                        String string = resource.getDirectory();
                        Object k = it.getKey();
                        Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
                        if (FileUtil.isAncestor((String)string, (String)((VirtualFile)k).getPath(), (boolean)false)) {
                            Map map2 = newMap;
                            Object k2 = it.getKey();
                            Intrinsics.checkNotNullExpressionValue(k2, (String)"it.key");
                            map2.put(k2, charset);
                            continue;
                        }
                        Map map3 = leaveAsIsMap;
                        Object k3 = it.getKey();
                        Intrinsics.checkNotNullExpressionValue(k3, (String)"it.key");
                        Object v = it.getValue();
                        Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
                        map3.put(k3, v);
                    }
                }
            }
        }
    }

    private final void fillSourceEncoding(MavenProject mavenProject, LinkedHashMap<VirtualFile, Charset> newMap, LinkedHashMap<VirtualFile, Charset> leaveAsIsMap, EncodingProjectManagerImpl projectManagerImpl) {
        Object object = mavenProject.getSourceEncoding();
        if (object != null) {
            Object object2 = object;
            MavenEncodingConfigurer mavenEncodingConfigurer = this;
            boolean bl = false;
            boolean bl2 = false;
            String p1 = object2;
            boolean bl3 = false;
            object = mavenEncodingConfigurer.getCharset(p1);
            if (object != null) {
                object2 = object;
                boolean bl4 = false;
                bl = false;
                Object charset = object2;
                boolean bl5 = false;
                List<String> list = mavenProject.getSources();
                Intrinsics.checkNotNullExpressionValue(list, (String)"mavenProject.sources");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map $this$forEach$iv2;
                    VirtualFile dirVfile;
                    String directory = (String)element$iv;
                    boolean bl6 = false;
                    if (LocalFileSystem.getInstance().findFileByIoFile(new File(directory)) == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)dirVfile, (String)"LocalFileSystem.getInsta\u2026ile(directory)) ?: return");
                    ((Map)newMap).put(dirVfile, charset);
                    Intrinsics.checkNotNullExpressionValue((Object)projectManagerImpl.getAllMappings(), (String)"projectManagerImpl.allMappings");
                    boolean $i$f$forEach2 = false;
                    Map map = $this$forEach$iv2;
                    boolean bl7 = false;
                    Iterator iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv2;
                        Map.Entry it = element$iv2 = iterator.next();
                        boolean bl8 = false;
                        Object k = it.getKey();
                        Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
                        if (FileUtil.isAncestor((String)directory, (String)((VirtualFile)k).getPath(), (boolean)false)) {
                            Map map2 = newMap;
                            Object k2 = it.getKey();
                            Intrinsics.checkNotNullExpressionValue(k2, (String)"it.key");
                            map2.put(k2, charset);
                            continue;
                        }
                        Map map3 = leaveAsIsMap;
                        Object k3 = it.getKey();
                        Intrinsics.checkNotNullExpressionValue(k3, (String)"it.key");
                        Object v = it.getValue();
                        Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
                        map3.put(k3, v);
                    }
                }
            }
        }
    }

    private final Charset getCharset(String name) {
        try {
            return Charset.forName(name);
        }
        catch (UnsupportedCharsetException e) {
            MavenLog.LOG.warn("Charset " + name + " is not supported");
            return null;
        }
    }

    public static final /* synthetic */ void access$fillSourceEncoding(MavenEncodingConfigurer $this, MavenProject mavenProject, LinkedHashMap newMap, LinkedHashMap leaveAsIsMap, EncodingProjectManagerImpl projectManagerImpl) {
        $this.fillSourceEncoding(mavenProject, newMap, leaveAsIsMap, projectManagerImpl);
    }

    public static final /* synthetic */ void access$fillResourceEncoding(MavenEncodingConfigurer $this, Project project2, MavenProject mavenProject, LinkedHashMap newMap, LinkedHashMap leaveAsIsMap, EncodingProjectManagerImpl projectManagerImpl) {
        $this.fillResourceEncoding(project2, mavenProject, newMap, leaveAsIsMap, projectManagerImpl);
    }
}

