/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.jarRepository.RemoteRepositoriesConfiguration;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J0\u0010\u0013\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016Jj\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b\u0018\u00010\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u0004H\u0016\u00a8\u0006 "}, d2={"Lorg/jetbrains/idea/maven/importing/RemoteRepositoriesImporter;", "Lorg/jetbrains/idea/maven/importing/MavenImporter;", "()V", "isApplicable", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "mirror", "", "id", "url", "module", "Lcom/intellij/openapi/module/Module;", "postProcess", "", "changes", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "modifiableModelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "preProcess", "process", "rootModel", "Lorg/jetbrains/idea/maven/importing/MavenRootModelAdapter;", "mavenModel", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "mavenProjectToModuleName", "", "postTasks", "", "Lorg/jetbrains/idea/maven/project/MavenProjectsProcessorTask;", "processChangedModulesOnly", "Companion", "intellij.maven"})
public final class RemoteRepositoriesImporter
extends MavenImporter {
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    public boolean processChangedModulesOnly() {
        return false;
    }

    @Override
    public boolean isApplicable(@Nullable MavenProject mavenProject) {
        return true;
    }

    @Override
    public void process(@Nullable IdeModifiableModelsProvider modifiableModelsProvider, @Nullable Module module, @Nullable MavenRootModelAdapter rootModel, @Nullable MavenProjectsTree mavenModel, @Nullable MavenProject mavenProject, @Nullable MavenProjectChanges changes, @Nullable Map<MavenProject, String> mavenProjectToModuleName, @Nullable List<MavenProjectsProcessorTask> postTasks) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void preProcess(@Nullable Module module, @Nullable MavenProject mavenProject, @Nullable MavenProjectChanges changes, @Nullable IdeModifiableModelsProvider modifiableModelsProvider) {
        if (module == null || mavenProject == null) {
            return;
        }
        RemoteRepositoriesConfiguration remoteRepositoriesConfiguration = RemoteRepositoriesConfiguration.getInstance((Project)module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)remoteRepositoriesConfiguration, (String)"RemoteRepositoriesConfig\u2026tInstance(module.project)");
        RemoteRepositoriesConfiguration repoConfig = remoteRepositoriesConfiguration;
        boolean bl = false;
        HashSet hashSet = new HashSet();
        boolean bl2 = false;
        boolean bl3 = false;
        HashSet $this$apply = hashSet;
        boolean bl42 = false;
        $this$apply.addAll(repoConfig.getRepositories());
        Collection repositories = hashSet;
        List<MavenRemoteRepository> list = mavenProject.getRemoteRepositories();
        Intrinsics.checkNotNullExpressionValue(list, (String)"mavenProject.remoteRepositories");
        Iterable $this$mapTo$iv = list;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            MavenRemoteRepository bl42 = (MavenRemoteRepository)item$iv;
            Collection collection = repositories;
            boolean bl5 = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            String string = v2.getId();
            String string2 = it.getName();
            if (string2 == null) {
                string2 = it.getId();
            }
            String string3 = it.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.id");
            String string4 = it.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.url");
            RemoteRepositoryDescription remoteRepositoryDescription = new RemoteRepositoryDescription(string, string2, this.mirror(string3, string4, module));
            boolean bl6 = false;
            boolean bl7 = false;
            RemoteRepositoryDescription it2 = remoteRepositoryDescription;
            boolean bl8 = false;
            LOG.debug("Imported remote repository " + it2.getId() + '/' + it2.getName() + " at " + it2.getUrl());
            RemoteRepositoryDescription remoteRepositoryDescription2 = remoteRepositoryDescription;
            collection.add(remoteRepositoryDescription2);
        }
        repoConfig.setRepositories(CollectionsKt.toMutableList((Collection)repositories));
    }

    private final String mirror(String id, String url, Module module) {
        MavenWorkspaceSettingsComponent mavenWorkspaceSettingsComponent = MavenWorkspaceSettingsComponent.getInstance(module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)mavenWorkspaceSettingsComponent, (String)"MavenWorkspaceSettingsCo\u2026ce(\n      module.project)");
        MavenGeneralSettings mavenGeneralSettings = mavenWorkspaceSettingsComponent.getSettings().generalSettings;
        Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings, (String)"MavenWorkspaceSettingsCo\u2026.settings.generalSettings");
        File settingsFile = mavenGeneralSettings.getEffectiveUserSettingsIoFile();
        String string = MavenUtil.getMirroredUrl(settingsFile, url, id);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MavenUtil.getMirroredUrl(settingsFile, url, id)");
        return string;
    }

    @Override
    public void postProcess(@NotNull Module module, @NotNull MavenProject mavenProject, @NotNull MavenProjectChanges changes, @NotNull IdeModifiableModelsProvider modifiableModelsProvider) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
    }

    public RemoteRepositoriesImporter() {
        super("", "");
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(RemoteRepositoriesImporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Remot\u2026riesImporter::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/maven/importing/RemoteRepositoriesImporter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.maven"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

