/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProject;

public final class MavenModuleNameMapper {
    public static void map(Collection<MavenProject> projects, Map<MavenProject, Module> mavenProjectToModule, Map<MavenProject, String> mavenProjectToModuleName, Map<MavenProject, String> mavenProjectToModulePath, String dedicatedModuleDir) {
        MavenModuleNameMapper.resolveModuleNames(projects, mavenProjectToModule, mavenProjectToModuleName);
        MavenModuleNameMapper.resolveModulePaths(projects, mavenProjectToModule, mavenProjectToModuleName, mavenProjectToModulePath, dedicatedModuleDir);
    }

    private static void resolveModuleNames(Collection<MavenProject> projects, Map<MavenProject, Module> mavenProjectToModule, Map<MavenProject, String> mavenProjectToModuleName) {
        Object[] names = new NameItem[projects.size()];
        int i = 0;
        for (MavenProject each : projects) {
            names[i++] = new NameItem(each, mavenProjectToModule.get(each));
        }
        Arrays.sort(names);
        HashMap<String, Integer> nameCounters = new HashMap<String, Integer>();
        for (i = 0; i < names.length; ++i) {
            if (((NameItem)names[i]).hasDuplicatedGroup) continue;
            for (int k = i + 1; k < names.length; ++k) {
                if (!((NameItem)names[i]).originalName.equals(((NameItem)names[k]).originalName)) continue;
                nameCounters.put(((NameItem)names[i]).originalName, 0);
                if (!((NameItem)names[i]).groupId.equals(((NameItem)names[k]).groupId)) continue;
                ((NameItem)names[i]).hasDuplicatedGroup = true;
                ((NameItem)names[k]).hasDuplicatedGroup = true;
            }
        }
        HashSet<String> existingNames = new HashSet<String>();
        for (Object name : names) {
            if (((NameItem)name).module == null) continue;
            boolean bl = existingNames.add(((NameItem)name).getResultName());
        }
        for (Object nameItem : names) {
            String name;
            if (((NameItem)nameItem).module != null) continue;
            Integer c = (Integer)nameCounters.get(((NameItem)nameItem).originalName);
            if (c != null) {
                ((NameItem)nameItem).number = c;
                nameCounters.put(((NameItem)nameItem).originalName, c + 1);
            }
            while (!existingNames.add(name = ((NameItem)nameItem).getResultName())) {
                ++((NameItem)nameItem).number;
                nameCounters.put(((NameItem)nameItem).originalName, ((NameItem)nameItem).number + 1);
            }
        }
        for (Object each : names) {
            mavenProjectToModuleName.put(((NameItem)each).project, ((NameItem)each).getResultName());
        }
    }

    private static boolean isValidName(String name) {
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return false;
        }
        if (name.equals("Unknown")) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isDigit(ch) || Character.isLetter(ch) || ch == '-' || ch == '_' || ch == '.') continue;
            return false;
        }
        return true;
    }

    private static void resolveModulePaths(Collection<MavenProject> projects, Map<MavenProject, Module> mavenProjectToModule, Map<MavenProject, String> mavenProjectToModuleName, Map<MavenProject, String> mavenProjectToModulePath, String dedicatedModuleDir) {
        for (MavenProject each : projects) {
            Module module = mavenProjectToModule.get(each);
            String path = module != null ? module.getModuleFilePath() : MavenModuleNameMapper.generateModulePath(each, mavenProjectToModuleName, dedicatedModuleDir);
            mavenProjectToModulePath.put(each, path);
        }
    }

    private static String generateModulePath(MavenProject project2, Map<MavenProject, String> mavenProjectToModuleName, String dedicatedModuleDir) {
        String dir2 = StringUtil.isEmptyOrSpaces((String)dedicatedModuleDir) ? project2.getDirectory() : dedicatedModuleDir;
        String fileName = mavenProjectToModuleName.get(project2) + ".iml";
        return new File(dir2, fileName).getPath();
    }

    public static class NameItem
    implements Comparable<NameItem> {
        public final MavenProject project;
        public final Module module;
        public final String originalName;
        public final String groupId;
        public int number = -1;
        public boolean hasDuplicatedGroup;

        public NameItem(MavenProject project2, @Nullable Module module) {
            this.project = project2;
            this.module = module;
            this.originalName = this.calcOriginalName();
            String group = project2.getMavenId().getGroupId();
            this.groupId = MavenModuleNameMapper.isValidName(group) ? group : "";
        }

        private String calcOriginalName() {
            if (this.module != null) {
                return this.module.getName();
            }
            String name = this.project.getMavenId().getArtifactId();
            if (!MavenModuleNameMapper.isValidName(name)) {
                name = this.project.getDirectoryFile().getName();
            }
            return name;
        }

        public String getResultName() {
            if (this.module != null) {
                return this.module.getName();
            }
            if (this.number == -1) {
                return this.originalName;
            }
            String result = this.originalName + " (" + (this.number + 1) + ")";
            if (!this.hasDuplicatedGroup && this.groupId.length() != 0) {
                result = result + " (" + this.groupId + ")";
            }
            return result;
        }

        @Override
        public int compareTo(NameItem o) {
            return this.project.getPath().compareToIgnoreCase(o.project.getPath());
        }
    }
}

