/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.SmartList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectResolver;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenOutputActionProcessor;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myWorkingDir", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "showMavenInvalidConfig", "", "message", "intellij.maven"})
public final class MavenOutputActionProcessor {
    private final Project myProject;
    private final String myWorkingDir;

    /*
     * WARNING - void declaration
     */
    public final void showMavenInvalidConfig(@NotNull String message) {
        void $this$filterTo$iv$iv;
        MavenProjectsManager manager;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        MavenProjectsManager mavenProjectsManager = manager = MavenProjectsManager.getInstance(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"manager");
        List<MavenProject> list = mavenProjectsManager.getRootProjects();
        Intrinsics.checkNotNullExpressionValue(list, (String)"manager.rootProjects");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MavenProject it = (MavenProject)element$iv$iv;
            boolean bl = false;
            MavenProject mavenProject = it;
            Intrinsics.checkNotNullExpressionValue((Object)mavenProject, (String)"it");
            if (!Intrinsics.areEqual((Object)mavenProject.getDirectoryFile(), (Object)LocalFileSystem.getInstance().findFileByIoFile(new File(this.myWorkingDir)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        MavenProject mavenProject = (MavenProject)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (mavenProject == null) {
            MavenLog.LOG.warn("Cannot find appropriate maven project,project =  " + this.myProject.getName() + ", workingdir = " + this.myWorkingDir);
            return;
        }
        MavenProjectResolver.showNotificationInvalidConfig(this.myProject, mavenProject, message);
        mavenProject.setConfigFileError(message);
        MavenUtil.restartConfigHighlightning(this.myProject, (Collection)new SmartList((Object)mavenProject));
    }

    public MavenOutputActionProcessor(@NotNull Project myProject, @NotNull String myWorkingDir) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)myWorkingDir, (String)"myWorkingDir");
        this.myProject = myProject;
        this.myWorkingDir = myWorkingDir;
    }
}

