/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLogEntryReader;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLoggedEventParser;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenParsingContext;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenSpyLoggedEventParser;
import org.jetbrains.idea.maven.externalSystemIntegration.output.parsers.MavenSpyOutputParser;
import org.jetbrains.idea.maven.externalSystemIntegration.output.parsers.MavenTaskFailedResultImpl;

@ApiStatus.Experimental
public class MavenLogOutputParser
implements BuildOutputParser {
    private boolean myCompleted;
    private final List<MavenLoggedEventParser> myRegisteredEvents;
    private final ExternalSystemTaskId myTaskId;
    private final MavenSpyOutputParser mavenSpyOutputParser;
    private final MavenParsingContext myParsingContext;

    public MavenLogOutputParser(@NotNull Project project2, @NotNull ExternalSystemTaskId taskId, @NotNull List<MavenLoggedEventParser> registeredEvents) {
        if (project2 == null) {
            MavenLogOutputParser.$$$reportNull$$$0(0);
        }
        if (taskId == null) {
            MavenLogOutputParser.$$$reportNull$$$0(1);
        }
        if (registeredEvents == null) {
            MavenLogOutputParser.$$$reportNull$$$0(2);
        }
        this(project2, taskId, Function.identity(), registeredEvents);
    }

    public MavenLogOutputParser(@NotNull Project project2, @NotNull ExternalSystemTaskId taskId, @NotNull Function<String, String> targetFileMapper, @NotNull List<MavenLoggedEventParser> registeredEvents) {
        if (project2 == null) {
            MavenLogOutputParser.$$$reportNull$$$0(3);
        }
        if (taskId == null) {
            MavenLogOutputParser.$$$reportNull$$$0(4);
        }
        if (targetFileMapper == null) {
            MavenLogOutputParser.$$$reportNull$$$0(5);
        }
        if (registeredEvents == null) {
            MavenLogOutputParser.$$$reportNull$$$0(6);
        }
        this.myCompleted = false;
        this.myRegisteredEvents = registeredEvents;
        this.myTaskId = taskId;
        this.myParsingContext = new MavenParsingContext(project2, taskId, targetFileMapper);
        this.mavenSpyOutputParser = new MavenSpyOutputParser(this.myParsingContext, MavenSpyLoggedEventParser.EP_NAME.getExtensionList());
    }

    public synchronized void finish(Consumer<? super BuildEvent> messageConsumer) {
        this.completeParsers(messageConsumer);
        if (!this.myCompleted) {
            messageConsumer.accept((BuildEvent)new FinishBuildEventImpl((Object)this.myTaskId, null, System.currentTimeMillis(), "", (EventResult)new MavenTaskFailedResultImpl("Process terminated")));
        }
    }

    public MavenParsingContext getParsingContext() {
        return this.myParsingContext;
    }

    private void completeParsers(Consumer<? super BuildEvent> messageConsumer) {
        for (MavenLoggedEventParser parser : this.myRegisteredEvents) {
            parser.finish(this.myTaskId, messageConsumer);
        }
    }

    public boolean parse(String line, BuildOutputInstantReader reader, Consumer<? super BuildEvent> messageConsumer) {
        if (this.myCompleted) {
            return false;
        }
        if (line == null || StringUtil.isEmptyOrSpaces((String)line)) {
            return false;
        }
        if (MavenSpyOutputParser.isSpyLog(line)) {
            this.mavenSpyOutputParser.processLine(line, messageConsumer);
            return true;
        }
        this.sendMessageToAllParents(line, messageConsumer);
        MavenLogEntryReader.MavenLogEntry logLine = MavenLogOutputParser.nextLine(line);
        MavenLogEntryReader mavenLogReader = MavenLogOutputParser.wrapReader(reader);
        for (MavenLoggedEventParser event : this.myRegisteredEvents) {
            if (!event.supportsType(logLine.myType) || !event.checkLogLine(this.myParsingContext.getLastId(), this.myParsingContext, logLine, mavenLogReader, messageConsumer)) continue;
            return true;
        }
        return this.checkComplete(messageConsumer, logLine);
    }

    private void sendMessageToAllParents(@NlsSafe String line, Consumer<? super BuildEvent> messageConsumer) {
        List<MavenParsingContext.MavenExecutionEntry> ids = this.myParsingContext.getAllEntriesReversed();
        for (MavenParsingContext.MavenExecutionEntry entry : ids) {
            if (entry.getId() == this.myTaskId) {
                return;
            }
            messageConsumer.accept((BuildEvent)new OutputBuildEventImpl(entry.getId(), MavenLogOutputParser.withSeparator(line), true));
        }
    }

    private static String withSeparator(@NotNull String line) {
        if (line == null) {
            MavenLogOutputParser.$$$reportNull$$$0(7);
        }
        if (line.endsWith("\n")) {
            return line;
        }
        return line + "\n";
    }

    private static MavenLogEntryReader wrapReader(final BuildOutputInstantReader reader) {
        return new MavenLogEntryReader(){

            @Override
            public void pushBack() {
                reader.pushBack();
            }

            @Override
            @Nullable
            public MavenLogEntryReader.MavenLogEntry readLine() {
                return MavenLogOutputParser.nextLine(reader.readLine());
            }
        };
    }

    private synchronized boolean checkComplete(Consumer<? super BuildEvent> messageConsumer, MavenLogEntryReader.MavenLogEntry logLine) {
        if (logLine.myLine.equals("BUILD FAILURE")) {
            this.completeParsers(messageConsumer);
            messageConsumer.accept((BuildEvent)new FinishBuildEventImpl((Object)this.myTaskId, null, System.currentTimeMillis(), "", (EventResult)new FailureResultImpl()));
            this.myCompleted = true;
            return true;
        }
        if (logLine.myLine.equals("BUILD SUCCESS")) {
            this.completeParsers(messageConsumer);
            messageConsumer.accept((BuildEvent)new FinishBuildEventImpl((Object)this.myTaskId, null, System.currentTimeMillis(), "", (EventResult)new SuccessResultImpl()));
            this.myCompleted = true;
            return true;
        }
        return false;
    }

    @Nullable
    private static MavenLogEntryReader.MavenLogEntry nextLine(String line) {
        if (line == null) {
            return null;
        }
        return new MavenLogEntryReader.MavenLogEntry(line);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registeredEvents";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFileMapper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/externalSystemIntegration/output/MavenLogOutputParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "withSeparator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

