/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution.target;

import com.intellij.execution.CantRunException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.java.JavaLanguageRuntimeConfiguration;
import com.intellij.execution.target.value.DeferredTargetValue;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.execution.target.MavenCommandLineSetup;
import org.jetbrains.idea.maven.execution.target.MavenRuntimeTargetConfiguration;
import org.jetbrains.idea.maven.execution.target.MavenRuntimeType;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000 L2\u00020\u0001:\u0001LB\"\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ$\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050$0\u0013H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0002\u001a\u00020-H\u0002J\u0018\u00100\u001a\u0004\u0018\u00010\u00052\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000502H\u0002J\u001e\u00103\u001a\b\u0012\u0004\u0012\u00020\u0005022\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0002\u001a\u00020-H\u0002J\u001b\u00104\u001a\u00020\u00052\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000506H\u0002\u00a2\u0006\u0002\u00107J\u0010\u00108\u001a\u0002092\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010:\u001a\u00020;2\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010<\u001a\u00020\u00152\u0006\u0010=\u001a\u00020\u00192\u0006\u0010>\u001a\u00020\u001aJ\u001a\u0010?\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010@\u001a\u00020AH\u0007J\b\u0010B\u001a\u00020\u0015H\u0002J\b\u0010C\u001a\u00020\u0015H\u0002J$\u0010D\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050$0\u0013H\u0002J\u0010\u0010E\u001a\u00020\u00152\u0006\u0010F\u001a\u00020;H\u0002J\u0010\u0010G\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0002J&\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00050$2\u0006\u0010I\u001a\u00020&2\u0006\u0010J\u001a\u00020\u00052\u0006\u0010K\u001a\u00020\u0005H\u0002R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lorg/jetbrains/idea/maven/execution/target/MavenCommandLineSetup;", "", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "request", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/execution/target/TargetEnvironmentRequest;)V", "commandLine", "Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "getCommandLine", "()Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "defaultJavaRuntimeConfiguration", "Lcom/intellij/execution/target/java/JavaLanguageRuntimeConfiguration;", "defaultMavenRuntimeConfiguration", "Lorg/jetbrains/idea/maven/execution/target/MavenRuntimeTargetConfiguration;", "dependingOnEnvironmentPromise", "", "Lorg/jetbrains/concurrency/Promise;", "", "environmentPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lkotlin/Pair;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/TargetProgressIndicator;", "platform", "Lcom/intellij/execution/Platform;", "Lorg/jetbrains/annotations/NotNull;", "getPlatform", "()Lcom/intellij/execution/Platform;", "addMavenParameters", "settings", "Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration$MavenSettings;", "mavenOptsValues", "Lcom/intellij/execution/target/value/TargetValue;", "createUploadRoot", "Lcom/intellij/execution/target/TargetEnvironment$UploadRoot;", "volumeDescriptor", "Lcom/intellij/execution/target/LanguageRuntimeType$VolumeDescriptor;", "localRootPath", "Ljava/nio/file/Path;", "findAllInheritors", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "mavenProjectsManager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "findCommonAncestor", "paths", "", "findPathsToUpload", "joinPath", "segments", "", "([Ljava/lang/String;)Ljava/lang/String;", "mavenGeneralSettings", "Lorg/jetbrains/idea/maven/project/MavenGeneralSettings;", "mavenRunnerSettings", "Lorg/jetbrains/idea/maven/execution/MavenRunnerSettings;", "provideEnvironment", "environment", "progressIndicator", "setupCommandLine", "setupEventListener", "", "setupExePath", "setupMavenExtClassPath", "setupTargetEnvironmentVariables", "setupTargetJavaRuntime", "runnerSettings", "setupTargetProjectDirectories", "upload", "uploadRoot", "uploadPathString", "uploadRelativePath", "Companion", "intellij.maven"})
public final class MavenCommandLineSetup {
    @NotNull
    private final TargetedCommandLineBuilder commandLine;
    @NotNull
    private final Platform platform;
    private final MavenRuntimeTargetConfiguration defaultMavenRuntimeConfiguration;
    private final JavaLanguageRuntimeConfiguration defaultJavaRuntimeConfiguration;
    private final AsyncPromise<Pair<TargetEnvironment, TargetProgressIndicator>> environmentPromise;
    private final List<Promise<Unit>> dependingOnEnvironmentPromise;
    private final Project project;
    private final String name;
    private final TargetEnvironmentRequest request;
    @NotNull
    private static final Key<MavenCommandLineSetup> setupKey;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final TargetedCommandLineBuilder getCommandLine() {
        return this.commandLine;
    }

    @NotNull
    public final Platform getPlatform() {
        return this.platform;
    }

    @JvmOverloads
    @NotNull
    public final MavenCommandLineSetup setupCommandLine(@NotNull MavenRunConfiguration.MavenSettings settings, boolean setupEventListener) throws CantRunException {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        boolean bl = false;
        List mavenOptsValues = new ArrayList();
        this.setupExePath();
        this.setupTargetJavaRuntime(this.mavenRunnerSettings(settings));
        this.setupTargetProjectDirectories(settings);
        if (setupEventListener) {
            this.setupMavenExtClassPath();
        }
        this.addMavenParameters(settings, mavenOptsValues);
        this.setupTargetEnvironmentVariables(settings, mavenOptsValues);
        return this;
    }

    public static /* synthetic */ MavenCommandLineSetup setupCommandLine$default(MavenCommandLineSetup mavenCommandLineSetup, MavenRunConfiguration.MavenSettings mavenSettings, boolean bl, int n, Object object) throws CantRunException {
        if ((n & 2) != 0) {
            bl = true;
        }
        return mavenCommandLineSetup.setupCommandLine(mavenSettings, bl);
    }

    @JvmOverloads
    @NotNull
    public final MavenCommandLineSetup setupCommandLine(@NotNull MavenRunConfiguration.MavenSettings settings) throws CantRunException {
        return MavenCommandLineSetup.setupCommandLine$default(this, settings, false, 2, null);
    }

    public final void provideEnvironment(@NotNull TargetEnvironment environment, @NotNull TargetProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        this.environmentPromise.setResult((Object)TuplesKt.to((Object)environment, (Object)progressIndicator));
        for (Promise<Unit> promise : this.dependingOnEnvironmentPromise) {
            promise.blockingGet(0);
        }
    }

    private final void setupExePath() throws CantRunException {
        if (this.defaultMavenRuntimeConfiguration == null) {
            this.commandLine.setExePath("mvn");
            return;
        }
        String homePath = this.defaultMavenRuntimeConfiguration.getHomePath();
        if (StringUtil.isEmptyOrSpaces((String)homePath)) {
            this.commandLine.setExePath("mvn");
            return;
        }
        this.commandLine.addEnvironmentVariable("MAVEN_HOME", homePath);
        this.commandLine.addEnvironmentVariable("M2_HOME", homePath);
        this.commandLine.setExePath(this.joinPath(new String[]{homePath, "bin", "mvn"}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void setupTargetJavaRuntime(MavenRunnerSettings runnerSettings) {
        boolean bl;
        String string;
        if (Intrinsics.areEqual((Object)runnerSettings.getJreName(), (Object)"#USE_PROJECT_JDK") ^ true) {
            string = runnerSettings.getJreName();
        } else {
            JavaLanguageRuntimeConfiguration javaLanguageRuntimeConfiguration = this.defaultJavaRuntimeConfiguration;
            Object object = javaLanguageRuntimeConfiguration;
            if (javaLanguageRuntimeConfiguration == null) return;
            String string2 = object.getHomePath();
            object = string2;
            if (string2 == null) return;
            CharSequence charSequence = (CharSequence)object;
            bl = false;
            if (StringsKt.isBlank((CharSequence)charSequence)) return;
            boolean bl2 = true;
            if (!bl2) return;
            string = this.defaultJavaRuntimeConfiguration.getHomePath();
        }
        if (string == null) return;
        String string3 = string;
        bl = false;
        boolean bl3 = false;
        String string4 = string3;
        boolean bl4 = false;
        this.commandLine.addEnvironmentVariable("JAVA_HOME", string4);
    }

    private final void setupMavenExtClassPath() {
        File mavenEventListener;
        File file = mavenEventListener = MavenServerManager.getMavenEventListener();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"mavenEventListener");
        Path uploadPath = Paths.get(FileUtil.toSystemDependentName((String)file.getPath()), new String[0]);
        LanguageRuntimeType.VolumeDescriptor volumeDescriptor = MavenRuntimeType.Companion.getMAVEN_EXT_CLASS_PATH_VOLUME();
        Path path = uploadPath;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"uploadPath");
        Path path2 = path.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"uploadPath.parent");
        TargetEnvironment.UploadRoot uploadRoot = this.createUploadRoot(volumeDescriptor, path2);
        Collection collection = this.request.getUploadVolumes();
        boolean bl = false;
        collection.add(uploadRoot);
        TargetValue<String> targetValue2 = this.upload(uploadRoot, ((Object)uploadPath).toString(), ((Object)uploadPath.getFileName()).toString());
        this.commandLine.addParameter(TargetValue.map(targetValue2, (Function)setupMavenExtClassPath.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private final void addMavenParameters(MavenRunConfiguration.MavenSettings settings, List<TargetValue<String>> mavenOptsValues) {
        block17: {
            Object it;
            String encodeProfiles;
            void $this$forEach$iv;
            Map $this$filterKeys$iv;
            MavenGeneralSettings generalSettings = this.mavenGeneralSettings(settings);
            MavenRunnerSettings runnerSettings = this.mavenRunnerSettings(settings);
            if (runnerSettings.isSkipTests()) {
                this.commandLine.addParameter("-DskipTests=true");
            }
            TargetValue targetValue2 = TargetValue.fixed((Object)("-Didea.version=" + MavenUtil.getIdeaVersionToPassToMavenProcess()));
            Intrinsics.checkNotNullExpressionValue((Object)targetValue2, (String)"TargetValue.fixed(\"-Dide\u2026ToPassToMavenProcess()}\")");
            mavenOptsValues.add((TargetValue<String>)targetValue2);
            String string = runnerSettings.getVmOptions();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"runnerSettings.vmOptions");
            CharSequence charSequence = string;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                TargetValue targetValue3 = TargetValue.fixed((Object)runnerSettings.getVmOptions());
                Intrinsics.checkNotNullExpressionValue((Object)targetValue3, (String)"TargetValue.fixed(runnerSettings.vmOptions)");
                mavenOptsValues.add((TargetValue<String>)targetValue3);
            }
            ParametersList mavenPropertiesList = new ParametersList();
            Map<String, String> map = runnerSettings.getMavenProperties();
            Intrinsics.checkNotNullExpressionValue(map, (String)"runnerSettings.mavenProperties");
            Map<String, String> map2 = map;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            void var9_12 = $this$filterKeys$iv;
            boolean bl2 = false;
            for (Map.Entry entry$iv : var9_12.entrySet()) {
                String it2 = (String)entry$iv.getKey();
                boolean bl3 = false;
                String string2 = it2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
                CharSequence charSequence2 = string2;
                boolean bl4 = false;
                if (!(charSequence2.length() > 0)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterKeys$iv = result$iv;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv;
            boolean bl5 = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void key;
                Map.Entry element$iv;
                Map.Entry $dstr$key$value = element$iv = iterator.next();
                boolean bl6 = false;
                Map.Entry entry = $dstr$key$value;
                boolean bl7 = false;
                String string3 = (String)entry.getKey();
                entry = $dstr$key$value;
                bl7 = false;
                String value = (String)entry.getValue();
                mavenPropertiesList.addProperty((String)key, value);
            }
            this.commandLine.addParameters(mavenPropertiesList.getParameters());
            MavenRunnerParameters mavenRunnerParameters = settings.myRunnerParameters;
            if (mavenRunnerParameters == null) {
                mavenRunnerParameters = new MavenRunnerParameters();
            }
            Intrinsics.checkNotNullExpressionValue((Object)mavenRunnerParameters, (String)"settings.myRunnerParamet\u2026: MavenRunnerParameters()");
            MavenRunnerParameters runnerParameters = mavenRunnerParameters;
            for (String goal : runnerParameters.getGoals()) {
                this.commandLine.addParameter(goal);
            }
            if (runnerParameters.getPomFileName() != null && !FileUtil.namesEqual((String)"pom.xml", (String)runnerParameters.getPomFileName())) {
                this.commandLine.addParameter("-f");
                this.commandLine.addParameter(runnerParameters.getPomFileName());
            }
            String string4 = encodeProfiles = MavenExternalParameters.encodeProfiles(runnerParameters.getProfilesMap());
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"encodeProfiles");
            object = string4;
            bl5 = false;
            if (object.length() > 0) {
                this.commandLine.addParameters(new String[]{"-P", encodeProfiles});
            }
            if (generalSettings.isWorkOffline()) {
                this.commandLine.addParameter("--offline");
            }
            if (generalSettings.getOutputLevel() == MavenExecutionOptions.LoggingLevel.DEBUG) {
                this.commandLine.addParameter("--debug");
            }
            if (generalSettings.isNonRecursive()) {
                this.commandLine.addParameter("--non-recursive");
            }
            if (generalSettings.isPrintErrorStackTraces()) {
                this.commandLine.addParameter("--errors");
            }
            if (generalSettings.isAlwaysUpdateSnapshots()) {
                this.commandLine.addParameter("--update-snapshots");
            }
            object = generalSettings.getThreads();
            bl5 = false;
            boolean bl8 = false;
            if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
                this.commandLine.addParameters(new String[]{"-T", generalSettings.getThreads()});
            }
            MavenExecutionOptions.FailureMode failureMode = generalSettings.getFailureBehavior();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)failureMode), (String)"generalSettings.failureBehavior");
            String string5 = StringKt.nullize((String)failureMode.getCommandLineOption(), (boolean)true);
            if (string5 != null) {
                object = string5;
                bl5 = false;
                bl8 = false;
                it = object;
                boolean bl9 = false;
                this.commandLine.addParameter((String)it);
            }
            MavenExecutionOptions.ChecksumPolicy checksumPolicy = generalSettings.getChecksumPolicy();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)checksumPolicy), (String)"generalSettings.checksumPolicy");
            String string6 = StringKt.nullize((String)checksumPolicy.getCommandLineOption(), (boolean)true);
            if (string6 != null) {
                object = string6;
                bl5 = false;
                bl8 = false;
                it = object;
                boolean bl10 = false;
                this.commandLine.addParameter((String)it);
            }
            String string7 = generalSettings.getUserSettingsFile();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"generalSettings.userSettingsFile");
            object = string7;
            bl5 = false;
            if (!StringsKt.isBlank((CharSequence)object)) {
                this.commandLine.addParameters(new String[]{"-s", generalSettings.getUserSettingsFile()});
            }
            String string8 = StringKt.nullize((String)generalSettings.getLocalRepository(), (boolean)true);
            if (string8 == null) break block17;
            object = string8;
            bl5 = false;
            bl8 = false;
            it = object;
            boolean bl11 = false;
            this.commandLine.addParameter("-Dmaven.repo.local=" + (String)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setupTargetEnvironmentVariables(MavenRunConfiguration.MavenSettings settings, List<TargetValue<String>> mavenOptsValues) {
        MavenRunnerSettings runnerSettings = this.mavenRunnerSettings(settings);
        Map<String, String> map = runnerSettings.getEnvironmentProperties();
        Intrinsics.checkNotNullExpressionValue(map, (String)"runnerSettings.environmentProperties");
        Map<String, String> $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Map<String, String> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            void name;
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$name$value = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, String> entry = $dstr$name$value;
            boolean bl3 = false;
            String string = entry.getKey();
            entry = $dstr$name$value;
            bl3 = false;
            String value = entry.getValue();
            if (Intrinsics.areEqual((Object)"MAVEN_OPTS", (Object)name)) {
                TargetValue targetValue2 = TargetValue.fixed((Object)value);
                Intrinsics.checkNotNullExpressionValue((Object)targetValue2, (String)"TargetValue.fixed(value)");
                mavenOptsValues.add((TargetValue<String>)targetValue2);
                continue;
            }
            this.commandLine.addEnvironmentVariable((String)name, value);
        }
        TargetValue targetValue3 = TargetValue.composite((Collection)mavenOptsValues, (Function)setupTargetEnvironmentVariables.targetValue.1.INSTANCE);
        this.commandLine.addEnvironmentVariable("MAVEN_OPTS", targetValue3);
    }

    private final MavenGeneralSettings mavenGeneralSettings(MavenRunConfiguration.MavenSettings settings) {
        MavenGeneralSettings mavenGeneralSettings = settings.myGeneralSettings;
        if (mavenGeneralSettings == null) {
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(this.project);
            Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"MavenProjectsManager.getInstance(project)");
            MavenGeneralSettings mavenGeneralSettings2 = mavenProjectsManager.getGeneralSettings();
            mavenGeneralSettings = mavenGeneralSettings2;
            Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings2, (String)"MavenProjectsManager.get\u2026(project).generalSettings");
        }
        return mavenGeneralSettings;
    }

    private final MavenRunnerSettings mavenRunnerSettings(MavenRunConfiguration.MavenSettings settings) {
        MavenRunnerSettings mavenRunnerSettings = settings.myRunnerSettings;
        if (mavenRunnerSettings == null) {
            MavenRunner mavenRunner = MavenRunner.getInstance(this.project);
            Intrinsics.checkNotNullExpressionValue((Object)mavenRunner, (String)"MavenRunner.getInstance(project)");
            MavenRunnerSettings mavenRunnerSettings2 = mavenRunner.getState();
            mavenRunnerSettings = mavenRunnerSettings2;
            Intrinsics.checkNotNullExpressionValue((Object)mavenRunnerSettings2, (String)"MavenRunner.getInstance(project).state");
        }
        return mavenRunnerSettings;
    }

    private final TargetValue<String> upload(TargetEnvironment.UploadRoot uploadRoot, String uploadPathString, String uploadRelativePath) {
        DeferredTargetValue result = new DeferredTargetValue((Object)uploadPathString);
        Collection collection = this.dependingOnEnvironmentPromise;
        Promise promise = this.environmentPromise.then(new Function(uploadRoot, uploadRelativePath, result){
            final /* synthetic */ TargetEnvironment.UploadRoot $uploadRoot;
            final /* synthetic */ String $uploadRelativePath;
            final /* synthetic */ DeferredTargetValue $result;

            /*
             * WARNING - void declaration
             */
            public final void fun(Pair<? extends TargetEnvironment, ? extends TargetProgressIndicator> $dstr$environment$progress) {
                void environment;
                TargetEnvironment targetEnvironment = (TargetEnvironment)$dstr$environment$progress.component1();
                TargetProgressIndicator progress = (TargetProgressIndicator)$dstr$environment$progress.component2();
                TargetEnvironment.UploadableVolume volume = (TargetEnvironment.UploadableVolume)MapsKt.getValue((Map)environment.getUploadVolumes(), (Object)this.$uploadRoot);
                String resolvedTargetPath = volume.resolveTargetPath(this.$uploadRelativePath);
                volume.upload(this.$uploadRelativePath, progress);
                this.$result.resolve((Object)resolvedTargetPath);
            }
            {
                this.$uploadRoot = uploadRoot;
                this.$uploadRelativePath = string;
                this.$result = deferredTargetValue;
            }
        });
        boolean bl = false;
        collection.add(promise);
        return (TargetValue)result;
    }

    private final TargetEnvironment.UploadRoot createUploadRoot(LanguageRuntimeType.VolumeDescriptor volumeDescriptor, Path localRootPath) {
        return MavenRuntimeTargetConfiguration.Companion.createUploadRoot(this.defaultMavenRuntimeConfiguration, this.request, volumeDescriptor, localRootPath);
    }

    private final void setupTargetProjectDirectories(MavenRunConfiguration.MavenSettings settings) {
        String commonAncestor;
        MavenRunnerParameters mavenRunnerParameters;
        MavenProjectsManager mavenProjectsManager;
        block9: {
            block8: {
                mavenProjectsManager = MavenProjectsManager.getInstance(this.project);
                mavenRunnerParameters = settings.myRunnerParameters;
                if (mavenRunnerParameters == null) break block8;
                MavenRunnerParameters mavenRunnerParameters2 = mavenRunnerParameters;
                boolean bl = false;
                boolean bl2 = false;
                MavenRunnerParameters it = mavenRunnerParameters2;
                boolean bl3 = false;
                MavenRunnerParameters mavenRunnerParameters3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)mavenRunnerParameters3, (String)"it");
                mavenRunnerParameters = VfsUtil.findFileByIoFile((File)mavenRunnerParameters3.getWorkingDirFile(), (boolean)false);
                if (mavenRunnerParameters != null) break block9;
            }
            throw (Throwable)new CantRunException(RunnerBundle.message("maven.target.message.unable.to.use.working.directory", this.name));
        }
        Intrinsics.checkNotNullExpressionValue((Object)mavenRunnerParameters, (String)"settings.myRunnerParamet\u2026orking.directory\", name))");
        MavenRunnerParameters file = mavenRunnerParameters;
        Module module = ProjectFileIndex.getInstance((Project)this.project).getModuleForFile((VirtualFile)file);
        if (module == null) {
            throw (Throwable)new CantRunException(RunnerBundle.message("maven.target.message.unable.to.find.maven.project.for.working.directory", this.name));
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ProjectFileIndex.getInst\u2026orking.directory\", name))");
        Module module2 = module;
        MavenProject mavenProject = mavenProjectsManager.findProject(module2);
        if (mavenProject == null) {
            throw (Throwable)new CantRunException(RunnerBundle.message("maven.target.message.unable.to.find.maven.project.for.working.directory", this.name));
        }
        MavenProject mavenProject2 = mavenProject;
        String string = FileUtil.toSystemDependentName((String)mavenProject2.getDirectory());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(mavenProject.directory)");
        String mavenProjectDirectory = string;
        MavenProjectsManager mavenProjectsManager2 = mavenProjectsManager;
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager2, (String)"mavenProjectsManager");
        Set<String> pathsToUpload = this.findPathsToUpload(mavenProjectsManager2, mavenProject2);
        String string2 = commonAncestor = this.findCommonAncestor(pathsToUpload);
        Intrinsics.checkNotNull((Object)string2);
        Path uploadPath = Paths.get(FileUtil.toSystemDependentName((String)string2), new String[0]);
        LanguageRuntimeType.VolumeDescriptor volumeDescriptor = MavenRuntimeType.Companion.getPROJECT_FOLDER_VOLUME();
        Path path = uploadPath;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"uploadPath");
        TargetEnvironment.UploadRoot uploadRoot = this.createUploadRoot(volumeDescriptor, path);
        Collection collection = this.request.getUploadVolumes();
        boolean bl = false;
        collection.add(uploadRoot);
        char targetFileSeparator = this.request.getTargetPlatform().getPlatform().fileSeparator;
        TargetValue targetWorkingDirectory = null;
        for (String path2 : pathsToUpload) {
            String string3;
            String workingDirRelativePath;
            String relativePath;
            String string4 = relativePath = FileUtil.getRelativePath((String)commonAncestor, (String)path2, (char)File.separatorChar);
            Intrinsics.checkNotNull((Object)string4);
            TargetValue<String> targetValue2 = this.upload(uploadRoot, path2, string4);
            if (targetWorkingDirectory != null || !FileUtil.isAncestor((String)path2, (String)mavenProjectDirectory, (boolean)false)) continue;
            Intrinsics.checkNotNull((Object)FileUtil.getRelativePath((String)path2, (String)mavenProjectDirectory, (char)File.separatorChar));
            Intrinsics.checkNotNullExpressionValue((Object)workingDirRelativePath, (String)"getRelativePath(path, ma\u2026ry, File.separatorChar)!!");
            if (Intrinsics.areEqual((Object)workingDirRelativePath, (Object)".")) {
                string3 = "";
            } else {
                String string5 = FileUtil.toSystemDependentName((String)workingDirRelativePath, (char)targetFileSeparator);
                string3 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toSystemDependentName(wo\u2026ath, targetFileSeparator)");
            }
            String targetWorkingDirRelativePath = string3;
            targetWorkingDirectory = TargetValue.map(targetValue2, (Function)new Function(targetFileSeparator, targetWorkingDirRelativePath){
                final /* synthetic */ char $targetFileSeparator;
                final /* synthetic */ String $targetWorkingDirRelativePath;

                public final String fun(String it) {
                    return it + this.$targetFileSeparator + this.$targetWorkingDirRelativePath;
                }
                {
                    this.$targetFileSeparator = c;
                    this.$targetWorkingDirRelativePath = string;
                }
            });
        }
        TargetValue targetValue3 = targetWorkingDirectory;
        Intrinsics.checkNotNull((Object)targetValue3);
        this.commandLine.setWorkingDirectory(targetValue3);
    }

    private final String findCommonAncestor(Set<String> paths) {
        boolean bl;
        boolean bl2;
        File commonRoot = null;
        for (String path : paths) {
            commonRoot = commonRoot == null ? new File(path) : FileUtil.findAncestor((File)commonRoot, (File)new File(path));
            bl2 = false;
            bl = false;
            if (commonRoot != null) continue;
            boolean bl3 = false;
            String string = "no common root found";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl4 = commonRoot != null;
        boolean bl5 = false;
        bl2 = false;
        if (_Assertions.ENABLED && !bl4) {
            bl = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        File file = commonRoot;
        Intrinsics.checkNotNull((Object)file);
        return file.getPath();
    }

    private final Set<String> findPathsToUpload(MavenProjectsManager mavenProjectsManager, MavenProject project2) {
        MavenProject mavenProject = mavenProjectsManager.findRootProject(project2);
        if (mavenProject == null) {
            return SetsKt.emptySet();
        }
        Intrinsics.checkNotNullExpressionValue((Object)mavenProject, (String)"mavenProjectsManager.fin\u2026ect) ?: return emptySet()");
        MavenProject rootProject = mavenProject;
        LinkedList projects = new LinkedList();
        Collection collection = projects;
        boolean bl = false;
        collection.add(rootProject);
        projects.addAll(this.findAllInheritors(mavenProjectsManager, rootProject));
        Set paths = new HashSet();
        while (true) {
            String projectDirectory;
            boolean bl2;
            block5: {
                MavenProject mavenProject2;
                Collection collection2 = projects;
                boolean bl3 = false;
                if (!(!collection2.isEmpty())) break;
                MavenProject mavenProject3 = mavenProject2 = (MavenProject)projects.pop();
                Intrinsics.checkNotNull((Object)mavenProject3);
                Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemDependentName((String)mavenProject3.getDirectory()), (String)"toSystemDependentName(mavenProject!!.directory)");
                Iterable $this$any$iv = paths;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl4 = false;
                        if (!FileUtil.isAncestor((String)it, (String)projectDirectory, (boolean)false)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            if (bl2) continue;
            paths.removeIf(new Predicate(projectDirectory){
                final /* synthetic */ String $projectDirectory;

                public final boolean test(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return FileUtil.isAncestor((String)this.$projectDirectory, (String)it, (boolean)false);
                }
                {
                    this.$projectDirectory = string;
                }
            });
            paths.add(projectDirectory);
        }
        return paths;
    }

    private final List<MavenProject> findAllInheritors(MavenProjectsManager mavenProjectsManager, MavenProject project2) {
        Collection<MavenProject> collection = mavenProjectsManager.findInheritors(project2);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"mavenProjectsManager.findInheritors(project)");
        Collection<MavenProject> inheritors = collection;
        ArrayList<MavenProject> result = new ArrayList<MavenProject>(inheritors);
        for (MavenProject inheritor : inheritors) {
            Collection collection2 = result;
            MavenProject mavenProject = inheritor;
            Intrinsics.checkNotNullExpressionValue((Object)mavenProject, (String)"inheritor");
            Iterable iterable = this.findAllInheritors(mavenProjectsManager, mavenProject);
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection2, (Iterable)iterable);
        }
        return result;
    }

    private final String joinPath(String[] segments) {
        String string = ((StringBuilder)ArraysKt.joinTo$default((Object[])segments, (Appendable)new StringBuilder(), (CharSequence)String.valueOf(this.platform.fileSeparator), null, null, (int)0, null, null, (int)124, null)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"segments.joinTo(StringBu\u2026or.toString()).toString()");
        return string;
    }

    public MavenCommandLineSetup(@NotNull Project project2, @NotNull String name, @NotNull TargetEnvironmentRequest request) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.project = project2;
        this.name = name;
        this.request = request;
        this.commandLine = new TargetedCommandLineBuilder(this.request);
        Platform platform = this.request.getTargetPlatform().getPlatform();
        Intrinsics.checkNotNullExpressionValue((Object)platform, (String)"request.targetPlatform.platform");
        this.platform = platform;
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = this.request.getConfiguration();
        this.defaultMavenRuntimeConfiguration = targetEnvironmentConfiguration != null && (targetEnvironmentConfiguration = targetEnvironmentConfiguration.getRuntimes()) != null ? (MavenRuntimeTargetConfiguration)targetEnvironmentConfiguration.findByType(MavenRuntimeTargetConfiguration.class) : null;
        TargetEnvironmentConfiguration targetEnvironmentConfiguration2 = this.request.getConfiguration();
        this.defaultJavaRuntimeConfiguration = targetEnvironmentConfiguration2 != null && (targetEnvironmentConfiguration2 = targetEnvironmentConfiguration2.getRuntimes()) != null ? (JavaLanguageRuntimeConfiguration)targetEnvironmentConfiguration2.findByType(JavaLanguageRuntimeConfiguration.class) : null;
        this.environmentPromise = new AsyncPromise();
        boolean bl = false;
        this.dependingOnEnvironmentPromise = new ArrayList();
        this.commandLine.putUserData(setupKey, (Object)this);
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"org.jetbrains.idea.maven.execution.target.MavenCommandLineSetup");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<MavenCommandL\u2026t.MavenCommandLineSetup\")");
        setupKey = key;
    }

    @NotNull
    public static final Key<MavenCommandLineSetup> getSetupKey() {
        Companion companion = Companion;
        return setupKey;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R/\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/maven/execution/target/MavenCommandLineSetup$Companion;", "", "()V", "setupKey", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/idea/maven/execution/target/MavenCommandLineSetup;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getSetupKey$annotations", "getSetupKey", "()Lcom/intellij/openapi/util/Key;", "intellij.maven"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getSetupKey$annotations() {
        }

        @NotNull
        public final Key<MavenCommandLineSetup> getSetupKey() {
            return setupKey;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

