/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.CommonBundle;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTreeFilters;
import com.intellij.build.BuildView;
import com.intellij.build.BuildViewManager;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.Filterable;
import com.intellij.build.ViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.debugger.impl.RemoteConnectionBuilder;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.CantRunException;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteConnectionCreator;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.impl.SingleConfigurationConfigurable;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.execution.wsl.target.WslTargetEnvironmentRequest;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfigurationViewManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.awt.Component;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.BuildToolConsoleProcessAdapter;
import org.jetbrains.idea.maven.buildtool.MavenBuildEventProcessor;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.execution.MavenApplicationConfigurationExecutionEnvironmentProvider;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenRCSettingsWatcherImpl;
import org.jetbrains.idea.maven.execution.MavenRebuildAction;
import org.jetbrains.idea.maven.execution.MavenResumeAction;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerParametersSettingEditor;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.MavenRunnerSettingsEditor;
import org.jetbrains.idea.maven.execution.MavenSimpleConsoleEventsBuffer;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.execution.target.MavenCommandLineSetup;
import org.jetbrains.idea.maven.execution.target.MavenRuntimeTargetConfiguration;
import org.jetbrains.idea.maven.execution.target.MavenRuntimeType;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenParsingContext;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenGeneralSettingsEditor;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenRunConfiguration
extends LocatableConfigurationBase
implements ModuleRunProfile,
TargetEnvironmentAwareRunProfile {
    private MavenSettings mySettings;

    protected MavenRunConfiguration(Project project2, ConfigurationFactory factory, String name) {
        super(project2, factory, name);
        this.mySettings = new MavenSettings(project2);
    }

    public MavenRunConfiguration clone() {
        MavenRunConfiguration clone = (MavenRunConfiguration)super.clone();
        clone.mySettings = this.mySettings.clone();
        return clone;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        MavenRunnerParametersSettingEditor runnerParamsEditor = new MavenRunnerParametersSettingEditor(this.getProject());
        MavenGeneralSettingsEditor generalSettingsEditor = new MavenGeneralSettingsEditor(this.getProject());
        MavenRunnerSettingsEditor runnerSettingsEditor = new MavenRunnerSettingsEditor(this.getProject());
        runnerParamsEditor.registerSettingsWatcher(new MavenRCSettingsWatcherImpl(this.getProject(), "maven.params", false));
        generalSettingsEditor.registerSettingsWatcher(new MavenRCSettingsWatcherImpl(this.getProject(), "maven.general", true));
        runnerSettingsEditor.registerSettingsWatcher(new MavenRCSettingsWatcherImpl(this.getProject(), "maven.runner", true));
        group.addEditor(RunnerBundle.message("maven.runner.parameters.title", new Object[0]), (SettingsEditor)runnerParamsEditor);
        group.addEditor(CommonBundle.message((String)"tab.title.general", (Object[])new Object[0]), (SettingsEditor)generalSettingsEditor);
        group.addEditor(RunnerBundle.message("maven.tab.runner", new Object[0]), (SettingsEditor)runnerSettingsEditor);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            MavenRunConfiguration.$$$reportNull$$$0(0);
        }
        return settingsEditorGroup;
    }

    @ApiStatus.Internal
    @Nullable
    public static String getTargetName(SettingsEditor<MavenRunConfiguration> mavenRunConfigurationSettingsEditor) {
        return (String)DataManager.getInstance().getDataContext((Component)mavenRunConfigurationSettingsEditor.getComponent()).getData(SingleConfigurationConfigurable.RUN_ON_TARGET_NAME_KEY);
    }

    public JavaParameters createJavaParameters(@Nullable Project project2) throws ExecutionException {
        return MavenExternalParameters.createJavaParameters(project2, this.mySettings.myRunnerParameters, this.mySettings.myGeneralSettings, this.mySettings.myRunnerSettings, this);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            MavenRunConfiguration.$$$reportNull$$$0(1);
        }
        if (env == null) {
            MavenRunConfiguration.$$$reportNull$$$0(2);
        }
        return new MavenCommandLineState(env, this);
    }

    @NotNull
    public RemoteConnectionCreator createRemoteConnectionCreator(JavaParameters javaParameters) {
        return new ExecRemoteConnectionCreator(javaParameters, this);
    }

    private void updateProjectsFolders() {
        MavenProjectsManager.getInstance(this.getProject()).updateProjectTargetFolders();
    }

    @Nullable
    public MavenGeneralSettings getGeneralSettings() {
        return this.mySettings.myGeneralSettings;
    }

    public void setGeneralSettings(@Nullable MavenGeneralSettings settings) {
        this.mySettings.myGeneralSettings = settings;
    }

    @Nullable
    public MavenRunnerSettings getRunnerSettings() {
        return this.mySettings.myRunnerSettings;
    }

    public void setRunnerSettings(@Nullable MavenRunnerSettings settings) {
        this.mySettings.myRunnerSettings = settings;
    }

    public MavenRunnerParameters getRunnerParameters() {
        return this.mySettings.myRunnerParameters;
    }

    public void setRunnerParameters(MavenRunnerParameters p) {
        this.mySettings.myRunnerParameters = p;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            MavenRunConfiguration.$$$reportNull$$$0(3);
        }
        super.readExternal(element);
        Element mavenSettingsElement = element.getChild("MavenSettings");
        if (mavenSettingsElement != null) {
            this.mySettings = (MavenSettings)XmlSerializer.deserialize((Element)mavenSettingsElement, MavenSettings.class);
            if (this.mySettings.myRunnerParameters == null) {
                this.mySettings.myRunnerParameters = new MavenRunnerParameters();
            }
            this.mySettings.myRunnerParameters.fixAfterLoadingFromOldFormat();
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            MavenRunConfiguration.$$$reportNull$$$0(4);
        }
        super.writeExternal(element);
        element.addContent(XmlSerializer.serialize((Object)this.mySettings));
    }

    public String suggestedName() {
        return MavenRunConfigurationType.generateName(this.getProject(), this.mySettings.myRunnerParameters);
    }

    public boolean canRunOn(@NotNull TargetEnvironmentConfiguration target) {
        if (target == null) {
            MavenRunConfiguration.$$$reportNull$$$0(5);
        }
        return target.getRuntimes().findByType(MavenRuntimeTargetConfiguration.class) != null;
    }

    @Nullable
    public LanguageRuntimeType<?> getDefaultLanguageRuntimeType() {
        return (LanguageRuntimeType)LanguageRuntimeType.EXTENSION_NAME.findExtension(MavenRuntimeType.class);
    }

    @Nullable
    public String getDefaultTargetName() {
        return this.getOptions().getRemoteTarget();
    }

    public void setDefaultTargetName(@Nullable String targetName) {
        this.getOptions().setRemoteTarget(targetName);
    }

    public void onNewConfigurationCreated() {
        super.onNewConfigurationCreated();
        if (!this.getName().equals(this.suggestedName())) {
            this.getOptions().setNameGenerated(false);
        }
    }

    @NotNull
    private static Function<String, String> createTargetFileMapper(@NotNull TargetEnvironment targetEnvironment, @NotNull String projectRootlocalPath, @NotNull String projectRootTargetPath) {
        if (targetEnvironment == null) {
            MavenRunConfiguration.$$$reportNull$$$0(6);
        }
        if (projectRootlocalPath == null) {
            MavenRunConfiguration.$$$reportNull$$$0(7);
        }
        if (projectRootTargetPath == null) {
            MavenRunConfiguration.$$$reportNull$$$0(8);
        }
        Function<String, String> function = path -> {
            if (path == null) {
                return null;
            }
            boolean isWindows = targetEnvironment.getTargetPlatform().getPlatform() == Platform.WINDOWS;
            String string = path = isWindows && path.charAt(0) == '/' ? path.substring(1) : path;
            if (path.startsWith(projectRootTargetPath)) {
                return Paths.get(projectRootlocalPath, StringUtil.trimStart((String)path, (String)projectRootTargetPath)).toString();
            }
            if (path.startsWith("/private" + projectRootTargetPath)) {
                return Paths.get(projectRootlocalPath, StringUtil.trimStart((String)path, (String)("/private" + projectRootTargetPath))).toString();
            }
            return path;
        };
        if (function == null) {
            MavenRunConfiguration.$$$reportNull$$$0(9);
        }
        return function;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootlocalPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootTargetPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetFileMapper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canRunOn";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTargetFileMapper";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ProcessListenerWithFilteredSpyOutput
    implements ProcessListener {
        private final ProcessListener myListener;
        private final ProcessHandler myProcessHandler;
        private final MavenSimpleConsoleEventsBuffer mySimpleConsoleEventsBuffer;

        ProcessListenerWithFilteredSpyOutput(ProcessListener listener2, ProcessHandler processHandler) {
            this.myListener = listener2;
            this.myProcessHandler = processHandler;
            this.mySimpleConsoleEventsBuffer = new MavenSimpleConsoleEventsBuffer((l, k) -> this.myListener.onTextAvailable(new ProcessEvent(processHandler, l), k), Registry.is((String)"maven.spy.events.debug"));
        }

        public void startNotified(@NotNull ProcessEvent event) {
            if (event == null) {
                ProcessListenerWithFilteredSpyOutput.$$$reportNull$$$0(0);
            }
            this.myListener.startNotified(event);
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                ProcessListenerWithFilteredSpyOutput.$$$reportNull$$$0(1);
            }
            this.myListener.processTerminated(event);
        }

        public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
            if (event == null) {
                ProcessListenerWithFilteredSpyOutput.$$$reportNull$$$0(2);
            }
            this.myListener.processWillTerminate(event, willBeDestroyed);
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            if (event == null) {
                ProcessListenerWithFilteredSpyOutput.$$$reportNull$$$0(3);
            }
            if (outputType == null) {
                ProcessListenerWithFilteredSpyOutput.$$$reportNull$$$0(4);
            }
            this.mySimpleConsoleEventsBuffer.addText(event.getText(), outputType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration$ProcessListenerWithFilteredSpyOutput";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startNotified";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminated";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processWillTerminate";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTextAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MavenBuildHandlerFilterSpyWrapper
    extends BuildProcessHandler {
        private final ProcessHandler myOriginalHandler;

        public MavenBuildHandlerFilterSpyWrapper(ProcessHandler original) {
            this.myOriginalHandler = original;
        }

        public void destroyProcess() {
            this.myOriginalHandler.destroyProcess();
        }

        public void detachProcess() {
            this.myOriginalHandler.detachProcess();
        }

        public boolean isProcessTerminated() {
            return this.myOriginalHandler.isProcessTerminated();
        }

        public boolean isProcessTerminating() {
            return this.myOriginalHandler.isProcessTerminating();
        }

        @Nullable
        public Integer getExitCode() {
            return this.myOriginalHandler.getExitCode();
        }

        public String getExecutionName() {
            return "Maven build";
        }

        protected void destroyProcessImpl() {
            this.myOriginalHandler.destroyProcess();
        }

        protected void detachProcessImpl() {
            this.myOriginalHandler.detachProcess();
        }

        public boolean detachIsDefault() {
            return this.myOriginalHandler.detachIsDefault();
        }

        @Nullable
        public OutputStream getProcessInput() {
            return this.myOriginalHandler.getProcessInput();
        }

        public void addProcessListener(@NotNull ProcessListener listener2) {
            if (listener2 == null) {
                MavenBuildHandlerFilterSpyWrapper.$$$reportNull$$$0(0);
            }
            this.myOriginalHandler.addProcessListener(this.filtered(listener2));
        }

        public void addProcessListener(@NotNull ProcessListener listener2, @NotNull Disposable parentDisposable) {
            if (listener2 == null) {
                MavenBuildHandlerFilterSpyWrapper.$$$reportNull$$$0(1);
            }
            if (parentDisposable == null) {
                MavenBuildHandlerFilterSpyWrapper.$$$reportNull$$$0(2);
            }
            this.myOriginalHandler.addProcessListener(this.filtered(listener2), parentDisposable);
        }

        private ProcessListener filtered(ProcessListener listener2) {
            return new ProcessListenerWithFilteredSpyOutput(listener2, (ProcessHandler)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "listener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentDisposable";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration$MavenBuildHandlerFilterSpyWrapper";
            objectArray[2] = "addProcessListener";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MavenHandlerFilterSpyWrapper
    extends ProcessHandler {
        private final ProcessHandler myOriginalHandler;

        MavenHandlerFilterSpyWrapper(ProcessHandler original) {
            this.myOriginalHandler = original;
        }

        public void detachProcess() {
            this.myOriginalHandler.detachProcess();
        }

        public boolean isProcessTerminated() {
            return this.myOriginalHandler.isProcessTerminated();
        }

        public boolean isProcessTerminating() {
            return this.myOriginalHandler.isProcessTerminating();
        }

        @Nullable
        public Integer getExitCode() {
            return this.myOriginalHandler.getExitCode();
        }

        protected void destroyProcessImpl() {
            this.myOriginalHandler.destroyProcess();
        }

        protected void detachProcessImpl() {
            this.myOriginalHandler.detachProcess();
        }

        public boolean detachIsDefault() {
            return this.myOriginalHandler.detachIsDefault();
        }

        @Nullable
        public OutputStream getProcessInput() {
            return this.myOriginalHandler.getProcessInput();
        }

        public void addProcessListener(@NotNull ProcessListener listener2) {
            if (listener2 == null) {
                MavenHandlerFilterSpyWrapper.$$$reportNull$$$0(0);
            }
            this.myOriginalHandler.addProcessListener(this.filtered(listener2));
        }

        public void addProcessListener(@NotNull ProcessListener listener2, @NotNull Disposable parentDisposable) {
            if (listener2 == null) {
                MavenHandlerFilterSpyWrapper.$$$reportNull$$$0(1);
            }
            if (parentDisposable == null) {
                MavenHandlerFilterSpyWrapper.$$$reportNull$$$0(2);
            }
            this.myOriginalHandler.addProcessListener(this.filtered(listener2), parentDisposable);
        }

        private ProcessListener filtered(ProcessListener listener2) {
            return new ProcessListenerWithFilteredSpyOutput(listener2, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "listener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentDisposable";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration$MavenHandlerFilterSpyWrapper";
            objectArray[2] = "addProcessListener";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class MavenCommandLineState
    extends JavaCommandLineState
    implements RemoteConnectionCreator {
        private final MavenRunConfiguration myConfiguration;
        private RemoteConnectionCreator myRemoteConnectionCreator;

        protected MavenCommandLineState(@NotNull ExecutionEnvironment environment, @NotNull MavenRunConfiguration configuration) {
            if (environment == null) {
                MavenCommandLineState.$$$reportNull$$$0(0);
            }
            if (configuration == null) {
                MavenCommandLineState.$$$reportNull$$$0(1);
            }
            super(environment);
            this.myConfiguration = configuration;
        }

        public TargetEnvironmentRequest createCustomTargetEnvironmentRequest() {
            try {
                JavaParameters parameters = this.getJavaParameters();
                WslTargetEnvironmentConfiguration config = MavenCommandLineState.checkCreateWslConfiguration((Sdk)parameters.getJdk());
                if (config == null || config.getDistribution() == null) {
                    return null;
                }
                MavenDistribution mavenDistribution = MavenDistributionsCache.getInstance(this.myConfiguration.getProject()).getMavenDistribution(this.myConfiguration.getRunnerParameters().getWorkingDirPath());
                String mavenHome = StringUtil.notNullize((String)config.getDistribution().getWslPath(mavenDistribution.getMavenHome().getPath()));
                String mavenVersion = StringUtil.notNullize((String)mavenDistribution.getVersion());
                MavenRuntimeTargetConfiguration mavenConfig = new MavenRuntimeTargetConfiguration();
                mavenConfig.setHomePath(mavenHome);
                mavenConfig.setVersionString(mavenVersion);
                config.addLanguageRuntime((LanguageRuntimeConfiguration)mavenConfig);
                return new WslTargetEnvironmentRequest(config);
            }
            catch (ExecutionException executionException) {
                return null;
            }
        }

        protected JavaParameters createJavaParameters() throws ExecutionException {
            if (this.getEnvironment().getTargetEnvironmentRequest() instanceof LocalTargetEnvironmentRequest) {
                JavaParameters parameters = this.myConfiguration.createJavaParameters(this.getEnvironment().getProject());
                JavaRunConfigurationExtensionManager.getInstance().updateJavaParameters((RunConfigurationBase)this.myConfiguration, parameters, this.getEnvironment().getRunnerSettings(), this.getEnvironment().getExecutor());
                return parameters;
            }
            return new JavaParameters();
        }

        public ExecutionResult doDelegateBuildExecute(@NotNull Executor executor, @NotNull ProgramRunner runner, ExternalSystemTaskId taskId, DefaultBuildDescriptor descriptor2, ProcessHandler processHandler, Function<String, String> targetFileMapper) throws ExecutionException {
            if (executor == null) {
                MavenCommandLineState.$$$reportNull$$$0(2);
            }
            if (runner == null) {
                MavenCommandLineState.$$$reportNull$$$0(3);
            }
            ConsoleView consoleView = super.createConsole(executor);
            BuildViewManager viewManager = (BuildViewManager)this.getEnvironment().getProject().getService(BuildViewManager.class);
            descriptor2.withProcessHandler((BuildProcessHandler)new MavenBuildHandlerFilterSpyWrapper(processHandler), null);
            descriptor2.withExecutionEnvironment(this.getEnvironment());
            StartBuildEventImpl startBuildEvent = new StartBuildEventImpl((BuildDescriptor)descriptor2, "");
            boolean withResumeAction = MavenResumeAction.isApplicable(this.getEnvironment().getProject(), this.getJavaParameters(), this.myConfiguration);
            Project project2 = this.myConfiguration.getProject();
            MavenBuildEventProcessor eventProcessor = new MavenBuildEventProcessor(project2, project2.getBasePath(), (BuildProgressListener)viewManager, (BuildDescriptor)descriptor2, taskId, targetFileMapper, this.getStartBuildEventSupplier(runner, processHandler, startBuildEvent, withResumeAction));
            processHandler.addProcessListener((ProcessListener)new BuildToolConsoleProcessAdapter(eventProcessor, true));
            return new DefaultExecutionResult((ExecutionConsole)consoleView, processHandler, new AnAction[]{new DefaultActionGroup()});
        }

        public ExecutionResult doRunExecute(@NotNull Executor executor, @NotNull ProgramRunner runner, ExternalSystemTaskId taskId, DefaultBuildDescriptor descriptor2, ProcessHandler processHandler, @NotNull Function<String, String> targetFileMapper) throws ExecutionException {
            AnAction[] anActionArray;
            BuildView buildView;
            if (executor == null) {
                MavenCommandLineState.$$$reportNull$$$0(4);
            }
            if (runner == null) {
                MavenCommandLineState.$$$reportNull$$$0(5);
            }
            if (targetFileMapper == null) {
                MavenCommandLineState.$$$reportNull$$$0(6);
            }
            if ((buildView = this.createBuildView(executor, taskId, (BuildDescriptor)descriptor2)) == null) {
                MavenLog.LOG.warn("buildView is null for " + this.myConfiguration.getName());
            }
            Project project2 = this.myConfiguration.getProject();
            MavenBuildEventProcessor eventProcessor = new MavenBuildEventProcessor(project2, project2.getBasePath(), (BuildProgressListener)buildView, (BuildDescriptor)descriptor2, taskId, targetFileMapper, ctx -> new StartBuildEventImpl((BuildDescriptor)descriptor2, ""));
            processHandler.addProcessListener((ProcessListener)new BuildToolConsoleProcessAdapter(eventProcessor, true));
            buildView.attachToProcess((ProcessHandler)new MavenHandlerFilterSpyWrapper(processHandler));
            if (buildView != null) {
                AnAction[] anActionArray2 = new AnAction[1];
                anActionArray = anActionArray2;
                anActionArray2[0] = BuildTreeFilters.createFilteringActionsGroup((Filterable)buildView);
            } else {
                anActionArray = AnAction.EMPTY_ARRAY;
            }
            AnAction[] actions = anActionArray;
            DefaultExecutionResult res = new DefaultExecutionResult((ExecutionConsole)buildView, processHandler, actions);
            if (MavenResumeAction.isApplicable(this.getEnvironment().getProject(), this.getJavaParameters(), this.myConfiguration)) {
                MavenResumeAction resumeAction = new MavenResumeAction(res.getProcessHandler(), runner, this.getEnvironment(), eventProcessor.getParsingContext());
                res.setRestartActions(new AnAction[]{resumeAction});
            }
            return res;
        }

        @NotNull
        private Function<MavenParsingContext, StartBuildEvent> getStartBuildEventSupplier(@NotNull ProgramRunner runner, ProcessHandler processHandler, StartBuildEventImpl startBuildEvent, boolean withResumeAction) {
            if (runner == null) {
                MavenCommandLineState.$$$reportNull$$$0(7);
            }
            Function<MavenParsingContext, StartBuildEvent> function = ctx -> withResumeAction ? startBuildEvent.withRestartActions(new AnAction[]{new MavenRebuildAction(this.getEnvironment()), new MavenResumeAction(processHandler, runner, this.getEnvironment(), (MavenParsingContext)ctx)}) : startBuildEvent.withRestartActions(new AnAction[]{new MavenRebuildAction(this.getEnvironment())});
            if (function == null) {
                MavenCommandLineState.$$$reportNull$$$0(8);
            }
            return function;
        }

        @NotNull
        public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
            TargetedCommandLineBuilder targetedCommandLineBuilder;
            String targetWorkingDirectory;
            if (executor == null) {
                MavenCommandLineState.$$$reportNull$$$0(9);
            }
            if (runner == null) {
                MavenCommandLineState.$$$reportNull$$$0(10);
            }
            OSProcessHandler processHandler = this.startProcess();
            ExecutionEnvironment environment = this.getEnvironment();
            TargetEnvironment targetEnvironment = environment.getPreparedTargetEnvironment((RunProfileState)this, TargetProgressIndicator.EMPTY);
            Function<String, String> targetFileMapper = path -> path != null && SystemInfo.isWindows && path.charAt(0) == '/' ? path.substring(1) : path;
            if (!(targetEnvironment instanceof LocalTargetEnvironment)) {
                TargetEnvironmentRequest targetEnvironmentRequest = this.getTargetEnvironmentRequest();
                LanguageRuntimeType.VolumeType mavenProjectFolderVolumeType = MavenRuntimeType.getPROJECT_FOLDER_VOLUME().getType();
                Set uploadVolumes = targetEnvironmentRequest.getUploadVolumes();
                for (TargetEnvironment.UploadRoot uploadVolume : uploadVolumes) {
                    String localPath = uploadVolume.getLocalRootPath().toString();
                    TargetEnvironment.TargetPath targetRootPath = uploadVolume.getTargetRootPath();
                    if (!(targetRootPath instanceof TargetEnvironment.TargetPath.Temporary) || !mavenProjectFolderVolumeType.getId().equals(((TargetEnvironment.TargetPath.Temporary)targetRootPath).getHint())) continue;
                    String targetPath = (String)TargetEnvironmentFunctions.getTargetUploadPath((TargetEnvironment.UploadRoot)uploadVolume).apply(targetEnvironment);
                    targetFileMapper = MavenRunConfiguration.createTargetFileMapper(targetEnvironment, localPath, targetPath);
                    break;
                }
            }
            String workingDir = (targetWorkingDirectory = (targetedCommandLineBuilder = this.getTargetedCommandLine()).build().getWorkingDirectory()) != null ? targetFileMapper.apply(targetWorkingDirectory) : this.getEnvironment().getProject().getBasePath();
            ExternalSystemTaskId taskId = ExternalSystemTaskId.create((ProjectSystemId)MavenUtil.SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)this.myConfiguration.getProject());
            DefaultBuildDescriptor descriptor2 = new DefaultBuildDescriptor((Object)taskId, this.myConfiguration.getName(), workingDir, System.currentTimeMillis());
            if (MavenRunConfigurationType.isDelegate(this.getEnvironment())) {
                ExecutionResult executionResult = this.doDelegateBuildExecute(executor, runner, taskId, descriptor2, (ProcessHandler)processHandler, targetFileMapper);
                if (executionResult == null) {
                    MavenCommandLineState.$$$reportNull$$$0(11);
                }
                return executionResult;
            }
            ExecutionResult executionResult = this.doRunExecute(executor, runner, taskId, descriptor2, (ProcessHandler)processHandler, targetFileMapper);
            if (executionResult == null) {
                MavenCommandLineState.$$$reportNull$$$0(12);
            }
            return executionResult;
        }

        @Nullable
        private BuildView createBuildView(@NotNull Executor executor, @NotNull ExternalSystemTaskId taskId, @NotNull BuildDescriptor descriptor2) throws ExecutionException {
            ConsoleView console;
            if (executor == null) {
                MavenCommandLineState.$$$reportNull$$$0(13);
            }
            if (taskId == null) {
                MavenCommandLineState.$$$reportNull$$$0(14);
            }
            if (descriptor2 == null) {
                MavenCommandLineState.$$$reportNull$$$0(15);
            }
            if ((console = super.createConsole(executor)) == null) {
                return null;
            }
            Project project2 = this.myConfiguration.getProject();
            final ExternalSystemRunConfigurationViewManager viewManager = (ExternalSystemRunConfigurationViewManager)project2.getService(ExternalSystemRunConfigurationViewManager.class);
            return new BuildView(project2, (ExecutionConsole)console, descriptor2, "build.toolwindow.run.selection.state", (ViewManager)viewManager){

                public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
                    if (buildId == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.onEvent(buildId, event);
                    viewManager.onEvent(buildId, event);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "buildId";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration$MavenCommandLineState$1";
                    objectArray[2] = "onEvent";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        @NotNull
        protected TargetedCommandLineBuilder createTargetedCommandLine(@NotNull TargetEnvironmentRequest request) throws ExecutionException {
            if (request == null) {
                MavenCommandLineState.$$$reportNull$$$0(16);
            }
            if (request instanceof LocalTargetEnvironmentRequest) {
                TargetedCommandLineBuilder targetedCommandLineBuilder = super.createTargetedCommandLine(request);
                if (targetedCommandLineBuilder == null) {
                    MavenCommandLineState.$$$reportNull$$$0(17);
                }
                return targetedCommandLineBuilder;
            }
            if (request.getConfiguration() == null) {
                throw new CantRunException(RunnerBundle.message("cannot.find.target.environment.configuration", new Object[0]));
            }
            TargetedCommandLineBuilder targetedCommandLineBuilder = new MavenCommandLineSetup(this.myConfiguration.getProject(), this.myConfiguration.getName(), request).setupCommandLine(this.myConfiguration.mySettings).getCommandLine();
            if (targetedCommandLineBuilder == null) {
                MavenCommandLineState.$$$reportNull$$$0(18);
            }
            return targetedCommandLineBuilder;
        }

        public void handleCreatedTargetEnvironment(@NotNull TargetEnvironment environment, @NotNull TargetProgressIndicator targetProgressIndicator) {
            if (environment == null) {
                MavenCommandLineState.$$$reportNull$$$0(19);
            }
            if (targetProgressIndicator == null) {
                MavenCommandLineState.$$$reportNull$$$0(20);
            }
            if (environment instanceof LocalTargetEnvironment) {
                super.handleCreatedTargetEnvironment(environment, targetProgressIndicator);
            } else {
                TargetedCommandLineBuilder targetedCommandLineBuilder = this.getTargetedCommandLine();
                Objects.requireNonNull((MavenCommandLineSetup)targetedCommandLineBuilder.getUserData(MavenCommandLineSetup.getSetupKey())).provideEnvironment(environment, targetProgressIndicator);
            }
        }

        @NotNull
        protected OSProcessHandler startProcess() throws ExecutionException {
            ExecutionEnvironment environment = this.getEnvironment();
            TargetEnvironment remoteEnvironment = environment.getPreparedTargetEnvironment((RunProfileState)this, TargetProgressIndicator.EMPTY);
            TargetedCommandLineBuilder targetedCommandLineBuilder = this.getTargetedCommandLine();
            TargetedCommandLine targetedCommandLine = targetedCommandLineBuilder.build();
            Process process2 = remoteEnvironment.createProcess(targetedCommandLine, (ProgressIndicator)new EmptyProgressIndicator());
            KillableColoredProcessHandler.Silent handler = new KillableColoredProcessHandler.Silent(process2, targetedCommandLine.getCommandPresentation(remoteEnvironment), targetedCommandLine.getCharset(), targetedCommandLineBuilder.getFilesToDeleteOnTermination());
            ProcessTerminatedListener.attach((ProcessHandler)handler);
            JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.myConfiguration, (ProcessHandler)handler, this.getRunnerSettings());
            KillableColoredProcessHandler.Silent silent = handler;
            if (silent == null) {
                MavenCommandLineState.$$$reportNull$$$0(21);
            }
            return silent;
        }

        public RemoteConnectionCreator getRemoteConnectionCreator() {
            if (this.myRemoteConnectionCreator == null) {
                try {
                    this.myRemoteConnectionCreator = this.myConfiguration.createRemoteConnectionCreator(this.getJavaParameters());
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("Cannot create java parameters", e);
                }
            }
            return this.myRemoteConnectionCreator;
        }

        @Nullable
        public RemoteConnection createRemoteConnection(ExecutionEnvironment environment) {
            return this.getRemoteConnectionCreator().createRemoteConnection(environment);
        }

        public boolean isPollConnection() {
            return this.getRemoteConnectionCreator().isPollConnection();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 11: 
                case 12: 
                case 17: 
                case 18: 
                case 21: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 11: 
                case 12: 
                case 17: 
                case 18: 
                case 21: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 2: 
                case 4: 
                case 9: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runner";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetFileMapper";
                    break;
                }
                case 8: 
                case 11: 
                case 12: 
                case 17: 
                case 18: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration$MavenCommandLineState";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskId";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetProgressIndicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration$MavenCommandLineState";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStartBuildEventSupplier";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "execute";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTargetedCommandLine";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "startProcess";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doDelegateBuildExecute";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "doRunExecute";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getStartBuildEventSupplier";
                    break;
                }
                case 8: 
                case 11: 
                case 12: 
                case 17: 
                case 18: 
                case 21: {
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "createBuildView";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "createTargetedCommandLine";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "handleCreatedTargetEnvironment";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 11: 
                case 12: 
                case 17: 
                case 18: 
                case 21: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ExecRemoteConnectionCreator
    implements RemoteConnectionCreator {
        private static final Pattern EXEC_MAVEN_PLUGIN_PATTERN = Pattern.compile("org[.]codehaus[.]mojo:exec-maven-plugin(:[\\d.]+)?:exec");
        private final JavaParameters myJavaParameters;
        private final MavenRunConfiguration myRunConfiguration;

        ExecRemoteConnectionCreator(JavaParameters javaParameters, MavenRunConfiguration runConfiguration) {
            this.myJavaParameters = javaParameters;
            this.myRunConfiguration = runConfiguration;
        }

        @Nullable
        public RemoteConnection createRemoteConnection(ExecutionEnvironment environment) {
            RemoteConnection connection;
            ParametersList programParametersList = this.myJavaParameters.getProgramParametersList();
            boolean execGoal = programParametersList.getList().stream().anyMatch(parameter -> parameter.equals("exec:exec") || EXEC_MAVEN_PLUGIN_PATTERN.matcher((CharSequence)parameter).matches());
            if (!execGoal) {
                return null;
            }
            Project project2 = this.myRunConfiguration.getProject();
            MavenRunnerParameters runnerParameters = this.myRunConfiguration.getRunnerParameters();
            JavaParameters parameters = new JavaParameters();
            try {
                parameters.setJdk(JavaParametersUtil.createProjectJdk((Project)project2, null));
                connection = new RemoteConnectionBuilder(false, DebuggerSettings.getInstance().getTransport(), "").asyncAgent(true).project(environment.getProject()).create(parameters);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Cannot create debug connection", e);
            }
            String execArgsPrefix = "-Dexec.args=";
            int execArgsIndex = ContainerUtil.indexOf((List)programParametersList.getList(), s -> s.startsWith(execArgsPrefix));
            String execArgsStr = execArgsIndex != -1 ? programParametersList.get(execArgsIndex).substring(execArgsPrefix.length()) : ExecRemoteConnectionCreator.getExecArgsFromPomXml(project2, runnerParameters);
            ParametersList execArgs = new ParametersList();
            execArgs.addAll(MavenApplicationConfigurationExecutionEnvironmentProvider.patchVmParameters(parameters.getVMParametersList()));
            execArgs.addParametersString(execArgsStr);
            String classPath = FileUtil.toSystemDependentName((String)parameters.getClassPath().getPathsString());
            if (StringUtil.isNotEmpty((String)classPath)) {
                ExecRemoteConnectionCreator.appendToClassPath(execArgs, classPath);
            }
            String execArgsCommandLineArg = execArgsPrefix + execArgs.getParametersString();
            if (execArgsIndex != -1) {
                programParametersList.set(execArgsIndex, execArgsCommandLineArg);
            } else {
                programParametersList.add(execArgsCommandLineArg);
            }
            return connection;
        }

        public boolean isPollConnection() {
            return true;
        }

        private static String getExecArgsFromPomXml(Project project2, MavenRunnerParameters runnerParameters) {
            MavenDomProjectModel projectModel;
            String pomFileName;
            VirtualFile pomFile;
            VirtualFile workingDir = VfsUtil.findFileByIoFile((File)runnerParameters.getWorkingDirFile(), (boolean)false);
            if (workingDir != null && (pomFile = workingDir.findChild(pomFileName = StringUtil.defaultIfEmpty((String)runnerParameters.getPomFileName(), (String)"pom.xml"))) != null && (projectModel = MavenDomUtil.getMavenDomProjectModel(project2, pomFile)) != null) {
                return StringUtil.notNullize((String)MavenPropertyResolver.resolve("${exec.args}", projectModel));
            }
            return "";
        }

        private static void appendToClassPath(ParametersList execArgs, String classPath) {
            List execArgsList = execArgs.getList();
            int classPathIndex = execArgsList.indexOf("-classpath");
            if (classPathIndex == -1) {
                classPathIndex = execArgsList.indexOf("-cp");
            }
            if (classPathIndex == -1) {
                execArgs.prependAll(new String[]{"-classpath", "%classpath" + File.pathSeparator + classPath});
            } else if (classPathIndex + 1 == execArgsList.size()) {
                execArgs.add("%classpath" + File.pathSeparator + classPath);
            } else {
                String oldClassPath = execArgs.get(classPathIndex + 1);
                execArgs.set(classPathIndex + 1, oldClassPath + File.pathSeparator + classPath);
            }
        }
    }

    public static class MavenSettings
    implements Cloneable {
        public static final String TAG = "MavenSettings";
        @Nullable
        public MavenGeneralSettings myGeneralSettings;
        @Nullable
        public MavenRunnerSettings myRunnerSettings;
        @Nullable
        public MavenRunnerParameters myRunnerParameters;

        public MavenSettings() {
        }

        public MavenSettings(Project project2) {
            this(null, null, new MavenRunnerParameters());
        }

        private MavenSettings(@Nullable MavenGeneralSettings cs, @Nullable MavenRunnerSettings rs, MavenRunnerParameters rp) {
            this.myGeneralSettings = cs == null ? null : cs.clone();
            this.myRunnerSettings = rs == null ? null : rs.clone();
            this.myRunnerParameters = rp.clone();
        }

        protected MavenSettings clone() {
            return new MavenSettings(this.myGeneralSettings, this.myRunnerSettings, this.myRunnerParameters);
        }
    }
}

