/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.model.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.dom.model.completion.MavenCoordinateCompletionContributor;
import org.jetbrains.idea.maven.dom.model.completion.insert.MavenTopLevelDependencyInsertionHandler;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.reposearch.DependencySearchService;
import org.jetbrains.idea.reposearch.RepositoryArtifactData;
import org.jetbrains.idea.reposearch.SearchParameters;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J4\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/idea/maven/dom/model/completion/MavenTopLevelCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "myName", "", "(Ljava/lang/String;)V", "getMyName", "()Ljava/lang/String;", "createSearchParameters", "Lorg/jetbrains/idea/reposearch/SearchParameters;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "fillCompletionVariants", "", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "find", "Lorg/jetbrains/concurrency/Promise;", "", "project", "Lcom/intellij/openapi/project/Project;", "text", "cld", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lorg/jetbrains/idea/maven/onlinecompletion/model/MavenRepositoryArtifactInfo;", "intellij.maven"})
public abstract class MavenTopLevelCompletionContributor
extends CompletionContributor {
    @NotNull
    private final String myName;

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parameters.getPosition()");
        PsiElement element = psiElement;
        PsiElement psiElement2 = element.getParent();
        if (!(psiElement2 instanceof XmlText)) {
            psiElement2 = null;
        }
        XmlText xmlText = (XmlText)psiElement2;
        if (xmlText == null) {
            return;
        }
        XmlText xmlText2 = xmlText;
        PsiElement parent = xmlText2.getParent();
        if (!(parent instanceof XmlTag) || Intrinsics.areEqual((Object)((XmlTag)parent).getName(), (Object)this.myName) ^ true) {
            return;
        }
        result.restartCompletionWhenNothingMatches();
        ConcurrentLinkedDeque<MavenRepositoryArtifactInfo> cld = new ConcurrentLinkedDeque<MavenRepositoryArtifactInfo>();
        Project project2 = xmlText2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"xmlText.project");
        String string = MavenCoordinateCompletionContributor.trimDummy(xmlText2.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimDummy(xmlText.value)");
        Promise<Integer> promise = this.find(project2, string, parameters, cld);
        while (promise.getState() == Promise.State.PENDING || !cld.isEmpty()) {
            ProgressManager.checkCanceled();
            MavenRepositoryArtifactInfo item = cld.poll();
            if (item == null) continue;
            result.addElement((LookupElement)MavenDependencyCompletionUtil.lookupElement(item).withInsertHandler(MavenTopLevelDependencyInsertionHandler.INSTANCE));
        }
    }

    @NotNull
    protected final Promise<Integer> find(@NotNull Project project2, @NotNull String text, @NotNull CompletionParameters parameters, @NotNull ConcurrentLinkedDeque<MavenRepositoryArtifactInfo> cld) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(cld, (String)"cld");
        SearchParameters searchParameters = this.createSearchParameters(parameters);
        String string = MavenCoordinateCompletionContributor.trimDummy(text);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimDummy(text)");
        String searchString = string;
        DependencySearchService service = DependencySearchService.Companion.getInstance(project2);
        List splitted = StringsKt.split$default((CharSequence)searchString, (char[])new char[]{':'}, (boolean)false, (int)0, (int)6, null);
        if (splitted.size() < 2) {
            return service.fulltextSearch(searchString, searchParameters, (Function1)new Function1<RepositoryArtifactData, Unit>(cld){
                final /* synthetic */ ConcurrentLinkedDeque $cld;

                public final void invoke(@NotNull RepositoryArtifactData it) {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        RepositoryArtifactData repositoryArtifactData = it;
                        if (!(repositoryArtifactData instanceof MavenRepositoryArtifactInfo)) {
                            repositoryArtifactData = null;
                        }
                        MavenRepositoryArtifactInfo mavenRepositoryArtifactInfo = (MavenRepositoryArtifactInfo)repositoryArtifactData;
                        if (mavenRepositoryArtifactInfo == null) break block1;
                        MavenRepositoryArtifactInfo mavenRepositoryArtifactInfo2 = mavenRepositoryArtifactInfo;
                        boolean bl = false;
                        boolean bl2 = false;
                        MavenRepositoryArtifactInfo it2 = mavenRepositoryArtifactInfo2;
                        boolean bl3 = false;
                        this.$cld.add(it2);
                    }
                }
                {
                    this.$cld = concurrentLinkedDeque;
                    super(1);
                }
            });
        }
        return service.suggestPrefix((String)splitted.get(0), (String)splitted.get(1), searchParameters, (Function1)new Function1<RepositoryArtifactData, Unit>(cld){
            final /* synthetic */ ConcurrentLinkedDeque $cld;

            public final void invoke(@NotNull RepositoryArtifactData it) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    RepositoryArtifactData repositoryArtifactData = it;
                    if (!(repositoryArtifactData instanceof MavenRepositoryArtifactInfo)) {
                        repositoryArtifactData = null;
                    }
                    MavenRepositoryArtifactInfo mavenRepositoryArtifactInfo = (MavenRepositoryArtifactInfo)repositoryArtifactData;
                    if (mavenRepositoryArtifactInfo == null) break block1;
                    MavenRepositoryArtifactInfo mavenRepositoryArtifactInfo2 = mavenRepositoryArtifactInfo;
                    boolean bl = false;
                    boolean bl2 = false;
                    MavenRepositoryArtifactInfo it2 = mavenRepositoryArtifactInfo2;
                    boolean bl3 = false;
                    this.$cld.add(it2);
                }
            }
            {
                this.$cld = concurrentLinkedDeque;
                super(1);
            }
        });
    }

    @NotNull
    protected final SearchParameters createSearchParameters(@NotNull CompletionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        boolean bl = parameters.getInvocationCount() < 2;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        return new SearchParameters(bl, application.isUnitTestMode());
    }

    @NotNull
    public final String getMyName() {
        return this.myName;
    }

    public MavenTopLevelCompletionContributor(@NotNull String myName) {
        Intrinsics.checkNotNullParameter((Object)myName, (String)"myName");
        this.myName = myName;
    }
}

