/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.model.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates;
import org.jetbrains.idea.maven.dom.model.completion.MavenAbstractPluginExtensionCompletionContributor;
import org.jetbrains.idea.maven.dom.model.completion.MavenCoordinateCompletionContributor;
import org.jetbrains.idea.maven.dom.model.completion.insert.MavenArtifactIdInsertionHandler;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.reposearch.DependencySearchService;
import org.jetbrains.idea.reposearch.RepositoryArtifactData;
import org.jetbrains.idea.reposearch.SearchParameters;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J4\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0014\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/idea/maven/dom/model/completion/MavenArtifactIdCompletionContributor;", "Lorg/jetbrains/idea/maven/dom/model/completion/MavenCoordinateCompletionContributor;", "()V", "fillResults", "", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "coordinates", "Lorg/jetbrains/idea/maven/dom/model/MavenDomShortArtifactCoordinates;", "cld", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lorg/jetbrains/idea/reposearch/RepositoryArtifactData;", "promise", "Lorg/jetbrains/concurrency/Promise;", "", "find", "service", "Lorg/jetbrains/idea/reposearch/DependencySearchService;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "consumer", "Ljava/util/function/Consumer;", "validate", "", "groupId", "", "artifactId", "intellij.maven"})
public final class MavenArtifactIdCompletionContributor
extends MavenCoordinateCompletionContributor {
    @Override
    protected boolean validate(@NotNull String groupId, @NotNull String artifactId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        return true;
    }

    @Override
    @NotNull
    protected Promise<Integer> find(@NotNull DependencySearchService service, @NotNull MavenDomShortArtifactCoordinates coordinates, @NotNull CompletionParameters parameters, @NotNull Consumer<RepositoryArtifactData> consumer) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        SearchParameters searchParameters = this.createSearchParameters(parameters);
        GenericDomValue<String> genericDomValue = coordinates.getGroupId();
        Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"coordinates.groupId");
        String string = MavenCoordinateCompletionContributor.trimDummy(genericDomValue.getStringValue());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimDummy(coordinates.groupId.stringValue)");
        String groupId = string;
        GenericDomValue<String> genericDomValue2 = coordinates.getArtifactId();
        Intrinsics.checkNotNullExpressionValue(genericDomValue2, (String)"coordinates.artifactId");
        String string2 = MavenCoordinateCompletionContributor.trimDummy(genericDomValue2.getStringValue());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"trimDummy(coordinates.artifactId.stringValue)");
        String artifactId = string2;
        if (MavenAbstractPluginExtensionCompletionContributor.Companion.isPluginOrExtension(coordinates) && StringUtil.isEmpty((String)groupId)) {
            SearchParameters searchParameters2 = searchParameters;
            Intrinsics.checkNotNullExpressionValue((Object)searchParameters2, (String)"searchParameters");
            return (Promise)MavenAbstractPluginExtensionCompletionContributor.Companion.findPluginByArtifactId(service, artifactId, searchParameters2, consumer);
        }
        SearchParameters searchParameters3 = searchParameters;
        Intrinsics.checkNotNullExpressionValue((Object)searchParameters3, (String)"searchParameters");
        Consumer<RepositoryArtifactData> consumer2 = MavenCoordinateCompletionContributor.withPredicate(consumer, new Predicate(groupId){
            final /* synthetic */ String $groupId;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean test(RepositoryArtifactData it) {
                if (!(it instanceof MavenRepositoryArtifactInfo)) return false;
                CharSequence charSequence = this.$groupId;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    return true;
                }
                boolean bl2 = false;
                if (bl2) return true;
                if (!Intrinsics.areEqual((Object)this.$groupId, (Object)((MavenRepositoryArtifactInfo)it).getGroupId())) return false;
                return true;
            }
            {
                this.$groupId = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue(consumer2, (String)"withPredicate(consumer,\n\u2026groupId == it.groupId) })");
        return service.suggestPrefix(groupId, artifactId, searchParameters3, consumer2);
    }

    @Override
    protected void fillResults(@NotNull CompletionResultSet result, @NotNull MavenDomShortArtifactCoordinates coordinates, @NotNull ConcurrentLinkedDeque<RepositoryArtifactData> cld, @NotNull Promise<Integer> promise) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter(cld, (String)"cld");
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        HashSet<String> set = new HashSet<String>();
        while (promise.getState() == Promise.State.PENDING || !cld.isEmpty()) {
            ProgressManager.checkCanceled();
            RepositoryArtifactData item = cld.poll();
            if (!(item instanceof MavenRepositoryArtifactInfo) || !set.add(((MavenRepositoryArtifactInfo)item).getArtifactId())) continue;
            result.addElement((LookupElement)MavenDependencyCompletionUtil.lookupElement((MavenRepositoryArtifactInfo)item, ((MavenRepositoryArtifactInfo)item).getArtifactId()).withInsertHandler(MavenArtifactIdInsertionHandler.INSTANCE));
        }
    }

    public MavenArtifactIdCompletionContributor() {
        super("artifactId");
    }
}

