/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.annotator;

import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import icons.MavenIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencyManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenProject;

public class MavenDomGutterAnnotator
implements Annotator {
    private static void annotateDependencyUsages(@NotNull MavenDomDependency dependency, AnnotationHolder holder) {
        XmlTag tag;
        if (dependency == null) {
            MavenDomGutterAnnotator.$$$reportNull$$$0(0);
        }
        if ((tag = dependency.getXmlTag()) == null) {
            return;
        }
        Set<MavenDomDependency> children = MavenDomProjectProcessorUtils.searchDependencyUsages(dependency);
        if (children.size() > 0) {
            NavigationGutterIconBuilder iconBuilder = NavigationGutterIconBuilder.create((Icon)AllIcons.General.OverridenMethod, (NotNullFunction)DependencyConverter.INSTANCE);
            iconBuilder.setTargets(children).setPopupTitle(MavenDomBundle.message("navigate.parent.dependency.title", new Object[0])).setCellRenderer((PsiElementListCellRenderer)MyListCellRenderer.INSTANCE).setTooltipText(MavenDomBundle.message("overriding.dependency.title", new Object[0])).createGutterIcon(holder, (PsiElement)dependency.getXmlTag());
        }
    }

    private static void annotateManagedDependency(MavenDomDependency dependency, AnnotationHolder holder) {
        XmlTag tag = dependency.getXmlTag();
        if (tag == null) {
            return;
        }
        MavenDomDependency managingDependency = MavenDomGutterAnnotator.getManagingDependency(dependency);
        if (managingDependency != null) {
            NavigationGutterIconBuilder iconBuilder = NavigationGutterIconBuilder.create((Icon)AllIcons.General.OverridingMethod, (NotNullFunction)DependencyConverter.INSTANCE);
            iconBuilder.setTargets((Object[])new MavenDomDependency[]{managingDependency}).setTooltipText(MavenDomGutterAnnotator.generateTooltip(managingDependency)).createGutterIcon(holder, (PsiElement)tag);
        }
    }

    @Nullable
    private static MavenDomDependency getManagingDependency(@NotNull MavenDomDependency dependency) {
        if (dependency == null) {
            MavenDomGutterAnnotator.$$$reportNull$$$0(1);
        }
        Project project2 = dependency.getManager().getProject();
        return MavenDomProjectProcessorUtils.searchManagingDependency(dependency, project2);
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            MavenDomGutterAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            MavenDomGutterAnnotator.$$$reportNull$$$0(3);
        }
        if (psiElement instanceof XmlTag) {
            DomElement element = DomManager.getDomManager((Project)psiElement.getProject()).getDomElement((XmlTag)psiElement);
            if (element instanceof MavenDomDependency) {
                if (element.getParentOfType(MavenDomPlugin.class, true) != null) {
                    return;
                }
                MavenDomDependency dependency = (MavenDomDependency)element;
                if (MavenDomGutterAnnotator.isDependencyManagementSection(dependency)) {
                    MavenDomGutterAnnotator.annotateDependencyUsages(dependency, holder);
                } else {
                    MavenDomGutterAnnotator.annotateManagedDependency(dependency, holder);
                }
            } else if (element instanceof MavenDomParent) {
                MavenDomGutterAnnotator.annotateMavenDomParent((MavenDomParent)element, holder);
            } else if (element instanceof MavenDomProjectModel) {
                MavenDomGutterAnnotator.annotateMavenDomProjectChildren((MavenDomProjectModel)element, holder);
            } else if (element instanceof MavenDomPlugin) {
                MavenDomGutterAnnotator.annotateMavenDomPlugin((MavenDomPlugin)element, holder);
            }
        }
    }

    private static void annotateMavenDomPlugin(@NotNull MavenDomPlugin plugin, @NotNull AnnotationHolder holder) {
        XmlTag xmlTag;
        if (plugin == null) {
            MavenDomGutterAnnotator.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            MavenDomGutterAnnotator.$$$reportNull$$$0(5);
        }
        if ((xmlTag = plugin.getArtifactId().getXmlTag()) == null) {
            return;
        }
        DomElement plugins = plugin.getParent();
        if (plugins == null) {
            return;
        }
        DomElement parent = plugins.getParent();
        if (parent instanceof MavenDomPluginManagement) {
            MavenDomGutterAnnotator.annotateMavenDomPluginInManagement(plugin, holder);
            return;
        }
        MavenDomPlugin managingPlugin = MavenDomProjectProcessorUtils.searchManagingPlugin(plugin);
        if (managingPlugin != null) {
            NavigationGutterIconBuilder iconBuilder = NavigationGutterIconBuilder.create((Icon)AllIcons.General.OverridingMethod, (NotNullFunction)PluginConverter.INSTANCE);
            iconBuilder.setTargets(Collections.singletonList(managingPlugin)).setTooltipText(MavenDomBundle.message("overriden.plugin.title", new Object[0])).createGutterIcon(holder, (PsiElement)xmlTag);
        }
    }

    private static void annotateMavenDomPluginInManagement(@NotNull MavenDomPlugin plugin, @NotNull AnnotationHolder holder) {
        XmlTag xmlTag;
        if (plugin == null) {
            MavenDomGutterAnnotator.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            MavenDomGutterAnnotator.$$$reportNull$$$0(7);
        }
        if ((xmlTag = plugin.getArtifactId().getXmlTag()) == null) {
            return;
        }
        Collection<MavenDomPlugin> children = MavenDomProjectProcessorUtils.searchManagedPluginUsages(plugin);
        if (children.size() > 0) {
            NavigationGutterIconBuilder iconBuilder = NavigationGutterIconBuilder.create((Icon)AllIcons.General.OverridenMethod, (NotNullFunction)PluginConverter.INSTANCE);
            iconBuilder.setTargets(children).setPopupTitle(MavenDomBundle.message("navigate.parent.plugin.title", new Object[0])).setCellRenderer((PsiElementListCellRenderer)MyListCellRenderer.INSTANCE).setTooltipText(MavenDomBundle.message("overriding.plugin.title", new Object[0])).createGutterIcon(holder, (PsiElement)xmlTag);
        }
    }

    private static void annotateMavenDomParent(@NotNull MavenDomParent mavenDomParent, @NotNull AnnotationHolder holder) {
        MavenDomProjectModel parent;
        if (mavenDomParent == null) {
            MavenDomGutterAnnotator.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            MavenDomGutterAnnotator.$$$reportNull$$$0(9);
        }
        if ((parent = MavenDomProjectProcessorUtils.findParent(mavenDomParent, mavenDomParent.getManager().getProject())) != null) {
            NavigationGutterIconBuilder.create((Icon)MavenIcons.ParentProject, (NotNullFunction)MavenProjectConverter.INSTANCE).setTargets((Object[])new MavenDomProjectModel[]{parent}).setTooltipText(MavenDomBundle.message("parent.pom.title", new Object[0])).createGutterIcon(holder, (PsiElement)mavenDomParent.getXmlElement());
        }
    }

    private static void annotateMavenDomProjectChildren(MavenDomProjectModel model2, AnnotationHolder holder) {
        Set<MavenDomProjectModel> children;
        MavenProject mavenProject = MavenDomUtil.findProject(model2);
        if (mavenProject != null && (children = MavenDomProjectProcessorUtils.getChildrenProjects(model2)).size() > 0) {
            NavigationGutterIconBuilder.create((Icon)MavenIcons.ChildrenProjects, (NotNullFunction)MavenProjectConverter.INSTANCE).setTargets(children).setCellRenderer((PsiElementListCellRenderer)MyListCellRenderer.INSTANCE).setPopupTitle(MavenDomBundle.message("navigate.children.poms.title", new Object[0])).setTooltipText(MavenDomBundle.message("children.poms.title", new Object[0])).createGutterIcon(holder, (PsiElement)model2.getXmlElement());
        }
    }

    private static boolean isDependencyManagementSection(@NotNull MavenDomDependency dependency) {
        if (dependency == null) {
            MavenDomGutterAnnotator.$$$reportNull$$$0(10);
        }
        return dependency.getParentOfType(MavenDomDependencyManagement.class, false) != null;
    }

    @NlsContexts.DetailedDescription
    private static String generateTooltip(MavenDomDependency dependency) {
        StringBuilder res = new StringBuilder();
        res.append("<dependency>\n");
        res.append("    <groupId>").append(dependency.getGroupId().getStringValue()).append("</groupId>\n");
        res.append("    <artifactId>").append(dependency.getArtifactId().getStringValue()).append("</artifactId>\n");
        if (dependency.getType().getXmlElement() != null) {
            res.append("    <type>").append(dependency.getType().getStringValue()).append("</type>\n");
        }
        if (dependency.getClassifier().getXmlElement() != null) {
            res.append("    <classifier>").append(dependency.getClassifier().getStringValue()).append("</classifier>\n");
        }
        if (dependency.getScope().getXmlElement() != null) {
            res.append("    <scope>").append(dependency.getScope().getStringValue()).append("</scope>\n");
        }
        if (dependency.getOptional().getXmlElement() != null) {
            res.append("    <optional>").append(dependency.getOptional().getStringValue()).append("</optional>\n");
        }
        if (dependency.getVersion().getXmlElement() != null) {
            res.append("    <version>").append(dependency.getVersion().getStringValue()).append("</version>\n");
        }
        res.append("</dependency>");
        return StringUtil.escapeXmlEntities((String)res.toString()).replace(" ", "&nbsp;");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenDomParent";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateDependencyUsages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getManagingDependency";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateMavenDomPlugin";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateMavenDomPluginInManagement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateMavenDomParent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isDependencyManagementSection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MavenProjectConverter
    implements NotNullFunction<MavenDomProjectModel, Collection<? extends PsiElement>> {
        public static final MavenProjectConverter INSTANCE = new MavenProjectConverter();

        private MavenProjectConverter() {
        }

        @NotNull
        public Collection<? extends PsiElement> fun(MavenDomProjectModel pointer) {
            List list = ContainerUtil.createMaybeSingletonList((Object)pointer.getXmlTag());
            if (list == null) {
                MavenProjectConverter.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator$MavenProjectConverter", "fun"));
        }
    }

    private static class PluginConverter
    implements NotNullFunction<MavenDomPlugin, Collection<? extends PsiElement>> {
        public static final PluginConverter INSTANCE = new PluginConverter();

        private PluginConverter() {
        }

        @NotNull
        public Collection<? extends PsiElement> fun(MavenDomPlugin pointer) {
            List list = ContainerUtil.createMaybeSingletonList((Object)pointer.getXmlTag());
            if (list == null) {
                PluginConverter.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator$PluginConverter", "fun"));
        }
    }

    private static class DependencyConverter
    implements NotNullFunction<MavenDomDependency, Collection<? extends PsiElement>> {
        public static final DependencyConverter INSTANCE = new DependencyConverter();

        private DependencyConverter() {
        }

        @NotNull
        public Collection<? extends PsiElement> fun(MavenDomDependency pointer) {
            List list = ContainerUtil.createMaybeSingletonList((Object)pointer.getXmlTag());
            if (list == null) {
                DependencyConverter.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator$DependencyConverter", "fun"));
        }
    }

    private static class MyListCellRenderer
    extends PsiElementListCellRenderer<XmlTag> {
        public static final MyListCellRenderer INSTANCE = new MyListCellRenderer();

        private MyListCellRenderer() {
        }

        public String getElementText(XmlTag tag) {
            MavenDomProjectModel model2;
            DomElement domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
            if (domElement != null && (model2 = (MavenDomProjectModel)domElement.getParentOfType(MavenDomProjectModel.class, false)) != null) {
                MavenProject mavenProject = MavenDomUtil.findProject(model2);
                if (mavenProject != null) {
                    return mavenProject.getDisplayName();
                }
                String name = model2.getName().getStringValue();
                if (!StringUtil.isEmptyOrSpaces((String)name)) {
                    return name;
                }
            }
            return tag.getContainingFile().getName();
        }

        protected String getContainerText(XmlTag element, String name) {
            return null;
        }

        protected Icon getIcon(PsiElement element) {
            return MavenIcons.MavenProject;
        }
    }
}

