/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;

@Service(value={Service.Level.PROJECT})
public final class MavenDomElementDescriptorHolder {
    private static final Logger LOG = Logger.getInstance(MavenDomElementDescriptorHolder.class);
    private final Project myProject;
    private final Map<FileKind, CachedValue<XmlNSDescriptorImpl>> myDescriptorsMap = new HashMap<FileKind, CachedValue<XmlNSDescriptorImpl>>();

    public MavenDomElementDescriptorHolder(Project project2) {
        this.myProject = project2;
    }

    public static MavenDomElementDescriptorHolder getInstance(@NotNull Project project2) {
        if (project2 == null) {
            MavenDomElementDescriptorHolder.$$$reportNull$$$0(0);
        }
        return (MavenDomElementDescriptorHolder)project2.getService(MavenDomElementDescriptorHolder.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public XmlElementDescriptor getDescriptor(@NotNull XmlTag tag) {
        XmlNSDescriptorImpl desc;
        FileKind kind;
        if (tag == null) {
            MavenDomElementDescriptorHolder.$$$reportNull$$$0(1);
        }
        if ((kind = MavenDomElementDescriptorHolder.getFileKind(tag.getContainingFile())) == null) {
            return null;
        }
        MavenDomElementDescriptorHolder mavenDomElementDescriptorHolder = this;
        synchronized (mavenDomElementDescriptorHolder) {
            desc = this.tryGetOrCreateDescriptor(kind);
            if (desc == null) {
                return null;
            }
        }
        LOG.assertTrue(tag.isValid());
        LOG.assertTrue(desc.isValid());
        return desc.getElementDescriptor(tag.getName(), desc.getDefaultNamespace());
    }

    @Nullable
    private XmlNSDescriptorImpl tryGetOrCreateDescriptor(FileKind kind) {
        CachedValue result = this.myDescriptorsMap.get((Object)kind);
        if (result == null) {
            result = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> CachedValueProvider.Result.create((Object)this.doCreateDescriptor(kind), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
            this.myDescriptorsMap.put(kind, (CachedValue<XmlNSDescriptorImpl>)result);
        }
        return (XmlNSDescriptorImpl)result.getValue();
    }

    @Nullable
    private XmlNSDescriptorImpl doCreateDescriptor(FileKind kind) {
        VirtualFile schema;
        String location;
        String schemaUrl = kind.getSchemaUrl();
        if (schemaUrl.equals(location = ExternalResourceManager.getInstance().getResourceLocation(schemaUrl))) {
            return null;
        }
        try {
            schema = VfsUtil.findFileByURL((URL)new URL(location));
        }
        catch (MalformedURLException ignore) {
            return null;
        }
        if (schema == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(schema);
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        XmlNSDescriptorImpl result = new XmlNSDescriptorImpl();
        result.init((PsiElement)psiFile);
        return result;
    }

    @Nullable
    private static FileKind getFileKind(PsiFile file) {
        if (MavenDomUtil.isProjectFile(file)) {
            return FileKind.PROJECT_FILE;
        }
        if (MavenDomUtil.isProfilesFile(file)) {
            return FileKind.PROFILES_FILE;
        }
        if (MavenDomUtil.isSettingsFile(file)) {
            return FileKind.SETTINGS_FILE;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/dom/MavenDomElementDescriptorHolder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDescriptor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum FileKind {
        PROJECT_FILE{

            @Override
            public String getSchemaUrl() {
                return "http://maven.apache.org/xsd/maven-4.0.0.xsd";
            }
        }
        ,
        PROFILES_FILE{

            @Override
            public String getSchemaUrl() {
                return "http://maven.apache.org/xsd/profiles-1.0.0.xsd";
            }
        }
        ,
        SETTINGS_FILE{

            @Override
            public String getSchemaUrl() {
                return "http://maven.apache.org/xsd/settings-1.0.0.xsd";
            }
        };


        public abstract String getSchemaUrl();
    }
}

