/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.config;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/maven/config/MavenConfigAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "isConfigFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.maven"})
public final class MavenConfigAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (element instanceof PsiPlainTextFileImpl) {
            Object v7;
            block6: {
                MavenProjectsManager manager;
                PsiFile psiFile = ((PsiPlainTextFileImpl)element).getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"element.containingFile");
                VirtualFile elementFile = psiFile.getVirtualFile();
                if (!this.isConfigFile(elementFile)) {
                    return;
                }
                MavenProjectsManager mavenProjectsManager = manager = MavenProjectsManager.getInstance(element.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"manager");
                if (!mavenProjectsManager.isMavenizedProject()) {
                    return;
                }
                List<MavenProject> list = manager.getRootProjects();
                Intrinsics.checkNotNullExpressionValue(list, (String)"manager.getRootProjects()");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    MavenProject it = (MavenProject)element$iv;
                    boolean bl = false;
                    MavenProject mavenProject = it;
                    Intrinsics.checkNotNullExpressionValue((Object)mavenProject, (String)"it");
                    VirtualFile virtualFile = mavenProject.getDirectoryFile();
                    VirtualFile virtualFile2 = elementFile;
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"elementFile");
                    VirtualFile virtualFile3 = virtualFile2.getParent();
                    if (!Intrinsics.areEqual((Object)virtualFile, (Object)(virtualFile3 != null ? virtualFile3.getParent() : null))) continue;
                    v7 = element$iv;
                    break block6;
                }
                v7 = null;
            }
            MavenProject mavenProject = v7;
            if (mavenProject == null) {
                return;
            }
            MavenProject mavenProject2 = mavenProject;
            String string = mavenProject2.getConfigFileError();
            if (string == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mavenProject.configFileError ?: return");
            String error = string;
            holder.newAnnotation(HighlightSeverity.ERROR, error).create();
        }
    }

    private final boolean isConfigFile(VirtualFile file) {
        VirtualFile virtualFile = file;
        if (virtualFile == null || (virtualFile = virtualFile.getParent()) == null) {
            return false;
        }
        VirtualFile parent = virtualFile;
        return Intrinsics.areEqual((Object)file.getName(), (Object)"maven.config") && Intrinsics.areEqual((Object)parent.getName(), (Object)".mvn");
    }
}

