/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.buildtool;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.output.BuildOutputInstantReaderImpl;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Collections;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.MavenProgressListener;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLogOutputParser;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenOutputParserProvider;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenParsingContext;

@ApiStatus.Experimental
public class MavenBuildEventProcessor
implements AnsiEscapeDecoder.ColoredTextAcceptor {
    @NotNull
    private final BuildProgressListener myBuildProgressListener;
    @NotNull
    private final Project myProject;
    @NotNull
    private final BuildOutputInstantReaderImpl myInstantReader;
    @NotNull
    private final ExternalSystemTaskId myTaskId;
    @NotNull
    private final String myWorkingDir;
    @NotNull
    private final MavenLogOutputParser myParser;
    private boolean closed;
    private final BuildDescriptor myDescriptor;
    @NotNull
    private final Function<MavenParsingContext, StartBuildEvent> myStartBuildEventSupplier;

    public MavenBuildEventProcessor(@NotNull Project project2, @NotNull String workingDir, @NotNull BuildProgressListener buildProgressListener, @NotNull BuildDescriptor descriptor2, @NotNull ExternalSystemTaskId taskId, @NotNull Function<String, String> targetFileMapper, @Nullable Function<MavenParsingContext, StartBuildEvent> startBuildEventSupplier) {
        if (project2 == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(0);
        }
        if (workingDir == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(1);
        }
        if (buildProgressListener == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(3);
        }
        if (taskId == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(4);
        }
        if (targetFileMapper == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(5);
        }
        this.closed = false;
        this.myBuildProgressListener = buildProgressListener;
        this.myProject = project2;
        this.myTaskId = taskId;
        this.myWorkingDir = workingDir;
        this.myDescriptor = descriptor2;
        this.myStartBuildEventSupplier = startBuildEventSupplier != null ? startBuildEventSupplier : ctx -> new StartBuildEventImpl(this.myDescriptor, "");
        this.myParser = MavenOutputParserProvider.createMavenOutputParser(project2, this.myTaskId, targetFileMapper);
        this.myInstantReader = new BuildOutputInstantReaderImpl((Object)this.myTaskId, (Object)this.myTaskId, MavenBuildEventProcessor.wrapListener(project2, this.myBuildProgressListener, this.myWorkingDir), Collections.singletonList(this.myParser));
    }

    private static BuildProgressListener wrapListener(@NotNull Project project2, @NotNull BuildProgressListener listener2, @NotNull String workingDir) {
        if (project2 == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(6);
        }
        if (listener2 == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(7);
        }
        if (workingDir == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(8);
        }
        return new MavenProgressListener(project2, listener2, workingDir);
    }

    public synchronized void finish() {
        this.myParser.finish(e -> this.myBuildProgressListener.onEvent(this.myDescriptor.getId(), e));
        this.myInstantReader.close();
        this.closed = true;
    }

    public void start() {
        StartBuildEvent startEvent = this.myStartBuildEventSupplier.apply(this.getParsingContext());
        this.myBuildProgressListener.onEvent(this.myDescriptor.getId(), (BuildEvent)startEvent);
    }

    public synchronized void onTextAvailable(String text, boolean stdError) {
        if (!this.closed) {
            this.myInstantReader.append((CharSequence)text);
        }
    }

    public MavenParsingContext getParsingContext() {
        return this.myParser.getParsingContext();
    }

    public void coloredTextAvailable(@NotNull String text, @NotNull Key outputType) {
        if (text == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(9);
        }
        if (outputType == null) {
            MavenBuildEventProcessor.$$$reportNull$$$0(10);
        }
        this.onTextAvailable(text, ProcessOutputType.isStderr((Key)outputType));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildProgressListener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFileMapper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/buildtool/MavenBuildEventProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapListener";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "coloredTextAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

