/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.ui.FinderRecursivePanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringModulesPanelBase
extends FinderRecursivePanel<Module> {
    protected SpringModulesPanelBase(Project project, String groupId) {
        super(project, groupId);
    }

    @NotNull
    public List<Module> getListItems() {
        Module[] modules;
        boolean autoConfigurationMode = SpringGeneralSettings.getInstance(this.getProject()).isAllowAutoConfigurationMode();
        if (!SpringCommonUtils.hasSpringFacets(this.getProject()) && !autoConfigurationMode) {
            List<Module> list = Collections.emptyList();
            if (list == null) {
                SpringModulesPanelBase.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<Module> items = new ArrayList<Module>();
        for (Module module : modules = ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            if (!autoConfigurationMode && !SpringCommonUtils.hasSpringFacet(module)) continue;
            items.add(module);
        }
        items.sort((Comparator<Module>)ModulesAlphaComparator.INSTANCE);
        ArrayList<Module> arrayList = items;
        if (arrayList == null) {
            SpringModulesPanelBase.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public String getItemText(@NotNull Module module) {
        if (module == null) {
            SpringModulesPanelBase.$$$reportNull$$$0(2);
        }
        String string = module.getName();
        if (string == null) {
            SpringModulesPanelBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public Icon getItemIcon(@NotNull Module module) {
        if (module == null) {
            SpringModulesPanelBase.$$$reportNull$$$0(4);
        }
        return module.isDisposed() ? null : ModuleType.get((Module)module).getIcon();
    }

    public boolean performEditAction() {
        Module module = (Module)this.getSelectedValue();
        if (module != null) {
            ModulesConfigurator.showDialog((Project)this.getProject(), (String)module.getName(), null);
        }
        return true;
    }

    public boolean hasChildren(@NotNull Module module) {
        if (module == null) {
            SpringModulesPanelBase.$$$reportNull$$$0(5);
        }
        if (module.isDisposed()) {
            return false;
        }
        if (DumbService.isDumb((Project)this.getProject())) {
            return false;
        }
        SpringFacet springFacet = SpringFacet.getInstance(module);
        if (springFacet == null) {
            return false;
        }
        return !SpringFileSetService.getInstance().getAllSets(springFacet).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/toolWindow/SpringModulesPanelBase";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/toolWindow/SpringModulesPanelBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getItemText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getItemIcon";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

