/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow;

import com.intellij.ProjectTopics;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.toolWindow.SpringToolWindowContent;
import com.intellij.spring.toolWindow.SpringToolWindowContentUpdater;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBaseView
extends SimpleToolWindowPanel
implements Disposable {
    protected final Project myProject;
    protected FinderRecursivePanel<?> myRootPanel;

    protected SpringBaseView(Project project) {
        super(false, true);
        this.myProject = project;
        this.refreshContentPanel();
    }

    protected abstract FinderRecursivePanel<?> createRootPanel();

    private void refreshContentPanel() {
        this.myRootPanel = this.createRootPanel();
        this.myRootPanel.initPanel();
        this.setContent((JComponent)this.myRootPanel);
        Disposer.register((Disposable)this, this.myRootPanel);
    }

    protected void performFullUpdate() {
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this)).submit(() -> {
            FinderRecursivePanel<?> oldPanel = this.myRootPanel;
            this.remove((Component)oldPanel);
            Disposer.dispose(oldPanel);
            this.refreshContentPanel();
        });
    }

    protected void performDetailsUpdate() {
        FinderRecursivePanel panel2 = this.myRootPanel;
        while (true) {
            if (!(panel2.getSecondComponent() instanceof FinderRecursivePanel)) break;
            panel2 = (FinderRecursivePanel)panel2.getSecondComponent();
        }
        panel2.updateRightComponent(true);
    }

    private void updateSelectedPath(Object ... pathToSelect) {
        this.myRootPanel.updateSelectedPath(pathToSelect);
    }

    protected MessageBusConnection installProjectModuleListener() {
        ProjectWideFacetAdapter<SpringFacet> myProjectWideFacetAdapter = new ProjectWideFacetAdapter<SpringFacet>(){

            public void facetAdded(@NotNull SpringFacet facet) {
                if (facet == null) {
                    1.$$$reportNull$$$0(0);
                }
                SpringBaseView.this.performFullUpdate();
            }

            public void facetRemoved(@NotNull SpringFacet facet) {
                if (facet == null) {
                    1.$$$reportNull$$$0(1);
                }
                SpringBaseView.this.performFullUpdate();
            }

            public void facetConfigurationChanged(@NotNull SpringFacet facet) {
                if (facet == null) {
                    1.$$$reportNull$$$0(2);
                }
                SpringBaseView.this.performFullUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "facet";
                objectArray2[1] = "com/intellij/spring/toolWindow/SpringBaseView$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetConfigurationChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ProjectWideFacetListenersRegistry.getInstance((Project)this.myProject).registerListener(SpringFacet.FACET_TYPE_ID, (ProjectWideFacetListener)myProjectWideFacetAdapter, (Disposable)this);
        MessageBusConnection messageBusConnection = this.myProject.getMessageBus().connect((Disposable)this);
        messageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                SpringBaseView.this.performFullUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/toolWindow/SpringBaseView$2", "rootsChanged"));
            }
        });
        messageBusConnection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    3.$$$reportNull$$$0(1);
                }
                SpringBaseView.this.performFullUpdate();
            }

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (module == null) {
                    3.$$$reportNull$$$0(3);
                }
                SpringBaseView.this.performFullUpdate();
            }

            public void modulesRenamed(@NotNull Project project, @NotNull List<? extends Module> modules, @NotNull Function<? super Module, String> oldNameProvider) {
                if (project == null) {
                    3.$$$reportNull$$$0(4);
                }
                if (modules == null) {
                    3.$$$reportNull$$$0(5);
                }
                if (oldNameProvider == null) {
                    3.$$$reportNull$$$0(6);
                }
                SpringBaseView.this.performFullUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "modules";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldNameProvider";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/spring/toolWindow/SpringBaseView$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleRemoved";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modulesRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return messageBusConnection;
    }

    protected static void select(Project project, Object[] pathToSelect, boolean requestFocus, String tabName) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Spring");
        assert (toolWindow != null);
        Runnable runnable = () -> {
            ContentManager contentManager = toolWindow.getContentManager();
            Content content = contentManager.findContent(tabName);
            if (content != null) {
                contentManager.setSelectedContentCB(content, requestFocus).doWhenDone(() -> {
                    SpringBaseView springBaseView = (SpringBaseView)((Object)((Object)((Object)content.getComponent())));
                    springBaseView.updateSelectedPath(pathToSelect);
                });
            } else {
                DataContext context = DataManager.getInstance().getDataContext((Component)contentManager.getComponent());
                SpringToolWindowContentUpdater updater = (SpringToolWindowContentUpdater)SpringToolWindowContent.CONTENT_UPDATER.getData(context);
                assert (updater != null);
                updater.update(() -> {
                    Content updatedContent = contentManager.findContent(tabName);
                    if (updatedContent == null) {
                        return;
                    }
                    contentManager.setSelectedContentCB(updatedContent, requestFocus).doWhenDone(() -> toolWindow.activate(() -> {
                        SpringBaseView springBaseView = (SpringBaseView)((Object)((Object)((Object)((Object)((Object)updatedContent.getComponent())))));
                        springBaseView.updateSelectedPath(pathToSelect);
                    }));
                });
            }
        };
        if (requestFocus) {
            toolWindow.activate(runnable);
        } else {
            runnable.run();
        }
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            SpringBaseView.$$$reportNull$$$0(0);
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.getHelpId();
        }
        return super.getData(dataId);
    }

    public void dispose() {
    }

    protected String getHelpId() {
        return "Reference.Spring.ToolWindow";
    }

    protected AnAction getHelpAction() {
        return new ContextHelpAction(this.getHelpId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/spring/toolWindow/SpringBaseView", "getData"));
    }
}

