/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.spi;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.lang.properties.IProperty;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.spi.SpringFactoriesFileType;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UastContextKt;

public final class SpringSpiRegistrationAnnotator
extends RelatedItemLineMarkerProvider {
    private static final NotNullFunction<IProperty, Collection<? extends PsiElement>> PROPERTY_CONVERTER = dom -> Collections.singleton(dom.getPsiElement());
    private static final NotNullFunction<IProperty, Collection<? extends GotoRelatedItem>> PROPERTY_RELATED_CONVERTER = dom -> GotoRelatedItem.createItems(Collections.singleton(dom.getPsiElement()), (String)"spring.factories");

    public String getId() {
        return "SpringSpiRegistrationAnnotator";
    }

    public String getName() {
        return SpringBundle.message("SpringSpiRegistrationAnnotator.spring.factories.registration", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = (Icon)SpringFactoriesFileType.ICON.getValue();
        if (icon == null) {
            SpringSpiRegistrationAnnotator.$$$reportNull$$$0(0);
        }
        return icon;
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            SpringSpiRegistrationAnnotator.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SpringSpiRegistrationAnnotator.$$$reportNull$$$0(2);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null || !SpringLibraryUtil.hasSpringLibrary(psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        if (element == null) {
            SpringSpiRegistrationAnnotator.$$$reportNull$$$0(3);
        }
        if (result == null) {
            SpringSpiRegistrationAnnotator.$$$reportNull$$$0(4);
        }
        if (!SpringLibraryUtil.hasSpringLibrary(element.getProject())) {
            return;
        }
        UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)element, UClass.class);
        if (uClass == null) {
            return;
        }
        PsiElement nameIdentifier = UElementKt.getSourcePsiElement((UElement)uClass.getUastAnchor());
        if (nameIdentifier == null) {
            return;
        }
        PsiClass psiClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)uClass, PsiClass.class);
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            return;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        PairProcessor findFirstProcessor2 = (property, aClass) -> !psiManager.areElementsEquivalent((PsiElement)psiClass, (PsiElement)aClass);
        String clazzName = uClass.getQualifiedName();
        boolean foundEntry = SpringSpiManager.getInstance(module).processClassesListValues(false, clazzName, (PairProcessor<IProperty, PsiClass>)findFirstProcessor2);
        if (!foundEntry) {
            SpringGutterIconBuilder<IProperty> builder = SpringGutterIconBuilder.createBuilder((Icon)SpringFactoriesFileType.GUTTER_ICON.getValue(), PROPERTY_CONVERTER, PROPERTY_RELATED_CONVERTER);
            builder.setTargets(NotNullLazyValue.lazy(() -> {
                SmartList mappedConfigKeys = new SmartList();
                PairProcessor processor2 = (arg_0, arg_1) -> SpringSpiRegistrationAnnotator.lambda$collectNavigationMarkers$3(psiManager, psiClass, (List)mappedConfigKeys, arg_0, arg_1);
                SpringSpiManager.getInstance(module).processClassesListValues(false, clazzName, (PairProcessor<IProperty, PsiClass>)processor2);
                return mappedConfigKeys;
            })).setPopupTitle(SpringBundle.message("SpringSpiRegistrationAnnotator.choose.registration", new Object[0])).setTooltipText(SpringBundle.message("SpringSpiRegistrationAnnotator.tooltip", new Object[0]));
            result.add(builder.createSpringRelatedMergeableLineMarkerInfo(nameIdentifier));
        }
    }

    private static /* synthetic */ boolean lambda$collectNavigationMarkers$3(PsiManager psiManager, PsiClass psiClass, List mappedConfigKeys, IProperty property, PsiClass aClass) {
        if (psiManager.areElementsEquivalent((PsiElement)psiClass, (PsiElement)aClass)) {
            mappedConfigKeys.add(property);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/spi/SpringSpiRegistrationAnnotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/spi/SpringSpiRegistrationAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

