/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.spi;

import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringSpiClassesListJamConverter
extends JamConverter<PsiClass> {
    private final String myConfigKey;

    public SpringSpiClassesListJamConverter(String configKey) {
        this.myConfigKey = configKey;
    }

    @Nullable
    public PsiClass fromString(@Nullable String s, JamStringAttributeElement<PsiClass> context) {
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return null;
        }
        PsiLanguageInjectionHost host = context.getLanguageInjectionHost();
        if (host == null) {
            return null;
        }
        PsiReference[] references = this.createReferences(context, host);
        if (references.length != 1) {
            return null;
        }
        return (PsiClass)references[0].resolve();
    }

    public PsiReference @NotNull [] createReferences(@NotNull JamStringAttributeElement<PsiClass> context, @NotNull PsiLanguageInjectionHost injectionHost) {
        if (context == null) {
            SpringSpiClassesListJamConverter.$$$reportNull$$$0(0);
        }
        if (injectionHost == null) {
            SpringSpiClassesListJamConverter.$$$reportNull$$$0(1);
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new SpringSpiClassReference(this.myConfigKey, (PsiElement)injectionHost, context.getStringValue())};
        if (psiReferenceArray == null) {
            SpringSpiClassesListJamConverter.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionHost";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/spi/SpringSpiClassesListJamConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/spi/SpringSpiClassesListJamConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SpringSpiClassReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        private final String myConfigKey;
        private final String myText;

        public SpringSpiClassReference(String configKey, @NotNull PsiElement literal, String text) {
            if (literal == null) {
                SpringSpiClassReference.$$$reportNull$$$0(0);
            }
            super(literal);
            this.myConfigKey = configKey;
            this.myText = text;
        }

        public SpringSpiClassReference(String configKey, PsiElement element, TextRange rangeInElement, String text) {
            super(element, rangeInElement);
            this.myConfigKey = configKey;
            this.myText = text;
        }

        @Nullable
        public PsiElement resolve() {
            if (StringUtil.isEmptyOrSpaces((String)this.myText)) {
                return null;
            }
            return (PsiElement)ContainerUtil.find(this.getRelevantClasses(this.getElement()), psiClass -> this.myText.equals(psiClass.getQualifiedName()));
        }

        public Object @NotNull [] getVariants() {
            List<PsiClass> classes = this.getRelevantClasses(this.getElement());
            Object[] objectArray = ContainerUtil.map2Array(classes, LookupElement.class, psiClass -> JavaLookupElementBuilder.forClass((PsiClass)psiClass, (String)psiClass.getQualifiedName(), (boolean)true).withPresentableText(StringUtil.notNullize((String)psiClass.getName())));
            if (objectArray == null) {
                SpringSpiClassReference.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        private List<PsiClass> getRelevantClasses(PsiElement literal) {
            if (literal == null) {
                return Collections.emptyList();
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)literal);
            if (module == null) {
                return Collections.emptyList();
            }
            VirtualFile containingFile = literal.getContainingFile().getOriginalFile().getVirtualFile();
            boolean isInTest = containingFile != null && ModuleRootManager.getInstance((Module)module).getFileIndex().isInTestSourceContent(containingFile);
            return SpringSpiManager.getInstance(module).getClassesListValue(isInTest, this.myConfigKey);
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = SpringApiBundle.message("SpringSpiClassesListJamConverter.unresolved.message.pattern", this.myText, this.myConfigKey);
            if (string == null) {
                SpringSpiClassReference.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literal";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/spi/SpringSpiClassesListJamConverter$SpringSpiClassReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/spi/SpringSpiClassesListJamConverter$SpringSpiClassReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

