/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.spi;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spring.SpringApiIcons;
import com.intellij.ui.LayeredIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringFactoriesFileType
extends LanguageFileType
implements FileTypeIdentifiableByVirtualFile {
    public static final SpringFactoriesFileType FILE_TYPE = new SpringFactoriesFileType();
    static final String SPRING_FACTORIES_FILE_NAME = "spring.factories";
    static final NotNullLazyValue<Icon> ICON = NotNullLazyValue.createValue(() -> new LayeredIcon(new Icon[]{SpringApiIcons.Spring, AllIcons.Actions.New}));
    static final NotNullLazyValue<Icon> GUTTER_ICON = NotNullLazyValue.createValue(() -> new LayeredIcon(new Icon[]{SpringApiIcons.Gutter.Spring, AllIcons.Actions.New}));

    private SpringFactoriesFileType() {
        super((Language)PropertiesLanguage.INSTANCE, true);
    }

    public boolean isMyFileType(@NotNull VirtualFile file) {
        if (file == null) {
            SpringFactoriesFileType.$$$reportNull$$$0(0);
        }
        if (!Comparing.equal((CharSequence)SPRING_FACTORIES_FILE_NAME, (CharSequence)file.getNameSequence())) {
            return false;
        }
        VirtualFile parent = file.getParent();
        return parent != null && Comparing.equal((CharSequence)"META-INF", (CharSequence)parent.getNameSequence());
    }

    @NotNull
    public String getName() {
        return SPRING_FACTORIES_FILE_NAME;
    }

    @NotNull
    public String getDescription() {
        return SPRING_FACTORIES_FILE_NAME;
    }

    @NotNull
    public String getDisplayName() {
        return "Spring Factories";
    }

    @NotNull
    public String getDefaultExtension() {
        return "";
    }

    @Nullable
    public Icon getIcon() {
        return (Icon)ICON.getValue();
    }

    public String getCharset(@NotNull VirtualFile file, byte @NotNull [] content) {
        if (file == null) {
            SpringFactoriesFileType.$$$reportNull$$$0(1);
        }
        if (content == null) {
            SpringFactoriesFileType.$$$reportNull$$$0(2);
        }
        return PropertiesFileType.INSTANCE.getCharset(file, content);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/spi/SpringFactoriesFileType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isMyFileType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCharset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

