/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.TypePresentationService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.scope.SpringBeanScopeManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UExpression;

public class SpringBeanScopeReference
extends PsiReferenceBase<PsiLanguageInjectionHost> {
    private static final List<String> DEFAULT_SCOPE_NAMES = ContainerUtil.map((Object[])SpringBeanScope.getDefaultScopes(), SpringBeanScope::getValue);
    private final UExpression myLiteral;

    public SpringBeanScopeReference(@NotNull UExpression uLiteral, @NotNull PsiLanguageInjectionHost element) {
        if (uLiteral == null) {
            SpringBeanScopeReference.$$$reportNull$$$0(0);
        }
        if (element == null) {
            SpringBeanScopeReference.$$$reportNull$$$0(1);
        }
        super((PsiElement)element);
        this.myLiteral = uLiteral;
    }

    public PsiElement resolve() {
        Object value = this.myLiteral.evaluate();
        if (value instanceof String) {
            if (DEFAULT_SCOPE_NAMES.contains(value)) {
                return this.getElement();
            }
            for (SpringBeanScope beanScope : SpringBeanScopeManager.getInstance().getCustomBeanScopes(this.getElement())) {
                if (!value.equals(beanScope.getValue())) continue;
                return this.getElement();
            }
        }
        return null;
    }

    public Object @NotNull [] getVariants() {
        ArrayList<LookupElementBuilder> variants = new ArrayList<LookupElementBuilder>(DEFAULT_SCOPE_NAMES.size());
        for (String scope : DEFAULT_SCOPE_NAMES) {
            variants.add(SpringBeanScopeReference.getLookupElement(scope));
        }
        for (SpringBeanScope beanScope : SpringBeanScopeManager.getInstance().getCustomBeanScopes(this.getElement())) {
            variants.add(SpringBeanScopeReference.getLookupElement(beanScope.getValue()));
        }
        Object[] objectArray = variants.toArray(LookupElement.EMPTY_ARRAY);
        if (objectArray == null) {
            SpringBeanScopeReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    private static LookupElementBuilder getLookupElement(String scope) {
        return LookupElementBuilder.create((String)scope).withIcon(TypePresentationService.getService().getTypeIcon(SpringBeanScope.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uLiteral";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/references/SpringBeanScopeReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/references/SpringBeanScopeReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

