/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.references.SpringBeanReference;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanResourceReference
extends SpringBeanReference {
    public SpringBeanResourceReference(PsiElement element, TextRange range, @Nullable PsiClass requiredClass, boolean isFactoryBeanRef) {
        super(element, range, requiredClass, isFactoryBeanRef);
    }

    @Override
    public PsiElement resolve() {
        String beanName = this.getValue();
        CommonSpringModel springModel = this.getSpringModel();
        SpringBeanPointer<?> pointer = SpringModelSearchers.findBean(springModel, beanName);
        return pointer == null || !pointer.isValid() || SpringCommonUtils.isDefinedAsCollectionElement(pointer) ? SpringBeanResourceReference.resolveResourceByFqn(beanName, springModel, this.getElement().getProject()) : pointer.getPsiElement();
    }

    @Override
    @NotNull
    protected Collection<SpringBeanPointer<?>> getBeanPointers(CommonSpringModel model) {
        Set<SpringBeanPointer<?>> set = SpringCommonUtils.filterInnerClassBeans(super.getBeanPointers(model));
        if (set == null) {
            SpringBeanResourceReference.$$$reportNull$$$0(0);
        }
        return set;
    }

    public boolean isSoft() {
        return true;
    }

    @Nullable
    public static PsiClass resolveResourceByFqn(@NotNull String beanName, @NotNull CommonSpringModel model, @NotNull Project project) {
        Module module;
        if (beanName == null) {
            SpringBeanResourceReference.$$$reportNull$$$0(1);
        }
        if (model == null) {
            SpringBeanResourceReference.$$$reportNull$$$0(2);
        }
        if (project == null) {
            SpringBeanResourceReference.$$$reportNull$$$0(3);
        }
        GlobalSearchScope scope = (module = model.getModule()) != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.allScope((Project)project);
        return JavaPsiFacade.getInstance((Project)project).findClass(beanName.replace("$", "."), scope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/references/SpringBeanResourceReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanPointers";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/references/SpringBeanResourceReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveResourceByFqn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

