/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.profiles.SpringProfilesFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Predicate;

final class SpringProfilesParser {
    private static final Predicate<Set<String>> DEFAULT = activeProfiles -> true;

    SpringProfilesParser() {
    }

    static Predicate<Set<String>> parse(Collection<String> expressions) {
        String expression = (String)ContainerUtil.getOnlyItem(expressions);
        if ("_DEFAULT_PROFILE_NAME_".equals(expression)) {
            return DEFAULT;
        }
        if (expression != null) {
            return SpringProfilesParser.parseExpression(expression);
        }
        return SpringProfilesParser.or(ContainerUtil.map(expressions, SpringProfilesParser::parseExpression));
    }

    private static Predicate<Set<String>> parseExpression(String expression) {
        if (StringUtil.isEmptyOrSpaces((String)expression)) {
            throw new SpringProfilesFactory.MalformedProfileExpressionException(SpringBundle.message("spring.profile.expression.empty", new Object[0]));
        }
        StringTokenizer tokens = new StringTokenizer(expression, "()&|!", true);
        return SpringProfilesParser.parseTokens(tokens, Context.NONE);
    }

    private static Predicate<Set<String>> parseTokens(StringTokenizer tokens, Context context) {
        ArrayList<Predicate<Set<String>>> elements = new ArrayList<Predicate<Set<String>>>();
        Operator operator = null;
        block14: while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.isEmpty()) continue;
            switch (token) {
                case "(": {
                    Predicate<Set<String>> contents = SpringProfilesParser.parseTokens(tokens, Context.BRACKET);
                    if (context == Context.INVERT) {
                        return contents;
                    }
                    elements.add(contents);
                    continue block14;
                }
                case "&": {
                    SpringProfilesParser.assertWellFormed(operator == null || operator == Operator.AND);
                    operator = Operator.AND;
                    continue block14;
                }
                case "|": {
                    SpringProfilesParser.assertWellFormed(operator == null || operator == Operator.OR);
                    operator = Operator.OR;
                    continue block14;
                }
                case "!": {
                    elements.add(SpringProfilesParser.parseTokens(tokens, Context.INVERT).negate());
                    continue block14;
                }
                case ")": {
                    Predicate<Set<String>> merged = SpringProfilesParser.merge(elements, operator);
                    if (context == Context.BRACKET) {
                        return merged;
                    }
                    elements.clear();
                    elements.add(merged);
                    operator = null;
                    continue block14;
                }
            }
            Predicate<Set<String>> value = SpringProfilesParser.equals(token);
            if (context == Context.INVERT) {
                return value;
            }
            elements.add(value);
        }
        return SpringProfilesParser.merge(elements, operator);
    }

    private static Predicate<Set<String>> merge(List<Predicate<Set<String>>> elements, Operator operator) {
        SpringProfilesParser.assertWellFormed(!elements.isEmpty());
        if (elements.size() == 1) {
            return elements.get(0);
        }
        ArrayList<Predicate<Set<String>>> profiles = new ArrayList<Predicate<Set<String>>>(elements);
        return operator == Operator.AND ? SpringProfilesParser.and(profiles) : SpringProfilesParser.or(profiles);
    }

    private static void assertWellFormed(boolean wellFormed) {
        if (!wellFormed) {
            throw new SpringProfilesFactory.MalformedProfileExpressionException(SpringBundle.message("spring.profile.expression.malformed", new Object[0]));
        }
    }

    private static Predicate<Set<String>> or(List<Predicate<Set<String>>> profiles) {
        return activeProfiles -> profiles.stream().anyMatch(profile -> profile.test(activeProfiles));
    }

    private static Predicate<Set<String>> and(List<Predicate<Set<String>>> profiles) {
        return activeProfiles -> profiles.stream().allMatch(profile -> profile.test(activeProfiles));
    }

    private static Predicate<Set<String>> equals(String profile) {
        return activeProfiles -> activeProfiles.contains(profile);
    }

    private static enum Context {
        NONE,
        INVERT,
        BRACKET;

    }

    private static enum Operator {
        AND,
        OR;

    }
}

