/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.DelimitedListProcessor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlElement;
import com.intellij.spring.model.jam.SpringSemContributorUtil;
import com.intellij.spring.model.jam.profile.SpringContextProfile;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringDomProfile;
import com.intellij.spring.profiles.SpringProfilePsiReference;
import com.intellij.spring.profiles.SpringProfileTarget;
import com.intellij.spring.profiles.SpringProfilesFactory;
import com.intellij.spring.profiles.SpringProfilesParser;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringProfilesFactoryImpl
extends SpringProfilesFactory {
    @Override
    @NotNull
    public List<SpringProfileTarget> findProfileTargets(@NotNull Module module, boolean includeTests) {
        if (module == null) {
            SpringProfilesFactoryImpl.$$$reportNull$$$0(0);
        }
        List list = ContainerUtil.concat(SpringProfilesFactoryImpl.findJamTargets(module, includeTests), SpringProfilesFactoryImpl.findDomTargets(module, includeTests));
        if (list == null) {
            SpringProfilesFactoryImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @Nullable
    public SpringProfileTarget findProfileTarget(@NotNull Module module, boolean includeTests, @NotNull String profileName) {
        if (module == null) {
            SpringProfilesFactoryImpl.$$$reportNull$$$0(2);
        }
        if (profileName == null) {
            SpringProfilesFactoryImpl.$$$reportNull$$$0(3);
        }
        for (SpringProfileTarget target : SpringProfilesFactoryImpl.findJamTargets(module, includeTests)) {
            if (!profileName.equals(target.getName())) continue;
            return target;
        }
        for (SpringProfileTarget target : SpringProfilesFactoryImpl.findDomTargets(module, includeTests)) {
            if (!profileName.equals(target.getName())) continue;
            return target;
        }
        return null;
    }

    @Override
    public PsiReference @NotNull [] getProfilesReferences(@NotNull Module module, @NotNull PsiElement element, @Nullable String value, int valueOffset, @NotNull String delimiters, boolean isDefinition) {
        List<TextRange> ranges;
        if (module == null) {
            SpringProfilesFactoryImpl.$$$reportNull$$$0(4);
        }
        if (element == null) {
            SpringProfilesFactoryImpl.$$$reportNull$$$0(5);
        }
        if (delimiters == null) {
            SpringProfilesFactoryImpl.$$$reportNull$$$0(6);
        }
        if ((ranges = SpringProfilesFactoryImpl.getProfileRanges(value, delimiters)).isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringProfilesFactoryImpl.$$$reportNull$$$0(7);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        int referenceOffset = ElementManipulators.getOffsetInElement((PsiElement)element) + valueOffset;
        PsiReference[] psiReferenceArray = (PsiReference[])ContainerUtil.map2Array(ranges, PsiReference.class, range -> new SpringProfilePsiReference(element, range.shiftRight(referenceOffset), module, isDefinition));
        if (psiReferenceArray == null) {
            SpringProfilesFactoryImpl.$$$reportNull$$$0(8);
        }
        return psiReferenceArray;
    }

    @Override
    public Predicate<Set<String>> parseProfileExpressions(@NotNull Collection<String> expressions) {
        if (expressions == null) {
            SpringProfilesFactoryImpl.$$$reportNull$$$0(9);
        }
        return SpringProfilesParser.parse(expressions);
    }

    private static List<SpringProfileTarget> findDomTargets(Module module, boolean includeTests) {
        return (List)((Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            ConcurrentMap map = ConcurrentFactoryMap.createMap(withTests -> SpringProfilesFactoryImpl.findDomTargets(module, module.getModuleScope(withTests.booleanValue())));
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{DomManager.getDomManager((Project)module.getProject())});
        })).get(includeTests);
    }

    private static List<SpringProfileTarget> findDomTargets(Module module, GlobalSearchScope scope) {
        SmartList targets = new SmartList();
        List elements = DomService.getInstance().getFileElements(Beans.class, module.getProject(), scope);
        for (DomFileElement element : elements) {
            SpringProfilesFactoryImpl.collectProfileTargets((Beans)element.getRootElement(), (List<SpringProfileTarget>)targets);
        }
        return targets;
    }

    private static void collectProfileTargets(Beans beans, List<SpringProfileTarget> targets) {
        String value;
        List<TextRange> ranges;
        SpringDomProfile profile = beans.getProfile();
        XmlElement xmlElement = profile.getXmlElement();
        if (xmlElement != null && !(ranges = SpringProfilesFactoryImpl.getProfileRanges(value = profile.getStringValue(), ",; ")).isEmpty()) {
            int offset = ElementManipulators.getOffsetInElement((PsiElement)xmlElement);
            targets.addAll(ContainerUtil.map(ranges, range -> new SpringProfileTarget((PsiElement)xmlElement, range.substring(value), range.getStartOffset() + offset)));
        }
        for (Beans beansProfile : beans.getBeansProfiles()) {
            SpringProfilesFactoryImpl.collectProfileTargets(beansProfile, targets);
        }
    }

    private static List<SpringProfileTarget> findJamTargets(Module module, boolean includeTests) {
        return (List)((Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            ConcurrentMap map = ConcurrentFactoryMap.createMap(withTests -> SpringProfilesFactoryImpl.findJamTargets(module, module.getModuleScope(withTests.booleanValue())));
            Project project = module.getProject();
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project), UastModificationTracker.getInstance((Project)project)});
        })).get(includeTests);
    }

    private static List<SpringProfileTarget> findJamTargets(Module module, GlobalSearchScope scope) {
        ArrayList<SpringProfileTarget> targets = new ArrayList<SpringProfileTarget>();
        JamService jamService = JamService.getJamService((Project)module.getProject());
        ArrayList<String> fqns = new ArrayList<String>((Collection)SpringSemContributorUtil.getCustomMetaAnnotations("org.springframework.context.annotation.Profile").fun((Object)module));
        fqns.add("org.springframework.context.annotation.Profile");
        for (String fqn : fqns) {
            List jamProfiles = jamService.getJamClassElements(SpringContextProfile.CONTEXT_PROFILE_JAM_KEY, fqn, scope);
            for (SpringContextProfile jamProfile : jamProfiles) {
                targets.addAll(SpringProfilesFactoryImpl.getProfileTargets(jamProfile));
            }
            List jamMethodProfiles = jamService.getJamMethodElements(SpringContextProfile.CONTEXT_PROFILE_JAM_KEY, fqn, scope);
            for (SpringContextProfile jamProfile : jamMethodProfiles) {
                targets.addAll(SpringProfilesFactoryImpl.getProfileTargets(jamProfile));
            }
        }
        return targets;
    }

    private static List<SpringProfileTarget> getProfileTargets(@NotNull SpringContextProfile jamProfile) {
        if (jamProfile == null) {
            SpringProfilesFactoryImpl.$$$reportNull$$$0(10);
        }
        SmartList targets = new SmartList();
        for (JamStringAttributeElement<String> attributeElement : jamProfile.getValueElements()) {
            String value;
            List<TextRange> ranges;
            PsiAnnotationMemberValue psiElement = attributeElement.getPsiElement();
            if (psiElement == null || (ranges = SpringProfilesFactoryImpl.getProfileRanges(value = attributeElement.getStringValue(), "()&|")).isEmpty()) continue;
            PsiLiteral psiLiteral = attributeElement.getPsiLiteral();
            int offset = psiLiteral == null ? -1 : ElementManipulators.getOffsetInElement((PsiElement)psiLiteral);
            targets.addAll(ContainerUtil.map(ranges, arg_0 -> SpringProfilesFactoryImpl.lambda$getProfileTargets$6((PsiElement)psiElement, value, psiLiteral, offset, arg_0)));
        }
        return targets;
    }

    private static List<TextRange> getProfileRanges(final @Nullable String value, @NotNull String delimiters) {
        if (delimiters == null) {
            SpringProfilesFactoryImpl.$$$reportNull$$$0(11);
        }
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            return Collections.emptyList();
        }
        SmartList ranges = new SmartList();
        new DelimitedListProcessor(delimiters, (List)ranges){
            final /* synthetic */ List val$ranges;
            {
                this.val$ranges = list;
                super(arg0);
            }

            protected void processToken(int start, int end, boolean delimitersOnly) {
                String profileName = value.substring(start, end);
                String profileNameTrimmed = profileName.trim();
                int profileNameIdx = profileName.indexOf(profileNameTrimmed);
                TextRange trimmedRange = TextRange.from((int)(start + profileNameIdx), (int)profileNameTrimmed.length());
                if (StringUtil.startsWithChar((CharSequence)profileNameTrimmed, (char)'!')) {
                    trimmedRange = trimmedRange.shiftRight(1).grown(-1);
                }
                if (trimmedRange.getLength() > 0) {
                    this.val$ranges.add(trimmedRange);
                }
            }
        }.processText(value);
        return ranges;
    }

    private static /* synthetic */ SpringProfileTarget lambda$getProfileTargets$6(PsiElement psiElement, String value, PsiLiteral psiLiteral, int offset, TextRange range) {
        return new SpringProfileTarget(psiElement, range.substring(value), psiLiteral == null ? -1 : range.getStartOffset() + offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/profiles/SpringProfilesFactoryImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delimiters";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jamProfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/profiles/SpringProfilesFactoryImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findProfileTargets";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilesReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findProfileTargets";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findProfileTarget";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getProfilesReferences";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseProfileExpressions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getProfileTargets";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProfileRanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

