/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.perspectives.diagrams.beans;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.AbstractProcessableModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapperBase;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAppContextWrapper
extends SpringElementWrapperBase<XmlFile> {
    private static final String APP_CONTEXT_PATH = "appContextPath";
    private static final String APP_CONTEXT_NAME = "appContextName";

    public SpringAppContextWrapper(@NotNull XmlFile file) {
        if (file == null) {
            SpringAppContextWrapper.$$$reportNull$$$0(0);
        }
        super(file);
    }

    @Override
    public Icon getIcon() {
        return ((XmlFile)this.getWrapped()).getIcon(0);
    }

    @Override
    public Module getModule() {
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)this.getWrapped()));
    }

    @Override
    public String getName() {
        return ((XmlFile)this.getWrapped()).getName();
    }

    @Override
    public CommonSpringModel getProcessingSpringModel(boolean localModel) {
        Module module;
        XmlFile xmlFile = (XmlFile)this.getWrapped();
        SpringManager springManager = SpringManager.getInstance(xmlFile.getProject());
        AbstractProcessableModel springModel = localModel ? ((module = this.getModule()) == null ? null : SpringLocalModelFactory.getInstance().getOrCreateLocalXmlModel(xmlFile, module, Collections.emptySet())) : springManager.getSpringModelByFile((PsiFile)xmlFile);
        return springModel == null ? SpringModel.UNKNOWN : springModel;
    }

    @Override
    public String getFqn() {
        XmlFile xmlFile = (XmlFile)this.getWrapped();
        VirtualFile virtualFile = xmlFile.getVirtualFile();
        return virtualFile == null ? null : "appContextPath=" + virtualFile.getPath() + ";appContextName=" + virtualFile.getNameWithoutExtension();
    }

    @Nullable
    public static SpringElementWrapper resolveElementByFQN(String fqn, Project project) {
        String path = SpringElementWrapperBase.split(fqn).get(APP_CONTEXT_PATH);
        XmlFile file = SpringElementWrapperBase.findFile(project, path);
        if (file != null) {
            return new SpringAppContextWrapper(file);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/perspectives/diagrams/beans/SpringAppContextWrapper", "<init>"));
    }
}

