/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.perspectives.diagrams;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringInjection;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.perspectives.diagrams.beans.SpringAppContextWrapper;
import com.intellij.spring.perspectives.diagrams.beans.SpringBeanClassWrapper;
import com.intellij.spring.perspectives.diagrams.beans.SpringBeanPointerWrapper;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.ui.SimpleColoredText;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UastUtils;

public class SpringDiagramElementManager
extends AbstractDiagramElementManager<SpringElementWrapper<?>> {
    private final SmartPsiElementPointer<? extends PsiElement> myPointer;

    public SpringDiagramElementManager() {
        this(null);
    }

    public SpringDiagramElementManager(@Nullable SmartPsiElementPointer<? extends PsiElement> pointer) {
        this.myPointer = pointer;
    }

    @Nullable
    public SpringElementWrapper findInDataContext(@NotNull DataContext context) {
        PsiFile psiFile;
        if (context == null) {
            SpringDiagramElementManager.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = this.myPointer != null ? this.myPointer.getElement() : null;
        PsiFile psiFile2 = psiFile = psiElement instanceof XmlElement ? psiElement.getContainingFile() : (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (JamCommonUtil.isPlainXmlFile((PsiElement)psiFile) && SpringDomUtils.isSpringXml((XmlFile)psiFile)) {
            return new SpringAppContextWrapper((XmlFile)psiFile);
        }
        return SpringDiagramElementManager.findBeanPointer(psiElement != null ? psiElement : (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context));
    }

    @Nullable
    private static SpringElementWrapper findBeanPointer(@Nullable PsiElement element) {
        UClass uClass = (UClass)UastUtils.findContaining((PsiElement)element, UClass.class);
        if (uClass == null) {
            return null;
        }
        PsiClass psiClass = uClass.getJavaPsi();
        if (SpringCommonUtils.isStereotypeComponentOrMeta(psiClass)) {
            return new SpringBeanClassWrapper(psiClass);
        }
        return null;
    }

    public boolean isAcceptableAsNode(@Nullable Object element) {
        return element instanceof SpringElementWrapper;
    }

    @Nullable
    public String getElementTitle(SpringElementWrapper element) {
        return element.getName();
    }

    public SimpleColoredText getItemName(@Nullable Object obj, @NotNull DiagramState presentation) {
        String name;
        SpringBeanPointer element;
        if (presentation == null) {
            SpringDiagramElementManager.$$$reportNull$$$0(1);
        }
        if (obj instanceof SpringBeanPointerWrapper && (element = (SpringBeanPointer)((SpringBeanPointerWrapper)obj).getWrapped()).isValid()) {
            String beanName = SpringPresentationProvider.getSpringBeanName(element);
            return new SimpleColoredText(SpringDiagramElementManager.getShotBeanName(beanName), DiagramElementManager.DEFAULT_TITLE_ATTR);
        }
        if (obj instanceof SpringProperty) {
            name = ((SpringProperty)obj).getName().getRawText();
            return new SimpleColoredText(StringUtil.notNullize((String)name), DiagramElementManager.DEFAULT_TEXT_ATTR);
        }
        if (obj instanceof SpringElementWrapper) {
            name = ((SpringElementWrapper)obj).getName();
            return new SimpleColoredText(name, DiagramElementManager.DEFAULT_TEXT_ATTR);
        }
        return null;
    }

    @NlsSafe
    private static String getShotBeanName(String beanName) {
        if (!beanName.startsWith("<") && beanName.contains(".")) {
            return StringUtil.getShortName((String)beanName);
        }
        return beanName;
    }

    @Nullable
    @Nls
    public String getNodeTooltip(SpringElementWrapper element) {
        if (element instanceof SpringBeanPointerWrapper) {
            SpringBeanPointer beanPointer = (SpringBeanPointer)element.getWrapped();
            PsiClass aClass = beanPointer.getBeanClass();
            if (aClass != null) {
                return aClass.getQualifiedName();
            }
            return SpringPresentationProvider.getSpringBeanName(beanPointer);
        }
        return element.getName();
    }

    public Object @NotNull [] getNodeItems(SpringElementWrapper parent) {
        Object springBean;
        SpringBeanPointer wrapped;
        ArrayList<SpringInjection> children = new ArrayList<SpringInjection>();
        if (parent instanceof SpringBeanPointerWrapper && (wrapped = (SpringBeanPointer)((SpringBeanPointerWrapper)parent).getWrapped()).isValid() && (springBean = wrapped.getSpringBean()) instanceof SpringBean) {
            SpringBean bean = (SpringBean)springBean;
            children.addAll(bean.getProperties());
            children.addAll(bean.getConstructorArgs());
        }
        Object[] objectArray = children.toArray();
        if (objectArray == null) {
            SpringDiagramElementManager.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    @Nullable
    public Icon getItemIcon(@Nullable Object element, @NotNull DiagramState presentation) {
        if (presentation == null) {
            SpringDiagramElementManager.$$$reportNull$$$0(3);
        }
        if (element instanceof SpringProperty) {
            return SpringApiIcons.SpringProperty;
        }
        return super.getItemIcon(element, presentation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/perspectives/diagrams/SpringDiagramElementManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/perspectives/diagrams/SpringDiagramElementManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getItemName";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getItemIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

