/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration.jpa.actions;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.module.Module;
import com.intellij.spring.model.actions.patterns.frameworks.AbstractFrameworkIntegrationAction;
import com.intellij.spring.model.actions.patterns.frameworks.ui.LibrariesInfo;
import com.intellij.spring.model.actions.patterns.frameworks.ui.TemplateInfo;
import com.intellij.spring.model.actions.patterns.frameworks.util.LibrariesConfigurationManager;
import com.intellij.spring.persistence.integration.SpringPersistenceIntegrationBundle;
import com.intellij.spring.persistence.integration.jpa.actions.JpaEntityManagerBeanGenerateProvider;
import icons.SpringPersistenceIntegrationIcons;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class JpaPatternAction
extends AbstractFrameworkIntegrationAction {
    @NonNls
    private static final String JPA_STRING_ID = "jpa";

    @Override
    protected String[] getBeansClassNames() {
        return new String[]{"org.springframework.orm.jpa.LocalEntityManagerFactoryBean"};
    }

    @Override
    public LibrariesInfo getLibrariesInfo(Module module) {
        LibraryInfo[] libraryInfos = LibrariesConfigurationManager.getInstance(module.getProject()).getLibraryInfos(JPA_STRING_ID);
        return new LibrariesInfo(libraryInfos, module, JPA_STRING_ID);
    }

    @Override
    public List<TemplateInfo> getTemplateInfos(Module module) {
        LinkedList<TemplateInfo> infos = new LinkedList<TemplateInfo>();
        TemplateSettings settings = TemplateSettings.getInstance();
        TemplateImpl template = (TemplateImpl)JpaEntityManagerBeanGenerateProvider.getTemplate(module.getProject());
        template.setId("jpa-entity-manager-factory");
        TemplateInfo emf = new TemplateInfo(module, (Template)template, SpringPersistenceIntegrationBundle.message("spring.patterns.jpa.entity.manager.factory.bean", new Object[0]), null);
        TemplateInfo cemf = new TemplateInfo(module, settings.getTemplateById("jpa-container-entity-manager-factory"), SpringPersistenceIntegrationBundle.message("spring.patterns.jpa.container.entity.manager.factory.bean", new Object[0]), null, false);
        TemplateInfo pum = new TemplateInfo(module, settings.getTemplateById("jpa-persistent-unit-manager"), SpringPersistenceIntegrationBundle.message("spring.patterns.jpa.persistence.unit.manager", new Object[0]), null, false);
        TemplateInfo tm = new TemplateInfo(module, settings.getTemplateById("jpa-transaction-manager"), SpringPersistenceIntegrationBundle.message("spring.patterns.transaction.manager", new Object[0]), null);
        TemplateInfo anno = new TemplateInfo(module, settings.getTemplateById("jpa-anno-post-processor"), SpringPersistenceIntegrationBundle.message("spring.patterns.jpa.annotation.bean.post.processor", new Object[0]), null, false);
        TemplateInfo ex = new TemplateInfo(module, settings.getTemplateById("jpa-ex-translation-post-processor"), SpringPersistenceIntegrationBundle.message("spring.patterns.jpa.exception.translation.post.processor", new Object[0]), null, false);
        infos.add(emf);
        infos.add(cemf);
        infos.add(pum);
        infos.add(tm);
        infos.add(anno);
        infos.add(ex);
        return infos;
    }

    @Override
    @Nullable
    protected String getFacetId() {
        return JPA_STRING_ID;
    }

    @Override
    public String getDescription() {
        return SpringPersistenceIntegrationBundle.message("framework.name", new Object[0]);
    }

    @Override
    @Nullable
    protected Icon getIcon() {
        return SpringPersistenceIntegrationIcons.Jpa;
    }
}

