/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration.hibernate;

import com.intellij.hibernate.model.xml.config.HibernateConfiguration;
import com.intellij.hibernate.model.xml.config.SessionFactory;
import com.intellij.hibernate.model.xml.impl.config.SessionFactoryImpl;
import com.intellij.hibernate.util.HibernateUtil;
import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.view.DeleteHandler;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlElement;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.utils.SpringReferenceUtils;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.beans.Prop;
import com.intellij.spring.model.xml.beans.Props;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.persistence.integration.SpringXmlPersistencePackage;
import com.intellij.spring.persistence.integration.hibernate.SpringIntegrationDeleteHandler;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ReadOnlyGenericValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(icon="com.intellij.spring.SpringApiIcons.SpringConfig")
@DeleteHandler(handlerClass=SpringIntegrationDeleteHandler.class)
public class SpringXmlHibernateSessionFactory
extends SpringXmlPersistencePackage {
    @NonNls
    public static final String SESSION_FACTORY_HIBERNATE_3 = "org.springframework.orm.hibernate3.LocalSessionFactoryBean";
    @NonNls
    public static final String SESSION_FACTORY_HIBERNATE_4 = "org.springframework.orm.hibernate4.LocalSessionFactoryBean";
    @NonNls
    public static final String SESSION_FACTORY_HIBERNATE_5 = "org.springframework.orm.hibernate5.LocalSessionFactoryBean";
    @NonNls
    public static final String SESSION_FACTORY_BUILDER = "org.springframework.orm.hibernate4.LocalSessionFactoryBuilder";
    @NonNls
    public static final String SESSION_FACTORY = "org.hibernate.SessionFactory";
    @NonNls
    public static final String SESSION_FACTORY_1_0 = "org.springframework.orm.hibernate.LocalSessionFactoryBean";
    @NonNls
    public static final String ANNO_SESSION_FACTORY = "org.springframework.orm.hibernate3.annotation.AnnotationSessionFactoryBean";
    @NonNls
    public static final String CACHEABLE_MAPPING_LOCATIONS = "cacheableMappingLocations";
    @NonNls
    public static final String MAPPING_LOCATIONS = "mappingLocations";
    @NonNls
    public static final String MAPPING_DIRECTORY_LOCATIONS = "mappingDirectoryLocations";
    @NonNls
    public static final String CONFIG_LOCATION = "configLocation";
    @NonNls
    public static final String DATASOURCE = "dataSource";
    @NonNls
    public static final String ANNOTATED_CLASSES = "annotatedClasses";
    @NonNls
    public static final String ANNOTATED_PACKAGES = "annotatedPackages";
    @NonNls
    public static final String HIBERNATE_PROPERTIES = "hibernateProperties";
    @NonNls
    public static final String PHYSICAL_NAMING_STRATEGY = "physicalNamingStrategy";
    @NonNls
    public static final String IMPLICIT_NAMING_STRATEGY = "implicitNamingStrategy";
    @NonNls
    public static final String NAMING_STRATEGY = "namingStrategy";
    private static final String @NonNls [] STRATEGY_PROPERTIES = new String[]{"physicalNamingStrategy", "implicitNamingStrategy", "namingStrategy"};
    private final boolean mySupportsAnnotations;
    private final CachedValue<SessionFactory> mySessionFactory;

    public SpringXmlHibernateSessionFactory(DomSpringBeanPointer bean, Module module, boolean supportsAnnotations) {
        super(bean, module);
        this.mySupportsAnnotations = supportsAnnotations;
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)this.getPsiManager().getProject());
        this.mySessionFactory = cachedValuesManager.createCachedValue(() -> new CachedValueProvider.Result((Object)this.getSessionFactoryInner(), super.getCacheDependencies().toArray()), false);
        XmlElement element = this.getBean().getXmlElement();
        if (element != null) {
            element.putUserData(PersistencePackage.PERSISTENCE_UNIT_KEY, (Object)this);
        }
    }

    public boolean supportsAnnotations() {
        return this.mySupportsAnnotations;
    }

    @Override
    public String getPersistenceProviderName() {
        return "org.hibernate.ejb.HibernatePersistence";
    }

    public GenericValue<Boolean> getExcludeUnlistedClasses() {
        return ReadOnlyGenericValue.getInstance((Object)Boolean.FALSE);
    }

    @Nullable
    public String getNamingStrategy() {
        for (String strategyProperty : STRATEGY_PROPERTIES) {
            SpringPropertyDefinition definition = SpringPropertyUtils.findPropertyByName(this.getBean(), strategyProperty);
            if (definition == null) continue;
            return SpringXmlHibernateSessionFactory.getPsiClassPropertyValue(definition);
        }
        SpringPropertyDefinition definition = SpringPropertyUtils.findPropertyByName(this.getBean(), HIBERNATE_PROPERTIES);
        if (definition instanceof SpringProperty) {
            for (Prop prop : ((SpringProperty)definition).getProps().getProps()) {
                String value = prop.getKey().getStringValue();
                if (value == null || !value.endsWith("physical_naming_strategy") && !value.endsWith("implicit_naming_strategy")) continue;
                return prop.getStringValue();
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected Collection<String> getMappingResourcesProperties() {
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new String[]{MAPPING_LOCATIONS, CACHEABLE_MAPPING_LOCATIONS, "mappingResources"});
        if (arrayList == null) {
            SpringXmlHibernateSessionFactory.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Override
    protected Collection<String> getMappingResourcesDirectoryProperties() {
        return Collections.singleton(MAPPING_DIRECTORY_LOCATIONS);
    }

    @Nullable
    private static String getPsiClassPropertyValue(@NotNull SpringPropertyDefinition physical) {
        SpringBean springBean;
        PsiClass beanClass;
        SpringBeanPointer<?> beanPointer;
        if (physical == null) {
            SpringXmlHibernateSessionFactory.$$$reportNull$$$0(1);
        }
        if ((beanPointer = physical.getRefValue()) != null && (beanClass = beanPointer.getBeanClass()) != null) {
            return beanClass.getQualifiedName();
        }
        if (physical instanceof SpringProperty && DomUtil.hasXml((DomElement)(springBean = ((SpringProperty)physical).getBean()))) {
            return springBean.getClazz().getStringValue();
        }
        return null;
    }

    @Override
    @NotNull
    public <V extends PersistenceMappings> List<? extends GenericValue<V>> getMappingFiles(Class<V> mappingsClass) {
        ArrayList result = new ArrayList();
        ContainerUtil.addAllNotNull(result, super.getMappingFiles(mappingsClass));
        SessionFactory sessionFactory = (SessionFactory)this.mySessionFactory.getValue();
        if (sessionFactory instanceof SessionFactoryImpl) {
            ContainerUtil.addAllNotNull(result, (Iterable)((SessionFactoryImpl)sessionFactory).getMappingFiles(mappingsClass));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            SpringXmlHibernateSessionFactory.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<? extends GenericValue<PsiFile>> getJarFiles() {
        SessionFactory sessionFactory = (SessionFactory)this.mySessionFactory.getValue();
        List list = sessionFactory == null ? Collections.emptyList() : sessionFactory.getModelHelper().getJarFiles();
        if (list == null) {
            SpringXmlHibernateSessionFactory.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    public List<? extends GenericValue<PsiClass>> getClasses() {
        SessionFactory sessionFactory;
        if (!this.mySupportsAnnotations) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringXmlHibernateSessionFactory.$$$reportNull$$$0(4);
            }
            return list;
        }
        SpringPropertyDefinition property = SpringPropertyUtils.findPropertyByName(this.getBean(), ANNOTATED_CLASSES);
        ArrayList result = new ArrayList();
        if (property instanceof SpringProperty) {
            SpringPropertyUtils.processSpringValues((SpringProperty)property, (PairProcessor<? super GenericDomValue, ? super String>)((PairProcessor)(domValue, s) -> {
                Object o = domValue.getValue();
                if (o instanceof PsiClass) {
                    result.add(domValue);
                } else {
                    Project project = this.getPsiManager().getProject();
                    PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(s, GlobalSearchScope.allScope((Project)project));
                    if (aClass != null) {
                        result.add(ReadOnlyGenericValue.getInstance((Object)aClass));
                    }
                }
                return true;
            }));
        }
        if ((sessionFactory = (SessionFactory)this.mySessionFactory.getValue()) != null) {
            result.addAll(sessionFactory.getModelHelper().getClasses());
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            SpringXmlHibernateSessionFactory.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<? extends GenericValue<PsiPackage>> getPackages() {
        if (!this.mySupportsAnnotations) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringXmlHibernateSessionFactory.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<GenericValue<PsiPackage>> result = new ArrayList<GenericValue<PsiPackage>>();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.getModule().getProject());
        Processor<PsiPackage> processor2 = this.getPackagesCollectProcessor(result);
        SpringPropertyDefinition annotatedPackagesProperty = SpringPropertyUtils.findPropertyByName(this.getBean(), ANNOTATED_PACKAGES);
        if (annotatedPackagesProperty instanceof SpringProperty) {
            SpringPropertyUtils.processSpringValues((SpringProperty)annotatedPackagesProperty, (PairProcessor<? super GenericDomValue, ? super String>)((PairProcessor)(genericDomValue, s) -> {
                SpringReferenceUtils.processSeparatedString(s, ",", (PairProcessor<? super String, ? super Integer>)((PairProcessor)(s1, integer) -> {
                    PsiPackage aPackage = psiFacade.findPackage(s1.trim());
                    if (aPackage != null) {
                        processor2.process((Object)aPackage);
                    }
                    return true;
                }));
                return true;
            }));
        }
        result.addAll(this.getPackagesToScan());
        SessionFactory sessionFactory = (SessionFactory)this.mySessionFactory.getValue();
        if (sessionFactory != null) {
            result.addAll(sessionFactory.getModelHelper().getPackages());
        }
        ArrayList<GenericValue<PsiPackage>> arrayList = result;
        if (arrayList == null) {
            SpringXmlHibernateSessionFactory.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public GenericValue<String> getDataSourceName() {
        SpringBeanPointer<?> springBean;
        SpringPropertyDefinition property = SpringPropertyUtils.findPropertyByName(this.getBean(), DATASOURCE);
        if (property != null && (springBean = SpringPropertyUtils.findReferencedBean(property)) != null) {
            String name = springBean.getName();
            return StringUtil.isNotEmpty((String)name) ? ReadOnlyGenericValue.getInstance((Object)name) : null;
        }
        return null;
    }

    @Override
    public Collection<Object> getCacheDependencies() {
        ArrayList<Object> dependencies = new ArrayList<Object>(super.getCacheDependencies());
        SessionFactory sessionFactory = (SessionFactory)this.mySessionFactory.getValue();
        PsiFile sessionFactoryFile = sessionFactory != null && sessionFactory.isValid() ? sessionFactory.getContainingFile() : null;
        ContainerUtil.addIfNotNull(dependencies, (Object)sessionFactoryFile);
        return dependencies;
    }

    @Override
    @NotNull
    protected CachedValueProvider.Result<Properties> getPersistenceUnitPropertiesInner() {
        Object[] objectArray;
        SpringPropertyDefinition property;
        Properties result = new Properties();
        SessionFactory sessionFactory = (SessionFactory)this.mySessionFactory.getValue();
        if (sessionFactory != null) {
            result.putAll((Map<?, ?>)sessionFactory.getModelHelper().getPersistenceUnitProperties());
        }
        if ((property = SpringPropertyUtils.findPropertyByName(this.getBean(), HIBERNATE_PROPERTIES)) instanceof SpringProperty) {
            Props props = ((SpringProperty)property).getProps();
            for (Prop prop : props.getProps()) {
                Collection<String> variants = PlaceholderUtils.getInstance().getValueVariants(prop);
                result.setProperty(HibernateUtil.getFullPropertyName((String)((String)prop.getKey().getValue())), variants.isEmpty() ? "" : variants.iterator().next());
            }
        }
        if (sessionFactory == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.getContainingFile();
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = this.getContainingFile();
            objectArray = objectArray3;
            objectArray3[1] = sessionFactory.getContainingFile();
        }
        Object[] dependencies = objectArray;
        return new CachedValueProvider.Result((Object)result, dependencies);
    }

    @Nullable
    private SessionFactory getSessionFactoryInner() {
        HibernateConfiguration element;
        Collection files;
        SpringPropertyDefinition configProperty = SpringPropertyUtils.findPropertyByName(this.getBean(), CONFIG_LOCATION);
        if (configProperty instanceof SpringProperty && !(files = SpringResourcesUtil.getInstance().getResourceItems((SpringProperty)configProperty, (Condition<PsiFileSystemItem>)FileReferenceSet.FILE_FILTER)).isEmpty() && (element = (HibernateConfiguration)JamCommonUtil.getRootElement((PsiFile)((PsiFile)files.iterator().next()), HibernateConfiguration.class)) != null) {
            return element.getSessionFactory();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/persistence/integration/hibernate/SpringXmlHibernateSessionFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "physical";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingResourcesProperties";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/persistence/integration/hibernate/SpringXmlHibernateSessionFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarFiles";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPsiClassPropertyValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

