/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.navigation;

import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.util.xml.model.gotosymbol.GoToSymbolProvider;
import com.intellij.xml.util.PsiElementPointer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class GotoSpringBeanProvider
extends GoToSymbolProvider {
    GotoSpringBeanProvider() {
    }

    protected void addNames(@NotNull Module module, Set<String> result) {
        if (module == null) {
            GotoSpringBeanProvider.$$$reportNull$$$0(0);
        }
        HashSet<String> names = new HashSet<String>();
        for (SpringModel springModel : GotoSpringBeanProvider.getModels(module)) {
            for (SpringBeanPointer<?> pointer : springModel.getAllCommonBeans()) {
                String name = pointer.getName();
                if (!StringUtil.isNotEmpty((String)name)) continue;
                names.add(name);
                for (String alias : pointer.getAliases()) {
                    if (!StringUtil.isNotEmpty((String)alias)) continue;
                    names.add(alias);
                }
            }
        }
        result.addAll(names);
    }

    protected void addItems(@NotNull Module module, String name, List<NavigationItem> result) {
        if (module == null) {
            GotoSpringBeanProvider.$$$reportNull$$$0(1);
        }
        for (SpringModel springModel : GotoSpringBeanProvider.getModels(module)) {
            for (PsiElementPointer psiElementPointer : SpringModelSearchers.findBeans((CommonSpringModel)springModel, name)) {
                PsiElement element = psiElementPointer.getPsiElement();
                if (!(element instanceof NavigationItem)) continue;
                result.add((NavigationItem)element);
            }
        }
    }

    protected boolean acceptModule(Module module) {
        return SpringCommonUtils.hasSpringFacet(module) || SpringModelUtils.getInstance().hasAutoConfiguredModels(module);
    }

    private static Set<SpringModel> getModels(Module module) {
        return SpringManager.getInstance(module.getProject()).getAllModelsWithoutDependencies(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "module";
        objectArray2[1] = "com/intellij/spring/navigation/GotoSpringBeanProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

