/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.custom;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.xml.AbstractDomSpringBean;
import com.intellij.spring.model.xml.CustomBean;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.custom.CustomBeanFakePsiElement;
import com.intellij.spring.model.xml.custom.CustomBeanInfo;
import com.intellij.spring.model.xml.custom.CustomBeanRegistry;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ReadOnlyGenericValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomNamespaceSpringBean
extends AbstractDomSpringBean
implements CustomBean {
    private static final Logger LOG = Logger.getInstance(CustomNamespaceSpringBean.class);
    private final CustomBeanInfo myInfo;
    private final Module myModule;
    private final XmlTag mySourceTag;
    private final PsiElement myFakePsi;
    private final CustomBeanWrapper myWrapper;
    private final XmlAttribute myIdAttribute;

    public CustomNamespaceSpringBean(@NotNull CustomBeanInfo info, Module module, @NotNull CustomBeanWrapper wrapper) {
        if (info == null) {
            CustomNamespaceSpringBean.$$$reportNull$$$0(0);
        }
        if (wrapper == null) {
            CustomNamespaceSpringBean.$$$reportNull$$$0(1);
        }
        this.myInfo = info;
        this.myModule = module;
        this.myWrapper = wrapper;
        XmlTag tag = wrapper.getXmlTag();
        if (tag == null) {
            LOG.error(String.valueOf(wrapper.getParent()));
        }
        this.mySourceTag = tag = CustomBeanRegistry.getActualSourceTag(info, tag);
        this.myIdAttribute = this.mySourceTag.getAttribute(info.idAttribute);
        this.myFakePsi = new CustomBeanFakePsiElement(this);
    }

    @Override
    @Nullable
    public XmlAttribute getIdAttribute() {
        return this.myIdAttribute;
    }

    @Override
    @Nullable
    public GenericValue<SpringBeanPointer<?>> getFactoryBean() {
        SpringBeanPointer<?> beanPointer;
        SpringModel model;
        String beanName = this.myInfo.factoryBeanName;
        if (beanName != null && (model = SpringManager.getInstance(this.getPsiManager().getProject()).getSpringModelByFile(this.getContainingFile())) != null && (beanPointer = SpringBeanUtils.getInstance().findBean(model, beanName)) != null) {
            return ReadOnlyGenericValue.getInstance(beanPointer);
        }
        return super.getFactoryBean();
    }

    @Override
    @NotNull
    public CustomBeanWrapper getWrapper() {
        CustomBeanWrapper customBeanWrapper = this.myWrapper;
        if (customBeanWrapper == null) {
            CustomNamespaceSpringBean.$$$reportNull$$$0(2);
        }
        return customBeanWrapper;
    }

    @Override
    @Nullable
    public GenericValue<PsiMethod> getFactoryMethod() {
        PsiMethod method;
        PsiClass beanClass;
        String name = this.myInfo.factoryMethodName;
        if (name != null && (beanClass = PsiTypesUtil.getPsiClass((PsiType)this.getBeanType(false))) != null && (method = this.findMatchingFactoryMethod(name, beanClass)) != null) {
            return ReadOnlyGenericValue.getInstance((Object)method);
        }
        return super.getFactoryMethod();
    }

    @Nullable
    private PsiMethod findMatchingFactoryMethod(String name, PsiClass beanClass) {
        PsiMethod result = null;
        Object returnType = null;
        int count = this.myInfo.constructorArgumentCount;
        for (PsiMethod method : beanClass.findMethodsByName(name, true)) {
            if (method.getParameterList().getParametersCount() != count || !method.hasModifierProperty("static")) continue;
            if (returnType == null) {
                result = method;
                returnType = method.getReturnType();
                continue;
            }
            if (returnType.equals(method.getReturnType())) continue;
            return null;
        }
        return result;
    }

    @Override
    @Nullable
    public String getBeanName() {
        return this.myInfo.beanName;
    }

    @Override
    public String @NotNull [] getAliases() {
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            CustomNamespaceSpringBean.$$$reportNull$$$0(3);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public boolean isValid() {
        return this.mySourceTag.isValid();
    }

    @Override
    @NotNull
    public XmlTag getXmlTag() {
        XmlTag xmlTag = this.mySourceTag;
        if (xmlTag == null) {
            CustomNamespaceSpringBean.$$$reportNull$$$0(4);
        }
        return xmlTag;
    }

    public PsiManager getPsiManager() {
        return this.mySourceTag.getManager();
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    @Nullable
    public PsiElement getIdentifyingPsiElement() {
        return this.myFakePsi;
    }

    @Override
    @NotNull
    public final PsiFile getContainingFile() {
        PsiFile psiFile = this.mySourceTag.getContainingFile();
        if (psiFile == null) {
            CustomNamespaceSpringBean.$$$reportNull$$$0(5);
        }
        return psiFile;
    }

    @Override
    @Nullable
    public String getClassName() {
        return this.myInfo.beanClassName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomNamespaceSpringBean that = (CustomNamespaceSpringBean)o;
        if (!this.myInfo.equals(that.myInfo)) {
            return false;
        }
        return this.myWrapper.equals(that.myWrapper);
    }

    public int hashCode() {
        int result = this.myInfo.hashCode();
        result = 31 * result + this.myWrapper.hashCode();
        return result;
    }

    @Override
    public Beans getBeansParent() {
        return (Beans)DomUtil.getParentOfType((DomElement)this.getWrapper(), Beans.class, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/xml/custom/CustomNamespaceSpringBean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/xml/custom/CustomNamespaceSpringBean";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliases";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlTag";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

