/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.beans.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringRef;
import com.intellij.spring.model.xml.beans.impl.SpringInjectionImpl;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringPropertyImpl
extends SpringInjectionImpl
implements SpringProperty {
    @Override
    public PsiType guessTypeByValue() {
        if (DomUtil.hasXml((DomElement)this.getValue())) {
            PsiType type = (PsiType)this.getValue().getType().getValue();
            return type != null ? type : this.getTypeByName(String.class.getCanonicalName());
        }
        if (DomUtil.hasXml((DomElement)this.getRefAttr())) {
            return SpringPropertyImpl.getPointerType((SpringBeanPointer)this.getRefAttr().getValue());
        }
        if (DomUtil.hasXml((DomElement)this.getBean())) {
            return SpringPropertyImpl.getPointerType(BeanService.getInstance().createSpringBeanPointer(this.getBean()));
        }
        if (DomUtil.hasXml((DomElement)this.getRef())) {
            SpringRef springRef = this.getRef();
            SpringBeanPointer beanPointer = (SpringBeanPointer)springRef.getBean().getValue();
            if (beanPointer != null) {
                return SpringPropertyImpl.getPointerType(beanPointer);
            }
            SpringBeanPointer localPointer = (SpringBeanPointer)springRef.getLocal().getValue();
            return localPointer != null ? SpringPropertyImpl.getPointerType(localPointer) : SpringPropertyImpl.getPointerType((SpringBeanPointer)springRef.getParentAttr().getValue());
        }
        if (DomUtil.hasXml((DomElement)this.getIdref())) {
            return this.getTypeByName(String.class.getCanonicalName());
        }
        if (DomUtil.hasXml((DomElement)this.getList())) {
            return this.getTypeByName(List.class.getCanonicalName());
        }
        if (DomUtil.hasXml((DomElement)this.getMap())) {
            return this.getTypeByName(Map.class.getCanonicalName());
        }
        if (DomUtil.hasXml((DomElement)this.getSet())) {
            return this.getTypeByName(Set.class.getCanonicalName());
        }
        if (DomUtil.hasXml((DomElement)this.getArray())) {
            PsiClass psiClass = (PsiClass)this.getArray().getValueType().getValue();
            if (psiClass != null) {
                return PsiTypesUtil.getClassType((PsiClass)psiClass).createArrayType();
            }
            PsiType objectType = this.getTypeByName("java.lang.Object");
            return objectType != null ? objectType.createArrayType() : null;
        }
        if (DomUtil.hasXml((DomElement)this.getProps())) {
            return this.getTypeByName(Properties.class.getCanonicalName());
        }
        if (DomUtil.hasXml((DomElement)this.getNull())) {
            return PsiType.NULL;
        }
        return null;
    }

    @Nullable
    private PsiType getTypeByName(String name) {
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.getManager().getProject());
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.getManager().getProject()).findClass(name, scope);
        return psiClass != null ? PsiTypesUtil.getClassType((PsiClass)psiClass) : null;
    }

    @Nullable
    private static PsiType getPointerType(@Nullable SpringBeanPointer<?> pointer) {
        if (pointer == null) {
            return null;
        }
        PsiType[] psiTypes = pointer.getEffectiveBeanTypes();
        return psiTypes.length == 0 ? null : psiTypes[0];
    }

    @Override
    @NotNull
    public List<PsiType> getRequiredTypes() {
        List properties = (List)this.getName().getValue();
        if (properties == null || properties.isEmpty()) {
            List<PsiType> list = Collections.emptyList();
            if (list == null) {
                SpringPropertyImpl.$$$reportNull$$$0(0);
            }
            return list;
        }
        SmartList list = new SmartList();
        for (BeanProperty property : properties) {
            PsiClass superClass;
            PsiClass derivedClass;
            DomSpringBean bean;
            PsiType psiType = property.getPropertyType();
            if (psiType instanceof PsiClassReferenceType && (bean = (DomSpringBean)this.getParentOfType(DomSpringBean.class, false)) != null && (derivedClass = PsiTypesUtil.getPsiClass((PsiType)bean.getBeanType())) != null && (superClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)property.getMethod(), PsiClass.class)) != null && derivedClass.isInheritor(superClass, true)) {
                PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)derivedClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                psiType = superClassSubstitutor.substitute(psiType);
            }
            list.add(psiType);
        }
        SmartList smartList = list;
        if (smartList == null) {
            SpringPropertyImpl.$$$reportNull$$$0(1);
        }
        return smartList;
    }

    @Override
    @NonNls
    @Nullable
    public String getPropertyName() {
        return this.getName().getRawText();
    }

    public int hashCode() {
        String name = this.getPropertyName();
        return name == null ? 0 : name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof SpringProperty && ComparatorUtil.equalsNullable((Object)this.getPropertyName(), (Object)((SpringProperty)obj).getPropertyName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/SpringPropertyImpl", "getRequiredTypes"));
    }
}

