/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.PropertiesCompletionContributor;
import com.intellij.lang.properties.references.PropertiesPsiCompletionUtil;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.values.PlaceholderPropertyReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class PlaceholderPropertyCompletionContributor
extends CompletionContributor {
    public PlaceholderPropertyCompletionContributor() {
        this.extend(null, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                PlaceholderPropertyCompletionContributor.doAdd(parameters, result);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/spring/model/values/PlaceholderPropertyCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void doAdd(CompletionParameters parameters, CompletionResultSet result) {
        TextRange range;
        PsiElement element;
        int startOffset;
        int offsetInElement;
        PsiElement position = parameters.getPosition();
        if (!SpringCommonUtils.hasSpringFacets(position.getProject())) {
            return;
        }
        Optional injectionHostOpt = ((StreamEx)StreamEx.iterate((Object)position.getParent(), Objects::nonNull, PsiElement::getParent).limit(3L)).select(PsiLanguageInjectionHost.class).findFirst();
        Object[] references = injectionHostOpt.map(host -> (PsiReference[])ArrayUtil.mergeArrays((Object[])position.getReferences(), (Object[])host.getReferences())).orElseGet(() -> ((PsiElement)position).getReferences());
        PlaceholderPropertyReference propertyReference = (PlaceholderPropertyReference)((Object)ContainerUtil.findInstance((Object[])references, PlaceholderPropertyReference.class));
        if (propertyReference != null && !ContainerUtil.or((Object[])references, reference -> !reference.isSoft()) && (offsetInElement = (startOffset = parameters.getOffset()) - (element = propertyReference.getElement()).getTextRange().getStartOffset()) >= (range = propertyReference.getRangeInElement()).getStartOffset()) {
            String prefix = element.getText().substring(range.getStartOffset(), offsetInElement);
            LookupElement[] variants = PlaceholderPropertyCompletionContributor.getVariants(propertyReference);
            result.withPrefixMatcher(prefix).addAllElements(Arrays.asList(variants));
            if (variants.length != 0) {
                result.stopHere();
            }
        }
    }

    private static LookupElement @NotNull [] getVariants(@NotNull PlaceholderPropertyReference propertyReference) {
        if (propertyReference == null) {
            PlaceholderPropertyCompletionContributor.$$$reportNull$$$0(0);
        }
        HashSet<String> variants = new HashSet<String>();
        Processor processor2 = propertiesFile -> {
            PropertiesPsiCompletionUtil.addVariantsFromFile((PropertyReferenceBase)propertyReference, (PropertiesFile)propertiesFile, (Set)variants);
            return true;
        };
        CommonSpringModel springModel = SpringModelUtils.getInstance().getSpringModel(propertyReference.getElement());
        List<SpringBeanPointer<?>> placeholders = propertyReference.getPlaceholders(springModel);
        PlaceholderPropertyReference.processXmlProperties((Processor<? super PropertiesFile>)processor2, placeholders);
        PlaceholderPropertyReference.processEmbeddedPropertySources((Processor<? super PropertiesFile>)processor2, springModel);
        for (String key : PlaceholderPropertyReference.getAllPlaceholderConfigurerProperties(placeholders).keySet()) {
            if (StringUtil.isEmptyOrSpaces((String)key)) continue;
            variants.add(key);
        }
        PlaceholderPropertyReference.processCommonModel(propertyReference.getElement().getProject(), (Processor<? super PropertiesFile>)processor2, springModel);
        LookupElement[] lookupElementArray = PropertiesCompletionContributor.getVariants(variants);
        if (lookupElementArray == null) {
            PlaceholderPropertyCompletionContributor.$$$reportNull$$$0(1);
        }
        return lookupElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/values/PlaceholderPropertyCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/values/PlaceholderPropertyCompletionContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

