/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.spring.model.SpringModelSearchParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBeanSearchParameters {
    @NotNull
    private final Project myProject;
    private GlobalSearchScope myScope;
    @Nullable
    private VirtualFile myVirtualFile;

    protected SpringBeanSearchParameters(@NotNull Project project) {
        if (project == null) {
            SpringBeanSearchParameters.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            SpringBeanSearchParameters.$$$reportNull$$$0(1);
        }
        return project;
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope globalSearchScope = this.myScope == null ? GlobalSearchScope.allScope((Project)this.getProject()) : this.myScope;
        if (globalSearchScope == null) {
            SpringBeanSearchParameters.$$$reportNull$$$0(2);
        }
        return globalSearchScope;
    }

    public void setSearchScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringBeanSearchParameters.$$$reportNull$$$0(3);
        }
        this.myScope = scope;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    public void setVirtualFile(@Nullable VirtualFile virtualFile) {
        this.myVirtualFile = virtualFile;
    }

    public static BeanClass byClass(@NotNull Project project, @NotNull SpringModelSearchParameters.BeanClass parameters) {
        if (project == null) {
            SpringBeanSearchParameters.$$$reportNull$$$0(4);
        }
        if (parameters == null) {
            SpringBeanSearchParameters.$$$reportNull$$$0(5);
        }
        return new BeanClass(project, parameters);
    }

    @NotNull
    public static BeanName byName(@NotNull Project project, @NotNull String beanName) {
        if (project == null) {
            SpringBeanSearchParameters.$$$reportNull$$$0(6);
        }
        if (beanName == null) {
            SpringBeanSearchParameters.$$$reportNull$$$0(7);
        }
        return new BeanName(project, SpringModelSearchParameters.byName(beanName));
    }

    @NotNull
    public static BeanName byName(@NotNull Project project, @NotNull SpringModelSearchParameters.BeanName parameters) {
        if (project == null) {
            SpringBeanSearchParameters.$$$reportNull$$$0(8);
        }
        if (parameters == null) {
            SpringBeanSearchParameters.$$$reportNull$$$0(9);
        }
        return new BeanName(project, parameters);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/utils/search/SpringBeanSearchParameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/utils/search/SpringBeanSearchParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSearchScope";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "byClass";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "byName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class BeanName
    extends SpringBeanSearchParameters {
        @NotNull
        private final SpringModelSearchParameters.BeanName myParameters;

        private BeanName(@NotNull Project project, @NotNull SpringModelSearchParameters.BeanName parameters) {
            if (project == null) {
                BeanName.$$$reportNull$$$0(0);
            }
            if (parameters == null) {
                BeanName.$$$reportNull$$$0(1);
            }
            super(project);
            this.myParameters = parameters;
        }

        @NotNull
        public String getBeanName() {
            String string = this.myParameters.getBeanName();
            if (string == null) {
                BeanName.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/utils/search/SpringBeanSearchParameters$BeanName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/utils/search/SpringBeanSearchParameters$BeanName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBeanName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class BeanClass
    extends SpringBeanSearchParameters {
        @NotNull
        private final SpringModelSearchParameters.BeanClass myParameters;

        private BeanClass(@NotNull Project project, @NotNull SpringModelSearchParameters.BeanClass parameters) {
            if (project == null) {
                BeanClass.$$$reportNull$$$0(0);
            }
            if (parameters == null) {
                BeanClass.$$$reportNull$$$0(1);
            }
            super(project);
            this.myParameters = parameters;
        }

        public boolean matchesClass(@Nullable PsiType psiType) {
            if (psiType == null || !psiType.isValid() || TypeConversionUtil.isNullType((PsiType)psiType)) {
                return false;
            }
            return this.getPsiType().isAssignableFrom(psiType);
        }

        @NotNull
        public PsiType getPsiType() {
            PsiType psiType = this.myParameters.getSearchType();
            if (psiType == null) {
                BeanClass.$$$reportNull$$$0(2);
            }
            return psiType;
        }

        public boolean isWithInheritors() {
            return this.myParameters.isWithInheritors();
        }

        public boolean isEffectiveBeanTypes() {
            return this.myParameters.isEffectiveBeanTypes();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/utils/search/SpringBeanSearchParameters$BeanClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/utils/search/SpringBeanSearchParameters$BeanClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPsiType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

