/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.constants.SpringAnnotationsConstants;
import com.intellij.spring.contexts.model.CombinedSpringModel;
import com.intellij.spring.contexts.model.CombinedSpringModelImpl;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringConditional;
import com.intellij.spring.model.SpringImplicitBeanMarker;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.SpringObjectFactoryEffectiveTypeProvider;
import com.intellij.spring.model.aliasFor.SpringAliasForUtils;
import com.intellij.spring.model.highlighting.xml.SpringConstructorArgResolveUtil;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.contexts.CustomContextJavaBean;
import com.intellij.spring.model.jam.qualifiers.SpringJamQualifier;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.model.utils.ExplicitRedefinitionAwareBeansCollector;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringConstructorArgUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.Autowire;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.ConstructorArgDefinition;
import com.intellij.spring.model.xml.beans.DefaultableBoolean;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.references.SpringBeanReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringAutowireUtil {
    private static final Set<String> AUTOWIRED_ANNOTATIONS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("org.springframework.beans.factory.annotation.Autowired", "javax.inject.Inject", "javax.annotation.Resource")));
    @NonNls
    private static final Set<String> STANDARD_AUTOWIRED_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"org.springframework.beans.factory.BeanFactory", "org.springframework.context.ApplicationContext", "org.springframework.context.ApplicationEventPublisher", "org.springframework.context.MessageSource", "org.springframework.core.io.ResourceLoader", "org.springframework.core.env.Environment"});

    private SpringAutowireUtil() {
    }

    public static Map<PsiMethod, Collection<SpringBeanPointer<?>>> getByTypeAutowiredProperties(SpringBean springBean, CommonSpringModel model) {
        HashMap autowiredMap = new HashMap();
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (beanClass != null && model != null && SpringAutowireUtil.isByTypeAutowired(springBean)) {
            for (PsiMethod psiMethod : beanClass.getAllMethods()) {
                if (!SpringAutowireUtil.isPropertyAutowired(psiMethod, springBean)) continue;
                PsiParameter parameter = psiMethod.getParameterList().getParameters()[0];
                HashSet list = new HashSet();
                PsiAnnotation qualifiedAnnotation = SpringAutowireUtil.getQualifiedAnnotation((PsiModifierListOwner)psiMethod);
                if (qualifiedAnnotation != null) {
                    list.addAll(SpringAutowireUtil.getQualifiedBeans(qualifiedAnnotation, model));
                } else {
                    list.addAll(SpringAutowireUtil.autowireByType(model, parameter.getType(), parameter.getName()));
                    list.addAll(SpringAutowireUtil.autowireByType(model, SpringAutowireUtil.getAutowiredEffectiveBeanTypes(parameter.getType()), parameter.getName()));
                }
                if (list.size() <= 0) continue;
                autowiredMap.put(psiMethod, list);
            }
        }
        return autowiredMap;
    }

    @NotNull
    public static Set<SpringBeanPointer<?>> excludeAutowireCandidates(@NotNull Collection<SpringBeanPointer<?>> beans, @Nullable CommonSpringModel model) {
        if (beans == null) {
            SpringAutowireUtil.$$$reportNull$$$0(0);
        }
        return SpringAutowireUtil.excludeAutowireCandidates(beans, null, model);
    }

    @NotNull
    public static Set<SpringBeanPointer<?>> excludeAutowireCandidates(@NotNull Collection<SpringBeanPointer<?>> beans, @Nullable String primaryCandidateName, @Nullable CommonSpringModel model) {
        Collection<SpringBeanPointer<?>> primaryBeans;
        if (beans == null) {
            SpringAutowireUtil.$$$reportNull$$$0(1);
        }
        LinkedHashSet pointers = new LinkedHashSet();
        Collection<SpringBeanPointer<?>> collection = primaryBeans = beans.size() > 1 ? SpringAutowireUtil.getPrimaryBeans(beans, primaryCandidateName, model) : beans;
        if (!primaryBeans.isEmpty()) {
            for (SpringBeanPointer<?> primaryBean : primaryBeans) {
                if (!SpringAutowireUtil.isAutowireCandidate(primaryBean)) continue;
                pointers.add(primaryBean);
            }
            LinkedHashSet linkedHashSet = pointers;
            if (linkedHashSet == null) {
                SpringAutowireUtil.$$$reportNull$$$0(2);
            }
            return linkedHashSet;
        }
        for (SpringBeanPointer<?> beanPointer : beans) {
            if (!SpringAutowireUtil.isAutowireCandidate(beanPointer)) continue;
            pointers.add(beanPointer);
        }
        LinkedHashSet linkedHashSet = pointers;
        if (linkedHashSet == null) {
            SpringAutowireUtil.$$$reportNull$$$0(3);
        }
        return linkedHashSet;
    }

    @NotNull
    private static List<SpringBeanPointer<?>> getPrimaryBeans(@NotNull Collection<? extends SpringBeanPointer<?>> beans, @Nullable String primaryCandidateName, @Nullable CommonSpringModel model) {
        if (beans == null) {
            SpringAutowireUtil.$$$reportNull$$$0(4);
        }
        if (primaryCandidateName == null) {
            List<SpringBeanPointer<?>> list = SpringAutowireUtil.emptyList();
            if (list == null) {
                SpringAutowireUtil.$$$reportNull$$$0(5);
            }
            return list;
        }
        SmartList byPrimary = new SmartList();
        SmartList byName = new SmartList();
        for (SpringBeanPointer<?> springBeanPointer : beans) {
            if (!springBeanPointer.isValid()) continue;
            Object springBean = springBeanPointer.getSpringBean();
            if (springBean.isPrimary()) {
                if (SpringAutowireUtil.isMyName(primaryCandidateName, springBeanPointer, model)) {
                    List<SpringBeanPointer<?>> list = Collections.singletonList(springBeanPointer);
                    if (list == null) {
                        SpringAutowireUtil.$$$reportNull$$$0(6);
                    }
                    return list;
                }
                byPrimary.add(springBeanPointer);
                continue;
            }
            if (!SpringAutowireUtil.isMyName(primaryCandidateName, springBeanPointer, model)) continue;
            byName.add(springBeanPointer);
        }
        SmartList smartList = byPrimary.isEmpty() ? byName : byPrimary;
        if (smartList == null) {
            SpringAutowireUtil.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    private static boolean isMyName(@Nullable String name, @NotNull SpringBeanPointer<?> springBeanPointer, @Nullable CommonSpringModel model) {
        if (springBeanPointer == null) {
            SpringAutowireUtil.$$$reportNull$$$0(8);
        }
        if (name == null) {
            return false;
        }
        String beanName = springBeanPointer.getName();
        if (name.equals(beanName)) {
            return true;
        }
        if (beanName != null && model != null) {
            for (String aliasName : SpringModelVisitorUtils.getAllBeanNames(model, springBeanPointer)) {
                if (!name.equals(aliasName)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isAutowireCandidate(@Nullable SpringBeanPointer<?> pointer) {
        if (pointer == null || !pointer.isValid()) {
            return false;
        }
        Object springBean = pointer.getSpringBean();
        if (!(springBean instanceof SpringBean)) {
            return true;
        }
        if (((SpringBean)springBean).isAbstract()) {
            return false;
        }
        DefaultableBoolean autoWireCandidate = (DefaultableBoolean)((Object)((SpringBean)springBean).getAutowireCandidate().getValue());
        return (autoWireCandidate == null || autoWireCandidate.getBooleanValue() != false) && SpringAutowireUtil.isDefaultAutowireCandidate(springBean);
    }

    private static boolean isDefaultAutowireCandidate(CommonSpringBean springBean) {
        String autowireCandidates;
        Beans beans;
        if (springBean instanceof SpringBean && (beans = (Beans)((SpringBean)springBean).getParentOfType(Beans.class, false)) != null && StringUtil.isNotEmpty((String)(autowireCandidates = (String)beans.getDefaultAutowireCandidates().getValue()))) {
            String beanName = springBean.getBeanName();
            String[] aliases = springBean.getAliases();
            for (String patternText : StringUtil.split((String)autowireCandidates, (String)",")) {
                Pattern pattern = Pattern.compile(FileUtil.convertAntToRegexp((String)patternText.trim()));
                if (SpringAutowireUtil.isMatched(pattern, beanName)) {
                    return true;
                }
                for (String alias : aliases) {
                    if (!SpringAutowireUtil.isMatched(pattern, alias)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static boolean isMatched(Pattern pattern, @Nullable String beanName) {
        return beanName != null && pattern.matcher(beanName).matches();
    }

    public static Map<PsiType, Collection<SpringBeanPointer<?>>> getConstructorAutowiredProperties(SpringBean springBean, CommonSpringModel model) {
        HashMap autowiredMap = new HashMap();
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (beanClass != null && SpringAutowireUtil.isConstructorAutowire(springBean)) {
            PsiMethod checkedMethod;
            boolean instantiatedByFactory = SpringConstructorArgResolveUtil.isInstantiatedByFactory(springBean);
            PsiMethod psiMethod = checkedMethod = instantiatedByFactory ? (PsiMethod)springBean.getFactoryMethod().getValue() : SpringConstructorArgUtils.getInstance().getSpringBeanConstructor(springBean, model);
            if (checkedMethod != null) {
                List<ConstructorArg> list = springBean.getConstructorArgs();
                Map<Integer, ConstructorArg> indexedArgs = SpringConstructorArgResolveUtil.getIndexedConstructorArgs(list);
                PsiParameter[] parameters = checkedMethod.getParameterList().getParameters();
                SmartList usedArgs = new SmartList();
                for (int i = 0; i < parameters.length; ++i) {
                    Set<SpringBeanPointer<?>> springBeans;
                    PsiParameter parameter = parameters[i];
                    if (SpringConstructorArgResolveUtil.acceptParameter(parameter, new ArrayList<ConstructorArg>(springBean.getConstructorArgs()), indexedArgs, i, (Collection<? super ConstructorArgDefinition>)usedArgs)) continue;
                    PsiType psiType = parameter.getType();
                    PsiAnnotation qualifiedAnnotation = SpringAutowireUtil.getQualifiedAnnotation((PsiModifierListOwner)parameter);
                    Set<SpringBeanPointer<?>> set = springBeans = qualifiedAnnotation != null ? SpringAutowireUtil.getQualifiedBeans(qualifiedAnnotation, model) : SpringAutowireUtil.autowireByType(model, SpringAutowireUtil.getAutowiredEffectiveBeanTypes(psiType));
                    if (springBeans.isEmpty()) continue;
                    autowiredMap.put(psiType, springBeans);
                }
            }
        }
        return autowiredMap;
    }

    public static boolean isPropertyDefined(SpringBean springBean, String propertyName) {
        return springBean.getProperty(propertyName) != null;
    }

    public static Map<PsiMethod, SpringBeanPointer<?>> getByNameAutowiredProperties(SpringBean springBean) {
        HashMap autowiredMap = new HashMap();
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (beanClass != null) {
            CommonSpringModel model = SpringModelUtils.getInstance().getSpringModelByBean(springBean);
            if (SpringAutowireUtil.isByNameAutowired(springBean)) {
                for (PsiMethod psiMethod : beanClass.getAllMethods()) {
                    if (!PropertyUtilBase.isSimplePropertySetter((PsiMethod)psiMethod)) continue;
                    PsiParameter parameter = psiMethod.getParameterList().getParameters()[0];
                    Set<SpringBeanPointer<?>> list = SpringAutowireUtil.autowireByType(model, SpringAutowireUtil.getAutowiredEffectiveBeanTypes(parameter.getType()));
                    String propertyName = PropertyUtilBase.getPropertyNameBySetter((PsiMethod)psiMethod);
                    for (SpringBeanPointer springBeanPointer : list) {
                        if (!springBeanPointer.isValid() || !SpringBeanUtils.getInstance().findBeanNames((CommonSpringBean)springBeanPointer.getSpringBean()).contains(propertyName) || SpringAutowireUtil.isPropertyDefined(springBean, propertyName)) continue;
                        autowiredMap.put(psiMethod, springBeanPointer);
                    }
                }
            }
        }
        return autowiredMap;
    }

    private static boolean isPropertyAutowired(PsiMethod psiMethod, SpringBean springBean) {
        PsiParameter parameter;
        PsiType psiType;
        if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)psiMethod) && (psiType = (parameter = psiMethod.getParameterList().getParameters()[0]).getType()) instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            return psiClass != null && !SpringAutowireUtil.isPropertyDefined(springBean, PropertyUtilBase.getPropertyNameBySetter((PsiMethod)psiMethod));
        }
        return false;
    }

    public static boolean isByTypeAutowired(SpringBean springBean) {
        return springBean.getBeanAutowire().equals((Object)Autowire.BY_TYPE);
    }

    public static boolean isByNameAutowired(SpringBean springBean) {
        return springBean.getBeanAutowire().equals((Object)Autowire.BY_NAME);
    }

    public static boolean isConstructorAutowire(SpringBean springBean) {
        return springBean.getBeanAutowire().equals((Object)Autowire.CONSTRUCTOR);
    }

    public static Map<PsiMember, Set<SpringBeanPointer<?>>> getAutowireAnnotationProperties(CommonSpringBean springBean, @NotNull CommonSpringModel model) {
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(9);
        }
        HashMap map = new HashMap();
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (beanClass != null) {
            for (PsiMethod psiMethod : SpringAutowireUtil.getAnnotatedAutowiredMethods(beanClass)) {
                for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                    PsiAnnotation psiAnnotation = SpringAutowireUtil.getQualifiedAnnotation((PsiModifierListOwner)parameter);
                    if (psiAnnotation != null) {
                        SpringAutowireUtil.addAutowiredBeans(map, (PsiMember)psiMethod, SpringAutowireUtil.getQualifiedBeans(psiAnnotation, model), model);
                        continue;
                    }
                    SpringAutowireUtil.addAutowiredBeans(map, (PsiMember)psiMethod, SpringBeanCoreUtils.getBeansByType(parameter.getType(), model), model);
                }
            }
            for (PsiField psiField : SpringAutowireUtil.getAnnotatedAutowiredFields(beanClass)) {
                PsiAnnotation psiAnnotation = SpringAutowireUtil.getQualifiedAnnotation((PsiModifierListOwner)psiField);
                if (psiAnnotation != null) {
                    SpringAutowireUtil.addAutowiredBeans(map, (PsiMember)psiField, SpringAutowireUtil.getQualifiedBeanPointers(psiAnnotation, model), model);
                    continue;
                }
                SpringAutowireUtil.addAutowiredBeans(map, (PsiMember)psiField, SpringAutowireUtil.getAutowiredBeansFor((PsiModifierListOwner)psiField, psiField.getType(), model), model);
            }
        }
        return map;
    }

    private static void addAutowiredBeans(@NotNull Map<PsiMember, Set<SpringBeanPointer<?>>> map, @NotNull PsiMember psiMember, @NotNull Collection<SpringBeanPointer<?>> beans, CommonSpringModel model) {
        Set<SpringBeanPointer<?>> list;
        if (map == null) {
            SpringAutowireUtil.$$$reportNull$$$0(10);
        }
        if (psiMember == null) {
            SpringAutowireUtil.$$$reportNull$$$0(11);
        }
        if (beans == null) {
            SpringAutowireUtil.$$$reportNull$$$0(12);
        }
        if (!(list = SpringAutowireUtil.excludeAutowireCandidates(beans, null, model)).isEmpty()) {
            if (!map.containsKey(psiMember)) {
                map.put(psiMember, list);
            } else {
                map.get(psiMember).addAll(list);
            }
        }
    }

    @NotNull
    public static Set<SpringBeanPointer<?>> getQualifiedBeans(@NotNull PsiAnnotation psiAnnotation, @Nullable CommonSpringModel model) {
        if (psiAnnotation == null) {
            SpringAutowireUtil.$$$reportNull$$$0(13);
        }
        if (model == null) {
            Set<SpringBeanPointer<?>> set = Collections.emptySet();
            if (set == null) {
                SpringAutowireUtil.$$$reportNull$$$0(14);
            }
            return set;
        }
        SpringJamQualifier qualifier = SpringAutowireUtil.getQualifier(null, psiAnnotation);
        Set<SpringBeanPointer<?>> set = SpringModelVisitorUtils.findQualifiedBeans(model, qualifier);
        if (set == null) {
            SpringAutowireUtil.$$$reportNull$$$0(15);
        }
        return set;
    }

    @Nullable
    public static PsiAnnotation getQualifiedAnnotation(@NotNull PsiModifierListOwner modifierListOwner) {
        if (modifierListOwner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(16);
        }
        return SpringAutowireUtil.getQualifiedAnnotation(modifierListOwner, ModuleUtilCore.findModuleForPsiElement((PsiElement)modifierListOwner));
    }

    @Nullable
    private static PsiAnnotation getQualifiedAnnotation(@NotNull PsiModifierListOwner modifierListOwner, @Nullable Module module) {
        PsiMethod psiMethod;
        if (modifierListOwner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(17);
        }
        if (module == null) {
            return null;
        }
        JamAnnotationTypeUtil jamAnnotationTypeUtil = JamAnnotationTypeUtil.getInstance(module);
        List<PsiClass> annotationTypeClasses = jamAnnotationTypeUtil.getQualifierAnnotationTypesWithChildren();
        for (PsiClass annotationTypeClass : annotationTypeClasses) {
            PsiAnnotation annotation;
            if (!(modifierListOwner instanceof PsiField && AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationTypeClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.FIELD}) != null || modifierListOwner instanceof PsiParameter && AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationTypeClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PARAMETER}) != null) && (!(modifierListOwner instanceof PsiMethod) || AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationTypeClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.METHOD}) == null) || (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)modifierListOwner, (boolean)true, (String[])new String[]{annotationTypeClass.getQualifiedName()})) == null) continue;
            return annotation;
        }
        if (modifierListOwner instanceof PsiParameter && (psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)modifierListOwner, PsiMethod.class)) != null && SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiMethod)) {
            for (PsiClass annotationTypeClass : annotationTypeClasses) {
                PsiAnnotation annotation;
                if (AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationTypeClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.METHOD}) == null || (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiMethod, (boolean)true, (String[])new String[]{annotationTypeClass.getQualifiedName()})) == null) continue;
                return annotation;
            }
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation getAutowiredAnnotation(@NotNull PsiModifierListOwner owner) {
        PsiModifierList modifierList;
        if (owner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(18);
        }
        if ((modifierList = owner.getModifierList()) != null) {
            for (String annotation : AUTOWIRED_ANNOTATIONS) {
                PsiAnnotation autowireAnnotation = modifierList.findAnnotation(annotation);
                if (autowireAnnotation == null) continue;
                return autowireAnnotation;
            }
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation getResourceAnnotation(@NotNull PsiModifierListOwner owner) {
        PsiModifierList modifierList;
        if (owner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(19);
        }
        if ((modifierList = owner.getModifierList()) != null) {
            return modifierList.findAnnotation("javax.annotation.Resource");
        }
        return null;
    }

    public static boolean isAutowiredByAnnotation(@NotNull PsiModifierListOwner owner) {
        PsiModifierList modifierList;
        if (owner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(20);
        }
        if ((modifierList = owner.getModifierList()) == null || modifierList.hasModifierProperty("static") || modifierList.getAnnotations().length == 0) {
            return false;
        }
        Set<String> autowireAnnotations = SpringAutowireUtil.getAutowiredAnnotations(ModuleUtilCore.findModuleForPsiElement((PsiElement)owner));
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, autowireAnnotations, (int)0);
    }

    public static boolean isInjectionPoint(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            SpringAutowireUtil.$$$reportNull$$$0(21);
        }
        boolean hasParameters = psiMethod.getParameterList().getParametersCount() != 0;
        return hasParameters && SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiMethod) || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"org.springframework.context.annotation.Bean", (int)1) || SpringAutowireUtil.isCustomStereotypeBean(psiMethod) || hasParameters && SpringAutowireUtil.isDefaultStereotypeComponentConstructor(psiMethod);
    }

    public static boolean isDefaultStereotypeComponentConstructor(@NotNull PsiMethod method) {
        if (method == null) {
            SpringAutowireUtil.$$$reportNull$$$0(22);
        }
        if (!method.isConstructor()) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        return containingClass != null && containingClass.getConstructors().length == 1 && SpringCommonUtils.isStereotypeComponentOrMeta(containingClass);
    }

    public static boolean isCustomStereotypeBean(@NotNull PsiMethod method) {
        if (method == null) {
            SpringAutowireUtil.$$$reportNull$$$0(23);
        }
        return JamService.getJamService((Project)method.getProject()).getJamElement(CustomContextJavaBean.JAM_KEY, (PsiElement)method) != null;
    }

    public static boolean isRequired(@NotNull PsiModifierListOwner owner) {
        PsiModifierList modifierList;
        if (owner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(24);
        }
        if ((modifierList = owner.getModifierList()) != null) {
            PsiAnnotation required = modifierList.findAnnotation("org.springframework.beans.factory.annotation.Required");
            if (required != null) {
                return true;
            }
            PsiAnnotation autowiredAnnotation = SpringAutowireUtil.getAutowiredAnnotation(owner);
            if (autowiredAnnotation != null) {
                Boolean value = (Boolean)JamCommonUtil.getObjectValue((PsiElement)autowiredAnnotation.findAttributeValue("required"), Boolean.class);
                return value == null || value != false;
            }
        }
        return true;
    }

    @NotNull
    public static List<PsiMethod> getAnnotatedAutowiredMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringAutowireUtil.$$$reportNull$$$0(25);
        }
        SmartList methods = new SmartList();
        for (PsiMethod psiMethod : psiClass.getAllMethods()) {
            if (!SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiMethod)) continue;
            methods.add(psiMethod);
        }
        SmartList smartList = methods;
        if (smartList == null) {
            SpringAutowireUtil.$$$reportNull$$$0(26);
        }
        return smartList;
    }

    @NotNull
    public static List<PsiField> getAnnotatedAutowiredFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringAutowireUtil.$$$reportNull$$$0(27);
        }
        SmartList fields = new SmartList();
        for (PsiField psiField : psiClass.getAllFields()) {
            if (!SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiField)) continue;
            fields.add(psiField);
        }
        SmartList smartList = fields;
        if (smartList == null) {
            SpringAutowireUtil.$$$reportNull$$$0(28);
        }
        return smartList;
    }

    @NotNull
    public static Set<SpringBeanPointer<?>> autowireByType(@NotNull CommonSpringModel model, PsiType psiType) {
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(29);
        }
        return SpringAutowireUtil.autowireByType(model, psiType, null);
    }

    @NotNull
    public static Set<SpringBeanPointer<?>> autowireByType(@NotNull CommonSpringModel model, PsiType psiType, @Nullable String primaryCandidateName) {
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(30);
        }
        return SpringAutowireUtil.autowireByType(model, psiType, primaryCandidateName, true);
    }

    @NotNull
    public static Set<SpringBeanPointer<?>> autowireByType(@NotNull CommonSpringModel model, PsiType psiType, @Nullable String primaryCandidateName, boolean filterByGenerics) {
        PsiClass psiClass;
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(31);
        }
        if ((psiClass = PsiTypesUtil.getPsiClass((PsiType)psiType)) != null && psiClass.getQualifiedName() == null) {
            Set<SpringBeanPointer<?>> set = Collections.emptySet();
            if (set == null) {
                SpringAutowireUtil.$$$reportNull$$$0(32);
            }
            return set;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byType(psiType).withInheritors().effectiveBeanTypes();
        List<SpringBeanPointer<?>> beans = SpringModelSearchers.findBeans(model, searchParameters);
        if (beans.size() == 0 && psiType instanceof PsiClassType) {
            beans = SpringAutowireUtil.findWildcardInjectedBeans(model, (PsiClassType)psiType);
            filterByGenerics = false;
        }
        Set<SpringBeanPointer<?>> pointers = SpringAutowireUtil.excludeAutowireCandidates(beans, primaryCandidateName, model);
        pointers = SpringAutowireUtil.excludeOverridenDefaultBeans(pointers);
        pointers = SpringAutowireUtil.excludeTheSameIdentifyingElements(pointers);
        pointers = SpringAutowireUtil.excludeExplicitlyRedefined(pointers);
        pointers = SpringAutowireUtil.filterByPriority(pointers, model.getModule());
        pointers = SpringCommonUtils.filterInnerClassBeans(pointers);
        Set<SpringBeanPointer<?>> set = filterByGenerics ? SpringAutowireUtil.filterByGenerics(pointers, psiType) : pointers;
        if (set == null) {
            SpringAutowireUtil.$$$reportNull$$$0(33);
        }
        return set;
    }

    private static List<SpringBeanPointer<?>> findWildcardInjectedBeans(@NotNull CommonSpringModel model, @NotNull PsiClassType psiType) {
        PsiClass psiClass;
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(34);
        }
        if (psiType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(35);
        }
        if ((psiClass = psiType.resolve()) == null) {
            return SpringAutowireUtil.emptyList();
        }
        List<SpringBeanPointer<?>> beansByClass = SpringModelSearchers.findBeans(model, SpringModelSearchParameters.byClass(psiClass).withInheritors().effectiveBeanTypes());
        return ContainerUtil.filter(beansByClass, pointer -> SpringAutowireUtil.isAssignableWildcardTypeBean(psiType, pointer));
    }

    private static boolean isAssignableWildcardTypeBean(@NotNull PsiClassType searchType, SpringBeanPointer<?> bean) {
        if (searchType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(36);
        }
        return Arrays.stream(bean.getEffectiveBeanTypes()).filter(PsiClassType.class::isInstance).filter(type -> ContainerUtil.exists((Object[])((PsiClassType)type).getParameters(), PsiWildcardType.class::isInstance)).anyMatch(effectiveType -> effectiveType.isAssignableFrom((PsiType)searchType));
    }

    @NotNull
    private static Set<SpringBeanPointer<?>> filterByGenerics(@NotNull Set<? extends SpringBeanPointer<?>> pointers, @NotNull PsiType type) {
        if (pointers == null) {
            SpringAutowireUtil.$$$reportNull$$$0(37);
        }
        if (type == null) {
            SpringAutowireUtil.$$$reportNull$$$0(38);
        }
        HashSet filtered = new HashSet();
        block0: for (SpringBeanPointer<?> pointer : pointers) {
            for (PsiType psiType : pointer.getEffectiveBeanTypes()) {
                if (!TypeConversionUtil.isAssignable((PsiType)type, (PsiType)psiType, (pointers.size() == 1 ? 1 : 0) != 0)) continue;
                filtered.add(pointer);
                continue block0;
            }
        }
        HashSet hashSet = filtered;
        if (hashSet == null) {
            SpringAutowireUtil.$$$reportNull$$$0(39);
        }
        return hashSet;
    }

    private static boolean isAssignable(@NotNull PsiType type, @Nullable PsiClass beanClass) {
        if (type == null) {
            SpringAutowireUtil.$$$reportNull$$$0(40);
        }
        if (beanClass == null) {
            return false;
        }
        PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)beanClass.getProject()).getElementFactory().createType(beanClass);
        return type.isAssignableFrom((PsiType)psiClassType);
    }

    public static PsiType getAutowiredEffectiveBeanTypes(@NotNull PsiType psiType) {
        if (psiType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(41);
        }
        if (psiType instanceof PsiArrayType) {
            return SpringAutowireUtil.getAutowiredEffectiveBeanTypes(((PsiArrayType)psiType).getComponentType());
        }
        PsiType beanType = PsiUtil.extractIterableTypeParameter((PsiType)psiType, (boolean)false);
        if (beanType != null) {
            return beanType;
        }
        if (psiType instanceof PsiClassType) {
            PsiType objectFactoryType;
            if (SpringObjectFactoryEffectiveTypeProvider.isJavaxInjectProvider((PsiClassType)psiType)) {
                PsiType injectProviderType = SpringObjectFactoryEffectiveTypeProvider.getJavaxInjectProviderType((PsiClassType)psiType);
                if (injectProviderType != null) {
                    return injectProviderType;
                }
            } else if (SpringObjectFactoryEffectiveTypeProvider.isJakartaInjectProvider((PsiClassType)psiType)) {
                PsiType injectProviderType = SpringObjectFactoryEffectiveTypeProvider.getJakartaInjectProviderType((PsiClassType)psiType);
                if (injectProviderType != null) {
                    return injectProviderType;
                }
            } else if (SpringObjectFactoryEffectiveTypeProvider.isObjectFactory((PsiClassType)psiType) && (objectFactoryType = SpringObjectFactoryEffectiveTypeProvider.getObjectFactoryType((PsiClassType)psiType)) != null) {
                return objectFactoryType;
            }
        }
        return psiType;
    }

    private static List<SpringBeanPointer<?>> emptyList() {
        return new ArrayList();
    }

    public static boolean isAutowiredByDefault(@NotNull PsiType psiType) {
        if (psiType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(42);
        }
        if (!(psiType instanceof PsiClassType)) {
            return false;
        }
        String text = psiType.getCanonicalText();
        if (STANDARD_AUTOWIRED_TYPES.contains(text)) {
            return true;
        }
        for (String standardAutowiredType : STANDARD_AUTOWIRED_TYPES) {
            if (!InheritanceUtil.isInheritor((PsiType)psiType, (String)standardAutowiredType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAutowired(SpringBean springBean, CommonSpringModel springModel, PsiMethod psiMethod) {
        Autowire autowire = springBean.getBeanAutowire();
        switch (autowire) {
            case BY_TYPE: {
                PsiClass psiClass;
                PsiType psiType = psiMethod.getParameterList().getParameters()[0].getType();
                return psiType instanceof PsiClassType && (psiClass = ((PsiClassType)psiType).resolve()) != null && SpringModelSearchers.doesBeanExist(springModel, psiClass);
            }
            case BY_NAME: {
                String propertyName = PropertyUtilBase.getPropertyNameBySetter((PsiMethod)psiMethod);
                SpringBeanPointer<?> bean = SpringModelSearchers.findBean(springModel, propertyName);
                return bean != null && !bean.isReferenceTo(springBean);
            }
        }
        return false;
    }

    public static Set<String> getAutowiredAnnotations(@Nullable Module module) {
        if (module == null) {
            return AUTOWIRED_ANNOTATIONS;
        }
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.addAll(AUTOWIRED_ANNOTATIONS);
        annotations.addAll(SpringAutowireUtil.getMetaAutowiredAnnotations(module));
        if (SpringAutowireUtil.isUsingAutowiredPostProcessor(module)) {
            annotations.addAll(SpringAutowireUtil.getCustomAnnotationsFromPostProcessors(module));
        }
        return annotations;
    }

    @NotNull
    private static List<String> getMetaAutowiredAnnotations(@NotNull Module module) {
        if (module == null) {
            SpringAutowireUtil.$$$reportNull$$$0(43);
        }
        List list = ContainerUtil.mapNotNull((Collection)MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)"org.springframework.beans.factory.annotation.Autowired", (boolean)false), (Function)((NullableFunction)PsiClass::getQualifiedName));
        if (list == null) {
            SpringAutowireUtil.$$$reportNull$$$0(44);
        }
        return list;
    }

    public static Set<PsiModifierListOwner> getAutowiredMembers(@NotNull PsiType type, @Nullable Module module, @NotNull PsiMember method) {
        if (type == null) {
            SpringAutowireUtil.$$$reportNull$$$0(45);
        }
        if (method == null) {
            SpringAutowireUtil.$$$reportNull$$$0(46);
        }
        if (module == null) {
            return Collections.emptySet();
        }
        LinkedHashSet membersCandidate = new LinkedHashSet();
        GlobalSearchScope scope = method.getResolveScope();
        Set<PsiType> effectiveTypes = SpringAutowireUtil.getEffectiveTypes(type);
        Processor processor2 = member -> {
            block3: {
                block4: {
                    if (!(member instanceof PsiField)) break block4;
                    PsiType psiType = ((PsiField)member).getType();
                    for (PsiType effectiveType : effectiveTypes) {
                        if (!SpringAutowireUtil.isAutowiredCandidate(psiType, effectiveType)) continue;
                        membersCandidate.add(member);
                        break block3;
                    }
                    break block3;
                }
                if (!(member instanceof PsiMethod)) break block3;
                block1: for (PsiParameter psiParameter : ((PsiMethod)member).getParameterList().getParameters()) {
                    for (PsiType effectiveType : effectiveTypes) {
                        if (!SpringAutowireUtil.isAutowiredCandidate(psiParameter.getType(), effectiveType)) continue;
                        membersCandidate.add(psiParameter);
                        continue block1;
                    }
                }
            }
            return true;
        };
        HashSet<String> annotations = new HashSet<String>(SpringAutowireUtil.getAutowiredAnnotations(module));
        annotations.add("org.springframework.context.annotation.Bean");
        for (String annotation : annotations) {
            PsiClass annoClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(annotation, scope);
            if (annoClass == null) continue;
            AnnotatedMembersSearch.search((PsiClass)annoClass, (SearchScope)scope).forEach(processor2);
        }
        for (SpringStereotypeElement stereotypeElement : SpringJamModel.getModel(module).getStereotypeComponents()) {
            PsiClass psiClass = stereotypeElement.getPsiElement();
            PsiMethod[] constructors = psiClass.getConstructors();
            if (constructors.length != 1 || membersCandidate.contains(constructors[0])) continue;
            processor2.process((Object)constructors[0]);
        }
        return SpringAutowireUtil.filterCandidates(method, membersCandidate, module);
    }

    private static boolean isAutowiredCandidate(PsiType psiType, @NotNull PsiType candidateType) {
        if (candidateType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(47);
        }
        if ("java.lang.Object".equals(psiType.getCanonicalText())) {
            return false;
        }
        if (psiType.isAssignableFrom(candidateType)) {
            return true;
        }
        PsiType effectivePsiType = SpringAutowireUtil.getAutowiredEffectiveBeanTypes(psiType);
        return !effectivePsiType.equals(psiType) && effectivePsiType.isAssignableFrom(candidateType);
    }

    @NotNull
    public static Set<PsiModifierListOwner> filterCandidates(@NotNull PsiMember method, @NotNull Set<? extends PsiModifierListOwner> all, @Nullable Module module) {
        if (method == null) {
            SpringAutowireUtil.$$$reportNull$$$0(48);
        }
        if (all == null) {
            SpringAutowireUtil.$$$reportNull$$$0(49);
        }
        SpringJamQualifier qualifier = SpringAutowireUtil.getQualifier((PsiModifierListOwner)method, SpringAutowireUtil.getQualifiedAnnotation((PsiModifierListOwner)method, module));
        Set<PsiModifierListOwner> set = all.stream().filter(owner -> {
            SpringJamQualifier candidateQualifier = SpringAutowireUtil.getQualifier(owner);
            if (candidateQualifier != null) {
                if (qualifier != null && qualifier.compareQualifiers(candidateQualifier, module)) {
                    return true;
                }
                String name = method.getName();
                return name != null && name.equals(candidateQualifier.getQualifierValue());
            }
            return true;
        }).collect(Collectors.toSet());
        if (set == null) {
            SpringAutowireUtil.$$$reportNull$$$0(50);
        }
        return set;
    }

    @Nullable
    public static SpringJamQualifier getQualifier(@Nullable PsiModifierListOwner modifierListOwner) {
        return modifierListOwner == null ? null : SpringAutowireUtil.getQualifier(modifierListOwner, SpringAutowireUtil.getQualifiedAnnotation(modifierListOwner));
    }

    @Nullable
    public static SpringJamQualifier getQualifier(@Nullable PsiModifierListOwner modifierListOwner, @Nullable PsiAnnotation qualifiedAnnotation) {
        return qualifiedAnnotation == null ? null : new SpringJamQualifier(qualifiedAnnotation, modifierListOwner);
    }

    @NotNull
    private static Set<PsiType> getEffectiveTypes(@NotNull PsiType type) {
        if (type == null) {
            SpringAutowireUtil.$$$reportNull$$$0(51);
        }
        LinkedHashSet<PsiType> types = new LinkedHashSet<PsiType>();
        types.add(type);
        types.addAll(SpringBeanCoreUtils.getFactoryBeanTypes(type, null));
        LinkedHashSet<PsiType> linkedHashSet = types;
        if (linkedHashSet == null) {
            SpringAutowireUtil.$$$reportNull$$$0(52);
        }
        return linkedHashSet;
    }

    private static Set<String> getCustomAnnotationsFromPostProcessors(@Nullable Module module) {
        if (module == null) {
            return Collections.emptySet();
        }
        PsiClass autowiredPostProcessor = SpringCommonUtils.findLibraryClass(module, "org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor");
        if (autowiredPostProcessor == null) {
            return Collections.emptySet();
        }
        HashSet<String> annotations = new HashSet<String>();
        SpringModel springModel = SpringManager.getInstance(module.getProject()).getCombinedModel(module);
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass(autowiredPostProcessor).withInheritors();
        for (SpringBeanPointer<?> pointer : SpringModelSearchers.findBeans((CommonSpringModel)springModel, searchParameters)) {
            Object springBean = pointer.getSpringBean();
            if (!(springBean instanceof SpringBean)) continue;
            SpringAutowireUtil.addAutowiredAnnotationType(annotations, springBean);
            SpringAutowireUtil.addAutowiredAnnotationTypes(annotations, springBean);
        }
        return annotations;
    }

    private static boolean isUsingAutowiredPostProcessor(@NotNull Module module) {
        if (module == null) {
            SpringAutowireUtil.$$$reportNull$$$0(53);
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        Project project = module.getProject();
        Collection springXmlCandidates = DomService.getInstance().getDomFileCandidates(Beans.class, scope);
        if (springXmlCandidates.isEmpty()) {
            return false;
        }
        String className = ClassUtil.extractClassName((String)"org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor");
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        CacheManager.getInstance((Project)project).processFilesWithWord((Processor)processor2, className, (short)255, GlobalSearchScope.filesWithLibrariesScope((Project)project, (Collection)springXmlCandidates), true);
        return processor2.isFound();
    }

    private static void addAutowiredAnnotationType(@NotNull Set<? super String> annotations, @NotNull CommonSpringBean springBean) {
        String value;
        SpringPropertyDefinition autowiredTypeProperty;
        if (annotations == null) {
            SpringAutowireUtil.$$$reportNull$$$0(54);
        }
        if (springBean == null) {
            SpringAutowireUtil.$$$reportNull$$$0(55);
        }
        if ((autowiredTypeProperty = SpringPropertyUtils.findPropertyByName(springBean, "autowiredAnnotationType")) != null && !StringUtil.isEmptyOrSpaces((String)(value = autowiredTypeProperty.getValueAsString()))) {
            annotations.add(value);
        }
    }

    private static void addAutowiredAnnotationTypes(@NotNull Set<? super String> annotations, @NotNull CommonSpringBean springBean) {
        SpringPropertyDefinition autowiredTypes;
        if (annotations == null) {
            SpringAutowireUtil.$$$reportNull$$$0(56);
        }
        if (springBean == null) {
            SpringAutowireUtil.$$$reportNull$$$0(57);
        }
        if ((autowiredTypes = SpringPropertyUtils.findPropertyByName(springBean, "autowiredAnnotationTypes")) instanceof SpringProperty) {
            SpringProperty springProperty = (SpringProperty)autowiredTypes;
            SpringAutowireUtil.addNotNullValues(annotations, springProperty.getList().getValues());
            SpringAutowireUtil.addNotNullValues(annotations, springProperty.getSet().getValues());
            SpringAutowireUtil.addNotNullValues(annotations, springProperty.getArray().getValues());
        }
    }

    private static void addNotNullValues(@NotNull Collection<? super String> annotations, @NotNull Collection<? extends SpringValue> values) {
        if (annotations == null) {
            SpringAutowireUtil.$$$reportNull$$$0(58);
        }
        if (values == null) {
            SpringAutowireUtil.$$$reportNull$$$0(59);
        }
        for (SpringValue springValue : values) {
            String stringValue = springValue.getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)stringValue)) continue;
            annotations.add(stringValue);
        }
    }

    @Nullable
    public static CommonSpringModel getProcessingSpringModel(@Nullable PsiClass psiClass) {
        if (psiClass == null || psiClass.getQualifiedName() == null) {
            return null;
        }
        if (psiClass instanceof PsiAnonymousClass) {
            return SpringModelUtils.getInstance().getModuleCombinedSpringModel((PsiElement)psiClass);
        }
        CommonSpringModel model = SpringModelUtils.getInstance().getPsiClassSpringModel(psiClass);
        if (model instanceof CombinedSpringModel) {
            model = SpringAutowireUtil.filterClassRelatedModels((CombinedSpringModel)model, psiClass);
        }
        return SpringAutowireUtil.isEmptyModel(model) ? null : model;
    }

    @NotNull
    private static CommonSpringModel filterClassRelatedModels(@NotNull CombinedSpringModel model, @NotNull PsiClass aClass) {
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(60);
        }
        if (aClass == null) {
            SpringAutowireUtil.$$$reportNull$$$0(61);
        }
        HashSet<CommonSpringModel> models = new HashSet<CommonSpringModel>();
        for (CommonSpringModel commonSpringModel : model.getUnderlyingModels()) {
            SpringFileSet fileSet;
            if (!SpringModelSearchers.doesBeanExist(commonSpringModel, SpringModelSearchParameters.byClass(aClass).withInheritors())) continue;
            if (commonSpringModel instanceof SpringModel && (fileSet = ((SpringModel)commonSpringModel).getFileSet()) != null && fileSet.isAutodetected()) {
                CombinedSpringModel combinedSpringModel = model;
                if (combinedSpringModel == null) {
                    SpringAutowireUtil.$$$reportNull$$$0(62);
                }
                return combinedSpringModel;
            }
            models.add(commonSpringModel);
        }
        return new CombinedSpringModelImpl(models, model.getModule());
    }

    private static boolean isEmptyModel(@NotNull CommonSpringModel model) {
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(63);
        }
        return model.equals(SpringModel.UNKNOWN) || model instanceof CombinedSpringModel && ((CombinedSpringModel)model).getUnderlyingModels().isEmpty();
    }

    @NotNull
    private static Set<SpringBeanPointer<?>> excludeOverridenDefaultBeans(@NotNull Set<SpringBeanPointer<?>> pointers) {
        SpringBeanPointer[] objects;
        if (pointers == null) {
            SpringAutowireUtil.$$$reportNull$$$0(64);
        }
        if (pointers.size() == 1) {
            Set<SpringBeanPointer<?>> set = pointers;
            if (set == null) {
                SpringAutowireUtil.$$$reportNull$$$0(65);
            }
            return set;
        }
        LinkedHashSet beans = new LinkedHashSet();
        for (SpringBeanPointer pointer : objects = pointers.toArray(new SpringBeanPointer[0])) {
            Object bean = pointer.getSpringBean();
            if (SpringAutowireUtil.isOverridden(bean, objects)) continue;
            beans.add(pointer);
        }
        LinkedHashSet linkedHashSet = beans;
        if (linkedHashSet == null) {
            SpringAutowireUtil.$$$reportNull$$$0(66);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<SpringBeanPointer<?>> excludeTheSameIdentifyingElements(@NotNull Set<? extends SpringBeanPointer<?>> pointers) {
        if (pointers == null) {
            SpringAutowireUtil.$$$reportNull$$$0(67);
        }
        LinkedHashSet filtered = new LinkedHashSet();
        HashSet identifyingElements = new HashSet();
        for (SpringBeanPointer<?> pointer : pointers) {
            PsiElement element = pointer.getSpringBean().getIdentifyingPsiElement();
            if (identifyingElements.contains(element)) continue;
            filtered.add(pointer);
            ContainerUtil.addIfNotNull(identifyingElements, (Object)element);
        }
        LinkedHashSet linkedHashSet = filtered;
        if (linkedHashSet == null) {
            SpringAutowireUtil.$$$reportNull$$$0(68);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<SpringBeanPointer<?>> excludeExplicitlyRedefined(@NotNull Set<SpringBeanPointer<?>> pointers) {
        if (pointers == null) {
            SpringAutowireUtil.$$$reportNull$$$0(69);
        }
        if (pointers.size() <= 1) {
            Set<SpringBeanPointer<?>> set = pointers;
            if (set == null) {
                SpringAutowireUtil.$$$reportNull$$$0(70);
            }
            return set;
        }
        ExplicitRedefinitionAwareBeansCollector collector = new ExplicitRedefinitionAwareBeansCollector();
        for (SpringBeanPointer<?> pointer : pointers) {
            collector.process(pointer);
        }
        Set<SpringBeanPointer<?>> set = collector.getResult();
        if (set == null) {
            SpringAutowireUtil.$$$reportNull$$$0(71);
        }
        return set;
    }

    @NotNull
    private static Set<SpringBeanPointer<?>> filterByPriority(@NotNull Set<SpringBeanPointer<?>> filtered, @Nullable Module module) {
        if (filtered == null) {
            SpringAutowireUtil.$$$reportNull$$$0(72);
        }
        if (filtered.isEmpty()) {
            HashSet hashSet = filtered;
            if (hashSet == null) {
                SpringAutowireUtil.$$$reportNull$$$0(73);
            }
            return hashSet;
        }
        Long maxPriority = null;
        MultiMap byPriority = new MultiMap();
        for (SpringBeanPointer<?> pointer : filtered) {
            if (!(pointer instanceof JamSpringBeanPointer)) continue;
            JamPsiMemberSpringBean psiMemberSpringBean = (JamPsiMemberSpringBean)((JamSpringBeanPointer)pointer).getSpringBean();
            Object psiMember = psiMemberSpringBean.getPsiElement();
            PsiAnnotation priority = AnnotationUtil.findAnnotation(psiMember, (String[])SpringAutowireUtil.getPriorityAnnotations(module));
            if (priority == null) {
                HashSet hashSet = filtered;
                if (hashSet == null) {
                    SpringAutowireUtil.$$$reportNull$$$0(74);
                }
                return hashSet;
            }
            Long value = SpringAutowireUtil.getPriorityAnnotationValue(priority, module);
            if (value == null) {
                HashSet hashSet = filtered;
                if (hashSet == null) {
                    SpringAutowireUtil.$$$reportNull$$$0(75);
                }
                return hashSet;
            }
            if (maxPriority == null || value.intValue() < maxPriority.intValue()) {
                maxPriority = value;
            }
            byPriority.putValue((Object)value, pointer);
        }
        return maxPriority == null ? filtered : new HashSet(byPriority.get(maxPriority));
    }

    private static String[] getPriorityAnnotations(@Nullable Module module) {
        return module == null ? SpringAnnotationsConstants.PRIORITY_ANNOTATIONS : ArrayUtil.toStringArray(SpringAutowireUtil.getMetaPriorityAnnotations(module));
    }

    @NotNull
    private static List<String> getMetaPriorityAnnotations(@NotNull Module module) {
        if (module == null) {
            SpringAutowireUtil.$$$reportNull$$$0(76);
        }
        @NotNull SmartList annotations = new SmartList();
        for (String priorityAnnotation : SpringAnnotationsConstants.PRIORITY_ANNOTATIONS) {
            annotations.addAll(JamAnnotationTypeUtil.getInstance(module).getAnnotationTypesWithChildrenIncludingTests(priorityAnnotation).stream().map(aClass -> aClass.getQualifiedName()).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        SmartList smartList = annotations;
        if (smartList == null) {
            SpringAutowireUtil.$$$reportNull$$$0(77);
        }
        return smartList;
    }

    @Nullable
    private static Long getPriorityAnnotationValue(@NotNull PsiAnnotation priority, @Nullable Module module) {
        String qualifiedName;
        if (priority == null) {
            SpringAutowireUtil.$$$reportNull$$$0(78);
        }
        if ((qualifiedName = priority.getQualifiedName()) == null) {
            return null;
        }
        if (ArrayUtil.contains((String)qualifiedName, (String[])SpringAnnotationsConstants.PRIORITY_ANNOTATIONS)) {
            return AnnotationUtil.getLongAttributeValue((PsiAnnotation)priority, (String)"value");
        }
        if (module == null) {
            return null;
        }
        PsiClass priorityAnnoClass = JavaPsiFacade.getInstance((Project)priority.getProject()).findClass(qualifiedName, GlobalSearchScope.allScope((Project)priority.getProject()));
        if (priorityAnnoClass == null) {
            return null;
        }
        for (String priorityAnnotation : SpringAnnotationsConstants.PRIORITY_ANNOTATIONS) {
            PsiAnnotation definingMetaAnnotation = SpringAliasForUtils.findDefiningMetaAnnotation(priorityAnnoClass, priorityAnnotation, JamAnnotationTypeUtil.getInstance(module).getAnnotationTypesWithChildrenIncludingTests(priorityAnnotation));
            if (definingMetaAnnotation == null) continue;
            return AnnotationUtil.getLongAttributeValue((PsiAnnotation)definingMetaAnnotation, (String)"value");
        }
        return null;
    }

    private static boolean isOverridden(CommonSpringBean bean, SpringBeanPointer[] objects) {
        if (bean instanceof SpringImplicitBeanMarker) {
            String beanName = bean.getBeanName();
            PsiType beanType = bean.getBeanType();
            if (beanType != null && beanName != null) {
                for (SpringBeanPointer pointer : objects) {
                    if (bean.equals(pointer.getSpringBean()) || !beanName.equals(pointer.getName())) continue;
                    for (PsiType psiType : pointer.getEffectiveBeanTypes()) {
                        if (!psiType.isAssignableFrom(beanType)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isJavaUtilOptional(@NotNull PsiType type) {
        PsiClass psiClass;
        if (type == null) {
            SpringAutowireUtil.$$$reportNull$$$0(79);
        }
        return (psiClass = PsiTypesUtil.getPsiClass((PsiType)type)) != null && "java.util.Optional".equals(psiClass.getQualifiedName());
    }

    @Nullable
    public static PsiType getOptionalType(@NotNull PsiType psiClassType) {
        if (psiClassType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(80);
        }
        return PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)"java.util.Optional", (int)0, (boolean)false);
    }

    @NotNull
    public static Set<SpringBeanPointer<?>> getAutowiredBeansFor(@NotNull PsiModifierListOwner injectionPointOwner, @NotNull PsiType psiType, @NotNull CommonSpringModel springModel) {
        PsiAnnotation resourceAnnotation;
        if (injectionPointOwner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(81);
        }
        if (psiType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(82);
        }
        if (springModel == null) {
            SpringAutowireUtil.$$$reportNull$$$0(83);
        }
        if ((resourceAnnotation = SpringAutowireUtil.getResourceAnnotation(injectionPointOwner)) != null && injectionPointOwner instanceof PsiMember) {
            SpringBeanPointer<?> bean = SpringAutowireUtil.getResourceAutowiredBean(injectionPointOwner, springModel, resourceAnnotation);
            Set<Object> set = bean != null ? Collections.singleton(bean) : Collections.emptySet();
            if (set == null) {
                SpringAutowireUtil.$$$reportNull$$$0(84);
            }
            return set;
        }
        PsiAnnotation qualifiedAnnotation = SpringAutowireUtil.getEffectiveQualifiedAnnotation(injectionPointOwner);
        if (qualifiedAnnotation != null) {
            return SpringAutowireUtil.getQualifiedAutowiredBeans(psiType, qualifiedAnnotation, springModel);
        }
        return SpringAutowireUtil.getByTypeAutowiredBeans((PsiNameIdentifierOwner)injectionPointOwner, psiType, springModel);
    }

    @NotNull
    private static Set<SpringBeanPointer<?>> getByTypeAutowiredBeans(@NotNull PsiNameIdentifierOwner psiNameIdentifierOwner, @NotNull PsiType searchType, CommonSpringModel model) {
        if (psiNameIdentifierOwner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(85);
        }
        if (searchType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(86);
        }
        String primaryCandidateName = psiNameIdentifierOwner.getName();
        Set<SpringBeanPointer<?>> iterableBeanPointers = SpringAutowireUtil.getIterableBeanPointers(searchType, model);
        Set<SpringBeanPointer<?>> set = iterableBeanPointers.isEmpty() ? SpringAutowireUtil.autowireByType(model, searchType, primaryCandidateName) : iterableBeanPointers;
        if (set == null) {
            SpringAutowireUtil.$$$reportNull$$$0(87);
        }
        return set;
    }

    @NotNull
    private static Set<SpringBeanPointer<?>> getQualifiedAutowiredBeans(@NotNull PsiType type, @NotNull PsiAnnotation annotation, @NotNull CommonSpringModel model) {
        if (type == null) {
            SpringAutowireUtil.$$$reportNull$$$0(88);
        }
        if (annotation == null) {
            SpringAutowireUtil.$$$reportNull$$$0(89);
        }
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(90);
        }
        return SpringAutowireUtil.filterPointersByAutowiredType(type, SpringAutowireUtil.getQualifiedBeanPointers(annotation, model));
    }

    @Nullable
    private static SpringBeanPointer<?> getResourceAutowiredBean(@NotNull PsiModifierListOwner injectionPointOwner, @NotNull CommonSpringModel springModel, @NotNull PsiAnnotation resourceAnnotation) {
        PsiAnnotationMemberValue attributeValue;
        if (injectionPointOwner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(91);
        }
        if (springModel == null) {
            SpringAutowireUtil.$$$reportNull$$$0(92);
        }
        if (resourceAnnotation == null) {
            SpringAutowireUtil.$$$reportNull$$$0(93);
        }
        if ((attributeValue = resourceAnnotation.findDeclaredAttributeValue("name")) != null) {
            return SpringAutowireUtil.getByNameAutowiredBean(attributeValue, springModel);
        }
        return SpringAutowireUtil.findBeanByImplicitInjectionPointName(injectionPointOwner, springModel);
    }

    @Nullable
    private static SpringBeanPointer<?> findBeanByImplicitInjectionPointName(@NotNull PsiModifierListOwner injectionPointOwner, @NotNull CommonSpringModel springModel) {
        SpringBeanPointer<?> bean;
        if (injectionPointOwner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(94);
        }
        if (springModel == null) {
            SpringAutowireUtil.$$$reportNull$$$0(95);
        }
        String name = null;
        if (injectionPointOwner instanceof PsiMethod) {
            name = PropertyUtilBase.getPropertyNameBySetter((PsiMethod)((PsiMethod)injectionPointOwner));
        } else if (injectionPointOwner instanceof PsiField) {
            name = ((PsiField)injectionPointOwner).getName();
        }
        if (name != null && (bean = SpringModelSearchers.findBean(springModel, name)) != null) {
            return bean.getBasePointer();
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation getEffectiveQualifiedAnnotation(@NotNull PsiModifierListOwner modifierListOwner) {
        if (modifierListOwner == null) {
            SpringAutowireUtil.$$$reportNull$$$0(96);
        }
        return modifierListOwner instanceof PsiMethod ? null : SpringAutowireUtil.getQualifiedAnnotation(modifierListOwner);
    }

    @Nullable
    private static SpringBeanPointer<?> getByNameAutowiredBean(@NotNull PsiAnnotationMemberValue annotationMemberValue, @NotNull CommonSpringModel model) {
        if (annotationMemberValue == null) {
            SpringAutowireUtil.$$$reportNull$$$0(97);
        }
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(98);
        }
        for (PsiReference reference : annotationMemberValue.getReferences()) {
            PsiConstantEvaluationHelper helper;
            Object o;
            PsiElement element;
            if (reference instanceof SpringBeanReference) {
                SpringBeanReference sbReference = (SpringBeanReference)reference;
                String beanName = sbReference.getValue();
                if (!StringUtil.isNotEmpty((String)beanName)) continue;
                return SpringModelSearchers.findBean(model, beanName);
            }
            if (!(reference instanceof PsiReferenceExpression) || !((element = reference.resolve()) instanceof PsiField) || !((o = (helper = JavaPsiFacade.getInstance((Project)element.getProject()).getConstantEvaluationHelper()).computeConstantExpression((PsiElement)((PsiField)element).getInitializer())) instanceof String)) continue;
            return SpringModelSearchers.findBean(model, (String)o);
        }
        return null;
    }

    @NotNull
    public static Set<SpringBeanPointer<?>> filterPointersByAutowiredType(@NotNull PsiType searchType, @NotNull Set<? extends SpringBeanPointer<?>> beanPointers) {
        if (searchType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(99);
        }
        if (beanPointers == null) {
            SpringAutowireUtil.$$$reportNull$$$0(100);
        }
        HashSet autowiredPointers = new HashSet();
        block0: for (SpringBeanPointer<?> bean : beanPointers) {
            PsiType[] psiTypes;
            for (PsiType psiType : psiTypes = bean.getEffectiveBeanTypes()) {
                if (!SpringAutowireUtil.canBeAutowiredByType(searchType, psiType)) continue;
                autowiredPointers.add(bean);
                continue block0;
            }
        }
        HashSet hashSet = autowiredPointers;
        if (hashSet == null) {
            SpringAutowireUtil.$$$reportNull$$$0(101);
        }
        return hashSet;
    }

    @NotNull
    public static Set<SpringBeanPointer<?>> getQualifiedBeanPointers(@NotNull PsiAnnotation qualifiedAnnotation, @NotNull CommonSpringModel model) {
        SpringBeanPointer<?> pointer;
        if (qualifiedAnnotation == null) {
            SpringAutowireUtil.$$$reportNull$$$0(102);
        }
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(103);
        }
        Collection<SpringBeanPointer<?>> candidates = SpringAutowireUtil.getQualifiedBeans(qualifiedAnnotation, model);
        String name = SpringAutowireUtil.getQualifiedBeanName(qualifiedAnnotation);
        if (name != null && (pointer = SpringModelSearchers.findBean(model, name)) != null) {
            candidates = new ArrayList(candidates);
            candidates.add(pointer.getBasePointer());
        }
        return SpringAutowireUtil.excludeAutowireCandidates(candidates, model);
    }

    public static boolean canBeAutowiredByType(@NotNull PsiType psiType, @NotNull PsiType searchType) {
        if (psiType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(104);
        }
        if (searchType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(105);
        }
        if (psiType.isAssignableFrom(searchType)) {
            return true;
        }
        PsiType iterableType = SpringAutowireUtil.getIterableType(psiType);
        if (iterableType != null && iterableType.isAssignableFrom(searchType)) {
            return true;
        }
        if (SpringAutowireUtil.isObjectFactoryEffectiveType(psiType, searchType)) {
            return true;
        }
        if (SpringAutowireUtil.isJavaUtilOptionalEffectiveType(psiType, searchType)) {
            return true;
        }
        return SpringAutowireUtil.isJavaUtilProperties(searchType) && SpringAutowireUtil.isStringMap(psiType);
    }

    private static boolean isJavaUtilOptionalEffectiveType(PsiType psiType, PsiType type) {
        if (!SpringAutowireUtil.isJavaUtilOptional(psiType)) {
            return false;
        }
        PsiType optionalType = SpringAutowireUtil.getOptionalType(psiType);
        return optionalType != null && optionalType.isAssignableFrom(type);
    }

    private static boolean isStringMap(@NotNull PsiType psiType) {
        if (psiType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(106);
        }
        return SpringAutowireUtil.isJavaUtilMap(psiType) && SpringAutowireUtil.isJavaLangString(PsiUtil.substituteTypeParameter((PsiType)psiType, (String)"java.util.Map", (int)0, (boolean)false)) && SpringAutowireUtil.isJavaLangString(PsiUtil.substituteTypeParameter((PsiType)psiType, (String)"java.util.Map", (int)1, (boolean)false));
    }

    private static boolean isJavaLangString(@Nullable PsiType type) {
        return type instanceof PsiClassType && type.getCanonicalText().equals("java.lang.String");
    }

    private static boolean isJavaUtilProperties(PsiType psiType) {
        return psiType instanceof PsiClassType && InheritanceUtil.isInheritor((PsiType)psiType, (String)"java.util.Properties");
    }

    private static boolean isObjectFactoryEffectiveType(@NotNull PsiType psiType, @NotNull PsiType aType) {
        PsiType objectFactoryEffectiveType;
        if (psiType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(107);
        }
        if (aType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(108);
        }
        return (objectFactoryEffectiveType = SpringObjectFactoryEffectiveTypeProvider.getObjectFactoryEffectiveType(aType)) != null && psiType.isAssignableFrom(objectFactoryEffectiveType);
    }

    @NotNull
    public static Set<SpringBeanPointer<?>> getIterableBeanPointers(@NotNull PsiType searchType, @NotNull CommonSpringModel model) {
        PsiType secondarySearchType;
        if (searchType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(109);
        }
        if (model == null) {
            SpringAutowireUtil.$$$reportNull$$$0(110);
        }
        Set<SpringBeanPointer<?>> set = (secondarySearchType = SpringAutowireUtil.getIterableSearchType(searchType)) != null ? SpringAutowireUtil.autowireByType(model, secondarySearchType, null) : Collections.emptySet();
        if (set == null) {
            SpringAutowireUtil.$$$reportNull$$$0(111);
        }
        return set;
    }

    @Nullable
    public static PsiType getIterableSearchType(@NotNull PsiType searchType) {
        PsiType iterableType;
        if (searchType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(112);
        }
        if ((iterableType = SpringAutowireUtil.getIterableType(searchType)) != null) {
            return iterableType;
        }
        if (SpringAutowireUtil.isTypedMapWithStringKey(searchType)) {
            return PsiUtil.substituteTypeParameter((PsiType)searchType, (String)"java.util.Map", (int)1, (boolean)false);
        }
        return SpringObjectFactoryEffectiveTypeProvider.getObjectFactoryEffectiveType(searchType);
    }

    @Nullable
    private static PsiType getIterableType(@NotNull PsiType psiType) {
        if (psiType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(113);
        }
        return psiType instanceof PsiArrayType ? ((PsiArrayType)psiType).getComponentType() : PsiUtil.extractIterableTypeParameter((PsiType)psiType, (boolean)true);
    }

    @Nullable
    public static String getQualifiedBeanName(@NotNull PsiAnnotation qualifiedAnnotation) {
        PsiAnnotationMemberValue attributeValue;
        if (qualifiedAnnotation == null) {
            SpringAutowireUtil.$$$reportNull$$$0(114);
        }
        return (attributeValue = qualifiedAnnotation.findDeclaredAttributeValue("value")) == null ? null : (String)JamCommonUtil.getObjectValue((PsiElement)attributeValue, String.class);
    }

    public static boolean isTypedMapWithStringKey(@NotNull PsiType psiType) {
        if (psiType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(115);
        }
        if (SpringAutowireUtil.isJavaUtilMap(psiType)) {
            return SpringAutowireUtil.isJavaLangString(PsiUtil.substituteTypeParameter((PsiType)psiType, (String)"java.util.Map", (int)0, (boolean)false));
        }
        return false;
    }

    public static boolean isJavaUtilMap(@NotNull PsiType psiType) {
        if (psiType == null) {
            SpringAutowireUtil.$$$reportNull$$$0(116);
        }
        return psiType instanceof PsiClassType && InheritanceUtil.isInheritor((PsiType)psiType, (String)"java.util.Map");
    }

    public static boolean isAutowiringRelevantClass(@Nullable PsiClass psiClass) {
        return psiClass != null && SpringLibraryUtil.hasSpringLibrary(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass)) && (SpringCommonUtils.isSpringBeanCandidateClass(psiClass) || SpringTestContextUtil.getInstance().isTestContextConfigurationClass(psiClass));
    }

    public static boolean isValueAnnoInjection(@Nullable PsiModifierListOwner modifierListOwner) {
        return modifierListOwner != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)modifierListOwner, (String)"org.springframework.beans.factory.annotation.Value", (int)1);
    }

    public static boolean hasConditional(@NotNull PsiMethod method) {
        if (method == null) {
            SpringAutowireUtil.$$$reportNull$$$0(117);
        }
        return JamService.getJamService((Project)method.getProject()).getJamElement(SpringConditional.SPRING_CONDITIONAL_JAM_ELEMENT_KEY, (PsiElement)method) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 39: 
            case 44: 
            case 50: 
            case 52: 
            case 62: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 84: 
            case 87: 
            case 101: 
            case 111: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 39: 
            case 44: 
            case 50: 
            case 52: 
            case 62: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 84: 
            case 87: 
            case 101: 
            case 111: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 39: 
            case 44: 
            case 50: 
            case 52: 
            case 62: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 84: 
            case 87: 
            case 101: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/utils/SpringAutowireUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBeanPointer";
                break;
            }
            case 9: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 60: 
            case 63: 
            case 90: 
            case 98: 
            case 103: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 16: 
            case 17: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 22: 
            case 23: 
            case 46: 
            case 48: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 35: 
            case 41: 
            case 42: 
            case 82: 
            case 104: 
            case 106: 
            case 107: 
            case 113: 
            case 115: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 36: 
            case 86: 
            case 99: 
            case 105: 
            case 109: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchType";
                break;
            }
            case 37: 
            case 64: 
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 38: 
            case 40: 
            case 45: 
            case 51: 
            case 79: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 43: 
            case 53: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateType";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "all";
                break;
            }
            case 54: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filtered";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClassType";
                break;
            }
            case 81: 
            case 91: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionPointOwner";
                break;
            }
            case 83: 
            case 92: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springModel";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiNameIdentifierOwner";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceAnnotation";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationMemberValue";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanPointers";
                break;
            }
            case 102: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedAnnotation";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/utils/SpringAutowireUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeAutowireCandidates";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryBeans";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedBeans";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotatedAutowiredMethods";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotatedAutowiredFields";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "autowireByType";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByGenerics";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaAutowiredAnnotations";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "filterCandidates";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveTypes";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "filterClassRelatedModels";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeOverridenDefaultBeans";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeTheSameIdentifyingElements";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeExplicitlyRedefined";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByPriority";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaPriorityAnnotations";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutowiredBeansFor";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getByTypeAutowiredBeans";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPointersByAutowiredType";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "getIterableBeanPointers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "excludeAutowireCandidates";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 39: 
            case 44: 
            case 50: 
            case 52: 
            case 62: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 84: 
            case 87: 
            case 101: 
            case 111: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPrimaryBeans";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isMyName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAutowireAnnotationProperties";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addAutowiredBeans";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedBeans";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedAnnotation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAutowiredAnnotation";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAnnotation";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isAutowiredByAnnotation";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInjectionPoint";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultStereotypeComponentConstructor";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isCustomStereotypeBean";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isRequired";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotatedAutowiredMethods";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotatedAutowiredFields";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "autowireByType";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findWildcardInjectedBeans";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableWildcardTypeBean";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "filterByGenerics";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isAssignable";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getAutowiredEffectiveBeanTypes";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isAutowiredByDefault";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getMetaAutowiredAnnotations";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getAutowiredMembers";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isAutowiredCandidate";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "filterCandidates";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveTypes";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isUsingAutowiredPostProcessor";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "addAutowiredAnnotationType";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "addAutowiredAnnotationTypes";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addNotNullValues";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "filterClassRelatedModels";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyModel";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "excludeOverridenDefaultBeans";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "excludeTheSameIdentifyingElements";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "excludeExplicitlyRedefined";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "filterByPriority";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getMetaPriorityAnnotations";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getPriorityAnnotationValue";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "isJavaUtilOptional";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getOptionalType";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getAutowiredBeansFor";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getByTypeAutowiredBeans";
                break;
            }
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedAutowiredBeans";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAutowiredBean";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "findBeanByImplicitInjectionPointName";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveQualifiedAnnotation";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getByNameAutowiredBean";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "filterPointersByAutowiredType";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedBeanPointers";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "canBeAutowiredByType";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "isStringMap";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "isObjectFactoryEffectiveType";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getIterableBeanPointers";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "getIterableSearchType";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "getIterableType";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedBeanName";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "isTypedMapWithStringKey";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "isJavaUtilMap";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "hasConditional";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 39: 
            case 44: 
            case 50: 
            case 52: 
            case 62: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 84: 
            case 87: 
            case 101: 
            case 111: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

